/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.util;

import java.io.File;
import java.io.InputStream;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import quadbase.common.util.SecParamInfo;
import quadbase.common.util.SecParamInfoList;
import quadbase.common.util.internal.DataType;

public class ReadSecParamFile {
    final int ELEMENT_TYPE = 1;
    final int ATTR_TYPE = 2;
    final int TEXT_TYPE = 3;
    final int CDATA_TYPE = 4;
    final int ENTITYREF_TYPE = 5;
    final int ENTITY_TYPE = 6;
    final int PROCINSTR_TYPE = 7;
    final int COMMENT_TYPE = 8;
    final int DOCUMENT_TYPE = 9;
    final int DOCTYPE_TYPE = 10;
    final int DOCFRAG_TYPE = 11;
    final int NOTATION_TYPE = 12;
    Document document;

    public ReadSecParamFile(String uri) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        this.document = builder.parse(uri);
    }

    public ReadSecParamFile(File file) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        this.document = builder.parse(file);
    }

    public ReadSecParamFile(InputStream xmlStream) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        this.document = builder.parse(xmlStream);
    }

    public SecParamInfoList createParamInfoList() throws Exception {
        return this.createParamInfoList(this.document);
    }

    SecParamInfoList createParamInfoList(Node domNode) throws Exception {
        NodeList nodeList = domNode.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            short type = node.getNodeType();
            if (type == 1 && node.getNodeName().equalsIgnoreCase("SecuredParamInfoList")) {
                return this.parseParamInfoList(node);
            }
            SecParamInfoList list = this.createParamInfoList(node);
            if (list == null) continue;
            return list;
        }
        return null;
    }

    SecParamInfoList parseParamInfoList(Node domNode) throws Exception {
        NodeList nodeList = domNode.getChildNodes();
        SecParamInfoList infoList = new SecParamInfoList();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            SecParamInfo pInfo;
            Node node = nodeList.item(i);
            short type = node.getNodeType();
            if (type != 1 || !node.getNodeName().equalsIgnoreCase("SecuredParamInfo") || (pInfo = this.parseParamInfo(node)) == null) continue;
            infoList.add(pInfo);
        }
        return infoList;
    }

    SecParamInfo parseParamInfo(Node domNode) throws Exception {
        SecParamInfo secParamInfo = new SecParamInfo();
        Vector<String> secLevelKeys = new Vector<String>();
        Vector<Vector> secLevelVals = new Vector<Vector>();
        NodeList nodeList = domNode.getChildNodes();
        String paramName = this.getAttribute(domNode, "ParamName");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            short type = node.getNodeType();
            if (type != 1) continue;
            if (node.getNodeName().equalsIgnoreCase("Driver")) {
                secParamInfo.setDriver(this.getData(node));
                continue;
            }
            if (node.getNodeName().equalsIgnoreCase("URL")) {
                secParamInfo.setDBUrl(this.getData(node));
                continue;
            }
            if (node.getNodeName().equalsIgnoreCase("JNDIName")) {
                secParamInfo.setJNDIName(this.getData(node));
                continue;
            }
            if (node.getNodeName().equalsIgnoreCase("ContextFactory")) {
                secParamInfo.setContextFactory(this.getData(node));
                continue;
            }
            if (node.getNodeName().equalsIgnoreCase("ProviderURL")) {
                secParamInfo.setProviderURL(this.getData(node));
                continue;
            }
            if (node.getNodeName().equalsIgnoreCase("TableName")) {
                secParamInfo.setTableName(this.getData(node));
                continue;
            }
            if (node.getNodeName().equalsIgnoreCase("ColumnName")) {
                secParamInfo.setColName(this.getData(node));
                continue;
            }
            if (node.getNodeName().equalsIgnoreCase("DataType")) {
                secParamInfo.setSQLType(DataType.findType(this.getData(node)));
                continue;
            }
            if (node.getNodeName().equalsIgnoreCase("IsMulti")) {
                secParamInfo.setMulti(this.readBoolean(node));
                continue;
            }
            if (node.getNodeName().equalsIgnoreCase("IsJNDI")) {
                secParamInfo.setJNDI(this.readBoolean(node));
                continue;
            }
            if (!node.getNodeName().equalsIgnoreCase("SecLevel")) continue;
            String key = this.getAttribute(node, "Name");
            boolean grantAll = Boolean.valueOf(this.getAttribute(node, "GrantAll"));
            if (grantAll) {
                secParamInfo.grantAll(key);
                continue;
            }
            Vector vec = this.getDataList(node);
            secLevelKeys.add(key);
            secLevelVals.add(vec);
        }
        if (paramName == null) {
            secParamInfo.setParamName(secParamInfo.getTableName() + "." + secParamInfo.getColumnName());
        } else {
            secParamInfo.setParamName(paramName);
        }
        int dataType = DataType.mapType(secParamInfo.getSqlType());
        for (int i = 0; i < secLevelKeys.size(); ++i) {
            secParamInfo.addSecLevel((String)secLevelKeys.elementAt(i), this.getObject((Vector)secLevelVals.elementAt(i), secParamInfo.isMulti(), dataType));
        }
        return secParamInfo;
    }

    Object getObject(Vector vec, boolean isMulti, int dataType) throws Exception {
        if (isMulti) {
            Vector<Object> vec1 = new Vector<Object>();
            for (int i = 0; i < vec.size(); ++i) {
                vec1.add(DataType.createObject((String)vec.elementAt(i), dataType));
            }
            return vec1;
        }
        if (vec.size() > 0) {
            return DataType.createObject((String)vec.elementAt(0), dataType);
        }
        return null;
    }

    Vector getDataList(Node domNode) {
        Vector<String> list = new Vector<String>();
        NodeList nodeList = domNode.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            short type = node.getNodeType();
            if (type != 1 || !node.getNodeName().equalsIgnoreCase("Data")) continue;
            list.add(this.getData(node));
        }
        return list;
    }

    String getData(Node domNode) {
        if (domNode == null) {
            return "";
        }
        NodeList nodeList = domNode.getChildNodes();
        String s = "";
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            short type = node.getNodeType();
            if (type == 1) {
                s = s + this.getData(node);
                continue;
            }
            if (type == 3) {
                s = s + node.getNodeValue();
                continue;
            }
            if (type == 5) {
                s = s + this.getData(node);
                continue;
            }
            if (type != 4) continue;
            s = s + node.getNodeValue();
        }
        return s;
    }

    boolean readBoolean(Node domNode) {
        return Boolean.valueOf(this.getAttribute(domNode, "state"));
    }

    String getAttribute(Node domNode, String attr) {
        NamedNodeMap nodeMap = domNode.getAttributes();
        Node node = nodeMap.getNamedItem(attr);
        if (node != null) {
            return node.getNodeValue();
        }
        return null;
    }
}

