/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.util;

import java.util.Hashtable;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import quadbase.common.paramquery.QueryFileInfo;
import quadbase.common.paramquery.QueryParser;
import quadbase.common.paramquery.parser.GenericParser;
import quadbase.common.util.IQueryInParam;
import quadbase.common.util.SecParamInfo;
import quadbase.common.util.SecuredParameterException;
import quadbase.common.util.internal.QbDebug;
import quadbase.reportdesigner.ReportAPI.DBInfo;
import quadbase.util.IQueryFileInfo;
import quadbase.util.IQueryMultiValueInParam;
import quadbase.util.SimpleQueryFileInfo;
import quadbase.util.internal.QbUtil;

public class SecParamInfoList {
    public static final String LEFT_BRACKET_REPLACEMENT = "<l#E#f#T>";
    public static final String RIGHT_BRACKET_REPLACEMENT = "<R#i#G#h#T>";
    public static final String SELECT_REPLACEMENT = "<s#E#l#E#c#T>";
    public static final String FROM_REPLACEMENT = "<F#r#O#m>";
    public static final String WHERE_REPLACEMENT = "<W#h#e#R#e>";
    protected Vector infoList = new Vector();

    public boolean isSecured(String colName, String secLevel) {
        for (int i = 0; i < this.infoList.size(); ++i) {
            SecParamInfo tmp = (SecParamInfo)this.infoList.elementAt(i);
            int tidx = colName.lastIndexOf(46);
            String tName = colName;
            if (tidx >= 0) {
                tName = colName.substring(0, tidx);
            }
            if (!tmp.getTableName().equals(tName) || !tmp.isSecured(secLevel)) continue;
            return true;
        }
        return false;
    }

    public boolean isSecuredColumn(String colName, String secLevel) {
        for (int i = 0; i < this.infoList.size(); ++i) {
            SecParamInfo tmp = (SecParamInfo)this.infoList.elementAt(i);
            if (!tmp.getColumnName().equals(colName) && !(tmp.getTableName() + "." + tmp.getColumnName()).equals(colName) || !tmp.isSecured(secLevel)) continue;
            return true;
        }
        return false;
    }

    protected Vector getParamInfos(String[][] tblNames, String driver, String dbURL) {
        Vector<SecParamInfo> res = new Vector<SecParamInfo>();
        QbDebug.println(4, "PARAM INFO SQL [DRIVER] = " + driver);
        QbDebug.println(4, "PARAM INFO SQL [URL] = " + dbURL);
        for (int i = 0; i < this.infoList.size(); ++i) {
            SecParamInfo tmp = (SecParamInfo)this.infoList.elementAt(i);
            QbDebug.println(4, "SEC XML [DRIVER] = " + tmp.getDriver());
            QbDebug.println(4, "SEC XML [URL] = " + tmp.getDBUrl());
            QbDebug.println(4, "SEC XML [TABLE NAME] = " + tmp.getTableName());
            QbDebug.println(4, "SEC XML [COL NAME] = " + tmp.getColumnName());
            QbDebug.println(4, "SEC XML [SEC LEVELS] = " + tmp.getSecurityLevels());
            if (!tmp.match(tblNames, driver, dbURL)) continue;
            res.add(tmp);
        }
        return res;
    }

    protected Vector getParamInfos(String[][] tblNames, String JNDIName, String contextFactory, String providerURL) {
        Vector<SecParamInfo> res = new Vector<SecParamInfo>();
        QbDebug.println(4, "PARAM INFO SQL [JNDIName] = " + JNDIName);
        for (int i = 0; i < this.infoList.size(); ++i) {
            SecParamInfo tmp = (SecParamInfo)this.infoList.elementAt(i);
            QbDebug.println(4, "SEC XML [JNDI NAME] = " + tmp.getJNDIName());
            QbDebug.println(4, "SEC XML [CONTEXT FACTORY] = " + tmp.getContextFactory());
            QbDebug.println(4, "SEC XML [PROVIDER URL] = " + tmp.getProviderURL());
            QbDebug.println(4, "SEC XML [TABLE NAME] = " + tmp.getTableName());
            QbDebug.println(4, "SEC XML [COL NAME] = " + tmp.getColumnName());
            QbDebug.println(4, "SEC XML [SEC LEVELS] = " + tmp.getSecurityLevels());
            if (!tmp.match(tblNames, JNDIName, contextFactory, providerURL)) continue;
            res.add(tmp);
        }
        return res;
    }

    public void add(SecParamInfo info) {
        this.infoList.add(info);
    }

    public int isValidLevel(String driver, String dbURL, String[][] tblNames, String secLevel) {
        QbDebug.println(4, "USER SEC LEVEL = " + secLevel);
        QbDebug.println(4, "DATAVIEW SQL [DRIVER] = " + driver);
        QbDebug.println(4, "DATAVIEW SQL [URL] = " + dbURL);
        boolean matchTable = false;
        for (int i = 0; i < this.infoList.size(); ++i) {
            SecParamInfo tmp = (SecParamInfo)this.infoList.elementAt(i);
            QbDebug.println(4, "SEC XML [DRIVER] = " + tmp.getDriver());
            QbDebug.println(4, "SEC XML [URL] = " + tmp.getDBUrl());
            QbDebug.println(4, "SEC XML [TABLE NAME] = " + tmp.getTableName());
            QbDebug.println(4, "SEC XML [COL NAME] = " + tmp.getColumnName());
            QbDebug.println(4, "SEC XML [SEC LEVELS] = " + tmp.getSecurityLevels());
            boolean matchDriver = false;
            boolean matchUrl = false;
            if (driver.equalsIgnoreCase(tmp.getDriver())) {
                matchDriver = true;
            }
            if (dbURL.equalsIgnoreCase(tmp.getDBUrl())) {
                matchUrl = true;
            }
            QbDebug.println(4, "DRIVER MATCH = " + matchDriver);
            QbDebug.println(4, "URL MATCH = " + matchUrl);
            if (!matchDriver || !matchUrl) continue;
            for (String[] tblName : tblNames) {
                if (!tmp.getTableName().equals(tblName[0]) && !tmp.getTableName().equals(tblName[1])) continue;
                matchTable = true;
                QbDebug.println(4, "MATCH TBL = " + tblName[0]);
                break;
            }
            if (!matchTable || !tmp.isDenied(secLevel)) continue;
            return 2;
        }
        if (!matchTable) {
            return 0;
        }
        return 1;
    }

    public int isValidLevel(String JNDIName, String contextFactory, String providerURL, String[][] tblNames, String secLevel) {
        QbDebug.println(4, "USER SEC LEVEL = " + secLevel);
        QbDebug.println(4, "SEC XML [JNDI NAME] = " + JNDIName);
        QbDebug.println(4, "SEC XML [CONTEXT FACTORY] = " + contextFactory);
        QbDebug.println(4, "SEC XML [PROVIDER URL] = " + providerURL);
        boolean matchTable = false;
        for (int i = 0; i < this.infoList.size(); ++i) {
            SecParamInfo tmp = (SecParamInfo)this.infoList.elementAt(i);
            QbDebug.println(4, "SEC XML [JNDI NAME] = " + tmp.getJNDIName());
            QbDebug.println(4, "SEC XML [CONTEXT FACTORY] = " + tmp.getContextFactory());
            QbDebug.println(4, "SEC XML [PROVIDER URL] = " + tmp.getProviderURL());
            QbDebug.println(4, "SEC XML [TABLE NAME] = " + tmp.getTableName());
            QbDebug.println(4, "SEC XML [COL NAME] = " + tmp.getColumnName());
            QbDebug.println(4, "SEC XML [SEC LEVELS] = " + tmp.getSecurityLevels());
            boolean matchJNDIName = false;
            boolean matchContextFactory = false;
            boolean matchProviderURL = false;
            if (JNDIName.equalsIgnoreCase(tmp.getJNDIName())) {
                matchJNDIName = true;
            }
            if (contextFactory == null || contextFactory.trim().length() == 0) {
                matchContextFactory = true;
            } else if (contextFactory.equalsIgnoreCase(tmp.getContextFactory())) {
                matchContextFactory = true;
            }
            if (providerURL == null || providerURL.trim().length() == 0) {
                matchProviderURL = true;
            } else if (providerURL.equalsIgnoreCase(tmp.getProviderURL())) {
                matchProviderURL = true;
            }
            QbDebug.println(4, "JNDI NAME MATCH = " + matchJNDIName);
            QbDebug.println(4, "CONTEXT fACTORY MATCH = " + matchContextFactory);
            QbDebug.println(4, "PROVIDER URL MATCH = " + matchProviderURL);
            if (!matchJNDIName || !matchContextFactory || !matchProviderURL) continue;
            for (String[] tblName : tblNames) {
                if (!tmp.getTableName().equals(tblName[0]) && !tmp.getTableName().equals(tblName[1])) continue;
                matchTable = true;
                QbDebug.println(4, "MATCH TBL = " + tblName[0]);
            }
            if (!matchTable || !tmp.isDenied(secLevel)) continue;
            return 2;
        }
        if (!matchTable) {
            return 0;
        }
        return 1;
    }

    public DBInfo appendConditions(DBInfo dbInfo, String secLevel) throws SecuredParameterException {
        if (!dbInfo.isUseJNDIDataSource()) {
            dbInfo.setQuery(this.appendConditionsToQuery(dbInfo.getDriverName(), dbInfo.getURLString(), dbInfo.getQuery(), secLevel));
        } else {
            dbInfo.setQuery(this.appendConditionsToQuery(dbInfo.getJNDIName(), dbInfo.getContextFactory(), dbInfo.getProviderURL(), dbInfo.getQuery(), secLevel));
        }
        return dbInfo;
    }

    public void appendConditionsForChart(quadbase.ChartAPI.DBInfo dbInfo, String secLevel) throws SecuredParameterException {
        if (!dbInfo.isUseJNDIDataSource()) {
            int result = this.isValidLevel(dbInfo.getDriverName(), dbInfo.getURLString(), this.getTableNamesAndAliases(dbInfo.getQuery()), secLevel);
            if (result == 0) {
                return;
            }
            if (result == 2) {
                throw new SecuredParameterException();
            }
            dbInfo.setQuery(this.appendConditionsToQuery(dbInfo.getDriverName(), dbInfo.getURLString(), dbInfo.getQuery(), secLevel));
        } else {
            int result = this.isValidLevel(dbInfo.getJNDIName(), dbInfo.getContextFactory(), dbInfo.getProviderURL(), this.getTableNamesAndAliases(dbInfo.getQuery()), secLevel);
            if (result == 0) {
                return;
            }
            if (result == 2) {
                throw new SecuredParameterException();
            }
            dbInfo.setQuery(this.appendConditionsToQuery(dbInfo.getJNDIName(), dbInfo.getContextFactory(), dbInfo.getProviderURL(), dbInfo.getQuery(), secLevel));
        }
    }

    public IQueryFileInfo appendCondtionForParamChart(IQueryFileInfo iqueryFileInfo, String secLevel) throws Exception {
        Vector vect;
        String query = iqueryFileInfo.getQuery();
        boolean isJNDI = false;
        if (iqueryFileInfo instanceof QbUtil.CQueryFileInfo) {
            isJNDI = ((QbUtil.CQueryFileInfo)iqueryFileInfo).isUseJNDIDataSource();
        }
        QbDebug.println(4, "USER SEC LEVEL = " + secLevel);
        if (isJNDI) {
            String providerURL = null;
            String contextFactory = null;
            Hashtable env = ((QbUtil.CQueryFileInfo)iqueryFileInfo).getEnvProperties();
            if (env != null && env.size() > 0) {
                providerURL = (String)env.get("java.naming.provider.url");
                contextFactory = (String)env.get("java.naming.factory.initial");
            }
            vect = this.getParamInfos(this.getTableNamesAndAliases(query), ((QbUtil.CQueryFileInfo)iqueryFileInfo).getJNDIName(), providerURL, contextFactory);
        } else {
            vect = this.getParamInfos(this.getTableNamesAndAliases(query), iqueryFileInfo.getDriverName(), iqueryFileInfo.getURLString());
        }
        for (int i = 0; i < vect.size(); ++i) {
            SecParamInfo tmp = (SecParamInfo)vect.elementAt(i);
            if (!tmp.isSecured(secLevel)) continue;
            for (int j = 0; j < iqueryFileInfo.getInParam().length; ++j) {
                quadbase.util.IQueryInParam iparam = iqueryFileInfo.getInParam()[j];
                if (!iparam.getTableName().equalsIgnoreCase(tmp.getTableName()) || !iparam.getColumnName().equalsIgnoreCase(tmp.getColumnName()) && !iparam.getColumnName().equalsIgnoreCase(tmp.getTableName() + "." + tmp.getColumnName()) && !tmp.getColumnName().equalsIgnoreCase(iparam.getTableName() + "." + iparam.getColumnName())) continue;
                Object valObj = tmp.getObject(secLevel);
                if (iparam instanceof IQueryMultiValueInParam) {
                    if (!(valObj instanceof Vector)) {
                        Vector<Object> v2 = new Vector<Object>();
                        v2.add(valObj);
                        ((IQueryMultiValueInParam)iparam).setDefaultValue(v2);
                        if (((Vector)iparam.getValue()).get(0).toString().equals(valObj)) continue;
                        ((IQueryMultiValueInParam)iparam).setValues((Vector)v2);
                        continue;
                    }
                    ((IQueryMultiValueInParam)iparam).setDefaultValue(valObj);
                    continue;
                }
                if (valObj instanceof Vector) {
                    Object obj = ((Vector)valObj).elementAt(0);
                    iparam.setDefaultValue(obj);
                    if (((Vector)valObj).contains(iparam.getValue())) continue;
                    iparam.setValue(obj);
                    continue;
                }
                iparam.setDefaultValue(valObj);
                if (valObj.toString().equals(iparam.getValue())) continue;
                iparam.setValue(valObj);
            }
        }
        SimpleQueryFileInfo sqf = null;
        if (isJNDI) {
            String providerURL = null;
            String contextFactory = null;
            Hashtable env = ((QbUtil.CQueryFileInfo)iqueryFileInfo).getEnvProperties();
            if (env != null && env.size() > 0) {
                providerURL = (String)env.get("java.naming.provider.url");
                contextFactory = (String)env.get("java.naming.factory.initial");
            }
            sqf = new SimpleQueryFileInfo(((QbUtil.CQueryFileInfo)iqueryFileInfo).getJNDIName(), iqueryFileInfo.getQuery(), env);
            sqf.setInParam(iqueryFileInfo.getInParam());
            sqf.setQuery(this.appendConditionsToQuery(((QbUtil.CQueryFileInfo)iqueryFileInfo).getJNDIName(), providerURL, contextFactory, query, secLevel));
        } else {
            sqf = new SimpleQueryFileInfo(iqueryFileInfo.getURLString(), iqueryFileInfo.getDriverName(), iqueryFileInfo.getUserID(), iqueryFileInfo.getPassword(), iqueryFileInfo.getQuery());
            sqf.setInParam(iqueryFileInfo.getInParam());
            sqf.setQuery(this.appendConditionsToQuery(iqueryFileInfo.getDriverName(), iqueryFileInfo.getURLString(), query, secLevel));
        }
        return sqf;
    }

    public QueryFileInfo appendConditionForParamReport(QueryFileInfo queryFileInfo, String secLevel) throws Exception {
        String query = queryFileInfo.getQuery();
        boolean isJNDI = queryFileInfo.isUseJNDIDataSource();
        QbDebug.println(4, "USER SEC LEVEL = " + secLevel);
        Vector vect = isJNDI ? this.getParamInfos(this.getTableNamesAndAliases(query), queryFileInfo.getJNDIName(), queryFileInfo.getContextFactory(), queryFileInfo.getProviderURL()) : this.getParamInfos(this.getTableNamesAndAliases(query), queryFileInfo.getDriverName(), queryFileInfo.getURLString());
        for (int i = 0; i < vect.size(); ++i) {
            SecParamInfo tmp = (SecParamInfo)vect.elementAt(i);
            if (!tmp.isSecured(secLevel)) continue;
            for (int j = 0; j < queryFileInfo.getInParam().length; ++j) {
                IQueryInParam iparam = queryFileInfo.getInParam()[j];
                if (!iparam.getTableName().equalsIgnoreCase(tmp.getTableName()) || !iparam.getColumnName().equalsIgnoreCase(tmp.getColumnName()) && !iparam.getColumnName().equalsIgnoreCase(tmp.getTableName() + "." + tmp.getColumnName()) && !tmp.getColumnName().equalsIgnoreCase(iparam.getTableName() + "." + iparam.getColumnName())) continue;
                Object valObj = tmp.getObject(secLevel);
                if (iparam instanceof IQueryMultiValueInParam) {
                    if (!(valObj instanceof Vector)) {
                        Vector<Object> v2 = new Vector<Object>();
                        v2.add(valObj);
                        ((IQueryMultiValueInParam)iparam).setValues((Vector)v2);
                        ((IQueryMultiValueInParam)iparam).setDefaultValue(v2);
                        continue;
                    }
                    ((IQueryMultiValueInParam)iparam).setValues((Vector)valObj);
                    ((IQueryMultiValueInParam)iparam).setDefaultValue(valObj);
                    continue;
                }
                if (valObj instanceof Vector) {
                    Object obj = ((Vector)valObj).elementAt(0);
                    iparam.setValue(obj);
                    iparam.setDefaultValue(obj);
                    continue;
                }
                iparam.setValue(valObj);
                iparam.setDefaultValue(valObj);
            }
        }
        String queryStr = null;
        queryStr = isJNDI ? this.appendConditionsToQuery(queryFileInfo.getJNDIName(), queryFileInfo.getContextFactory(), queryFileInfo.getProviderURL(), query, secLevel) : this.appendConditionsToQuery(queryFileInfo.getDriverName(), queryFileInfo.getURLString(), query, secLevel);
        queryFileInfo.setQuery(queryStr);
        return queryFileInfo;
    }

    private String[][] getTableNamesAndAliases(String query) {
        query = this.revertReplacements(query);
        String[] tableNames = QueryParser.getAllTableNames(query);
        String[] tableAliases = QueryParser.getAllTableAlias(query);
        String[][] tableNamesAndAliases = new String[tableNames.length][2];
        for (int i = 0; i < tableNames.length; ++i) {
            tableNamesAndAliases[i][0] = tableNames[i];
            tableNamesAndAliases[i][1] = tableAliases[i];
        }
        return tableNamesAndAliases;
    }

    public String appendConditionsToQuery(String driver, String url, String query, String secLevel) throws SecuredParameterException {
        String oldQuery;
        int result = this.isValidLevel(driver, url, this.getTableNamesAndAliases(query), secLevel);
        if (result == 0) {
            return query;
        }
        if (result == 2) {
            throw new SecuredParameterException();
        }
        QbDebug.println(4, "Appending conditions\nOriginal query:\n" + query);
        Pattern bracketPattern = Pattern.compile("\\(([^()]*)\\)");
        Pattern selectPattern = Pattern.compile("(?i)(?s).*\\bSELECT\\b.*");
        StringBuffer sb = new StringBuffer(query);
        do {
            Matcher m;
            oldQuery = sb.toString();
            boolean found = false;
            do {
                m = bracketPattern.matcher(sb);
                sb = new StringBuffer();
                found = false;
                while (m.find()) {
                    if (selectPattern.matcher(m.group()).matches()) continue;
                    m.appendReplacement(sb, "<l#E#f#T>$1<R#i#G#h#T>");
                    found = true;
                }
                m.appendTail(sb);
            } while (found);
            m = bracketPattern.matcher(sb);
            sb = new StringBuffer();
            while (m.find()) {
                String subQuery = m.group().substring(1, m.group().length() - 1);
                subQuery = this.appendConditionsToSubQuery(driver, url, subQuery, secLevel);
                m.appendReplacement(sb, LEFT_BRACKET_REPLACEMENT + Matcher.quoteReplacement(subQuery) + RIGHT_BRACKET_REPLACEMENT);
            }
            m.appendTail(sb);
        } while (!sb.toString().equals(oldQuery));
        query = this.appendConditionsToSubQuery(driver, url, sb.toString(), secLevel);
        query = this.revertReplacements(query);
        QbDebug.println(4, "Modified query:\n" + query);
        return query;
    }

    private String appendConditionsToSubQuery(String driver, String url, String query, String secLevel) {
        Pattern unionPattern = Pattern.compile("(?i)UNION ALL|UNION");
        String[] unionParts = unionPattern.split(query);
        for (int partNo = 0; partNo < unionParts.length; ++partNo) {
            String where;
            if (!unionParts[partNo].matches("(?i)(?s).*\\bSELECT\\b.*")) continue;
            String conditions = "";
            QbDebug.println(4, "APPEND CONDITION TO SUB QUERY");
            String[][] namesAndAliases = this.getTableNamesAndAliases(unionParts[partNo]);
            Vector vec = this.getParamInfos(namesAndAliases, driver, url);
            for (int i = 0; i < vec.size(); ++i) {
                String cond;
                SecParamInfo tmp = (SecParamInfo)vec.elementAt(i);
                if (!tmp.isSecured(secLevel) || (cond = tmp.getCondition(namesAndAliases, secLevel)) == null) continue;
                if (conditions.length() > 0) {
                    conditions = conditions + " AND ";
                }
                conditions = conditions + cond;
            }
            if (conditions.length() == 0) continue;
            String result = "<s#E#l#E#c#T> " + GenericParser.getQueryPart(unionParts[partNo], 1, false);
            String from = GenericParser.getQueryPart(unionParts[partNo], 2, false);
            if (from != null) {
                result = result + " <F#r#O#m> " + from;
            }
            result = (where = GenericParser.getQueryPart(unionParts[partNo], 3, false)) == null || where.length() == 0 ? result + " <W#h#e#R#e> " + conditions + " " : result + " <W#h#e#R#e> " + conditions + " AND " + LEFT_BRACKET_REPLACEMENT + where + RIGHT_BRACKET_REPLACEMENT + " ";
            unionParts[partNo] = result = result + GenericParser.getPostWhereQuery(unionParts[partNo]);
        }
        StringBuffer newQuery = new StringBuffer(unionParts[0]);
        Matcher m = unionPattern.matcher(query);
        int i = 1;
        while (m.find()) {
            newQuery.append(" " + m.group() + " " + unionParts[i]);
            ++i;
        }
        return newQuery.toString();
    }

    public String appendConditionsToQuery(String jndiName, String contextFactory, String providerURL, String query, String secLevel) throws SecuredParameterException {
        String oldQuery;
        int result = this.isValidLevel(jndiName, contextFactory, providerURL, this.getTableNamesAndAliases(query), secLevel);
        if (result == 0) {
            return query;
        }
        if (result == 2) {
            throw new SecuredParameterException();
        }
        QbDebug.println(4, "Appending conditions\nOriginal query:\n" + query);
        Pattern bracketPattern = Pattern.compile("\\(([^()]*)\\)");
        Pattern selectPattern = Pattern.compile("(?i)(?s).*\\bSELECT\\b.*");
        StringBuffer sb = new StringBuffer(query);
        do {
            Matcher m;
            oldQuery = sb.toString();
            boolean found = false;
            do {
                m = bracketPattern.matcher(sb);
                sb = new StringBuffer();
                found = false;
                while (m.find()) {
                    if (selectPattern.matcher(m.group()).matches()) continue;
                    m.appendReplacement(sb, "<l#E#f#T>$1<R#i#G#h#T>");
                    found = true;
                }
                m.appendTail(sb);
            } while (found);
            m = bracketPattern.matcher(sb);
            sb = new StringBuffer();
            while (m.find()) {
                String subQuery = m.group().substring(1, m.group().length() - 1);
                subQuery = this.appendConditionsToSubQuery(jndiName, contextFactory, providerURL, subQuery, secLevel);
                m.appendReplacement(sb, LEFT_BRACKET_REPLACEMENT + Matcher.quoteReplacement(subQuery) + RIGHT_BRACKET_REPLACEMENT);
            }
            m.appendTail(sb);
        } while (!sb.toString().equals(oldQuery));
        query = this.appendConditionsToSubQuery(jndiName, contextFactory, providerURL, sb.toString(), secLevel);
        query = this.revertReplacements(query);
        QbDebug.println(4, "Modified query:\n" + query);
        return query;
    }

    private String appendConditionsToSubQuery(String jndiName, String contextFactory, String providerURL, String query, String secLevel) {
        Pattern unionPattern = Pattern.compile("(?i)UNION ALL|UNION");
        String[] unionParts = unionPattern.split(query);
        for (int partNo = 0; partNo < unionParts.length; ++partNo) {
            String where;
            if (!unionParts[partNo].matches("(?i)(?s).*\\bSELECT\\b.*")) continue;
            String conditions = "";
            QbDebug.println(4, "APPEND CONDITION TO SUB QUERY");
            String[][] namesAndAliases = this.getTableNamesAndAliases(unionParts[partNo]);
            Vector vec = this.getParamInfos(namesAndAliases, jndiName, contextFactory, providerURL);
            for (int i = 0; i < vec.size(); ++i) {
                String cond;
                SecParamInfo tmp = (SecParamInfo)vec.elementAt(i);
                if (!tmp.isSecured(secLevel) || (cond = tmp.getCondition(namesAndAliases, secLevel)) == null) continue;
                if (conditions.length() > 0) {
                    conditions = conditions + " AND ";
                }
                conditions = conditions + cond;
            }
            if (conditions.length() == 0) continue;
            String result = "<s#E#l#E#c#T> " + GenericParser.getQueryPart(unionParts[partNo], 1, false);
            String from = GenericParser.getQueryPart(unionParts[partNo], 2, false);
            if (from != null) {
                result = result + " <F#r#O#m> " + from;
            }
            result = (where = GenericParser.getQueryPart(unionParts[partNo], 3, false)) == null || where.length() == 0 ? result + " <W#h#e#R#e> " + conditions + " " : result + " <W#h#e#R#e> " + conditions + " AND " + LEFT_BRACKET_REPLACEMENT + where + RIGHT_BRACKET_REPLACEMENT + " ";
            unionParts[partNo] = result = result + GenericParser.getPostWhereQuery(unionParts[partNo]);
        }
        StringBuffer newQuery = new StringBuffer(unionParts[0]);
        Matcher m = unionPattern.matcher(query);
        int i = 1;
        while (m.find()) {
            newQuery.append(" " + m.group() + " " + unionParts[i]);
            ++i;
        }
        return newQuery.toString();
    }

    private String revertReplacements(String query) {
        query = query.replaceAll(LEFT_BRACKET_REPLACEMENT, "(");
        query = query.replaceAll(RIGHT_BRACKET_REPLACEMENT, ")");
        query = query.replaceAll(SELECT_REPLACEMENT, "SELECT");
        query = query.replaceAll(FROM_REPLACEMENT, "FROM");
        query = query.replaceAll(WHERE_REPLACEMENT, "WHERE");
        return query;
    }

    public Vector getInfoList() {
        return this.infoList;
    }
}

