/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.util.dtd;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class DTDGenerator
extends DefaultHandler {
    protected static final int MIN_ENUMERATION_INSTANCES = 10;
    protected static final int MAX_ENUMERATION_VALUES = 20;
    protected static final int MIN_ENUMERATION_RATIO = 3;
    protected static final int MIN_FIXED = 5;
    protected static final int MIN_ID_VALUES = 10;
    protected static final int MAX_ID_VALUES = 100000;
    TreeMap<String, ElementDetails> elementList = new TreeMap();
    Stack<StackEntry> elementStack = new Stack();

    public void run(InputStream is) throws Exception {
        XMLReader parser = SAXParserFactory.newInstance().newSAXParser().getXMLReader();
        parser.setContentHandler(this);
        parser.parse(new InputSource(is));
    }

    private boolean isValidName(String s) {
        if (!this.isValidNMTOKEN(s)) {
            return false;
        }
        char c = s.charAt(0);
        return (c < '0' || c > '9') && c != '.' && c != '-';
    }

    private boolean isValidNMTOKEN(String s) {
        if (s.length() == 0) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '.' || c == '_' || c == '-' || c == ':' || c > '\u0080') continue;
            return false;
        }
        return true;
    }

    public void printDTD(OutputStream os) {
        PrintStream ps = new PrintStream(os);
        for (String elementname : this.elementList.keySet()) {
            ElementDetails ed = this.elementList.get(elementname);
            TreeMap children = ed.children;
            Set childKeys = children.keySet();
            if (childKeys.size() == 0 && !ed.hasCharacterContent) {
                ps.print("<!ELEMENT " + elementname + " EMPTY >\n");
            }
            if (childKeys.size() == 0 && ed.hasCharacterContent) {
                ps.print("<!ELEMENT " + elementname + " ( #PCDATA ) >\n");
            }
            if (childKeys.size() > 0 && !ed.hasCharacterContent) {
                ps.print("<!ELEMENT " + elementname + " ( ");
                if (ed.sequenced) {
                    Enumeration c = ed.childseq.elements();
                    while (true) {
                        ChildDetails ch = (ChildDetails)c.nextElement();
                        ps.print(ch.name);
                        if (ch.repeatable && !ch.optional) {
                            ps.print("+");
                        }
                        if (ch.repeatable && ch.optional) {
                            ps.print("*");
                        }
                        if (ch.optional && !ch.repeatable) {
                            ps.print("?");
                        }
                        if (!c.hasMoreElements()) break;
                        ps.print(", ");
                    }
                    ps.print(" ) >\n");
                } else {
                    Iterator c1 = childKeys.iterator();
                    while (c1.hasNext()) {
                        ps.print((String)c1.next());
                        if (!c1.hasNext()) continue;
                        ps.print(" | ");
                    }
                    ps.print(" )* >\n");
                }
            }
            if (childKeys.size() > 0 && ed.hasCharacterContent) {
                ps.print("<!ELEMENT " + elementname + " ( #PCDATA");
                Iterator c2 = childKeys.iterator();
                while (c2.hasNext()) {
                    ps.print(" | " + (String)c2.next());
                }
                ps.print(" )* >\n");
            }
            TreeMap attlist = ed.attributes;
            boolean doneID = false;
            for (String attname : attlist.keySet()) {
                String tokentype;
                AttributeDetails ad = (AttributeDetails)attlist.get(attname);
                boolean required = ad.occurrences == ed.occurrences;
                boolean isid = ad.allNames && !doneID && ad.unique && ad.occurrences >= 10;
                boolean isfixed = required && ad.values.size() == 1 && ad.occurrences >= 5;
                boolean isenum = ad.allNMTOKENs && ad.occurrences >= 10 && ad.values.size() <= ad.occurrences / 3 && ad.values.size() <= 20;
                ps.print("<!ATTLIST " + elementname + " " + attname + " ");
                String string = tokentype = ad.allNMTOKENs ? "NMTOKEN" : "CDATA";
                if (isid) {
                    ps.print("ID");
                    doneID = true;
                } else if (isfixed) {
                    String val = (String)ad.values.first();
                    ps.print(tokentype + " #FIXED \"" + DTDGenerator.escape(val) + "\" >\n");
                } else if (isenum) {
                    ps.print("( ");
                    Iterator v = ad.values.iterator();
                    while (v.hasNext()) {
                        ps.print((String)v.next());
                        if (!v.hasNext()) break;
                        ps.print(" | ");
                    }
                    ps.print(" )");
                } else {
                    ps.print(tokentype);
                }
                if (isfixed) continue;
                if (required) {
                    ps.print(" #REQUIRED >\n");
                    continue;
                }
                ps.print(" #IMPLIED >\n");
            }
            ps.print("\n");
        }
    }

    private static int escape(char[] ch, int start, int length, char[] out) {
        int o = 0;
        for (int i = start; i < start + length; ++i) {
            if (ch[i] == '<') {
                "&lt;".getChars(0, 4, out, o);
                o += 4;
                continue;
            }
            if (ch[i] == '>') {
                "&gt;".getChars(0, 4, out, o);
                o += 4;
                continue;
            }
            if (ch[i] == '&') {
                "&amp;".getChars(0, 5, out, o);
                o += 5;
                continue;
            }
            if (ch[i] == '\"') {
                "&#34;".getChars(0, 5, out, o);
                o += 5;
                continue;
            }
            if (ch[i] == '\'') {
                "&#39;".getChars(0, 5, out, o);
                o += 5;
                continue;
            }
            if (ch[i] <= '\u007f') {
                out[o++] = ch[i];
                continue;
            }
            String dec = "&#" + Integer.toString(ch[i]) + ';';
            dec.getChars(0, dec.length(), out, o);
            o += dec.length();
        }
        return o;
    }

    private static String escape(String in) {
        char[] dest = new char[in.length() * 8];
        int newlen = DTDGenerator.escape(in.toCharArray(), 0, in.length(), dest);
        return new String(dest, 0, newlen);
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        StackEntry se = new StackEntry();
        ElementDetails ed = this.elementList.get(name);
        if (ed == null) {
            ed = new ElementDetails(name);
            this.elementList.put(name, ed);
        }
        se.elementDetails = ed;
        se.sequenceNumber = -1;
        ++ed.occurrences;
        for (int a = 0; a < attributes.getLength(); ++a) {
            String attName = attributes.getQName(a);
            String val = attributes.getValue(a);
            AttributeDetails ad = (AttributeDetails)ed.attributes.get(attName);
            if (ad == null) {
                ad = new AttributeDetails(attName);
                ed.attributes.put(attName, ad);
            }
            if (!ad.values.contains(val)) {
                ad.values.add(val);
                if (ad.allNames && !this.isValidName(val)) {
                    ad.allNames = false;
                }
                if (ad.allNMTOKENs && !this.isValidNMTOKEN(val)) {
                    ad.allNMTOKENs = false;
                }
                if (ad.unique && ad.allNames && ad.occurrences <= 100000) {
                    ad.values.add(val);
                } else if (ad.values.size() <= 20) {
                    ad.values.add(val);
                }
            } else {
                ad.unique = false;
            }
            ++ad.occurrences;
        }
        if (!this.elementStack.isEmpty()) {
            boolean isFirstInGroup;
            StackEntry parent = this.elementStack.peek();
            ElementDetails parentDetails = parent.elementDetails;
            int seq = parent.sequenceNumber;
            boolean bl = isFirstInGroup = parent.latestChild == null || !parent.latestChild.equals(name);
            if (isFirstInGroup) {
                ++seq;
                ++parent.sequenceNumber;
            }
            parent.latestChild = name;
            TreeMap children = parentDetails.children;
            ChildDetails c = (ChildDetails)children.get(name);
            if (c == null) {
                c = new ChildDetails();
                c.name = name;
                c.position = seq;
                c.repeatable = false;
                c.optional = false;
                children.put(name, c);
                parentDetails.childseq.addElement(c);
                if (parentDetails.occurrences != 1) {
                    c.optional = true;
                }
            } else {
                if (parentDetails.occurrences == 1 && isFirstInGroup) {
                    parentDetails.sequenced = false;
                }
                if (parentDetails.childseq.size() <= seq || !((ChildDetails)parentDetails.childseq.elementAt((int)seq)).name.equals(name)) {
                    parentDetails.sequenced = false;
                }
            }
            if (!isFirstInGroup) {
                c.repeatable = true;
            }
        }
        this.elementStack.push(se);
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        ElementDetails ed = this.elementList.get(name);
        if (ed.sequenced) {
            StackEntry se = this.elementStack.peek();
            int seq = se.sequenceNumber;
            for (int i = seq + 1; i < ed.childseq.size(); ++i) {
                ((ChildDetails)ed.childseq.elementAt((int)i)).optional = true;
            }
        }
        this.elementStack.pop();
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        ElementDetails ed = this.elementStack.peek().elementDetails;
        if (!ed.hasCharacterContent) {
            for (int i = start; i < start + length; ++i) {
                if (ch[i] <= ' ') continue;
                ed.hasCharacterContent = true;
                break;
            }
        }
    }

    private class StackEntry {
        ElementDetails elementDetails;
        int sequenceNumber;
        String latestChild;

        private StackEntry() {
        }
    }

    private class AttributeDetails {
        String name;
        int occurrences;
        boolean unique;
        TreeSet values;
        boolean allNames;
        boolean allNMTOKENs;

        public AttributeDetails(String name) {
            this.name = name;
            this.occurrences = 0;
            this.unique = true;
            this.values = new TreeSet();
            this.allNames = true;
            this.allNMTOKENs = true;
        }
    }

    private class ChildDetails {
        String name;
        int position;
        boolean repeatable;
        boolean optional;

        private ChildDetails() {
        }
    }

    private class ElementDetails {
        String name;
        int occurrences;
        boolean hasCharacterContent;
        boolean sequenced;
        TreeMap children;
        Vector childseq;
        TreeMap attributes;

        public ElementDetails(String name) {
            this.name = name;
            this.occurrences = 0;
            this.hasCharacterContent = false;
            this.sequenced = true;
            this.children = new TreeMap();
            this.childseq = new Vector();
            this.attributes = new TreeMap();
        }
    }
}

