/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.util.dtd.elements;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import quadbase.common.util.dtd.elements.DTDContainer;
import quadbase.common.util.dtd.elements.DTDElement;
import quadbase.common.util.dtd.elements.DTDItem;
import quadbase.common.util.dtd.elements.DTDName;
import quadbase.common.util.dtd.elements.DTDOutput;
import quadbase.common.util.internal.IOUtil;

public class DTD
implements DTDOutput {
    protected Hashtable<String, DTDElement> elements;
    protected DTDElement rootElement;

    public DTD() {
        this.elements = new Hashtable();
        this.rootElement = null;
    }

    public DTD(Hashtable<String, DTDElement> elements, DTDElement root) {
        this.elements = elements;
        this.rootElement = root;
    }

    public boolean equals(Object ob) {
        if (this == ob) {
            return true;
        }
        if (!(ob instanceof DTD)) {
            return false;
        }
        DTD otherDTD = (DTD)ob;
        return this.elements.equals(otherDTD.elements);
    }

    public DTDElement getRootElement() {
        return this.rootElement;
    }

    public void setRootElement(DTDElement root) {
        this.rootElement = root;
    }

    public Hashtable<String, DTDElement> getElements() {
        return this.elements;
    }

    public DTDElement getElement(String eltName) {
        if (this.elements != null && this.elements.containsKey(eltName)) {
            return this.elements.get(eltName);
        }
        return null;
    }

    private String[] getElementNames() {
        String[] eltNames = new String[this.elements.size()];
        Enumeration<String> e = this.elements.keys();
        int i = 0;
        while (e.hasMoreElements()) {
            String obj = e.nextElement();
            eltNames[i] = obj.toString();
            ++i;
        }
        return eltNames;
    }

    @Override
    public void write(DataOutputStream out) throws IOException {
        String[] eltNames = this.getElementNames();
        int eltCt = this.elements.size();
        out.writeInt(eltCt);
        for (int i = 0; i < eltCt; ++i) {
            IOUtil.writeStr(out, eltNames[i]);
            if (!this.elements.containsKey(eltNames[i])) continue;
            DTDElement elt = this.elements.get(eltNames[i]);
            elt.write(out);
        }
        this.rootElement.write(out);
    }

    @Override
    public DTDOutput read(DataInputStream in, int version) throws IOException {
        Hashtable<String, DTDElement> eltTable = new Hashtable<String, DTDElement>();
        int eltCt = in.readInt();
        for (int i = 0; i < eltCt; ++i) {
            String eltName = IOUtil.readStr(in);
            DTDElement elt = (DTDElement)new DTDElement().read(in, version);
            eltTable.put(eltName, elt);
        }
        DTDElement root = (DTDElement)new DTDElement().read(in, version);
        return new DTD(eltTable, root);
    }

    public void traverseRootElement() {
        if (this.rootElement == null) {
            System.out.println("DTD ROOT? ");
            return;
        }
        Enumeration<DTDElement> elts = this.elements.elements();
        boolean reset = false;
        while (elts.hasMoreElements() && !reset) {
            DTDElement cElt = elts.nextElement();
            DTDItem cItem = cElt.getContent();
            if (cItem instanceof DTDContainer) {
                Vector<DTDItem> vec = this.traverseDTDItem((DTDContainer)cItem);
                for (int i = 0; i < vec.size(); ++i) {
                    DTDItem item = vec.elementAt(i);
                    if (!(item instanceof DTDName) || !((DTDName)item).getValue().equals(this.rootElement.getName())) continue;
                    this.rootElement = cElt;
                    reset = true;
                }
                continue;
            }
            if (!(cItem instanceof DTDName) || !((DTDName)cItem).getValue().equals(this.rootElement.getName())) continue;
            this.rootElement = cElt;
            reset = true;
        }
        if (reset) {
            this.traverseRootElement();
        }
    }

    private Vector<DTDItem> traverseDTDItem(DTDContainer con) {
        DTDItem[] items = con.getItems();
        Vector<DTDItem> vec = new Vector<DTDItem>();
        for (int i = 0; i < items.length; ++i) {
            if (!(items[i] instanceof DTDContainer)) {
                vec.addElement(items[i]);
                continue;
            }
            Vector<DTDItem> temp = this.traverseDTDItem((DTDContainer)items[i]);
            for (int j = 0; j < temp.size(); ++j) {
                vec.addElement(temp.elementAt(j));
            }
        }
        return vec;
    }
}

