/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.util.dtd.elements;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;
import quadbase.common.util.dtd.elements.DTDAttribute;
import quadbase.common.util.dtd.elements.DTDOutput;
import quadbase.common.util.internal.IOUtil;

public class DTDAttlist
implements DTDOutput {
    protected String name;
    protected Vector attributes;

    public DTDAttlist() {
        this.name = "";
        this.attributes = new Vector();
    }

    public DTDAttlist(String name) {
        this.name = name;
        this.attributes = new Vector();
    }

    public boolean equals(Object ob) {
        if (ob == this) {
            return true;
        }
        if (!(ob instanceof DTDAttlist)) {
            return false;
        }
        DTDAttlist other = (DTDAttlist)ob;
        if (this.name == null && other.name != null) {
            return false;
        }
        if (this.name != null && !this.name.equals(other.name)) {
            return false;
        }
        return this.attributes.equals(other.attributes);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public DTDAttribute[] getAttribute() {
        Object[] attrs = new DTDAttribute[this.attributes.size()];
        this.attributes.copyInto(attrs);
        return attrs;
    }

    public void setAttribute(DTDAttribute[] attrs) {
        this.attributes = new Vector(attrs.length);
        for (DTDAttribute attr : attrs) {
            this.attributes.addElement(attr);
        }
    }

    public DTDAttribute getAttribute(int i) {
        return (DTDAttribute)this.attributes.elementAt(i);
    }

    public void setAttribute(DTDAttribute attr, int i) {
        this.attributes.setElementAt(attr, i);
    }

    public Vector getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Vector atts) {
        this.attributes = atts;
    }

    @Override
    public void write(DataOutputStream out) throws IOException {
        IOUtil.writeStr(out, this.name);
        DTDAttribute[] attrs = this.getAttribute();
        out.writeInt(attrs.length);
        for (DTDAttribute attr : attrs) {
            attr.write(out);
        }
    }

    @Override
    public DTDOutput read(DataInputStream in, int version) throws IOException {
        String eltName = IOUtil.readStr(in);
        int ct = in.readInt();
        DTDAttlist attlist = new DTDAttlist(eltName);
        DTDAttribute[] atts = new DTDAttribute[ct];
        for (int i = 0; i < ct; ++i) {
            atts[i] = (DTDAttribute)new DTDAttribute().read(in, version);
        }
        attlist.setAttribute(atts);
        return attlist;
    }
}

