/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.util.dtd.elements;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import quadbase.common.util.dtd.elements.DTDEnumeration;
import quadbase.common.util.dtd.elements.DTDNotationList;
import quadbase.common.util.dtd.elements.DTDOutput;
import quadbase.common.util.internal.IOUtil;

public class DTDAttribute
implements DTDOutput {
    protected String name;
    protected Object type;
    protected String dataType = "string";
    protected String dateFormat;
    protected int declaration = 0;
    protected String defaultValue = null;

    public DTDAttribute() {
    }

    public DTDAttribute(String name) {
        this.name = name;
    }

    public boolean equalsWOFormat(Object ob) {
        if (ob == this) {
            return true;
        }
        if (!(ob instanceof DTDAttribute)) {
            return false;
        }
        DTDAttribute other = (DTDAttribute)ob;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }

    public boolean equals(Object ob) {
        if (!this.equalsWOFormat(ob)) {
            return false;
        }
        DTDAttribute other = (DTDAttribute)ob;
        if (this.dataType == null ? other.dataType != null : !this.dataType.equals(other.dataType)) {
            return false;
        }
        if (this.dateFormat == null ? other.dateFormat != null : !this.dateFormat.equals(other.dateFormat)) {
            return false;
        }
        if (this.declaration != other.declaration) {
            return false;
        }
        return !(this.defaultValue == null ? other.defaultValue != null : !this.defaultValue.equals(other.defaultValue));
    }

    public void merge(Object oba) {
        DTDAttribute ob = (DTDAttribute)oba;
        if (ob.dataType != null) {
            this.dataType = ob.dataType;
        }
        if (ob.dateFormat != null) {
            this.dateFormat = ob.dateFormat;
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setType(Object type) {
        if (!(type instanceof String || type instanceof DTDEnumeration || type instanceof DTDNotationList)) {
            throw new IllegalArgumentException("Must be String, DTDEnumeration or DTDNotationList");
        }
        this.type = type;
    }

    public Object getType() {
        return this.type;
    }

    public boolean isCDATAType() {
        if (this.type instanceof String) {
            return ((String)this.type).equals("CDATA");
        }
        return false;
    }

    public String getDataType() {
        if (this.isCDATAType()) {
            return this.dataType;
        }
        return "string";
    }

    public void setDataType(String dataType) {
        if (this.isCDATAType()) {
            this.dataType = dataType;
        }
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(String format) {
        if (this.isCDATAType() && this.dataType != null && this.dataType.equals("date")) {
            this.dateFormat = format;
        }
    }

    public void setDeclaration(int decl) {
        this.declaration = decl;
    }

    public int getDeclaration() {
        return this.declaration;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public void write(DataOutputStream out) throws IOException {
        IOUtil.writeStr(out, this.name);
        if (this.type instanceof String) {
            out.writeInt(12);
            IOUtil.writeStr(out, this.type.toString());
            if (this.isCDATAType()) {
                IOUtil.writeStr(out, this.dataType);
                if (this.dataType.equals("date")) {
                    IOUtil.writeStr(out, this.dateFormat);
                }
            }
        } else if (this.type instanceof DTDEnumeration) {
            out.writeInt(6);
            DTDEnumeration dtdEnum = (DTDEnumeration)this.type;
            dtdEnum.write(out);
        } else if (this.type instanceof DTDNotationList) {
            out.writeInt(9);
            DTDNotationList dtdnl = (DTDNotationList)this.type;
            dtdnl.write(out);
        }
        out.writeInt(this.declaration);
        if (this.defaultValue != null) {
            out.writeBoolean(true);
            IOUtil.writeStr(out, this.defaultValue);
        } else {
            out.writeBoolean(false);
        }
    }

    @Override
    public DTDOutput read(DataInputStream in, int version) throws IOException {
        String attname = IOUtil.readStr(in);
        int atttype = in.readInt();
        Object type = null;
        String dataType = null;
        String dateFormat = null;
        if (atttype == 12) {
            type = IOUtil.readStr(in);
            if (((String)type).equals("CDATA") && (dataType = IOUtil.readStr(in)).equals("date")) {
                dateFormat = IOUtil.readStr(in);
            }
        } else if (atttype == 6) {
            type = new DTDEnumeration().read(in, version);
        } else if (atttype == 9) {
            type = new DTDNotationList().read(in, version);
        }
        int decl = in.readInt();
        boolean hasDefault = in.readBoolean();
        String defaultValue = null;
        if (hasDefault) {
            defaultValue = IOUtil.readStr(in);
        }
        DTDAttribute att = new DTDAttribute(attname);
        att.setType(type);
        att.setDataType(dataType);
        att.setDateFormat(dateFormat);
        att.setDeclaration(decl);
        att.setDefaultValue(defaultValue);
        return att;
    }
}

