/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.util.dtd.elements;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import quadbase.common.util.dtd.elements.DTDAttribute;
import quadbase.common.util.dtd.elements.DTDItem;
import quadbase.common.util.dtd.elements.DTDMixed;
import quadbase.common.util.dtd.elements.DTDOutput;
import quadbase.common.util.dtd.elements.DTDPCData;
import quadbase.common.util.internal.DTDUtil;
import quadbase.common.util.internal.IOUtil;

public class DTDElement
implements DTDOutput {
    protected String name;
    protected Hashtable<String, DTDAttribute> attributes;
    protected DTDItem content;
    protected String dataType = null;
    protected String dateFormat = null;
    protected int cardinal = 0;
    protected boolean expand = true;

    public DTDElement() {
        this.attributes = new Hashtable();
    }

    public DTDElement(String aName) {
        this.name = aName;
        this.attributes = new Hashtable();
    }

    public boolean equalsWOFormat(Object ob) {
        if (ob == this) {
            return true;
        }
        if (!(ob instanceof DTDElement)) {
            return false;
        }
        DTDElement other = (DTDElement)ob;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.attributes == null ? other.attributes != null : !this.attributes.equals(other.attributes)) {
            return false;
        }
        return !(this.content == null ? other.content != null : !this.content.equals(other.content));
    }

    public boolean equals(Object ob) {
        if (!this.equalsWOFormat(ob)) {
            return false;
        }
        DTDElement other = (DTDElement)ob;
        if (this.dataType == null ? other.dataType != null : !this.dataType.equals(other.dataType)) {
            return false;
        }
        return !(this.dateFormat == null ? other.dateFormat != null : !this.dateFormat.equals(other.dateFormat));
    }

    public void merge(Object ob) {
        DTDElement other = (DTDElement)ob;
        if (other.dataType != null) {
            this.dataType = other.dataType;
        }
        if (other.dateFormat != null) {
            this.dateFormat = other.dateFormat;
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setAttribute(String attrName, DTDAttribute attr) {
        this.attributes.put(attrName, attr);
    }

    public DTDAttribute getAttribute(String attrName) {
        return this.attributes.get(attrName);
    }

    public DTDAttribute[] getAttributes() {
        if (this.attributes != null && this.attributes.size() > 0) {
            Object[] temp = this.attributes.values().toArray();
            DTDAttribute[] atts = new DTDAttribute[temp.length];
            for (int i = 0; i < temp.length; ++i) {
                if (temp[i] instanceof DTDAttribute) {
                    atts[i] = (DTDAttribute)temp[i];
                    continue;
                }
                System.out.println("It is not a DTDAttribute. ERROR.");
            }
            return atts;
        }
        return null;
    }

    private String[] getAttributeNames() {
        String[] attNames = new String[this.attributes.size()];
        Enumeration<String> e = this.attributes.keys();
        int i = 0;
        while (e.hasMoreElements()) {
            String obj = e.nextElement();
            attNames[i] = obj.toString();
            ++i;
        }
        return attNames;
    }

    public void setContent(DTDItem content) {
        this.content = content;
    }

    public DTDItem getContent() {
        return this.content;
    }

    public int getCardinal() {
        return this.cardinal;
    }

    public void setCardinal(int cardinal) {
        this.cardinal = cardinal;
    }

    public String getDataType() {
        return this.dataType;
    }

    public void setDataType(String type) {
        this.dataType = type;
        if (type.equals("date") && this.dateFormat == null) {
            this.dateFormat = "MM-DD-YYYY";
        }
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(String format) {
        this.dateFormat = format;
    }

    public boolean isExpand() {
        return this.expand;
    }

    public void setExpand(boolean state) {
        this.expand = state;
    }

    public boolean isMixedLeaf() {
        DTDItem[] items;
        if (this.content instanceof DTDMixed && (items = ((DTDMixed)this.content).getItems()) != null && items.length >= 1) {
            for (DTDItem item : items) {
                if (!(item instanceof DTDPCData)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void write(DataOutputStream out) throws IOException {
        IOUtil.writeStr(out, this.name);
        if (this.content != null) {
            DTDUtil.writeItem(out, this.content);
        }
        String[] attNames = this.getAttributeNames();
        int attCt = this.attributes.size();
        out.writeInt(attCt);
        for (int i = 0; i < attCt; ++i) {
            IOUtil.writeStr(out, attNames[i]);
            DTDAttribute att = this.getAttribute(attNames[i]);
            att.write(out);
        }
        out.writeInt(this.cardinal);
        if (this.dataType != null) {
            out.writeBoolean(true);
            IOUtil.writeStr(out, this.getDataType());
            if (this.dataType.equals("date")) {
                IOUtil.writeStr(out, this.getDateFormat());
            }
        } else {
            out.writeBoolean(false);
        }
        out.writeBoolean(this.expand);
    }

    @Override
    public DTDOutput read(DataInputStream in, int version) throws IOException {
        DTDElement elt = new DTDElement(IOUtil.readStr(in));
        DTDItem item = DTDUtil.readItem(in, version);
        elt.setContent(item);
        int attCt = in.readInt();
        for (int i = 0; i < attCt; ++i) {
            String attName = IOUtil.readStr(in);
            DTDAttribute att = (DTDAttribute)new DTDAttribute().read(in, version);
            elt.setAttribute(attName, att);
        }
        elt.setCardinal(in.readInt());
        if (in.readBoolean()) {
            String dataType = IOUtil.readStr(in);
            elt.setDataType(dataType);
            if (dataType.equals("date")) {
                elt.setDateFormat(IOUtil.readStr(in));
            }
        }
        if (version > 1) {
            elt.setExpand(in.readBoolean());
        }
        return elt;
    }
}

