/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.util.dtd.elements;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;
import quadbase.common.util.dtd.elements.DTDOutput;
import quadbase.common.util.internal.IOUtil;

public class DTDEnumeration
implements DTDOutput {
    protected Vector items = new Vector();

    public void add(String item) {
        this.items.addElement(item);
    }

    public void remove(String item) {
        this.items.removeElement(item);
    }

    public String[] getItems() {
        Object[] retval = new String[this.items.size()];
        this.items.copyInto(retval);
        return retval;
    }

    public Vector getItemsVec() {
        return this.items;
    }

    public boolean equals(Object ob) {
        if (ob == this) {
            return true;
        }
        if (!(ob instanceof DTDEnumeration)) {
            return false;
        }
        DTDEnumeration other = (DTDEnumeration)ob;
        return this.items.equals(other.items);
    }

    public void setItem(String[] newItems) {
        this.items = new Vector(newItems.length);
        for (String newItem : newItems) {
            this.items.addElement(newItem);
        }
    }

    public void setItem(String item, int i) {
        this.items.setElementAt(item, i);
    }

    public String getItem(int i) {
        return (String)this.items.elementAt(i);
    }

    @Override
    public void write(DataOutputStream out) throws IOException {
        String[] items = this.getItems();
        out.writeInt(items.length);
        for (String item : items) {
            IOUtil.writeStr(out, item);
        }
    }

    @Override
    public DTDOutput read(DataInputStream in, int version) throws IOException {
        DTDEnumeration enu = new DTDEnumeration();
        int ct = in.readInt();
        String[] items = new String[ct];
        for (int i = 0; i < ct; ++i) {
            items[i] = IOUtil.readStr(in);
        }
        enu.setItem(items);
        return enu;
    }
}

