/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.util.dtd.elements;

import org.apache.xerces.xs.XSAttributeDeclaration;
import org.apache.xerces.xs.XSComplexTypeDefinition;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSObject;
import org.apache.xerces.xs.XSSimpleTypeDefinition;
import org.apache.xerces.xs.XSTypeDefinition;
import org.apache.xerces.xs.XSWildcard;

public class XSObjectWrapper {
    private XSObject object = null;
    private int dataType = -1;
    private String dateFormatString = "";
    private boolean leaf = false;
    private boolean selectable = false;

    public XSObjectWrapper(XSObject obj) throws Exception {
        if (obj == null) {
            throw new Exception("XSObject cannot be null.");
        }
        if (!(obj instanceof XSElementDeclaration || obj instanceof XSAttributeDeclaration || obj instanceof XSWildcard)) {
            throw new Exception("XSObject must be either XSElementDeclaration, XSAttributeDeclaration or XSWildcard.");
        }
        this.object = obj;
        XSSimpleTypeDefinition type = null;
        if (obj instanceof XSElementDeclaration) {
            XSTypeDefinition typedef = ((XSElementDeclaration)obj).getTypeDefinition();
            if (typedef instanceof XSSimpleTypeDefinition) {
                type = (XSSimpleTypeDefinition)typedef;
                this.leaf = true;
                this.selectable = true;
            } else {
                XSComplexTypeDefinition complextype = (XSComplexTypeDefinition)typedef;
                this.selectable = complextype.getContentType() == 1 || complextype.getContentType() == 3;
                boolean bl = this.leaf = complextype.getParticle() == null && complextype.getAttributeUses().getLength() == 0;
                if (this.selectable) {
                    type = complextype.getSimpleType();
                }
            }
        } else if (obj instanceof XSAttributeDeclaration) {
            this.leaf = true;
            this.selectable = true;
            type = ((XSAttributeDeclaration)obj).getTypeDefinition();
        } else if (obj instanceof XSWildcard) {
            this.leaf = true;
            this.selectable = true;
            this.dataType = 7;
        }
        if (type != null && type.getVariety() == 1) {
            String typename = type.getName();
            if (XSObjectWrapper.mapDataType(typename) != 7) {
                this.setDataType(XSObjectWrapper.mapDataType(typename));
            } else if (XSObjectWrapper.mapDataType(type.getBaseType().getName()) != 7) {
                this.setDataType(XSObjectWrapper.mapDataType(type.getBaseType().getName()));
            } else {
                XSSimpleTypeDefinition simpleType = type.getPrimitiveType();
                this.setDataType(XSObjectWrapper.mapDataType(simpleType.getName()));
            }
        }
    }

    public boolean isLeaf() {
        return this.leaf;
    }

    public boolean isSelectable() {
        return this.selectable;
    }

    public XSObject getObject() {
        return this.object;
    }

    public String toString() {
        if (this.object.getName() != null) {
            return this.object.getName();
        }
        return "Wildcard - not supported";
    }

    public void merge(Object oldObj) {
        XSObjectWrapper oldWrapper = (XSObjectWrapper)oldObj;
        if (oldWrapper.dataType != -1) {
            this.dataType = oldWrapper.dataType;
        }
        if (oldWrapper.dateFormatString != null) {
            this.dateFormatString = oldWrapper.dateFormatString;
        }
    }

    public void setDataType(int type) {
        this.dataType = type;
        if (this.dateFormatString == null || this.dateFormatString.equals("")) {
            if (this.dataType == 8) {
                this.setDateFormatString("yyyy-MM-dd");
            } else if (this.dataType == 9) {
                this.setDateFormatString("hh:mm:ss.SSS");
            } else if (this.dataType == 10) {
                this.setDateFormatString("yyyy-MM-dd'T'hh:mm:ss.SSS");
            }
        }
    }

    public int getDataType() {
        return this.dataType;
    }

    public void setDateFormatString(String format) {
        if (format != null) {
            this.dateFormatString = format;
        }
    }

    public String getDateFormatString() {
        return this.dateFormatString;
    }

    public static int mapDataType(String primitiveType) {
        if (primitiveType == null) {
            return 7;
        }
        if (primitiveType.equalsIgnoreCase("boolean")) {
            return 0;
        }
        if (primitiveType.equalsIgnoreCase("date")) {
            return 8;
        }
        if (primitiveType.equalsIgnoreCase("time")) {
            return 9;
        }
        if (primitiveType.equalsIgnoreCase("datetime")) {
            return 10;
        }
        if (primitiveType.equalsIgnoreCase("integer") || primitiveType.equalsIgnoreCase("positiveInteger") || primitiveType.equalsIgnoreCase("negativeInteger") || primitiveType.equalsIgnoreCase("nonNegativeInteger") || primitiveType.equalsIgnoreCase("nonPositiveInteger") || primitiveType.equalsIgnoreCase("int") || primitiveType.equalsIgnoreCase("unsignedInt") || primitiveType.equalsIgnoreCase("gYear")) {
            return 2;
        }
        if (primitiveType.equalsIgnoreCase("long") || primitiveType.equalsIgnoreCase("unsignedLong")) {
            return 1;
        }
        if (primitiveType.equalsIgnoreCase("short") || primitiveType.equalsIgnoreCase("unsignedShort")) {
            return 12;
        }
        if (primitiveType.equalsIgnoreCase("byte") || primitiveType.equalsIgnoreCase("unsignedByte")) {
            return 11;
        }
        if (primitiveType.equalsIgnoreCase("float")) {
            return 3;
        }
        if (primitiveType.equalsIgnoreCase("decimal") || primitiveType.equalsIgnoreCase("double")) {
            return 4;
        }
        return 7;
    }
}

