/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.util.flash;

import java.awt.Font;

public class FontMapping {
    private static String defaultFont = "Arial";
    private static String[] supportedStyleFont = new String[]{"Agency FB", "Arial", "Arial Narrow", "Bell MT", "Berlin Sans FB", "Berlin Sans FB Demi", "Bitstream Vera Sans Mono", "Bodoni MT", "Bodoni MT Condensed", "Bodoni MT Poster Compressed", "Book Antiqua", "Bookman Old Style", "Bookshelf Symbol 7", "Calibri", "Californian FB", "Calisto MT", "Cambria", "Candara", "Century Gothic", "Century Schoolbook", "Chiller", "Comic Sans MS", "Consolas", "Constantia", "Corbel", "Courier New", "Dialog", "DialogInput", "Estrangelo Edessa", "Garamond", "Gautami", "Georgia", "Gill Sans MT", "Gill Sans MT Condensed", "Gill Sans MT Ext Condensed Bold", "Goudy Old Style", "Haettenschweiler", "Juice ITC", "Kartika", "Latha", "Lucida Bright", "Lucida Fax", "Lucida Sans", "Lucida Sans Typewriter", "Magneto", "Mangal", "Marlett", "Mistral", "Monospaced", "MS Outlook", "MS Reference Specialty", "MV Boli", "Niagara Engraved", "Niagara Solid", "Onyx", "Palatino Linotype", "Perpetua", "Perpetua Titling MT", "Playbill", "Pristina", "Raavi", "Rockwell", "Rockwell Condensed", "SansSerif", "Segoe UI", "Serif", "Shruti", "SimSun-PUA", "Symbol", "Tahoma", "Times New Roman", "Trebuchet MS", "Tunga", "Tw Cen MT", "Tw Cen MT Condensed", "Verdana", "Vrinda", "Webdings", "Wingdings", "Wingdings 2", "Wingdings 3"};
    private static String[] unSupportedFont = new String[]{"Free 3 of 9", "Bookshelf Symbol1", "Bookshelf Symbol2", "Bookshelf Symbol3", "Marlett", "Monotype Sorts", "MS Outlook", "Symbol", "Webdings", "Wingdings"};

    public static boolean isSupportedFont(String fontName) {
        for (String element : unSupportedFont) {
            if (!element.equals(fontName)) continue;
            return false;
        }
        return true;
    }

    static Font mapFont(Font font) {
        String fontName = font.getName();
        if (!FontMapping.isSupportedFont(fontName)) {
            return new Font(defaultFont, font.getStyle(), font.getSize());
        }
        if (!font.isBold()) {
            return font;
        }
        String version = System.getProperty("java.version");
        if (version.startsWith("1.4") || version.startsWith("1.5")) {
            int style = font.isItalic() ? 2 : 0;
            for (String element : supportedStyleFont) {
                if (!element.equals(fontName)) continue;
                return font;
            }
            return new Font(fontName, style, font.getSize());
        }
        return font;
    }
}

