/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.util.flash;

public class Plane {
    int width = 8000;
    int height = 8000;
    int centerX = 4000;
    int centerY = 4000;
    static int unit = 20;

    public Plane(int width, int height) {
        this.width = width * unit;
        this.height = height * unit;
        this.centerX = 0;
        this.centerY = 0;
    }

    int getUpperLeftX() {
        return 0 - this.centerX;
    }

    int getUpperLeftY() {
        return 0 - this.centerY;
    }

    int getLowerRightX() {
        return this.width - this.centerX;
    }

    int getLowerRightY() {
        return this.height - this.centerY;
    }

    int getX(int pixel) {
        return pixel * unit - this.centerX;
    }

    int getX(double pixel) {
        return (int)(pixel * (double)unit) - this.centerX;
    }

    int getY(int pixel) {
        return pixel * unit - this.centerY;
    }

    int getY(double pixel) {
        return (int)(pixel * (double)unit) - this.centerY;
    }

    static int getPoint(int pixel) {
        return pixel * unit;
    }

    int getPixel(int twips) {
        return twips / unit;
    }

    int getWidth() {
        return this.width;
    }

    int getHeight() {
        return this.height;
    }

    static {
        String lcOSName = System.getProperty("os.name").toLowerCase();
        boolean MAC_OS_X = lcOSName.startsWith("mac os");
        if (MAC_OS_X) {
            unit = 15;
        }
    }
}

