/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.util.flash.flagstoneex;

import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import quadbase.common.util.flash.flagstoneex.FlashGlyph;

public class FlashGlyphGenerator {
    public static final float SCALE = 1024.0f;
    private Font font;
    private FontRenderContext fontContext;
    private FlashGlyph missingGlyph;

    public static FlashGlyphGenerator getInstance(Font font) {
        return new FlashGlyphGenerator(font);
    }

    private FlashGlyphGenerator(Font font) {
        this.font = font;
        this.fontContext = new FontRenderContext(new AffineTransform(), true, true);
        if (System.getProperty("java.version").startsWith("1.4")) {
            this.transformFontToEMSquare();
        }
        this.font = this.font.deriveFont(1024.0f);
        this.missingGlyph = new FlashGlyph(this.font, this.fontContext, (char)this.font.getMissingGlyphCode());
    }

    public FlashGlyph getGlyphForCharacter(Integer character) {
        char c = (char)character.intValue();
        if (this.font.canDisplay(c)) {
            return new FlashGlyph(this.font, this.fontContext, c);
        }
        return this.missingGlyph;
    }

    private void transformFontToEMSquare() {
        this.font = this.font.deriveFont(1.0f);
        int numGlyphs = this.font.getNumGlyphs();
        int glyphIndex = 0;
        double x = 0.0;
        double y = 0.0;
        double w = 0.0;
        double h = 0.0;
        for (int characterCode = 0; glyphIndex < numGlyphs && characterCode < 65535; ++characterCode) {
            char currentChar = (char)characterCode;
            if (!this.font.canDisplay(currentChar)) continue;
            GlyphVector glyphVector = this.font.createGlyphVector(this.fontContext, new char[]{currentChar});
            Rectangle2D bounds = glyphVector.getGlyphOutline(0).getBounds2D();
            x = Math.min(bounds.getX(), x);
            y = Math.min(bounds.getY(), y);
            w = Math.max(bounds.getWidth(), w);
            h = Math.max(bounds.getHeight(), h);
            ++glyphIndex;
        }
        double translateX = 1024.0 - x * 1024.0;
        double translateY = 1024.0 - y * 1024.0;
        AffineTransform at = AffineTransform.getTranslateInstance(translateX, translateY);
        this.font = this.font.deriveFont(at);
    }
}

