/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.util.flash.flagstoneex;

import com.flagstone.transform.FSBounds;
import com.flagstone.transform.FSCurve;
import com.flagstone.transform.FSDefineShape2;
import com.flagstone.transform.FSDefineShape3;
import com.flagstone.transform.FSFillStyle;
import com.flagstone.transform.FSLine;
import com.flagstone.transform.FSLineStyle;
import com.flagstone.transform.FSShape;
import com.flagstone.transform.FSShapeStyle;
import com.flagstone.transform.FSSolidLine;
import java.util.ArrayList;

public class QbFlashShapeConstructor {
    private double flattenLimit = 0.25;
    public boolean COORDINATES_ARE_PIXELS = false;
    private double[] Px = new double[4];
    private double[] Py = new double[4];
    private boolean pathInProgress = false;
    private int initialX = 0;
    private int initialY = 0;
    private int currentX = 0;
    private int currentY = 0;
    private int controlX = 0;
    private int controlY = 0;
    private int minX = 0;
    private int minY = 0;
    private int maxX = 0;
    private int maxY = 0;
    private int lineWidth = 0;
    ArrayList objects = new ArrayList();
    ArrayList lineStyles = new ArrayList();
    ArrayList fillStyles = new ArrayList();

    public void set(int index, FSLineStyle aLineStyle) {
        this.lineStyles.set(index, aLineStyle);
    }

    public void add(FSLineStyle aLineStyle) {
        this.lineStyles.add(aLineStyle);
    }

    public void set(int index, FSFillStyle aFillStyle) {
        this.fillStyles.set(index, aFillStyle);
    }

    public void add(FSFillStyle aFillStyle) {
        this.fillStyles.add(aFillStyle);
    }

    public ArrayList getLineStyles() {
        return this.lineStyles;
    }

    public void setLineStyles(ArrayList anArray) {
        this.lineStyles = anArray;
    }

    public ArrayList getFillStyles() {
        return this.fillStyles;
    }

    public void setFillStyles(ArrayList anArray) {
        this.fillStyles = anArray;
    }

    public void selectLineStyle(int index) {
        this.lineWidth = ((FSSolidLine)this.lineStyles.get(index)).getWidth();
        this.objects.add(new FSShapeStyle(index + 1, Integer.MIN_VALUE, Integer.MIN_VALUE));
    }

    public void selectFillStyle(int index) {
        this.objects.add(new FSShapeStyle(Integer.MIN_VALUE, index + 1, Integer.MIN_VALUE));
    }

    public void selectAltStyle(int index) {
        this.objects.add(new FSShapeStyle(Integer.MIN_VALUE, Integer.MIN_VALUE, index + 1));
    }

    public void selectStyle(int lineIndex, int fillIndex) {
        this.lineWidth = ((FSSolidLine)this.lineStyles.get(lineIndex)).getWidth();
        this.objects.add(new FSShapeStyle(lineIndex + 1, fillIndex + 1, Integer.MIN_VALUE));
    }

    public void selectStyle(int lineIndex, int fillIndex, int altIndex) {
        this.lineWidth = ((FSSolidLine)this.lineStyles.get(lineIndex)).getWidth();
        this.objects.add(new FSShapeStyle(lineIndex + 1, fillIndex + 1, altIndex + 1));
    }

    public FSBounds bounds() {
        return new FSBounds(this.minX, this.minY, this.maxX, this.maxY);
    }

    public FSShape shape() {
        return new FSShape((ArrayList)this.objects.clone());
    }

    public FSDefineShape2 defineShape(int identifier) {
        return new FSDefineShape2(identifier, this.bounds(), (ArrayList)this.fillStyles.clone(), (ArrayList)this.lineStyles.clone(), new FSShape((ArrayList)this.objects.clone()));
    }

    public FSDefineShape3 defineTransparentShape(int identifier) {
        return new FSDefineShape3(identifier, this.bounds(), (ArrayList)this.fillStyles.clone(), (ArrayList)this.lineStyles.clone(), new FSShape((ArrayList)this.objects.clone()));
    }

    public void newPath() {
        this.pathInProgress = false;
        this.setInitial(0, 0);
        this.setCurrent(0, 0);
        this.setControl(0, 0);
        this.setBounds(0, 0, 0, 0);
        this.objects.clear();
        this.lineWidth = 0;
    }

    public void closePath() {
        int dx = this.initialX - this.currentX;
        int dy = this.initialY - this.currentY;
        if (dx != 0 || dy != 0) {
            this.objects.add(new FSLine(dx, dy));
        }
        this.setCurrent(this.initialX, this.initialY);
        this.pathInProgress = false;
    }

    public void move(int x, int y) {
        x = this.COORDINATES_ARE_PIXELS ? x * 20 : x;
        y = this.COORDINATES_ARE_PIXELS ? y * 20 : y;
        this.objects.add(new FSShapeStyle(x, y));
        this.setControl((this.currentX + x) / 2, (this.currentY + y) / 2);
        this.setCurrent(x, y);
        this.setInitial(x, y);
    }

    void moveForFont(int x, int y) {
        x = this.COORDINATES_ARE_PIXELS ? x * 20 : x;
        y = this.COORDINATES_ARE_PIXELS ? y * 20 : y;
        this.objects.add(new FSShapeStyle(1, Integer.MIN_VALUE, 1, x, y));
        this.setControl((this.currentX + x) / 2, (this.currentY + y) / 2);
        this.setCurrent(x, y);
        this.setInitial(x, y);
    }

    public void rmove(int x, int y) {
        x = this.COORDINATES_ARE_PIXELS ? x * 20 : x;
        y = this.COORDINATES_ARE_PIXELS ? y * 20 : y;
        this.objects.add(new FSShapeStyle(x + this.currentX, y + this.currentY));
        this.setControl(this.currentX + x / 2, this.currentY + y / 2);
        this.setCurrent(this.currentX + x, this.currentY + y);
    }

    public void line(int x, int y) {
        x = (this.COORDINATES_ARE_PIXELS ? x * 20 : x) - this.currentX;
        y = (this.COORDINATES_ARE_PIXELS ? y * 20 : y) - this.currentY;
        this.objects.add(new FSLine(x, y));
        if (!this.pathInProgress) {
            this.setInitial(this.currentX, this.currentY);
            this.pathInProgress = true;
        }
        this.setControl(this.currentX + x / 2, this.currentY + y / 2);
        this.setCurrent(this.currentX + x, this.currentY + y);
    }

    public void rline(int x, int y) {
        x = this.COORDINATES_ARE_PIXELS ? x * 20 : x;
        y = this.COORDINATES_ARE_PIXELS ? y * 20 : y;
        this.objects.add(new FSLine(x, y));
        if (!this.pathInProgress) {
            this.setInitial(this.currentX, this.currentY);
            this.pathInProgress = true;
        }
        this.setControl(this.currentX + x / 2, this.currentY + y / 2);
        this.setCurrent(this.currentX + x, this.currentY + y);
    }

    public void curve(int x1, int y1, int x, int y) {
        x1 = (this.COORDINATES_ARE_PIXELS ? x1 * 20 : x1) - this.currentX;
        y1 = (this.COORDINATES_ARE_PIXELS ? y1 * 20 : y1) - this.currentY;
        x = (this.COORDINATES_ARE_PIXELS ? x * 20 : x) - this.currentX - x1;
        y = (this.COORDINATES_ARE_PIXELS ? y * 20 : y) - this.currentY - y1;
        this.objects.add(new FSCurve(x1, y1, x, y));
        if (!this.pathInProgress) {
            this.setInitial(this.currentX, this.currentY);
            this.pathInProgress = true;
        }
        this.setControl(this.currentX + x1, this.currentY + y1);
        this.setCurrent(this.currentX + x1 + x, this.currentY + y1 + y);
    }

    public void rcurve(int x1, int y1, int x, int y) {
        x1 = this.COORDINATES_ARE_PIXELS ? x1 * 20 : x1;
        y1 = this.COORDINATES_ARE_PIXELS ? y1 * 20 : y1;
        x = this.COORDINATES_ARE_PIXELS ? x * 20 : x;
        y = this.COORDINATES_ARE_PIXELS ? y * 20 : y;
        this.objects.add(new FSCurve(x1, y1, x, y));
        if (!this.pathInProgress) {
            this.setInitial(this.currentX, this.currentY);
            this.pathInProgress = true;
        }
        this.setControl(this.currentX + x1, this.currentY + y1);
        this.setCurrent(this.currentX + x1 + x, this.currentY + y1 + y);
    }

    public void curve(int x1, int y1, int x2, int y2, int x, int y) {
        if (!this.pathInProgress) {
            this.setInitial(this.currentX, this.currentY);
            this.pathInProgress = true;
        }
        this.Px[0] = this.currentX;
        this.Py[0] = this.currentY;
        this.Px[1] = this.COORDINATES_ARE_PIXELS ? (double)(x1 * 20) : (double)x1;
        this.Py[1] = this.COORDINATES_ARE_PIXELS ? (double)(y1 * 20) : (double)y1;
        this.Px[2] = this.COORDINATES_ARE_PIXELS ? (double)(x2 * 20) : (double)x2;
        this.Py[2] = this.COORDINATES_ARE_PIXELS ? (double)(y2 * 20) : (double)y2;
        this.Px[3] = this.COORDINATES_ARE_PIXELS ? (double)(x * 20) : (double)x;
        this.Py[3] = this.COORDINATES_ARE_PIXELS ? (double)(y * 20) : (double)y;
        this.flatten();
    }

    public void rcurve(int x1, int y1, int x2, int y2, int x, int y) {
        this.Px[0] = this.currentX;
        this.Py[0] = this.currentY;
        this.Px[1] = this.currentX + (this.COORDINATES_ARE_PIXELS ? x1 * 20 : x1);
        this.Py[1] = this.currentY + (this.COORDINATES_ARE_PIXELS ? y1 * 20 : y1);
        this.Px[2] = this.currentX + (this.COORDINATES_ARE_PIXELS ? x2 * 20 : x2);
        this.Py[2] = this.currentY + (this.COORDINATES_ARE_PIXELS ? y2 * 20 : y2);
        this.Px[3] = this.currentX + (this.COORDINATES_ARE_PIXELS ? x * 20 : x);
        this.Py[3] = this.currentY + (this.COORDINATES_ARE_PIXELS ? y * 20 : y);
        this.flatten();
    }

    public void reflect(int x, int y) {
        int x1 = this.currentX - this.controlX;
        int y1 = this.currentY - this.controlY;
        x = (this.COORDINATES_ARE_PIXELS ? x * 20 : x) - this.currentX;
        y = (this.COORDINATES_ARE_PIXELS ? y * 20 : y) - this.currentY;
        this.objects.add(new FSCurve(x1, y1, x, y));
        if (!this.pathInProgress) {
            this.setInitial(this.currentX, this.currentY);
            this.pathInProgress = true;
        }
        this.setControl(x1 + this.currentX, y1 + this.currentY);
        this.setCurrent(x + this.currentX, y + this.currentY);
    }

    public void rreflect(int x, int y) {
        int x1 = this.currentX - this.controlX;
        int y1 = this.currentY - this.controlY;
        x = this.COORDINATES_ARE_PIXELS ? x * 20 : x;
        y = this.COORDINATES_ARE_PIXELS ? y * 20 : y;
        this.objects.add(new FSCurve(x1, y1, x, y));
        if (!this.pathInProgress) {
            this.setInitial(this.currentX, this.currentY);
            this.pathInProgress = true;
        }
        this.setControl(x1 + this.currentX, y1 + this.currentY);
        this.setCurrent(x + this.currentX, y + this.currentY);
    }

    public void reflect(int x2, int y2, int x, int y) {
        int x1 = this.currentX - this.controlX;
        int y1 = this.currentY - this.controlY;
        x2 = (this.COORDINATES_ARE_PIXELS ? x2 * 20 : x2) - this.currentX;
        y2 = (this.COORDINATES_ARE_PIXELS ? y2 * 20 : y2) - this.currentY;
        x = (this.COORDINATES_ARE_PIXELS ? x * 20 : x) - this.currentX;
        y = (this.COORDINATES_ARE_PIXELS ? y * 20 : y) - this.currentY;
        this.rcurve(x1, y1, x2, y2, x, y);
    }

    public void rreflect(int x2, int y2, int x, int y) {
        int x1 = this.currentX - this.controlX;
        int y1 = this.currentY - this.controlY;
        x2 = this.COORDINATES_ARE_PIXELS ? x2 * 20 : x2;
        y2 = this.COORDINATES_ARE_PIXELS ? y2 * 20 : y2;
        x = this.COORDINATES_ARE_PIXELS ? x * 20 : x;
        y = this.COORDINATES_ARE_PIXELS ? y * 20 : y;
        this.rcurve(x1, y1, x2, y2, x, y);
    }

    public void rect(int x, int y, int width, int height) {
        this.newPath();
        this.selectStyle(0, 0);
        this.move(x - width / 2, y - height / 2);
        this.rline(width, 0);
        this.rline(0, height);
        this.rline(-width, 0);
        this.rline(0, -height);
        this.closePath();
    }

    public void rect(int width, int height) {
        this.rect(0, 0, width, height);
    }

    public void rect(int x, int y, int width, int height, int radius) {
        int shortestSide;
        int n = shortestSide = height < width ? height : width;
        if (radius > shortestSide / 2) {
            radius = shortestSide / 2;
        }
        this.newPath();
        this.selectStyle(0, 0);
        this.move(x, y - height / 2);
        this.rline(width / 2 - radius, 0);
        this.rcurve(radius, 0, 0, radius);
        this.rline(0, height - 2 * radius);
        this.rcurve(0, radius, -radius, 0);
        this.rline(-(width - 2 * radius), 0);
        this.rcurve(-radius, 0, 0, -radius);
        this.rline(0, -(height - 2 * radius));
        this.rcurve(0, -radius, radius, 0);
        this.closePath();
    }

    public void rect(int width, int height, int radius) {
        this.rect(0, 0, width, height, radius);
    }

    public void ellipse(int x, int y, int rx, int ry) {
        boolean wasInPixels = false;
        if (this.COORDINATES_ARE_PIXELS) {
            this.COORDINATES_ARE_PIXELS = false;
            wasInPixels = true;
            x *= 20;
            y *= 20;
            rx *= 20;
            ry *= 20;
        }
        int startX = (int)(0.707 * (double)rx) + x;
        int startY = (int)(0.707 * (double)ry) + y;
        int ax = (int)(0.293 * (double)rx);
        int ay = (int)(0.293 * (double)ry);
        int cx = (int)(0.414 * (double)rx);
        int cy = (int)(0.414 * (double)ry);
        this.newPath();
        this.selectStyle(0, 0);
        this.move(startX, startY);
        this.rcurve(-ax, ay, -cx, 0);
        this.rcurve(-cx, 0, -ax, -ay);
        this.rcurve(-ax, -ay, 0, -cy);
        this.rcurve(0, -cy, ax, -ay);
        this.rcurve(ax, -ay, cx, 0);
        this.rcurve(cx, 0, ax, ay);
        this.rcurve(ax, ay, 0, cy);
        this.rcurve(0, cy, -ax, ay);
        this.closePath();
        if (wasInPixels) {
            this.COORDINATES_ARE_PIXELS = true;
        }
    }

    public void ellipse(int rx, int ry) {
        this.ellipse(0, 0, rx, ry);
    }

    public void circle(int x, int y, int r) {
        this.ellipse(x, y, r, r);
    }

    public void circle(int r) {
        this.ellipse(0, 0, r, r);
    }

    public void rpolygon(int[] points) {
        int length = points.length;
        if (length % 2 == 1) {
            --length;
        }
        this.rmove(points[0], points[1]);
        for (int i = 2; i < length; i += 2) {
            this.rline(points[i], points[i + 1]);
        }
        this.closePath();
    }

    public void polygon(int[] points) {
        int length = points.length;
        if (length % 2 == 1) {
            --length;
        }
        this.move(points[0], points[1]);
        for (int i = 2; i < length; i += 2) {
            this.line(points[i], points[i + 1]);
        }
        this.closePath();
    }

    private void setInitial(int x, int y) {
        this.initialX = x;
        this.initialY = y;
    }

    private void setCurrent(int x, int y) {
        this.currentX = x;
        this.currentY = y;
        if (x - this.lineWidth / 2 < this.minX) {
            this.minX = x - this.lineWidth / 2;
        }
        if (y - this.lineWidth / 2 < this.minY) {
            this.minY = y - this.lineWidth / 2;
        }
        if (x + this.lineWidth / 2 > this.maxX) {
            this.maxX = x + this.lineWidth / 2;
        }
        if (y + this.lineWidth / 2 > this.maxY) {
            this.maxY = y + this.lineWidth / 2;
        }
    }

    private void setControl(int x, int y) {
        this.controlX = x;
        this.controlY = y;
        if (x - this.lineWidth / 2 < this.minX) {
            this.minX = x - this.lineWidth / 2;
        }
        if (y - this.lineWidth / 2 < this.minY) {
            this.minY = y - this.lineWidth / 2;
        }
        if (x + this.lineWidth / 2 > this.maxX) {
            this.maxX = x + this.lineWidth / 2;
        }
        if (y + this.lineWidth / 2 > this.maxY) {
            this.maxY = y + this.lineWidth / 2;
        }
    }

    private void setBounds(int xl, int yl, int xu, int yu) {
        this.minX = xl;
        this.minY = yl;
        this.maxX = xu;
        this.maxY = yu;
    }

    private void flatten() {
        double[] Qx = new double[]{0.0, 0.0, 0.0, 0.0};
        double[] Qy = new double[]{0.0, 0.0, 0.0, 0.0};
        while (true) {
            double Ax = 2.0 * this.Px[0] + this.Px[3] - 3.0 * this.Px[1];
            Ax *= Ax;
            double Bx = 2.0 * this.Px[3] + this.Px[0] - 3.0 * this.Px[2];
            if (Ax < (Bx *= Bx)) {
                Ax = Bx;
            }
            double Ay = 2.0 * this.Py[0] + this.Py[3] - 3.0 * this.Py[1];
            Ay *= Ay;
            double By = 2.0 * this.Py[3] + this.Py[0] - 3.0 * this.Py[2];
            if (Ay < (By *= By)) {
                Ay = By;
            }
            if (Ax + Ay < this.flattenLimit) break;
            Qx[3] = this.Px[3];
            double u = (this.Px[1] + this.Px[2]) / 2.0;
            this.Px[1] = (this.Px[0] + this.Px[1]) / 2.0;
            Qx[2] = (this.Px[2] + this.Px[3]) / 2.0;
            this.Px[2] = (this.Px[1] + u) / 2.0;
            Qx[1] = (u + Qx[2]) / 2.0;
            this.Px[3] = Qx[0] = (this.Px[2] + Qx[1]) / 2.0;
            Qy[3] = this.Py[3];
            u = (this.Py[1] + this.Py[2]) / 2.0;
            this.Py[1] = (this.Py[0] + this.Py[1]) / 2.0;
            Qy[2] = (this.Py[2] + this.Py[3]) / 2.0;
            this.Py[2] = (this.Py[1] + u) / 2.0;
            Qy[1] = (u + Qy[2]) / 2.0;
            this.Py[3] = Qy[0] = (this.Py[2] + Qy[1]) / 2.0;
            this.flatten();
            this.Px[0] = Qx[0];
            this.Py[0] = Qy[0];
            this.Px[1] = Qx[1];
            this.Py[1] = Qy[1];
            this.Px[2] = Qx[2];
            this.Py[2] = Qy[2];
            this.Px[3] = Qx[3];
            this.Py[3] = Qy[3];
        }
        this.objects.add(new FSLine((int)this.Px[3] - this.currentX, (int)this.Py[3] - this.currentY));
        this.setControl((int)this.Px[1], (int)this.Py[1]);
        this.setControl((int)this.Px[2], (int)this.Py[2]);
        this.setCurrent((int)this.Px[3], (int)this.Py[3]);
    }
}

