/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.util.flash.flagstoneex;

import com.flagstone.transform.FSBounds;
import com.flagstone.transform.FSCharacter;
import com.flagstone.transform.FSColor;
import com.flagstone.transform.FSCoordTransform;
import com.flagstone.transform.FSCurve;
import com.flagstone.transform.FSDefineFont2;
import com.flagstone.transform.FSDefineText2;
import com.flagstone.transform.FSLine;
import com.flagstone.transform.FSShape;
import com.flagstone.transform.FSShapeStyle;
import com.flagstone.transform.FSText;
import com.flagstone.transform.FSTransformObject;
import java.awt.Font;
import java.util.ArrayList;
import quadbase.common.util.flash.flagstoneex.FlashGlyph;
import quadbase.common.util.flash.flagstoneex.FlashGlyphGenerator;

public class QbFlashTextConstructor {
    private int identifier;
    private int baseline = 0;
    private float ascent = 0.0f;
    private float descent = 0.0f;
    private float leading = 0.0f;
    private ArrayList usedChars = new ArrayList();
    private ArrayList usedGlyphs = new ArrayList();
    private Font font;
    private FlashGlyphGenerator glyphCache;

    public QbFlashTextConstructor(int anIdentifier, Font font) {
        this.font = font;
        this.identifier = anIdentifier;
        this.glyphCache = FlashGlyphGenerator.getInstance(font);
    }

    public FSDefineFont2 defineFont() {
        ArrayList<FSShape> shapesArray = new ArrayList<FSShape>(this.usedGlyphs.size());
        ArrayList codesArray = new ArrayList(this.usedGlyphs.size());
        ArrayList<Integer> advancesArray = new ArrayList<Integer>(this.usedGlyphs.size());
        ArrayList<FSBounds> boundsArray = new ArrayList<FSBounds>(this.usedGlyphs.size());
        for (int i = 0; i < this.usedGlyphs.size(); ++i) {
            FlashGlyph glyph = (FlashGlyph)this.usedGlyphs.get(i);
            shapesArray.add(glyph.getFSShape());
            codesArray.add(this.usedChars.get(i));
            advancesArray.add((int)glyph.getAdvance());
            boundsArray.add(glyph.getBounds());
        }
        FSDefineFont2 fsFont = new FSDefineFont2(this.identifier, this.font.getName());
        fsFont.setEncoding(0);
        fsFont.setItalic(this.font.isItalic());
        fsFont.setBold(this.font.isBold());
        fsFont.setAscent((int)this.ascent);
        fsFont.setDescent((int)this.descent);
        fsFont.setLeading((int)this.leading);
        fsFont.setShapes(shapesArray);
        fsFont.setCodes(codesArray);
        fsFont.setAdvances(advancesArray);
        fsFont.setBounds(boundsArray);
        fsFont.setKernings(new ArrayList());
        return fsFont;
    }

    public FSDefineText2 defineText(int anIdentifier, String text, int fontSize, FSColor aColor) {
        FSCoordTransform coordTransform = new FSCoordTransform(0, 0);
        float scaleFactor = (float)fontSize / 1024.0f;
        int[] charIndexes = this.getCharIndexesForString(text);
        FSText textRecord = new FSText(this.identifier, aColor, 0, this.scaleBaseline(scaleFactor), fontSize, this.getFsCharactersFromIndexes(charIndexes, scaleFactor));
        ArrayList<FSText> textRecords = new ArrayList<FSText>();
        textRecords.add(textRecord);
        return new FSDefineText2(anIdentifier, this.boundsForText(charIndexes, scaleFactor), coordTransform, textRecords);
    }

    private FSBounds boundsForText(int[] charIndexes, float scaleFactor) {
        int minX = 0;
        int maxX = 0;
        int minY = 0;
        int maxY = 0;
        boolean any = false;
        int advance = 0;
        for (int charIndexe : charIndexes) {
            FlashGlyph glyph = (FlashGlyph)this.usedGlyphs.get(charIndexe);
            ArrayList array = glyph.getFSShape().getObjects();
            int x = advance;
            int y = 0;
            for (FSTransformObject currentObject : array) {
                if (currentObject instanceof FSShapeStyle) {
                    FSShapeStyle style = (FSShapeStyle)currentObject;
                    x = advance + style.getMoveX();
                    y = style.getMoveY();
                } else if (currentObject instanceof FSLine) {
                    FSLine line = (FSLine)currentObject;
                    x += line.getX();
                    y += line.getY();
                } else if (currentObject instanceof FSCurve) {
                    FSCurve curve = (FSCurve)currentObject;
                    x += curve.getControlX() + curve.getAnchorX();
                    y += curve.getControlY() + curve.getAnchorY();
                }
                if (any) {
                    minX = Math.min(minX, x);
                    maxX = Math.max(maxX, x);
                    minY = Math.min(minY, y);
                    maxY = Math.max(maxY, y);
                    continue;
                }
                minX = maxX = x;
                minY = maxY = y;
                any = true;
            }
            advance = (int)((float)advance + glyph.getAdvance());
        }
        minX = (int)((float)minX * scaleFactor);
        maxX = (int)((float)maxX * scaleFactor);
        minY = (int)((float)minY * scaleFactor) + this.scaleBaseline(scaleFactor);
        maxY = (int)((float)maxY * scaleFactor) + this.scaleBaseline(scaleFactor);
        return new FSBounds(minX, minY, maxX, maxY);
    }

    private ArrayList getFsCharactersFromIndexes(int[] charIndexes, float scaleFactor) {
        ArrayList<FSCharacter> characters = new ArrayList<FSCharacter>(charIndexes.length);
        for (int charIndexe : charIndexes) {
            FlashGlyph glyph = (FlashGlyph)this.usedGlyphs.get(charIndexe);
            characters.add(new FSCharacter(charIndexe, (int)(glyph.getAdvance() * scaleFactor)));
        }
        return characters;
    }

    private int[] getCharIndexesForString(String aString) {
        int[] result = new int[aString.length()];
        for (int i = 0; i < aString.length(); ++i) {
            Integer c = aString.charAt(i);
            int idx = this.usedChars.indexOf(c);
            if (idx >= 0) {
                result[i] = idx;
                continue;
            }
            this.usedChars.add(c);
            this.usedGlyphs.add(this.glyphCache.getGlyphForCharacter(c));
            result[i] = this.usedChars.size() - 1;
        }
        return result;
    }

    private int scaleBaseline(float scaleFactor) {
        int newBaseline = (int)((float)this.baseline * scaleFactor);
        newBaseline += 20 - newBaseline % 20;
        return newBaseline;
    }
}

