/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.util.internal;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import quadbase.common.client.ServerMessage;
import quadbase.common.network.IConnection;
import quadbase.common.paramquery.QueryInParam;
import quadbase.common.paramquery.QueryInParamSet;
import quadbase.common.util.IQueryInParam;
import quadbase.common.util.internal.CloseUtils;
import quadbase.common.util.internal.IOUtil;
import quadbase.reportdesigner.util.IParameterizedDataSource;
import quadbase.util.IDataSource;

public class ClassFileUtil {
    private static final Logger LOGGER = Logger.getLogger(ClassFileUtil.class.getName());
    public static final int IS_PARAM_OP = 0;
    public static final int GET_PARAMETER_OP = 1;
    public static final int GET_RESULTSET_OP = 2;

    public static boolean isParameterized(String className) {
        if (!ServerMessage.useServer) {
            try {
                Class<?> objClass = null;
                Constructor<?> objCons = null;
                Object resultSetClass = null;
                objClass = Class.forName(className);
                objCons = objClass.getConstructor(new Class[0]);
                resultSetClass = objCons.newInstance(new Object[0]);
                if (resultSetClass != null) {
                    boolean isChartResultSetClass = resultSetClass instanceof quadbase.util.IParameterizedDataSource;
                    if (isChartResultSetClass) {
                        return true;
                    }
                    if (resultSetClass instanceof IDataSource) {
                        return false;
                    }
                    return resultSetClass instanceof IParameterizedDataSource;
                }
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINE, "isParameterized check failed", ex);
            }
        } else {
            IConnection socket = null;
            try {
                socket = ServerMessage.createConnection();
                ByteArrayOutputStream bstream = new ByteArrayOutputStream(1024);
                DataOutputStream out = new DataOutputStream(bstream);
                out.writeShort(25333);
                out.writeInt(0);
                IOUtil.writeString(out, className);
                out.writeBoolean(false);
                byte[] array = bstream.toByteArray();
                socket.setContentLength(array.length);
                socket.getOutputStream().write(array);
                socket.getOutputStream().flush();
                DataInputStream din = new DataInputStream(socket.getInputStream());
                int code = din.readInt();
                if (code != 0) {
                    throw new IOException(IOUtil.getErrorString(code) + IOUtil.readString(din, true));
                }
                boolean isParam = din.readBoolean();
                din.close();
                socket.close();
                return isParam;
            }
            catch (Throwable ex) {
                CloseUtils.close(socket);
            }
        }
        return false;
    }

    public static QueryInParamSet getInSet(String className) throws Exception {
        IQueryInParam[] params = null;
        if (!ServerMessage.useServer) {
            Class<?> objClass = null;
            Constructor<?> objCons = null;
            Object resultSetClass = null;
            try {
                objClass = Class.forName(className);
            }
            catch (Exception ex) {
                throw new Exception(className + " not found!", ex);
            }
            try {
                objCons = objClass.getConstructor(new Class[0]);
                resultSetClass = objCons.newInstance(new Object[0]);
            }
            catch (Exception ex) {
                throw new Exception("Cannot create " + className + "!", ex);
            }
            try {
                Method objMethod = objClass.getMethod("getParameters", new Class[0]);
                Object obj = objMethod.invoke(resultSetClass, new Object[0]);
                params = (IQueryInParam[])obj;
            }
            catch (Exception ex) {
                throw new Exception("Cannot execute getParameters()!", ex);
            }
            if (params != null) {
                QueryInParam[] newParam = new QueryInParam[params.length];
                for (int i = 0; i < params.length; ++i) {
                    newParam[i] = QueryInParam.create(params[i]);
                }
                return new QueryInParamSet(newParam);
            }
        } else {
            IConnection socket = null;
            try {
                socket = ServerMessage.createConnection();
                ByteArrayOutputStream bstream = new ByteArrayOutputStream(1024);
                DataOutputStream out = new DataOutputStream(bstream);
                out.writeShort(25333);
                out.writeInt(1);
                IOUtil.writeString(out, className);
                out.writeBoolean(false);
                byte[] array = bstream.toByteArray();
                socket.setContentLength(array.length);
                socket.getOutputStream().write(array);
                socket.getOutputStream().flush();
                DataInputStream din = new DataInputStream(socket.getInputStream());
                int code = din.readInt();
                if (code != 0) {
                    throw new IOException(IOUtil.getErrorString(code) + IOUtil.readString(din, true));
                }
                QueryInParamSet paramSet = QueryInParamSet.read(din, 6602);
                din.close();
                socket.close();
                return paramSet;
            }
            catch (Throwable ex) {
                CloseUtils.close(socket);
            }
        }
        return null;
    }

    public static IQueryInParam[] getParameterArray(String className) throws Exception {
        Class<?> objClass = null;
        Constructor<?> objCons = null;
        Object resultSetClass = null;
        try {
            objClass = Class.forName(className);
        }
        catch (Exception ex) {
            throw new Exception(className + " not found!", ex);
        }
        try {
            objCons = objClass.getConstructor(new Class[0]);
            resultSetClass = objCons.newInstance(new Object[0]);
        }
        catch (Exception ex) {
            throw new Exception("Cannot create " + className + "!", ex);
        }
        try {
            Method objMethod = objClass.getMethod("getParameters", new Class[0]);
            Object obj = objMethod.invoke(resultSetClass, new Object[0]);
            return (IQueryInParam[])obj;
        }
        catch (Exception ex) {
            throw new Exception("Cannot execute getParameters()!", ex);
        }
    }

    public static Object getResultSet(String className, QueryInParamSet paramSet) throws Exception {
        Class<?> argumentClass2;
        Class<?> objClass = null;
        Constructor<?> objCons = null;
        Object resultSetClass = null;
        try {
            objClass = Class.forName(className);
        }
        catch (Exception ex) {
            throw new Exception(className + " not found!", ex);
        }
        try {
            objCons = objClass.getConstructor(new Class[0]);
            resultSetClass = objCons.newInstance(new Object[0]);
        }
        catch (Exception ex) {
            throw new Exception("Cannot create " + className + "!", ex);
        }
        Method objMethod = null;
        try {
            argumentClass2 = Array.newInstance(Class.forName("quadbase.reportdesigner.util.IQueryInParam"), 0).getClass();
            objMethod = objClass.getMethod("getResultSet", argumentClass2);
        }
        catch (Exception argumentClass2) {
            // empty catch block
        }
        try {
            if (objMethod == null) {
                argumentClass2 = Array.newInstance(Class.forName("quadbase.util.IQueryInParam"), 0).getClass();
                objMethod = objClass.getMethod("getResultSet", argumentClass2);
            }
            IQueryInParam[] params = ClassFileUtil.getParameterArray(className);
            QueryInParam[] sources = paramSet.getParameter();
            for (int i = 0; i < params.length; ++i) {
                QueryInParam.copyValue(params[i], sources[i]);
            }
            return objMethod.invoke(resultSetClass, new Object[]{params});
        }
        catch (Exception ex) {
            throw new Exception("Cannot execute getResultSet()!", ex);
        }
    }
}

