/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.util.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.ServerSocket;
import java.net.Socket;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;
import quadbase.common.network.IConnection;
import quadbase.common.util.internal.QbConnection;

public class CloseUtils {
    private static final Logger LOGGER = Logger.getLogger(CloseUtils.class.getName());

    public static void close(Statement stat) {
        if (stat == null) {
            return;
        }
        try {
            stat.close();
        }
        catch (SQLException e) {
            LOGGER.log(Level.FINE, "Failed to close Statement", e);
        }
    }

    public static void close(Connection conn) {
        if (conn == null) {
            return;
        }
        try {
            conn.close();
        }
        catch (SQLException e) {
            LOGGER.log(Level.FINE, "Failed to close Connection", e);
        }
    }

    public static void close(ResultSet rs) {
        if (rs == null) {
            return;
        }
        try {
            rs.close();
        }
        catch (SQLException e) {
            LOGGER.log(Level.FINE, "Failed to close ResultSet", e);
        }
    }

    public static void close(IConnection iCon) {
        if (iCon == null) {
            return;
        }
        try {
            iCon.close();
        }
        catch (IOException e) {
            LOGGER.log(Level.FINE, "Failed to close IConnection", e);
        }
    }

    public static void close(Socket socket) {
        if (socket == null) {
            return;
        }
        try {
            socket.close();
        }
        catch (IOException e) {
            LOGGER.log(Level.FINE, "Failed to close Socket", e);
        }
    }

    public static void close(ServerSocket socket) {
        if (socket == null) {
            return;
        }
        try {
            socket.close();
        }
        catch (IOException e) {
            LOGGER.log(Level.FINE, "Failed to close ServerSocket", e);
        }
    }

    public static void close(InputStream iStream) {
        if (iStream == null) {
            return;
        }
        try {
            iStream.close();
        }
        catch (IOException e) {
            LOGGER.log(Level.FINE, "Failed to close InputStream", e);
        }
    }

    public static void close(OutputStream outputStream) {
        if (outputStream == null) {
            return;
        }
        try {
            outputStream.close();
        }
        catch (IOException e) {
            LOGGER.log(Level.FINE, "Failed to close OutputStream", e);
        }
    }

    public static void close(Reader reader) {
        if (reader == null) {
            return;
        }
        try {
            reader.close();
        }
        catch (IOException e) {
            LOGGER.log(Level.FINE, "Failed to close Reader", e);
        }
    }

    public static void close(Writer writer) {
        if (writer == null) {
            return;
        }
        try {
            writer.close();
        }
        catch (IOException e) {
            LOGGER.log(Level.FINE, "Failed to close Writer", e);
        }
    }

    public static void closeRemoveFromPool(QbConnection connection) {
        if (connection == null) {
            return;
        }
        try {
            connection.closeConnection(true);
        }
        catch (Exception e) {
            LOGGER.log(Level.FINE, "Failed to close and remove QbConnection", e);
        }
    }
}

