/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.util.internal;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import quadbase.common.server.ConnectionBuffer;
import quadbase.common.server.DBRefresh;
import quadbase.common.util.internal.CloseUtils;
import quadbase.common.util.internal.QbConnection;

public class ConnectionPool {
    private static final long SECOND = 1000L;
    private Map<ConnectionInfo, Vector<ConnectionDetail>> pool = new ConcurrentHashMap<ConnectionInfo, Vector<ConnectionDetail>>();
    private CleanupThread ct = new CleanupThread(this, 119000L);

    public ConnectionPool() {
        this.ct.start();
    }

    public int capacity() {
        try {
            return ConnectionBuffer.getBufferSize();
        }
        catch (Throwable e) {
            return 0;
        }
    }

    public int size(String url, Properties info) {
        ConnectionInfo ci = ConnectionInfo.getInstance(url, info);
        int size = 0;
        Vector<ConnectionDetail> connections = this.pool.get(ci);
        if (connections != null) {
            size = connections.size();
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupClosedConnections(String url, Properties info) {
        ConnectionInfo ci = ConnectionInfo.getInstance(url, info);
        Vector<ConnectionDetail> connections = this.pool.get(ci);
        if (connections == null) {
            return;
        }
        Vector<ConnectionDetail> vector = connections;
        synchronized (vector) {
            Iterator<ConnectionDetail> it = connections.iterator();
            while (it.hasNext()) {
                ConnectionDetail cd = it.next();
                try {
                    if (!cd.c.isClosed()) continue;
                    it.remove();
                }
                catch (SQLException e) {
                    it.remove();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void cleanup() {
        ConnectionPool.debug("running cleanup");
        System.out.println("running cleanup");
        for (Vector<ConnectionDetail> connections : this.pool.values()) {
            for (ConnectionDetail cd : connections) {
                block17: {
                    if (cd.use != 0) continue;
                    try {
                        if (cd.c instanceof QbConnection) {
                            ((QbConnection)cd.c).closeConnection(false);
                            break block17;
                        }
                        if (cd.c.isClosed()) break block17;
                        try {
                            if (!cd.c.getAutoCommit()) {
                                cd.c.commit();
                            }
                        }
                        catch (Exception e) {
                            System.out.println("ConnectionPool: fail to auto commit(1)");
                            e.printStackTrace();
                        }
                        finally {
                            try {
                                cd.c.close();
                            }
                            catch (Exception e) {
                                System.out.println("ConnectionPool: fail to close (1)");
                                e.printStackTrace();
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                this.pool.remove(cd);
            }
        }
        ConnectionPool.debug("cleanup finished");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection(String url, Properties info, boolean forceAllocate) throws SQLException {
        ConnectionInfo ci;
        ConnectionInfo connectionInfo = ci = ConnectionInfo.getInstance(url, info);
        synchronized (connectionInfo) {
            Vector<ConnectionDetail> connections = this.pool.get(ci);
            if (connections == null) {
                return this.allocateConnection(url, info, true);
            }
            this.cleanupClosedConnections(url, info);
            int size = this.size(url, info);
            ConnectionPool.debug("size [" + size + "] capacity [" + this.capacity() + "]");
            if (this.capacity() <= 0) {
                return this.allocateConnection(url, info, false);
            }
            if (!ConnectionPool.isHsqlInProcess(url) && size < this.capacity() || forceAllocate) {
                return this.allocateConnection(url, info, true);
            }
        }
        return this.getFromPool(url, info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close(QbConnection qbc, Connection c) throws SQLException {
        Iterator<Vector<ConnectionDetail>> iterator = this.pool.values().iterator();
        while (iterator.hasNext()) {
            Vector<ConnectionDetail> connections;
            Vector<ConnectionDetail> vector = connections = iterator.next();
            synchronized (vector) {
                for (ConnectionDetail cd : connections) {
                    if (cd.c != c) continue;
                    ConnectionDetail connectionDetail = cd;
                    connectionDetail.use = connectionDetail.use - 1;
                    ConnectionPool.debug("decrementing pool conn [" + cd.url + "] use = " + cd.use);
                    connections.notify();
                    return;
                }
            }
        }
        qbc.closeConnection();
    }

    Connection allocateConnection(String url, Properties info, boolean addToPool) throws SQLException {
        Connection c = DriverManager.getConnection(url, info);
        ConnectionPool.debug("allocating new connection [" + url + "] c = " + c);
        if (addToPool) {
            ConnectionInfo ci = ConnectionInfo.getInstance(url, info);
            ConnectionDetail cd = new ConnectionDetail(c, url);
            Vector<ConnectionDetail> connections = this.pool.get(ci);
            if (connections == null) {
                connections = new Vector();
                this.pool.put(ci, connections);
            }
            connections.add(cd);
            ConnectionPool.debug("adding connection to pool");
        }
        return c;
    }

    private Connection getFromPool(String url, Properties info) throws SQLException {
        if (url.contains("hive")) {
            return this.getFromPoolForThreadUnsafeJdbc(url, info);
        }
        return this.getFromPoolForThreadSafeJdbc(url, info);
    }

    private Connection getFromPoolForThreadUnsafeJdbc(String url, Properties info) throws SQLException {
        ConnectionPool.debug("looking for connection from pool [" + url + "]");
        ConnectionInfo requestedCi = ConnectionInfo.getInstance(url, info);
        Vector<ConnectionDetail> connections = this.pool.get(requestedCi);
        if (connections == null) {
            return this.replaceFromPool(requestedCi);
        }
        Vector<ConnectionDetail> vector = connections;
        synchronized (vector) {
            while (true) {
                Iterator<ConnectionDetail> it = connections.iterator();
                while (it.hasNext()) {
                    ConnectionDetail cd = it.next();
                    if (cd.c.isClosed()) {
                        it.remove();
                        continue;
                    }
                    if (cd.use != 0) continue;
                    ConnectionPool.debug("using connection from pool [" + url + "]");
                    cd.use = 1;
                    return cd.c;
                }
                if (connections.size() < this.capacity()) {
                    return this.replaceFromPool(requestedCi);
                }
                try {
                    connections.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Connection getFromPoolForThreadSafeJdbc(String url, Properties info) throws SQLException {
        Vector<ConnectionDetail> vector;
        ConnectionPool.debug("looking for connection from pool [" + url + "]");
        ConnectionInfo requestedCi = new ConnectionInfo(url, info);
        Vector<ConnectionDetail> connections = this.pool.get(requestedCi);
        ConnectionDetail minCd = null;
        if (connections != null) {
            vector = connections;
            synchronized (vector) {
                Iterator<ConnectionDetail> it = connections.iterator();
                while (it.hasNext()) {
                    ConnectionDetail cd = it.next();
                    if (cd.c.isClosed()) {
                        it.remove();
                        continue;
                    }
                    if (minCd != null && minCd.use <= cd.use) continue;
                    minCd = cd;
                }
            }
        }
        if (minCd == null) {
            return this.replaceFromPool(requestedCi);
        }
        vector = minCd;
        ((ConnectionDetail)vector).use = ((ConnectionDetail)vector).use + 1;
        ConnectionPool.debug("using connection from pool [" + url + "] use = " + minCd.use);
        return minCd.c;
    }

    private Connection replaceFromPool(ConnectionInfo requestedCi) throws SQLException {
        Vector<ConnectionDetail> connections = this.pool.get(requestedCi);
        if (connections == null || connections.size() < this.capacity()) {
            return this.allocateConnection(requestedCi.url, requestedCi.info, true);
        }
        for (ConnectionDetail cd : connections) {
            if (cd.use != 0 && !cd.c.isClosed()) continue;
            return this.replace(cd, requestedCi);
        }
        ConnectionPool.debug("pool is over capacity limit, allocating new connection outside of pool");
        return this.allocateConnection(requestedCi.url, requestedCi.info, false);
    }

    private Connection replace(ConnectionDetail oldCd, ConnectionInfo newCi) throws SQLException {
        ConnectionPool.debug("replacing from pool");
        if (oldCd.c instanceof QbConnection) {
            ((QbConnection)oldCd.c).closeConnection(false);
        } else if (!oldCd.c.isClosed()) {
            try {
                if (!oldCd.c.getAutoCommit()) {
                    oldCd.c.commit();
                }
            }
            catch (SQLException e) {
                System.out.println("ConnectionPool: fail to auto commit (2)");
                e.printStackTrace();
            }
            try {
                oldCd.c.close();
            }
            catch (SQLException e) {
                System.out.println("ConnectionPool: fail to close (2)");
                e.printStackTrace();
            }
        }
        oldCd.c = DriverManager.getConnection(newCi.url, newCi.info);
        oldCd.url = newCi.url;
        oldCd.use = 1;
        return oldCd.c;
    }

    private static boolean isHsqlInProcess(String url) {
        return url.startsWith("jdbc:hsqldb") && !url.startsWith("jdbc:hsqldb:hsql:") && !url.startsWith("jdbc:hsqldb:hsqls:") && !url.startsWith("jdbc:hsqldb:http:") && !url.startsWith("jdbc:hsqldb:https:") && !url.startsWith("jdbc:hsqldb:res:") && !url.startsWith("jdbc:hsqldb:mem:");
    }

    private static void debug(String msg) {
        if (ConnectionPool.initDEBUG()) {
            System.out.println("ConnectionPool - " + msg);
        }
    }

    private static boolean initDEBUG() {
        File debugFile = new File("debug_conn_pool.conf");
        return debugFile.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setBadConnection(Connection conn) {
        Iterator<Vector<ConnectionDetail>> iterator = this.pool.values().iterator();
        while (iterator.hasNext()) {
            Vector<ConnectionDetail> connections;
            Vector<ConnectionDetail> vector = connections = iterator.next();
            synchronized (vector) {
                Iterator<ConnectionDetail> iterator2 = connections.iterator();
                while (iterator2.hasNext()) {
                    ConnectionDetail cd = iterator2.next();
                    if (cd.c != conn) continue;
                    ConnectionPool.debug("removing bad connection(" + cd.c + ")");
                    CloseUtils.close(cd.c);
                    iterator2.remove();
                }
            }
        }
    }

    public void destroy() {
        this.ct.pleaseStop();
    }

    private class CleanupThread
    extends Thread {
        private ConnectionPool conPool;
        private long myInterval;
        boolean pleaseStop = false;

        CleanupThread(ConnectionPool cp, long interval) {
            this.setDaemon(true);
            this.conPool = cp;
            this.myInterval = interval;
        }

        @Override
        public void run() {
            while (!this.pleaseStop) {
                long tmpInterval = 0L;
                try {
                    tmpInterval = DBRefresh.getInterval() * 60000;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (tmpInterval > 60000L) {
                    this.myInterval = tmpInterval;
                }
                try {
                    Thread.sleep(this.myInterval);
                }
                catch (InterruptedException e) {
                    continue;
                }
                this.conPool.cleanup();
            }
        }

        void pleaseStop() {
            this.pleaseStop = true;
            this.interrupt();
        }
    }

    private static class ConnectionInfo {
        private String url;
        private String user;
        private String password;
        private Properties info;
        private static HashMap<String, ConnectionInfo> connectionInfoPool = new HashMap();

        private ConnectionInfo(String url, Properties info) {
            this.url = url;
            this.info = info;
            this.user = info.getProperty("user");
            this.password = info.getProperty("password");
        }

        public static synchronized ConnectionInfo getInstance(String url, Properties info) {
            String key = url + "#" + info.getProperty("user") + "#" + info.getProperty("password");
            ConnectionInfo result = connectionInfoPool.get(key);
            if (result == null) {
                result = new ConnectionInfo(url, info);
                connectionInfoPool.put(key, result);
            }
            return result;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.password == null ? 0 : this.password.hashCode());
            result = 31 * result + (this.url == null ? 0 : this.url.hashCode());
            result = 31 * result + (this.user == null ? 0 : this.user.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ConnectionInfo other = (ConnectionInfo)obj;
            if (this.password == null ? other.password != null : !this.password.equals(other.password)) {
                return false;
            }
            if (this.url == null ? other.url != null : !this.url.equals(other.url)) {
                return false;
            }
            return !(this.user == null ? other.user != null : !this.user.equals(other.user));
        }
    }

    private class ConnectionDetail {
        private int use;
        private Connection c;
        private String url;

        ConnectionDetail(Connection conn, String dburl) {
            this.c = conn;
            this.url = dburl;
            this.use = 1;
        }
    }
}

