/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.util.internal;

import java.awt.Color;
import org.apache.batik.dom.svg.SVGGraphicsElement;

public class CssUtil {
    public static String toCssColor(Color c) {
        return "rgb(" + c.getRed() + ", " + c.getGreen() + ", " + c.getBlue() + ")";
    }

    public static Color toAwtColor(String cssColor) {
        String c = cssColor.substring(cssColor.indexOf(40) + 1, cssColor.lastIndexOf(41));
        String[] rgb = c.split(",");
        int r = Integer.parseInt(rgb[0].trim());
        int g = Integer.parseInt(rgb[1].trim());
        int b = Integer.parseInt(rgb[2].trim());
        return new Color(r, g, b);
    }

    public static String getFill(SVGGraphicsElement e) {
        String style = e.getAttribute("style");
        if (style == null) {
            return null;
        }
        if (style.indexOf("fill:") < 0) {
            return null;
        }
        String fill = style.substring(style.indexOf("fill:") + 5);
        if (fill.indexOf(59) > 0) {
            fill = fill.substring(0, fill.indexOf(59));
        }
        return fill;
    }

    public static void removeFill(SVGGraphicsElement e) {
        String style = e.getAttribute("style");
        if (style != null && style.length() > 0 && style.indexOf("fill:") > -1) {
            String newStyle = style.substring(0, style.indexOf("fill:"));
            String rest = style.substring(style.indexOf("fill:") + 5);
            int scIndex = rest.indexOf(59);
            if (scIndex > 0) {
                newStyle = newStyle + rest.substring(scIndex);
            }
            e.setAttribute("style", newStyle);
        }
    }

    public static void setFill(SVGGraphicsElement e, String color) {
        String style = e.getAttribute("style");
        if (style == null || style.length() == 0) {
            e.setAttribute("style", "fill: " + color);
        } else if (style.indexOf("fill:") < 0) {
            e.setAttribute("style", style + "; fill: " + color);
        } else {
            String newStyle = style.substring(0, style.indexOf("fill:") + 5) + color;
            String rest = style.substring(style.indexOf("fill:") + 5);
            int scIndex = rest.indexOf(59);
            if (scIndex > 0) {
                newStyle = newStyle + rest.substring(scIndex);
            }
            e.setAttribute("style", newStyle);
        }
    }
}

