/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.util.internal;

import java.applet.Applet;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Writer;
import java.sql.Connection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import quadbase.common.client.ServerMessage;
import quadbase.common.util.IDatabaseInfo;
import quadbase.common.util.IJNDIDatabaseInfo;
import quadbase.common.util.internal.Coder;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.QbConnection;
import quadbase.common.util.internal.QbJNDIConnection;
import quadbase.common.util.internal.XMLUtil;
import quadbase.util.internal.QbUtil;

public class DBInfoBasic
implements IDatabaseInfo,
IJNDIDatabaseInfo {
    protected String url = null;
    protected String driver = null;
    protected String query = null;
    protected Connection connection = null;
    protected boolean doNotCloseConnection = false;
    protected Vector additionalDb = null;
    protected int tableNameFormat = 0;
    public static final String XMLTAG = "DATABASE";
    protected Properties info = new Properties();
    protected boolean useJNDIDataSource = false;
    protected String JNDIName;
    protected Hashtable<String, String> env;

    public DBInfoBasic(String url, String driver, String username, String password, String query, Vector<String> additionalDb) {
        this.url = url;
        this.driver = driver;
        if (username != null) {
            this.info.put("user", username);
        }
        if (password != null) {
            this.info.put("password", password);
        }
        this.query = query;
        this.additionalDb = additionalDb;
    }

    public DBInfoBasic(String url, String driver, String username, String password, String query) {
        this.url = url;
        this.driver = driver;
        if (username != null) {
            this.info.put("user", username);
        }
        if (password != null) {
            this.info.put("password", password);
        }
        this.query = query;
    }

    public Object clone() {
        DBInfoBasic cp = new DBInfoBasic(this.JNDIName, this.query, (Hashtable<String, String>)null);
        return this.clone(cp);
    }

    private DBInfoBasic clone(DBInfoBasic cp) {
        cp.JNDIName = this.JNDIName;
        cp.query = this.query;
        cp.useJNDIDataSource = this.useJNDIDataSource;
        if (this.env != null) {
            cp.env = (Hashtable)this.env.clone();
        }
        cp.url = this.url;
        cp.driver = this.driver;
        cp.query = this.query;
        cp.connection = this.connection;
        cp.doNotCloseConnection = this.doNotCloseConnection;
        cp.info = (Properties)this.info.clone();
        cp.additionalDb = this.additionalDb != null ? (Vector)this.additionalDb.clone() : null;
        return cp;
    }

    @Deprecated
    public DBInfoBasic(String url, String driver, String username, String password, String query, Applet applet) {
        this(url, driver, username, password, query);
        ServerMessage.setApplet(applet);
    }

    public DBInfoBasic(String JNDIName, String query, Hashtable<String, String> env) {
        this.JNDIName = JNDIName;
        this.query = query;
        this.env = env;
        this.useJNDIDataSource = true;
    }

    public DBInfoBasic(IJNDIDatabaseInfo dbInfo) {
        this.JNDIName = dbInfo.getJNDIName();
        this.query = dbInfo.getQuery();
        this.env = dbInfo.getEnvProperties();
        this.useJNDIDataSource = true;
    }

    public DBInfoBasic(DBInfoBasic dbInfo) {
        if (!dbInfo.isUseJNDIDataSource()) {
            String password;
            this.url = dbInfo.getURLString();
            this.driver = dbInfo.getDriverName();
            String username = dbInfo.getUserID();
            if (username != null) {
                this.info.put("user", username);
            }
            if ((password = dbInfo.getPassword()) != null) {
                this.info.put("password", password);
            }
            this.additionalDb = dbInfo.getAdditionalDb();
            if (dbInfo.getConnection() != null) {
                this.connection = dbInfo.getConnection();
                this.doNotCloseConnection = true;
                this.additionalDb = dbInfo.getAdditionalDb();
            }
        } else {
            this.JNDIName = dbInfo.getJNDIName();
            this.env = dbInfo.getEnvProperties();
            this.useJNDIDataSource = true;
        }
        this.query = dbInfo.getQuery();
    }

    public DBInfoBasic(IDatabaseInfo dbInfo) {
        String password;
        if (dbInfo instanceof DBInfoBasic) {
            ((DBInfoBasic)dbInfo).clone(this);
            return;
        }
        if (dbInfo instanceof QbUtil.CDatabaseInfo && ((QbUtil.CDatabaseInfo)dbInfo).isUseJNDIDataSource()) {
            this.JNDIName = ((QbUtil.CDatabaseInfo)dbInfo).getJNDIName();
            this.query = ((QbUtil.CDatabaseInfo)dbInfo).getQuery();
            this.env = ((QbUtil.CDatabaseInfo)dbInfo).getEnvProperties();
            this.useJNDIDataSource = true;
            return;
        }
        this.url = dbInfo.getURLString();
        this.driver = dbInfo.getDriverName();
        String username = dbInfo.getUserID();
        if (username != null) {
            this.info.put("user", username);
        }
        if ((password = dbInfo.getPassword()) != null) {
            this.info.put("password", password);
        }
        if (dbInfo.getConnection() != null) {
            this.connection = dbInfo.getConnection();
            this.doNotCloseConnection = true;
        }
        this.query = dbInfo.getQuery();
    }

    @Deprecated
    public DBInfoBasic(Connection conn, String query, Applet applet) {
        this(conn, query);
        ServerMessage.setApplet(applet);
    }

    public DBInfoBasic(Connection conn, String query) {
        this.connection = conn;
        this.query = query;
        this.doNotCloseConnection = true;
    }

    public DBInfoBasic(Connection conn, String url, String driver, String username, String password, String query) {
        this.url = url;
        this.driver = driver;
        this.info.put("user", username);
        this.info.put("password", password);
        if (conn != null) {
            this.connection = conn;
            this.doNotCloseConnection = true;
        }
        this.query = query;
    }

    @Override
    public String getURLString() {
        return this.url;
    }

    @Override
    public String getDriverName() {
        return this.driver;
    }

    @Override
    public String getUserID() {
        return this.info.getProperty("user", "");
    }

    @Override
    public String getPassword() {
        return this.info.getProperty("password", "");
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public String getQuery() {
        return this.query;
    }

    @Override
    public String getJNDIName() {
        return this.JNDIName;
    }

    public boolean isUseJNDIDataSource() {
        return this.useJNDIDataSource;
    }

    @Override
    public Hashtable<String, String> getEnvProperties() {
        return this.env;
    }

    public String getContextFactory() {
        if (this.env == null) {
            return null;
        }
        return this.env.get("java.naming.factory.initial");
    }

    public String getProviderURL() {
        if (this.env == null) {
            return null;
        }
        return this.env.get("java.naming.provider.url");
    }

    public void setURLString(String url) {
        this.url = url;
    }

    public void setDriverName(String driver) {
        this.driver = driver;
    }

    public void setUserID(String username) {
        if (this.info.containsKey("user")) {
            this.info.remove("user");
        }
        this.info.put("user", username);
    }

    public void setPassword(String password) {
        if (this.info.containsKey("password")) {
            this.info.remove("password");
        }
        this.info.put("password", password);
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public void setJNDIName(String JNDIName) {
        this.JNDIName = JNDIName;
    }

    public void setEnvProperties(Hashtable<String, String> env) {
        this.env = env;
    }

    public void setUseJNDIDataSource(boolean useJNDIDataSource) {
        this.useJNDIDataSource = useJNDIDataSource;
    }

    public void setConnection(Connection conn) {
        this.connection = conn;
        this.doNotCloseConnection = true;
    }

    @Override
    public synchronized Connection openConnection() throws Exception {
        if (this.isUseJNDIDataSource()) {
            try {
                InitialContext ctx = this.env == null || this.env.size() == 0 ? new InitialContext() : new InitialContext(this.env);
                DataSource ds = (DataSource)ctx.lookup(this.JNDIName);
                QbJNDIConnection con = new QbJNDIConnection(ds.getConnection());
                return con;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        if (this.connection != null) {
            return this.connection;
        }
        Properties newprop = (Properties)this.info.clone();
        String url2 = this.url;
        if (!ServerMessage.useServer && ServerMessage.isServlet()) {
            url2 = ServerMessage.getDatabaseURL(this.url);
        }
        if (url2.toUpperCase().indexOf("ORACLE") != -1) {
            this.info.put("restrictGetTables", "true");
        }
        QbConnection con = new QbConnection(this.driver, url2, this.info);
        this.info = newprop;
        return con;
    }

    public synchronized boolean establishConnection() {
        try {
            String url2 = this.url;
            if (!ServerMessage.useServer && ServerMessage.isServlet()) {
                url2 = ServerMessage.getDatabaseURL(this.url);
            }
            if (url2.toUpperCase().indexOf("ORACLE") != -1) {
                this.info.put("restrictGetTables", "true");
            }
            this.connection = new QbConnection(this.driver, url2, this.info);
        }
        catch (Exception e) {
            System.out.println("Error establishing database connection");
            this.connection = null;
            return false;
        }
        return true;
    }

    public void closeConnection() {
        try {
            if (this.connection != null && !this.doNotCloseConnection) {
                this.connection.close();
                this.connection = null;
            }
        }
        catch (Exception e) {
            System.out.println("Error closing connection to database");
        }
    }

    public boolean isCloseConnectionEnabled() {
        return !this.doNotCloseConnection;
    }

    public void write(DataOutput dout) throws IOException {
        IOUtil.writeString(dout, Coder.encode("LONG_QUERIES"));
        dout.writeBoolean(this.useJNDIDataSource);
        if (this.useJNDIDataSource) {
            IOUtil.writeString(dout, Coder.encode(this.JNDIName));
            if (this.env == null) {
                dout.writeInt(0);
            } else {
                dout.writeInt(this.env.size());
                Enumeration<String> name = this.env.keys();
                while (name.hasMoreElements()) {
                    String key = name.nextElement();
                    IOUtil.writeString(dout, Coder.encode(key));
                    IOUtil.writeString(dout, Coder.encode(this.env.get(key)));
                }
            }
        } else {
            IOUtil.writeString(dout, Coder.encode("MULTIPLEDB"));
            String url2 = this.url;
            if (this.url == null) {
                url2 = "";
            }
            IOUtil.writeString(dout, Coder.encode(url2));
            String driver2 = this.driver;
            if (this.driver == null) {
                driver2 = "";
            }
            IOUtil.writeString(dout, Coder.encode(driver2));
            dout.writeInt(this.info.size());
            Enumeration<?> name = this.info.propertyNames();
            while (name.hasMoreElements()) {
                String key = (String)name.nextElement();
                IOUtil.writeString(dout, Coder.encode(key));
                IOUtil.writeString(dout, Coder.encode(this.info.getProperty(key)));
            }
            if (this.additionalDb == null) {
                dout.writeInt(0);
            } else {
                dout.writeInt(this.additionalDb.size());
                for (int i = 0; i < this.additionalDb.size(); ++i) {
                    IOUtil.writeString(dout, Coder.encode(this.additionalDb.get(i).toString()));
                }
            }
        }
        IOUtil.writeLongString(dout, Coder.encode(this.query));
    }

    public static DBInfoBasic read(DataInput din, int version) throws IOException {
        String temp = Coder.decode(IOUtil.readString(din, true));
        boolean useJNDIDataSource = false;
        String url = "";
        String driver = "";
        String JNDIName = "";
        Properties info = new Properties();
        Hashtable<String, String> env = new Hashtable<String, String>();
        Vector<String> addDb = null;
        if (temp.equals("NEW_VERSION") || temp.equals("LONG_QUERIES")) {
            useJNDIDataSource = din.readBoolean();
            if (useJNDIDataSource) {
                JNDIName = Coder.decode(IOUtil.readString(din, true));
                int size = din.readInt();
                for (int i = 0; i < size; ++i) {
                    String key = Coder.decode(IOUtil.readString(din, true));
                    String value = Coder.decode(IOUtil.readString(din, true));
                    if (value == null || value.equals("")) continue;
                    env.put(key, value);
                }
            } else {
                int i;
                String tmp = Coder.decode(IOUtil.readString(din, true));
                boolean multiDb = false;
                if (tmp.equals("MULTIPLEDB")) {
                    multiDb = true;
                    url = Coder.decode(IOUtil.readString(din, true));
                } else {
                    url = tmp;
                }
                driver = Coder.decode(IOUtil.readString(din, true));
                info = new Properties();
                int size = din.readInt();
                for (i = 0; i < size; ++i) {
                    String key = Coder.decode(IOUtil.readString(din, true));
                    String value = Coder.decode(IOUtil.readString(din, true));
                    info.put(key, value);
                }
                if (multiDb) {
                    size = din.readInt();
                    if (size > 0) {
                        addDb = new Vector<String>();
                    }
                    for (i = 0; i < size; ++i) {
                        addDb.add(Coder.decode(IOUtil.readString(din, true)));
                    }
                }
            }
        } else {
            url = temp;
            driver = Coder.decode(IOUtil.readString(din, true));
            info = new Properties();
            int size = din.readInt();
            for (int i = 0; i < size; ++i) {
                String key = Coder.decode(IOUtil.readString(din, true));
                String value = Coder.decode(IOUtil.readString(din, true));
                info.put(key, value);
            }
        }
        String query = temp.equals("LONG_QUERIES") ? Coder.decode(IOUtil.readLongString(din)) : Coder.decode(IOUtil.readString(din, true));
        if (useJNDIDataSource) {
            return new DBInfoBasic(JNDIName, query, env);
        }
        return new DBInfoBasic(url, driver, info.getProperty("user", ""), info.getProperty("password", ""), query, addDb);
    }

    void write(Writer dout, String str) throws IOException {
        dout.write(str);
    }

    public void writeXML(Writer dout) throws IOException {
        String key;
        this.write(dout, "<DATABASE>\n");
        if (this.JNDIName != null) {
            this.write(dout, "<JNDIName>" + XMLUtil.encodeCDATA(this.JNDIName) + "</JNDIName>\n");
        }
        Enumeration<String> name = null;
        if (this.env != null) {
            name = this.env.keys();
            while (name.hasMoreElements()) {
                key = name.nextElement();
                if (key.equals("password")) {
                    this.write(dout, "<ENV_PROPERTY Key=\"" + XMLUtil.encodeXML("encryptedPassword") + "\" Value=\"" + XMLUtil.encodeXML(Coder.encode(this.env.get(key))) + "\" />\n");
                    continue;
                }
                this.write(dout, "<ENV_PROPERTY Key=\"" + XMLUtil.encodeXML(key) + "\" Value=\"" + XMLUtil.encodeXML(this.env.get(key)) + "\" />\n");
            }
        }
        this.write(dout, "<URL>" + XMLUtil.encodeCDATA(this.url) + "</URL>\n");
        this.write(dout, "<DRIVER>" + XMLUtil.encodeCDATA(this.driver) + "</DRIVER>\n");
        name = this.info.propertyNames();
        while (name.hasMoreElements()) {
            key = name.nextElement();
            if (key.equals("password")) {
                this.write(dout, "<PROPERTY Key=\"" + XMLUtil.encodeXML("encryptedPassword") + "\" Value=\"" + XMLUtil.encodeXML(Coder.encode((String)this.info.get(key))) + "\" />\n");
                continue;
            }
            this.write(dout, "<PROPERTY Key=\"" + XMLUtil.encodeXML(key) + "\" Value=\"" + XMLUtil.encodeXML(this.info.getProperty(key)) + "\" />\n");
        }
        this.write(dout, "<QUERY>" + XMLUtil.encodeCDATA(this.query) + "</QUERY>\n");
        this.write(dout, "</DATABASE>\n");
    }

    public static DBInfoBasic readXML(Node dnode, int version) throws Exception {
        if (dnode.getNodeName().equalsIgnoreCase(XMLTAG)) {
            String url = "";
            String driver = "";
            Properties info = new Properties();
            String query = "";
            boolean useJNDIDataSource = false;
            String JNDIName = "";
            Hashtable<String, String> env = new Hashtable<String, String>();
            NodeList nodeList = dnode.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                int j;
                NamedNodeMap map;
                String value;
                String key;
                Node node = nodeList.item(i);
                if (node.getNodeName().equalsIgnoreCase("URL")) {
                    url = XMLUtil.readCDATA(node);
                    continue;
                }
                if (node.getNodeName().equalsIgnoreCase("DRIVER")) {
                    driver = XMLUtil.readCDATA(node);
                    continue;
                }
                if (node.getNodeName().equalsIgnoreCase("PROPERTY")) {
                    key = null;
                    value = null;
                    map = node.getAttributes();
                    for (j = 0; j < map.getLength(); ++j) {
                        if (map.item(j).getNodeName().equalsIgnoreCase("Key")) {
                            key = map.item(j).getNodeValue();
                            continue;
                        }
                        if (!map.item(j).getNodeName().equalsIgnoreCase("Value")) continue;
                        value = map.item(j).getNodeValue();
                    }
                    if (key == null || value == null) continue;
                    if (key.equals("encryptedPassword")) {
                        info.put("password", Coder.decode(value));
                        continue;
                    }
                    info.put(key, value);
                    continue;
                }
                if (node.getNodeName().equalsIgnoreCase("ENV_PROPERTY")) {
                    key = null;
                    value = null;
                    map = node.getAttributes();
                    for (j = 0; j < map.getLength(); ++j) {
                        if (map.item(j).getNodeName().equalsIgnoreCase("Key")) {
                            key = map.item(j).getNodeValue();
                            continue;
                        }
                        if (!map.item(j).getNodeName().equalsIgnoreCase("Value")) continue;
                        value = map.item(j).getNodeValue();
                    }
                    if (key == null || value == null || value.equals("")) continue;
                    if (key.equals("encryptedPassword")) {
                        env.put("password", Coder.decode(value));
                        continue;
                    }
                    env.put(key, value);
                    continue;
                }
                if (node.getNodeName().equalsIgnoreCase("JNDIName")) {
                    useJNDIDataSource = true;
                    JNDIName = XMLUtil.readCDATA(node);
                    continue;
                }
                if (!node.getNodeName().equalsIgnoreCase("QUERY")) continue;
                query = XMLUtil.readCDATA(node);
            }
            if (useJNDIDataSource) {
                return new DBInfoBasic(JNDIName, query, env);
            }
            return new DBInfoBasic(url, driver, info.getProperty("user", ""), info.getProperty("password", ""), query);
        }
        return null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("<< DBInfoBasic >>\n");
        sb.append("JNDI name= " + this.JNDIName + "\n");
        sb.append("query    = " + this.query + "\n");
        return sb.toString();
    }

    public boolean equals(DBInfoBasic dbInfo) {
        return this.equals(dbInfo, true);
    }

    public boolean equalsIgnoreQuery(DBInfoBasic dbInfo) {
        return this.equals(dbInfo, false);
    }

    public boolean equals(DBInfoBasic dbInfo, boolean checkQuery) {
        int size2;
        if (this.connection != null) {
            return true;
        }
        if (this.useJNDIDataSource) {
            int size22;
            if (!dbInfo.isUseJNDIDataSource()) {
                return false;
            }
            if (!this.JNDIName.equals(dbInfo.getJNDIName())) {
                return false;
            }
            if (checkQuery && !this.query.equals(dbInfo.query)) {
                return false;
            }
            int size1 = this.env.size();
            if (size1 != (size22 = dbInfo.env.size())) {
                return false;
            }
            Enumeration<String> name1 = this.env.keys();
            Hashtable<String, String> target = dbInfo.env;
            while (name1.hasMoreElements()) {
                String key = name1.nextElement();
                String value = this.env.get(key);
                if (target.containsKey(key) && target.get(key).equals(value)) continue;
                return false;
            }
            return true;
        }
        if (!this.url.equals(dbInfo.url)) {
            return false;
        }
        if (!this.driver.equals(dbInfo.driver)) {
            return false;
        }
        if (checkQuery && !this.query.equals(dbInfo.query)) {
            return false;
        }
        int size1 = this.info.size();
        if (size1 != (size2 = dbInfo.info.size())) {
            return false;
        }
        Enumeration<?> name1 = this.info.propertyNames();
        Properties target = dbInfo.info;
        while (name1.hasMoreElements()) {
            String key = (String)name1.nextElement();
            String value = this.info.getProperty(key);
            if (target.containsKey(key) && target.getProperty(key).equals(value)) continue;
            return false;
        }
        return true;
    }

    public Vector<String> getAdditionalDb() {
        return this.additionalDb;
    }

    public void setAdditionalDb(Vector<String> v) {
        this.additionalDb = v;
    }

    public int getTableNameFormat() {
        return this.tableNameFormat;
    }

    public void setTableNameFormat(int tableNameFormat) {
        this.tableNameFormat = tableNameFormat;
    }
}

