/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.util.internal;

import java.io.ByteArrayInputStream;
import java.math.BigDecimal;
import java.util.Vector;
import quadbase.common.util.internal.DataSetARRAY;
import quadbase.common.util.internal.IDataSet;
import quadbase.common.util.internal.IOUtil;

public class DataSetARRAYIndexed
extends DataSetARRAY {
    Vector index;

    public DataSetARRAYIndexed(int blockSize, int dataType, int maxBuffer) {
        super(blockSize, dataType, maxBuffer);
    }

    @Override
    protected void initialBuffer() {
        super.initialBuffer();
        this.index = new Vector(this.maxBuffer);
        this.index.addElement(this.wBufferPtr);
    }

    @Override
    protected void releaseBuffer() {
        super.releaseBuffer();
        this.index = null;
    }

    @Override
    public boolean willFit(IDataSet data) {
        int dataSize = 0;
        for (int i = 0; i < data.size(); ++i) {
            dataSize = data.elementAt(i) == null || data.elementAt(i).equals("") ? ++dataSize : (dataSize += data.elementAt(i).toString().getBytes().length);
            if (dataSize < this.blockSize * this.maxBuffer) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean willFit(Object obj) {
        if (obj == null || obj.equals("")) {
            return this.wBufferPtr + 1 < this.blockSize * this.maxBuffer;
        }
        return this.wBufferPtr + obj.toString().getBytes().length < this.blockSize * this.maxBuffer;
    }

    @Override
    public Object elementAt(int i) {
        Object res;
        if (this.isFinalized) {
            return null;
        }
        if (this.buffer == null) {
            return null;
        }
        try {
            int startIndex = (Integer)this.index.get(i);
            int endIndex = (Integer)this.index.get(i + 1);
            res = this.readObject(this.buffer, startIndex, endIndex - startIndex);
        }
        catch (Exception ex) {
            if (this.isFinalized) {
                return null;
            }
            throw new IllegalArgumentException(IOUtil.getStackTrace(ex));
        }
        return res;
    }

    @Override
    protected void writeObject(Object obj) throws Exception {
        if (this.buffer == null) {
            this.initialBuffer();
        }
        if (!this.willFit(obj)) {
            throw new Exception("Object " + obj + " will not fit in the DataSetARRAY!");
        }
        if (obj == null) {
            this.buffer[this.wBufferPtr] = 0;
            ++this.wBufferPtr;
            this.index.addElement(this.wBufferPtr);
        } else if (obj.equals("")) {
            this.buffer[this.wBufferPtr] = 2;
            ++this.wBufferPtr;
            this.index.addElement(this.wBufferPtr);
        } else {
            byte[] barray = obj.toString().getBytes();
            System.arraycopy(barray, 0, this.buffer, this.wBufferPtr, barray.length);
            this.wBufferPtr += barray.length;
            this.index.addElement(this.wBufferPtr);
        }
    }

    private Object readObject(byte[] data, int offset, int length) throws Exception {
        if (length == 1 && data[offset] == 0) {
            return null;
        }
        if (length == 1 && data[offset] == 2) {
            return "";
        }
        if (this.isFinalized) {
            return null;
        }
        this.bis = new ByteArrayInputStream(data, offset, length);
        byte[] barray = new byte[length];
        this.bis.read(barray, 0, length);
        String tmpStr = new String(barray);
        if (this.dataType == 13) {
            return new BigDecimal(tmpStr);
        }
        return tmpStr;
    }

    @Override
    protected void checkDataType() throws IllegalArgumentException {
        if (this.dataType != 7 && this.dataType != 13) {
            throw new IllegalArgumentException("DataSetARRAYIndexed works only with STRING or BIGDECIMAL data type");
        }
    }
}

