/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.util.internal;

import java.util.Properties;
import quadbase.common.util.internal.DataSet;
import quadbase.common.util.internal.IDataSet;
import quadbase.common.util.internal.IOUtil;

public class DataSetColumn
extends DataSet {
    private IDataSet orgData = null;
    private IDataSet actualData = null;
    private IDataSet scriptedData = null;
    private Properties treeProperties = null;

    public DataSetColumn(String address, int maxChar, int noOfCol, boolean isTreeReport, Properties treeProperties) {
        super(null);
        this.address = address;
        this.maxChar = maxChar;
        this.noOfCol = noOfCol;
        this.treeProperties = treeProperties;
    }

    public IDataSet getColumnData(int colDataType) {
        switch (colDataType) {
            case 0: {
                return this.getOriginalData();
            }
            case 1: {
                return this.getActualData();
            }
            case 2: {
                return this.getScriptedData();
            }
        }
        return this;
    }

    private IDataSet getOriginalData() {
        if (this.orgData == null) {
            this.orgData = new DataSet("D_" + this.address, this.maxChar, this.noOfCol, false, this.treeProperties);
        }
        return this.orgData;
    }

    private IDataSet getActualData() {
        if (this.actualData == null) {
            this.actualData = new DataSet("AD_" + this.address, this.maxChar, this.noOfCol, false, this.treeProperties);
        }
        return this.actualData;
    }

    private IDataSet getScriptedData() {
        if (this.scriptedData == null) {
            this.scriptedData = new DataSet("SD_" + this.address, this.maxChar, this.noOfCol, false, this.treeProperties);
        }
        return this.scriptedData;
    }

    @Override
    public void cleanup() {
        try {
            this.finalize();
        }
        catch (Throwable ex) {
            throw new IllegalArgumentException(IOUtil.getStackTrace(ex));
        }
    }

    @Override
    protected void finalize() throws Throwable {
        try {
            if (this.orgData != null) {
                this.orgData.cleanup();
            }
            if (this.actualData != null) {
                this.actualData.cleanup();
            }
            if (this.scriptedData != null) {
                this.scriptedData.cleanup();
            }
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public void releaseDiskBuffer() {
        if (this.orgData != null) {
            this.orgData.releaseDiskBuffer();
        }
        if (this.actualData != null) {
            this.actualData.releaseDiskBuffer();
        }
        if (this.scriptedData != null) {
            this.scriptedData.releaseDiskBuffer();
        }
    }
}

