/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.util.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import quadbase.common.client.FileInfo;
import quadbase.common.client.ServerMessage;
import quadbase.common.util.internal.CloseUtils;
import quadbase.common.util.internal.DataSetARRAY;
import quadbase.common.util.internal.DeleteFile;
import quadbase.common.util.internal.IDataSet;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.QbDebug;

public class DataSetDISK
implements IDataSet {
    protected int size = 0;
    protected String fileName = "";
    protected int blockSize = -1;
    protected int dataType = -1;
    protected int maxBuffer = -1;
    protected int wBufferPtr = 0;
    protected byte[] writeBuffer;
    protected int rBufferStartPt = 0;
    protected byte[] readBuffer = null;
    protected ByteArrayOutputStream bos;
    protected DataOutputStream dos;
    protected ObjectOutputStream oos;
    protected ByteArrayInputStream bis;
    protected ObjectInputStream ois;
    protected boolean isFinalized = false;
    protected static int count = 0;
    protected static int memUsed = 0;
    protected int totalMaxPageBufferMem;
    protected static final int WRITE_OBJECT = 0;
    protected static final int READ_OBJECT = 1;
    protected static final int REMOVE_ALL_OBJECTS = 2;
    protected static final int RELEASE_READ_BUFFER = 3;
    protected boolean initWriteBuffer = false;
    protected boolean initReadBuffer = false;
    protected RandomAccessFile rf = null;

    public DataSetDISK(String name, int blockSize, int dataType, int maxBuffer) {
        this.dataType = dataType;
        this.checkDataType();
        this.blockSize = blockSize;
        this.maxBuffer = maxBuffer;
        this.totalMaxPageBufferMem = ServerMessage.getTotalPageBufferSize() * 1024 * 1024;
        count = (count + 1) % 9999;
        this.fileName = ServerMessage.getTempDirectory() + name + "_" + System.currentTimeMillis() + "_" + count + ".bbc";
        QbDebug.println(6, "Reached Paging Threshold - " + this.fileName + " will be created shortly");
        try {
            new DeleteFile(this.fileName).delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public DataSetDISK(DataSetDISK _disk, String name) {
        this.size = _disk.size;
        this.fileName = ServerMessage.getTempDirectory() + name + "_" + System.currentTimeMillis() + "_" + count + ".bbc";
        this.blockSize = _disk.blockSize;
        this.dataType = _disk.dataType;
        this.maxBuffer = _disk.maxBuffer;
        this.totalMaxPageBufferMem = _disk.totalMaxPageBufferMem;
        memUsed += this.blockSize * this.maxBuffer;
        try {
            this.copyFile(_disk.fileName, this.fileName);
        }
        catch (Exception ex) {
            System.out.println("Fail to copy " + _disk.fileName + " to " + this.fileName);
        }
    }

    protected void copy(DataSetARRAY dataARRAY) {
        this.blockSize = dataARRAY.blockSize;
        this.dataType = dataARRAY.dataType;
        this.maxBuffer = dataARRAY.maxBuffer;
        this.size = dataARRAY.size();
        this.wBufferPtr = dataARRAY.wBufferPtr;
        this.writeBuffer = dataARRAY.buffer;
        this.bos = dataARRAY.bos;
        this.dos = dataARRAY.dos;
        this.oos = dataARRAY.oos;
        this.bis = dataARRAY.bis;
        this.ois = dataARRAY.ois;
        this.initWriteBuffer = true;
        memUsed += this.blockSize * this.maxBuffer;
        if (this.wBufferPtr > this.writeBuffer.length) {
            try {
                this.writeToFile();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    protected void initialWriteBuffer() {
        if (this.totalMaxPageBufferMem > 0 && this.writeBuffer == null) {
            for (int i = 0; i < 15; ++i) {
                int freeMem = this.totalMaxPageBufferMem - memUsed;
                if (freeMem < this.totalMaxPageBufferMem / 3) {
                    int newBuffer = this.maxBuffer / 2;
                    int availBuffer = (int)Math.floor(freeMem / 10 / this.blockSize);
                    this.maxBuffer = newBuffer > availBuffer ? availBuffer : newBuffer;
                }
                if (this.maxBuffer > 0) {
                    if (i <= 0) break;
                    QbDebug.println(6, "MEMORY RELEASED...");
                    break;
                }
                try {
                    QbDebug.println(6, "HIT MAX MEMORY - WAITING FOR MEMORY RELEASE");
                    Thread.sleep(2000L);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.maxBuffer == 0) {
                this.maxBuffer = 1;
            }
            this.initWriteBuffer = true;
            memUsed += this.blockSize * this.maxBuffer;
        }
        QbDebug.println(6, this.fileName + " buffering: start");
        this.writeBuffer = new byte[this.blockSize * this.maxBuffer];
        this.wBufferPtr = 0;
    }

    protected void releaseWriteBuffer() {
        if (this.totalMaxPageBufferMem > 0 && this.writeBuffer != null) {
            memUsed -= this.writeBuffer.length;
            this.initWriteBuffer = false;
        }
        this.wBufferPtr = 0;
        this.writeBuffer = null;
    }

    protected void initialReadBuffer(int rowBuffer) {
        if (this.totalMaxPageBufferMem > 0 && this.readBuffer == null) {
            memUsed += this.blockSize * rowBuffer;
            this.initReadBuffer = true;
        }
        this.readBuffer = new byte[this.blockSize * rowBuffer];
    }

    protected void releaseReadBuffer() {
        if (this.totalMaxPageBufferMem > 0 && this.readBuffer != null) {
            memUsed -= this.readBuffer.length;
            this.initReadBuffer = false;
        }
        QbDebug.println(6, this.fileName + " buffering: done");
        this.readBuffer = null;
        this.rBufferStartPt = 0;
    }

    @Override
    public void addElement(Object obj) {
        if (this.isFinalized) {
            return;
        }
        try {
            this.processData(0, -1, obj);
            ++this.size;
        }
        catch (Exception ex) {
            if (this.isFinalized) {
                return;
            }
            throw new IllegalArgumentException(IOUtil.getStackTrace(ex));
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public long getMemSizeUsed() {
        return 0L;
    }

    @Override
    public Object elementAt(int i) {
        Object res;
        if (this.isFinalized) {
            return null;
        }
        if (this.readBuffer != null && i >= this.rBufferStartPt && i < this.readBuffer.length / this.blockSize + this.rBufferStartPt) {
            try {
                res = this.readObject(this.readBuffer, (i - this.rBufferStartPt) * this.blockSize);
            }
            catch (Exception ex) {
                if (this.isFinalized) {
                    return null;
                }
                throw new IllegalArgumentException(IOUtil.getStackTrace(ex));
            }
        }
        try {
            res = this.processData(1, i, null);
        }
        catch (Exception ex) {
            if (this.isFinalized) {
                return null;
            }
            throw new IllegalArgumentException(IOUtil.getStackTrace(ex));
        }
        if (i == this.size - 1) {
            try {
                this.processData(3, -1, null);
            }
            catch (Exception ex) {
                if (this.isFinalized) {
                    return null;
                }
                throw new IllegalArgumentException(IOUtil.getStackTrace(ex));
            }
        }
        return res;
    }

    @Override
    public void setElementAt(Object obj, int index) {
        System.out.println("DATASETDISK - setElementAt");
    }

    @Override
    public Object clone() {
        return null;
    }

    @Override
    public Object cloneStructure() {
        return null;
    }

    @Override
    public void insertElementAt(Object obj, int index) {
        System.out.println("DATASETDISK - insertElementAt");
    }

    @Override
    public void removeElementAt(int index) {
        System.out.println("DATASETDISK - removeElementAt");
    }

    @Override
    public void removeAllElements() {
        try {
            this.processData(2, -1, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void removeAllObjects() {
        if (this.size != 0) {
            this.delete(this.fileName);
            this.fileName = this.renameFile(this.fileName);
            this.reset();
        }
    }

    @Override
    public boolean isValid() {
        try {
            return new FileInfo(this.fileName).exists();
        }
        catch (Exception ex) {
            return false;
        }
    }

    @Override
    public void cleanup() {
        try {
            this.finalize();
        }
        catch (Throwable ex) {
            throw new IllegalArgumentException(IOUtil.getStackTrace(ex));
        }
    }

    protected void finalize() throws Throwable {
        try {
            if (this.isFinalized) {
                return;
            }
            this.isFinalized = true;
            if (this.initWriteBuffer) {
                this.releaseWriteBuffer();
            }
            if (this.initReadBuffer) {
                this.releaseReadBuffer();
            }
            this.delete(this.fileName);
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public void releaseDiskBuffer() {
        if (this.initWriteBuffer) {
            try {
                if (this.writeBuffer != null) {
                    this.writeLastDataSet();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.releaseWriteBuffer();
        }
        if (this.initReadBuffer) {
            this.releaseReadBuffer();
        }
    }

    private String renameFile(String filename) {
        if (filename.endsWith("_R_R_R_R_R_R_R_R_R_R")) {
            return filename.substring(0, filename.length() - 20);
        }
        return filename + "_R";
    }

    protected void reset() {
        this.rf = null;
        this.releaseWriteBuffer();
        this.releaseReadBuffer();
        this.bos = null;
        this.oos = null;
        this.bis = null;
        this.ois = null;
        this.dos = null;
    }

    protected void delete(String fn) {
        try {
            if (this.rf != null) {
                this.closeIO();
            }
            new DeleteFile(fn).delete();
            QbDebug.println(6, this.fileName + ": DELETE FILE");
            this.size = 0;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFile(String inputFN, String outputFN) throws IOException {
        QbDebug.println(6, "START COPYING " + inputFN + " to " + outputFN);
        File f1 = new File(inputFN);
        File f2 = new File(outputFN);
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            int len;
            in = new FileInputStream(f1);
            out = new FileOutputStream(f2);
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
        }
        catch (Throwable throwable) {
            CloseUtils.close(in);
            CloseUtils.close(out);
            throw throwable;
        }
        CloseUtils.close(in);
        CloseUtils.close(out);
        QbDebug.println(6, "DONE COPYING " + inputFN + " to " + outputFN);
    }

    protected void writeLastDataSet() throws IOException {
        if (this.wBufferPtr > 0) {
            this.writeToFile();
        }
        this.releaseWriteBuffer();
    }

    protected void writeObject(Object obj) throws Exception {
        if (this.writeBuffer == null) {
            this.initialWriteBuffer();
        }
        if (obj == null) {
            this.writeBuffer[this.wBufferPtr] = 0;
        } else if (obj.equals("")) {
            this.writeBuffer[this.wBufferPtr] = 2;
        } else {
            switch (this.dataType) {
                case 0: {
                    this.getDataOutputStream().writeBoolean((Boolean)obj);
                    break;
                }
                case 11: {
                    this.getDataOutputStream().writeByte(((Byte)obj).byteValue());
                    break;
                }
                case 12: {
                    this.getDataOutputStream().writeShort(((Short)obj).shortValue());
                    break;
                }
                case 2: {
                    this.getDataOutputStream().writeInt((Integer)obj);
                    break;
                }
                case 1: {
                    this.getDataOutputStream().writeLong((Long)obj);
                    break;
                }
                case 3: {
                    this.getDataOutputStream().writeFloat(((Float)obj).floatValue());
                    break;
                }
                case 4: {
                    this.getDataOutputStream().writeDouble((Double)obj);
                    break;
                }
                case 8: 
                case 9: 
                case 10: {
                    this.getDataOutputStream().writeLong(((java.util.Date)obj).getTime());
                    break;
                }
                default: {
                    if (this.bos == null) {
                        this.bos = new ByteArrayOutputStream();
                    }
                    this.bos.reset();
                    this.oos = new ObjectOutputStream(this.bos);
                    this.oos.writeObject(obj);
                    this.oos.flush();
                    this.oos.close();
                }
            }
            if (this.bos.size() > this.blockSize) {
                System.out.println("EXCEED SIZE LIMIT, size [" + this.bos.size() + "] max [" + this.blockSize + "]");
                QbDebug.println(6, "EXCEED SIZE LIMIT - OBJ CLASS = " + obj.getClass().toString() + " VAL = " + obj.toString());
                this.writeBuffer[this.wBufferPtr] = 0;
            } else {
                this.writeBuffer[this.wBufferPtr] = 1;
                byte[] data = this.bos.toByteArray();
                System.arraycopy(data, 0, this.writeBuffer, this.wBufferPtr + 1, data.length);
            }
        }
        this.wBufferPtr += this.blockSize;
        if (this.wBufferPtr >= this.writeBuffer.length) {
            this.writeToFile();
        }
    }

    protected void writeToFile() throws IOException {
        if (this.rf == null) {
            this.openIO();
        }
        this.rf.seek(this.rf.length());
        this.rf.write(this.writeBuffer, 0, this.wBufferPtr);
        this.wBufferPtr = 0;
    }

    protected synchronized Object processData(int flag, int startIndex, Object obj) throws Exception {
        if (flag == 1) {
            return this.readObject(startIndex);
        }
        if (flag == 0) {
            this.writeObject(obj);
            return null;
        }
        if (flag == 2) {
            this.removeAllObjects();
            return null;
        }
        if (flag == 3) {
            this.releaseReadBuffer();
            return null;
        }
        return null;
    }

    protected Object readObject(int startIndex) throws Exception {
        if (this.isFinalized) {
            return null;
        }
        this.rBufferStartPt = startIndex;
        int endIndex = startIndex + this.maxBuffer;
        if (endIndex > this.size) {
            endIndex = this.size;
        }
        if (this.writeBuffer != null && this.wBufferPtr > 0) {
            this.writeToFile();
        }
        if (this.rf == null) {
            this.openIO();
        }
        this.rf.seek(startIndex * this.blockSize);
        int bufSize = endIndex - startIndex;
        if (this.readBuffer == null || this.readBuffer.length != this.blockSize * bufSize) {
            this.initialReadBuffer(bufSize);
        }
        this.rf.read(this.readBuffer);
        if (endIndex == this.size) {
            this.closeIO();
        }
        return this.readObject(this.readBuffer, 0);
    }

    private Object readObject(byte[] data, int offset) throws Exception {
        if (this.isFinalized) {
            return null;
        }
        if (data[offset] == 0) {
            return null;
        }
        if (data[offset] == 2) {
            return "";
        }
        this.bis = new ByteArrayInputStream(data, offset + 1, this.blockSize - 1);
        DataInputStream dis = new DataInputStream(this.bis);
        switch (this.dataType) {
            case 0: {
                return dis.readBoolean();
            }
            case 11: {
                return dis.readByte();
            }
            case 12: {
                return dis.readShort();
            }
            case 2: {
                return dis.readInt();
            }
            case 1: {
                return dis.readLong();
            }
            case 3: {
                return Float.valueOf(dis.readFloat());
            }
            case 4: {
                return dis.readDouble();
            }
            case 8: {
                return new Date(dis.readLong());
            }
            case 9: {
                return new Time(dis.readLong());
            }
            case 10: {
                return new Timestamp(dis.readLong());
            }
        }
        this.ois = new ObjectInputStream(this.bis);
        Object result = this.ois.readObject();
        return result;
    }

    protected void openIO() throws IOException {
        this.rf = new RandomAccessFile(this.fileName, "rw");
    }

    protected void closeIO() throws IOException {
        if (this.rf != null) {
            this.rf.close();
        }
        this.rf = null;
    }

    private DataOutputStream getDataOutputStream() {
        if (this.bos == null) {
            this.bos = new ByteArrayOutputStream();
        }
        this.bos.reset();
        if (this.dos == null) {
            this.dos = new DataOutputStream(this.bos);
        }
        return this.dos;
    }

    protected void checkDataType() throws IllegalArgumentException {
        if (this.dataType == 7 || this.dataType == 13) {
            throw new IllegalArgumentException("DataSetDISKIndexed should be used instead of DataSetDISK for STRING and BIGDECIMAL data type");
        }
    }
}

