/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.util.internal;

import java.util.Vector;
import quadbase.common.util.internal.IDataSet;
import quadbase.common.util.internal.IOUtil;

public class DataSetMEM
implements IDataSet {
    private Vector data;
    private boolean isNullColumn = true;
    int ctData = 0;

    public DataSetMEM() {
        this.data = new Vector();
    }

    public DataSetMEM(DataSetMEM _data) {
        if (_data.data != null) {
            this.data = (Vector)_data.data.clone();
            this.ctData = _data.ctData;
            this.isNullColumn = _data.isNullColumn;
        }
    }

    public DataSetMEM(int intialCapacity) {
        this.data = new Vector(intialCapacity);
    }

    @Override
    public long getMemSizeUsed() {
        return 0L;
    }

    @Override
    public void addElement(Object obj) {
        if (obj != null && this.isNullColumn) {
            for (int i = 0; i < this.ctData; ++i) {
                this.data.addElement(null);
            }
            this.data.addElement(obj);
            this.isNullColumn = false;
        } else if (!this.isNullColumn) {
            this.data.addElement(obj);
        }
        ++this.ctData;
    }

    @Override
    public void insertElementAt(Object obj, int index) {
        if (obj != null && this.isNullColumn) {
            for (int i = 0; i < this.ctData; ++i) {
                this.data.addElement(null);
            }
            this.data.insertElementAt(obj, index);
            this.isNullColumn = false;
        } else if (!this.isNullColumn) {
            this.data.insertElementAt(obj, index);
        }
        ++this.ctData;
    }

    @Override
    public void removeElementAt(int index) {
        if (!this.isNullColumn) {
            this.data.removeElementAt(index);
        }
        --this.ctData;
    }

    @Override
    public void removeAllElements() {
        if (!this.isNullColumn) {
            this.data.removeAllElements();
        }
        this.ctData = 0;
    }

    @Override
    public int size() {
        if (this.data == null) {
            return 0;
        }
        if (this.isNullColumn) {
            return this.ctData;
        }
        return this.data.size();
    }

    @Override
    public Object elementAt(int i) {
        if (this.isNullColumn) {
            return null;
        }
        return this.data.elementAt(i);
    }

    @Override
    public void setElementAt(Object obj, int index) {
        if (obj != null && this.isNullColumn) {
            for (int i = 0; i < this.ctData; ++i) {
                this.data.addElement(null);
            }
            this.data.setElementAt(obj, index);
            this.isNullColumn = false;
        }
        if (!this.isNullColumn) {
            this.data.setElementAt(obj, index);
        }
    }

    @Override
    public Object clone() {
        DataSetMEM newData = new DataSetMEM();
        newData.data = (Vector)this.data.clone();
        newData.isNullColumn = this.isNullColumn;
        newData.ctData = this.ctData;
        return newData;
    }

    @Override
    public Object cloneStructure() {
        DataSetMEM newData = new DataSetMEM();
        newData.isNullColumn = this.isNullColumn;
        newData.ctData = this.ctData;
        return newData;
    }

    @Override
    public void cleanup() {
        try {
            this.finalize();
        }
        catch (Throwable ex) {
            throw new IllegalArgumentException(IOUtil.getStackTrace(ex));
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    @Override
    public void releaseDiskBuffer() {
    }

    @Override
    public boolean isValid() {
        return true;
    }
}

