/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.util.internal;

public class FileTypeUtil {
    public static final String PAK = ".pak";
    public static final String RPT = ".rpt";
    public static final String XML = ".xml";

    public static String getPakFileName(String fileName) {
        if (FileTypeUtil.isRPTFile(fileName) || FileTypeUtil.isXMLFile(fileName)) {
            return fileName.substring(0, fileName.length() - 4) + PAK;
        }
        if (FileTypeUtil.isPAKFile(fileName)) {
            return fileName;
        }
        return fileName + PAK;
    }

    public static String getRptFileName(String fileName) {
        if (FileTypeUtil.isPAKFile(fileName) || FileTypeUtil.isRPTFile(fileName) || FileTypeUtil.isXMLFile(fileName)) {
            return fileName.substring(0, fileName.length() - 4) + RPT;
        }
        if (FileTypeUtil.isRPTFile(fileName)) {
            return fileName;
        }
        return fileName + RPT;
    }

    public static boolean isPAKFile(String filename) {
        return filename.toLowerCase().endsWith(PAK);
    }

    public static boolean isXMLFile(String filename) {
        return filename.toLowerCase().endsWith(XML);
    }

    public static boolean isRPTFile(String filename) {
        return filename.toLowerCase().endsWith(RPT);
    }
}

