/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.util.internal;

import java.applet.Applet;
import java.awt.AWTException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Random;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import quadbase.common.client.ServerMessage;
import quadbase.common.network.IConnection;
import quadbase.common.util.internal.Coder;
import quadbase.common.util.internal.Java2DUtil;
import quadbase.common.util.internal.LCKey;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.common.util.internal.QbDebug;
import quadbase.common.util.internal.QbUtil;
import quadbase.common.util.internal.VersioningDataOutput;

public final class IOUtil {
    private static final int MAX_STRING_LENGTH = 21845;
    public static boolean isUsingEspressOrganizerApplet = false;
    private static Boolean isJava2D = null;
    private static Boolean isJava14 = null;
    private static Boolean isMac = null;
    private static Boolean isJimiIncluded = null;
    private static Boolean isXMLIncluded = null;
    private static Random random = null;

    public static final String readString(DataInput in) throws IOException {
        return in.readUTF();
    }

    public static final String readString(DataInput in, boolean isUTF) throws IOException {
        byte c;
        if (isUTF) {
            return in.readUTF();
        }
        int size = 60;
        byte[] barray = new byte[size];
        int i = 0;
        while ((c = in.readByte()) != 0) {
            barray[i++] = c;
            if (i != size) continue;
            byte[] barray2 = new byte[2 * size];
            System.arraycopy(barray, 0, barray2, 0, size);
            size = (short)(size * 2);
            barray = barray2;
        }
        return new String(barray, 0, i);
    }

    public static final void writeString(DataOutput out, String string) throws IOException {
        if (string == null) {
            out.writeUTF("");
        } else {
            out.writeUTF(string);
        }
    }

    public static final void writeLongString(DataOutput out, String string) throws IOException {
        if (string == null || string.length() == 0) {
            out.writeShort(1);
            out.writeUTF("");
        } else {
            out.writeShort((short)Math.ceil((double)string.length() / 21845.0));
            while (string.length() > 21845) {
                out.writeUTF(string.substring(0, 21845));
                string = string.substring(21845);
            }
            out.writeUTF(string);
        }
    }

    public static final String readLongString(DataInput in) throws IOException {
        int count = in.readShort();
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < count; ++i) {
            result.append(in.readUTF());
        }
        return result.toString();
    }

    public static final void writeString(VersioningDataOutput vdo, String string, short version) throws IOException {
        if (string == null) {
            vdo.writeUTF("", version);
        } else {
            vdo.writeUTF(string, version);
        }
    }

    public static final void writeStr(DataOutput out, String string) throws IOException {
        if (string == null) {
            out.writeBoolean(true);
        } else {
            out.writeBoolean(false);
            out.writeUTF(string);
        }
    }

    public static final void writeStr(VersioningDataOutput vout, String string, short version) throws IOException {
        if (string == null) {
            vout.writeBoolean(true, version);
        } else {
            vout.writeBoolean(false, version);
            vout.writeUTF(string, version);
        }
    }

    public static final String readStr(DataInput in) throws IOException {
        if (in.readBoolean()) {
            return null;
        }
        return in.readUTF();
    }

    public static final void writeColor(DataOutput out, Color color) throws IOException {
        if (color == null) {
            out.writeBoolean(true);
        } else {
            out.writeBoolean(false);
            out.writeInt(color.getRGB());
        }
    }

    public static final Color readColor(DataInput in) throws IOException {
        if (in.readBoolean()) {
            return null;
        }
        return new Color(in.readInt());
    }

    public static final void writeFont(DataOutput out, Font font) throws IOException {
        IOUtil.writeString(out, font.getName());
        out.writeInt(font.getStyle());
        out.writeInt(font.getSize());
    }

    public static final Font readFont(DataInput in) throws IOException {
        return new Font(IOUtil.readString(in, true), in.readInt(), in.readInt());
    }

    public static final void writeInts(DataOutput out, int[] iarray, int size) throws IOException {
        for (int i = 0; i < size; ++i) {
            out.writeInt(iarray[i]);
        }
    }

    public static final void writeInts(VersioningDataOutput out, int[] iarray, int size, short featureVersion) throws IOException {
        for (int i = 0; i < size; ++i) {
            out.writeInt(iarray[i], featureVersion);
        }
    }

    public static final int[] readInts(DataInput in, int size) throws IOException {
        int[] iarray = new int[size];
        for (int i = 0; i < size; ++i) {
            iarray[i] = in.readInt();
        }
        return iarray;
    }

    public static final void writeBooleans(VersioningDataOutput out, boolean[] barray, short featureVersion) throws IOException {
        int size = barray != null ? barray.length : -1;
        out.writeInt(size, featureVersion);
        if (barray != null) {
            for (int i = 0; i < size; ++i) {
                out.writeBoolean(barray[i], featureVersion);
            }
        }
    }

    public static final void writeBooleans(DataOutput out, boolean[] barray) throws IOException {
        int size = barray != null ? barray.length : -1;
        out.writeInt(size);
        if (barray != null) {
            for (int i = 0; i < size; ++i) {
                out.writeBoolean(barray[i]);
            }
        }
    }

    public static final boolean[] readBooleans(DataInput in) throws IOException {
        int size = in.readInt();
        if (size < 0) {
            return null;
        }
        boolean[] barray = new boolean[size];
        for (int i = 0; i < size; ++i) {
            barray[i] = in.readBoolean();
        }
        return barray;
    }

    public static final void writeFloats(DataOutput out, float[] farray) throws IOException {
        int size = farray != null ? farray.length : -1;
        out.writeInt(size);
        for (int i = 0; i < size; ++i) {
            out.writeFloat(farray[i]);
        }
    }

    public static final String[] readStrings(DataInput in) throws IOException {
        int size = in.readInt();
        if (size < 0) {
            return null;
        }
        String[] result = new String[size];
        for (int i = 0; i < size; ++i) {
            result[i] = IOUtil.readString(in);
        }
        return result;
    }

    public static final void writeStrings(DataOutput out, String[] array) throws IOException {
        int size = array != null ? array.length : -1;
        out.writeInt(size);
        if (array != null) {
            for (int i = 0; i < size; ++i) {
                IOUtil.writeString(out, array[i]);
            }
        }
    }

    public static String nameToURL(Applet applet, String name) {
        return IOUtil.nameToURL(applet, null, name);
    }

    public static String nameToURL(String path, String name) {
        return IOUtil.nameToURL(null, path, name);
    }

    public static String nameToURL(Applet applet, String path, String name) {
        String newname = IOUtil.nameToURL2(name);
        if (newname.startsWith("http://") || newname.startsWith("https://") || newname.startsWith("file:/")) {
            return newname;
        }
        if (applet != null) {
            return IOUtil.getCodeBase(applet) + newname;
        }
        return IOUtil.nameToURL2(path + File.separatorChar + name);
    }

    public static boolean isURL(String name) {
        if (name == null) {
            return false;
        }
        return (name = name.replace('\\', '/')).startsWith("http://") || name.startsWith("https://") || name.startsWith("file:/");
    }

    public static String nameToURL2(String name) {
        if (name == null) {
            return null;
        }
        if ((name = name.replace('\\', '/')).startsWith("http://") || name.startsWith("https://") || name.startsWith("file:/")) {
            return name;
        }
        if (name.startsWith("/")) {
            String userdir = System.getProperty("user.dir");
            int idx = userdir.indexOf(58);
            if (idx < 0) {
                return "file://" + name;
            }
            return "file:/" + userdir.substring(0, idx) + "|" + name;
        }
        if (name.length() > 1) {
            String name2 = name.substring(1);
            if (name2.startsWith(":/")) {
                return "file:/" + name;
            }
            if (name.length() > 2 && (name2 = name.substring(2)).startsWith(":/")) {
                return "file:/" + name;
            }
        }
        return name;
    }

    public static String nameToURL3(String name) {
        if (name == null) {
            return null;
        }
        if ((name = name.replace('\\', '/')).startsWith("http://") || name.startsWith("https://") || name.startsWith("file:/")) {
            return name;
        }
        if (name.startsWith("/")) {
            return "file:/" + name;
        }
        if (name.length() > 1) {
            String name2 = name.substring(1);
            if (name2.startsWith(":/")) {
                return "file:/" + name;
            }
            if (name.length() > 2 && (name2 = name.substring(2)).startsWith(":/")) {
                return "file:/" + name;
            }
        }
        return name;
    }

    public static final String getHostName(Applet applet) {
        String hostname;
        try {
            hostname = applet.getCodeBase().getHost();
        }
        catch (Exception ex) {
            try {
                hostname = InetAddress.getLocalHost().getHostName();
            }
            catch (Exception ex2) {
                hostname = "";
            }
        }
        return hostname;
    }

    public static final String getCodeBase(Applet applet) {
        String s;
        try {
            s = applet.getCodeBase() + "";
            if (isUsingEspressOrganizerApplet) {
                int i = s.lastIndexOf("EspressOrganizer");
                if (i < 0) {
                    return s;
                }
                s = s.substring(0, i) + "EspressQuery/";
            }
        }
        catch (Exception ex) {
            return "";
        }
        return s;
    }

    public static final FileInputStream createFileInputStream(String fileName) throws IOException {
        if (isUsingEspressOrganizerApplet) {
            return new FileInputStream(".." + File.separator + "EspressQuery" + File.separator + fileName);
        }
        if (ServerMessage.isServlet()) {
            fileName = ServerMessage.getPath(fileName);
        }
        return new FileInputStream(fileName);
    }

    public static final FileOutputStream createFileOutputStream(String fileName) throws IOException {
        if (ServerMessage.isServlet()) {
            fileName = ServerMessage.getPath(fileName);
        }
        return new FileOutputStream(fileName);
    }

    public static final File createFile(String fileName) {
        if (isUsingEspressOrganizerApplet) {
            return new File(".." + File.separator + "EspressQuery" + File.separator + fileName);
        }
        if (ServerMessage.isServlet()) {
            fileName = ServerMessage.getPath(fileName);
        }
        return new File(fileName);
    }

    public static final void closestream(InputStream stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static final void closestream(OutputStream stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String readLineFromFile(String filename, String defaultstr, Applet applet) {
        FileInputStream instream = null;
        String s = defaultstr;
        try {
            File file = new File(filename);
            String absFilePath = file.getAbsolutePath();
            instream = applet != null ? new URL(IOUtil.getCodeBase(applet) + filename).openStream() : new FileInputStream(absFilePath);
            s = new BufferedReader(new InputStreamReader(instream)).readLine().trim();
            IOUtil.closestream(instream);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            IOUtil.closestream(instream);
        }
        return s;
    }

    public static final boolean writeLineToFile(String filename, String line) {
        DataOutputStream outstream = null;
        try {
            outstream = new DataOutputStream(new FileOutputStream(filename));
            outstream.writeBytes(line + "\n");
        }
        catch (Exception ex) {
            IOUtil.closestream(outstream);
            return false;
        }
        IOUtil.closestream(outstream);
        return true;
    }

    public static final String convertString(byte[] b) {
        int i = b.length;
        char[] value = new char[i];
        while (i-- > 0) {
            value[i] = (char)(b[i] & 0xFF);
        }
        return new String(value);
    }

    public static final byte[] convertByte(String s) {
        int n = s.length();
        byte[] b = new byte[n];
        int i = -1;
        while (++i < n) {
            b[i] = (byte)s.charAt(i);
        }
        return b;
    }

    public static final byte[] encode(byte[] b) {
        return IOUtil.convertByte(Coder.encode(IOUtil.convertString(b)));
    }

    public static final byte[] decode(byte[] b) {
        return IOUtil.convertByte(Coder.decode(IOUtil.convertString(b)));
    }

    public static int[] getImageBuffer(int width, int height, Image image) throws Exception {
        int[] imagebuffer = new int[width * height];
        PixelGrabber grabber = new PixelGrabber(image, 0, 0, width, height, imagebuffer, 0, width);
        if (!grabber.grabPixels()) {
            throw new AWTException("Grabber fail : " + grabber.status());
        }
        return imagebuffer;
    }

    public static final String extractHostName(String filename, Applet applet) {
        int idxS = filename.indexOf("https://", 0);
        if (idxS >= 0) {
            int idx2 = filename.indexOf("/", idxS + 8);
            if (idx2 < 0) {
                return IOUtil.getHostName(applet);
            }
            return filename.substring(idxS + 8, idx2);
        }
        int idx = filename.indexOf("http://", 0);
        if (idx < 0) {
            return IOUtil.getHostName(applet);
        }
        int idx2 = filename.indexOf("/", idx + 7);
        if (idx2 < 0) {
            return IOUtil.getHostName(applet);
        }
        return filename.substring(idx + 7, idx2);
    }

    public static final String extractHostPath(String filename, Applet applet) {
        int idxS = filename.indexOf("https://", 0);
        if (idxS >= 0) {
            int idx2 = filename.indexOf("/", idxS + 8);
            if (idx2 < 0) {
                return IOUtil.getHostName(applet);
            }
            return filename.substring(idx2 + 1);
        }
        int idx = filename.indexOf("http://", 0);
        if (idx < 0) {
            return filename;
        }
        int idx2 = filename.indexOf("/", idx + 7);
        if (idx2 < 0) {
            return IOUtil.getHostName(applet);
        }
        return filename.substring(idx2 + 1);
    }

    public static String getStackTrace(Throwable e) {
        ByteArrayOutputStream bstream = new ByteArrayOutputStream();
        e.printStackTrace(new PrintWriter(bstream, true));
        return bstream.toString();
    }

    public static boolean isJava2D() {
        if (isJava2D != null) {
            return isJava2D;
        }
        try {
            Class<?> objClass = Class.forName("java.awt.Graphics2D");
            if (objClass == null) {
                isJava2D = Boolean.FALSE;
                return isJava2D;
            }
        }
        catch (Exception ex) {
            isJava2D = Boolean.FALSE;
            return isJava2D;
        }
        isJava2D = Boolean.TRUE;
        return isJava2D;
    }

    public static boolean isJava14() {
        if (isJava14 != null) {
            return isJava14;
        }
        try {
            Class<?> objClass = Class.forName("javax.print.PrintService");
            if (objClass == null) {
                isJava14 = Boolean.FALSE;
                return isJava14;
            }
        }
        catch (Exception ex) {
            isJava14 = Boolean.FALSE;
            return isJava14;
        }
        isJava14 = Boolean.TRUE;
        return isJava14;
    }

    public static boolean isMac() {
        if (isMac != null) {
            return isMac;
        }
        String osSystem = System.getProperty("os.name");
        isMac = osSystem.toLowerCase().startsWith("mac");
        return isMac;
    }

    public static boolean isJimiIncluded() {
        if (isJimiIncluded != null) {
            return isJimiIncluded;
        }
        try {
            Class<?> objClass = Class.forName("com.sun.jimi.core.Jimi");
            if (objClass == null) {
                isJimiIncluded = Boolean.FALSE;
                return isJimiIncluded;
            }
        }
        catch (Exception ex) {
            isJimiIncluded = Boolean.FALSE;
            return isJimiIncluded;
        }
        isJimiIncluded = Boolean.TRUE;
        return isJimiIncluded;
    }

    public static boolean checkCPU(int license) {
        if (ServerMessage.isEvalVersion()) {
            return true;
        }
        if (license >= 20) {
            return true;
        }
        String os_name = System.getProperty("os.name");
        QbDebug.println(3, "Operating System Name = " + os_name);
        int noOfCPU = 1;
        try {
            Runtime runtime = Runtime.getRuntime();
            noOfCPU = runtime.availableProcessors();
            QbDebug.println(3, noOfCPU + " CPU");
        }
        catch (Exception e) {
            return true;
        }
        return license >= noOfCPU;
    }

    public static boolean isXMLFormat(String fileName) {
        return fileName.toLowerCase().endsWith(".xml");
    }

    public static boolean isXMLIncluded() {
        if (isXMLIncluded != null) {
            return isXMLIncluded;
        }
        try {
            Class<?> objClass = Class.forName("org.w3c.dom.Node");
            if (objClass == null) {
                isXMLIncluded = Boolean.FALSE;
                return isXMLIncluded;
            }
            objClass = Class.forName("javax.xml.parsers.DocumentBuilder");
            if (objClass == null) {
                isXMLIncluded = Boolean.FALSE;
                return isXMLIncluded;
            }
        }
        catch (Exception ex) {
            isXMLIncluded = Boolean.FALSE;
            return isXMLIncluded;
        }
        isXMLIncluded = Boolean.TRUE;
        return isXMLIncluded;
    }

    public static boolean isChartPackageExisted() {
        boolean temp = false;
        try {
            Class<?> objClass = Class.forName("quadbase.chart.Chart");
            if (objClass != null) {
                temp = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return temp;
    }

    public static Color getRandomColor() {
        if (random == null) {
            random = new Random(System.currentTimeMillis());
        }
        int red = 0;
        int green = 0;
        int blue = 0;
        try {
            red = Math.abs(random.nextInt() % 256);
            green = Math.abs(random.nextInt() % 256);
            blue = Math.abs(random.nextInt() % 256);
            Color color = new Color(red, green, blue);
            return color;
        }
        catch (Exception ex) {
            return Color.green;
        }
    }

    public static final String getErrorString(int code) {
        String scode;
        if (code == 0) {
            return null;
        }
        switch (code) {
            case 1: {
                scode = "Unable to read data from database !";
                break;
            }
            case 2: {
                scode = "Server out of memory.\nPlease go to the Data menu and change the display row and refresh the page.";
                break;
            }
            case 3: {
                scode = "Failed to write the file to disk !";
                break;
            }
            case 4: {
                scode = "Too many users are currently logged onto the server.\n Please try again later.";
                break;
            }
            default: {
                scode = LanguageEncoder.getText("Unknown error code") + " " + code + "!";
            }
        }
        return scode;
    }

    public static String getWorkingDirectory() {
        if (!ServerMessage.useServer && ServerMessage.isLoadBalancer) {
            return System.getProperty("user.dir");
        }
        IConnection socket = null;
        String directory = "";
        try {
            socket = ServerMessage.createConnection();
            ByteArrayOutputStream bstream = new ByteArrayOutputStream(1024);
            DataOutputStream out = new DataOutputStream(bstream);
            out.writeShort(26002);
            byte[] array = bstream.toByteArray();
            socket.setContentLength(array.length);
            socket.getOutputStream().write(array);
            socket.getOutputStream().flush();
            DataInputStream din = new DataInputStream(socket.getInputStream());
            directory = IOUtil.readString(din, true);
            socket.close();
        }
        catch (Exception ex) {
            try {
                if (socket != null) {
                    socket.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return directory;
    }

    public static Component getOffScreenComponent() {
        Component comp = ServerMessage.getComponent();
        if (comp == null) {
            comp = new Frame();
        }
        return comp;
    }

    public static Graphics getOffScreenGraphics() {
        return IOUtil.getOffScreenGraphics(10, 10);
    }

    public static Graphics getOffScreenGraphics(int width, int height) {
        Graphics g = null;
        if (IOUtil.isJava2D()) {
            g = Java2DUtil.getBufferedGraphics(width, height);
        }
        if (g != null) {
            return g;
        }
        try {
            Frame frame = new Frame();
            frame.addNotify();
            Image image = frame.createImage(width, height);
            frame.removeNotify();
            return image.getGraphics();
        }
        catch (Exception exception) {
            return g;
        }
    }

    public static synchronized Image getOffScreenImage(int w, int h) {
        return IOUtil.getOffScreenImage(null, w, h);
    }

    public static synchronized Image getOffScreenImage(Component component, int w, int h) {
        Image image = null;
        if (IOUtil.isJava2D()) {
            image = new BufferedImage(w, h, 1);
        }
        if (image == null && component != null) {
            image = component.createImage(w, h);
        }
        if (image == null) {
            Frame frame = new Frame();
            frame.addNotify();
            image = frame.createImage(w, h);
            frame.removeNotify();
        }
        return image;
    }

    public static void releaseFileLock(String filename) throws Exception {
        if (!ServerMessage.useServer) {
            return;
        }
        ByteArrayOutputStream bstream = new ByteArrayOutputStream(50);
        DataOutputStream dout = new DataOutputStream(bstream);
        dout.writeShort(26000);
        dout.writeBoolean(false);
        IOUtil.writeString(dout, filename);
        IConnection socket = ServerMessage.createConnection();
        try {
            byte[] array = bstream.toByteArray();
            socket.setContentLength(array.length);
            socket.getOutputStream().write(array);
            socket.getOutputStream().flush();
        }
        catch (Exception ex) {
            socket.close();
            throw ex;
        }
        String errmsg = null;
        try {
            DataInputStream dstream = new DataInputStream(socket.getInputStream());
            int code = dstream.readInt();
            if (code != 0) {
                errmsg = LanguageEncoder.getText("Failed to release lock on file '") + filename + "'.";
            }
            dstream.close();
            socket.close();
        }
        catch (Exception ex) {
            try {
                socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw ex;
        }
        if (errmsg != null) {
            throw new Exception(errmsg);
        }
    }

    public static boolean containsUnicode(String str) {
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) < '\u0080') continue;
            return true;
        }
        return false;
    }

    public static String bytesToText(byte[] data) {
        StringBuffer datastr = new StringBuffer();
        for (byte element : data) {
            String bstr = Integer.toHexString(element);
            while (bstr.length() < 2) {
                bstr = "0" + bstr;
            }
            bstr = bstr.substring(bstr.length() - 2);
            datastr.append(bstr);
        }
        return datastr.toString();
    }

    public static byte[] textToBytes(String datastr) {
        Vector<Byte> bytes = new Vector<Byte>();
        datastr = QbUtil.replace(datastr, "\n", "");
        datastr = QbUtil.replace(datastr, "\r", "");
        for (int j = 0; j < datastr.length() - 1; j += 2) {
            int b = Integer.parseInt(datastr.substring(j, j + 2), 16);
            if (b >= 128) {
                b = -(256 - b);
            }
            bytes.addElement((byte)b);
        }
        if (bytes.size() == 0) {
            return null;
        }
        byte[] data = new byte[bytes.size()];
        for (int j = 0; j < bytes.size(); ++j) {
            data[j] = (Byte)bytes.elementAt(j);
        }
        return data;
    }

    public static int getRightMouseClickMask() {
        if (IOUtil.isMac()) {
            if (IOUtil.isJava14()) {
                return 2;
            }
            return 10;
        }
        return 4;
    }

    public static int getMultiObjSelectionMask() {
        if (IOUtil.isMac()) {
            return 4;
        }
        return 2;
    }

    public static String toRelativePath(String filepath) {
        String s = ServerMessage.getWorkingDirectory().replace('\\', '/');
        int index = filepath.indexOf(s);
        if (index >= 0) {
            return filepath.substring(index + s.length() + 1);
        }
        return filepath;
    }

    public static ImageIcon getImageIcon(String iconPath) {
        Image image = IOUtil.getImage(iconPath);
        if (image != null) {
            return new ImageIcon(image);
        }
        return null;
    }

    public static Image getImage(String imgPath) {
        InputStream inputStream;
        if (!imgPath.startsWith("/")) {
            imgPath = "/" + imgPath;
        }
        if (ServerMessage.isServlet() && !LCKey.isERES() && !LCKey.isDashboard()) {
            String path = ServerMessage.getPath(imgPath);
            Pattern pattern = Pattern.compile("^(([a-zA-Z]:[\\\\\\/])|(/))(?:[a-zA-Z0-9])", 2);
            Matcher matcher = pattern.matcher(path);
            boolean isLocalPath = matcher.find();
            if (isLocalPath) {
                path = "file:///" + path;
            }
            URL url = null;
            try {
                url = new URL(path);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            try {
                return ImageIO.read(url);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if ((inputStream = IOUtil.class.getResourceAsStream(imgPath)) == null) {
            System.err.println(imgPath + " image not found.");
            return null;
        }
        try {
            return ImageIO.read(inputStream);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void copyStream(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buf = new byte[1024];
        while ((len = in.read(buf)) > 0) {
            out.write(buf, 0, len);
        }
        in.close();
        out.flush();
        out.close();
    }

    public static byte[] streamToByteArray(InputStream in) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(1024);
        IOUtil.copyStream(in, bos);
        return bos.toByteArray();
    }

    public static boolean isClassAvailable(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

