/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.util.internal;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.Vector;
import quadbase.common.util.internal.CloseUtils;
import quadbase.common.util.internal.ReadDataFile;
import quadbase.internationalization.JavaFile;
import quadbase.internationalization.Product;

public class LanguageEncoder {
    private static Hashtable<String, Hashtable<String, String>> languageTables;
    private static Hashtable<String, String> theTable;
    private static boolean useDefaultLanguage;
    private static final String comment = "#";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void load(String fileName, String enc) throws Exception {
        useDefaultLanguage = false;
        languageTables = new Hashtable();
        if (fileName.endsWith(".xml")) {
            try {
                theTable = new Hashtable();
                LanguageEncoder.load(fileName, enc, new Vector<Product>(), theTable);
                languageTables.put(enc, theTable);
            }
            catch (Exception e) {
                System.err.println("Failed to load language file.");
                e.printStackTrace();
            }
            return;
        }
        FileInputStream fileInputStream = null;
        InputStreamReader inputStream = null;
        BufferedReader reader = null;
        try {
            fileInputStream = new FileInputStream(fileName);
            inputStream = new InputStreamReader((InputStream)fileInputStream, enc);
            reader = new BufferedReader(inputStream);
            Hashtable<String, String> table = new Hashtable<String, String>();
            String code = null;
            String text = null;
            while (true) {
                code = reader.readLine();
                while (code != null && (code.trim().equals("") || code.startsWith(comment))) {
                    code = reader.readLine();
                }
                while (code != null && code.endsWith("\\")) {
                    code = code.substring(0, code.length() - 1) + reader.readLine();
                }
                text = reader.readLine();
                while (text != null && (text.trim().equals("") || text.startsWith(comment))) {
                    text = reader.readLine();
                }
                while (text != null && text.endsWith("\\")) {
                    text = text.substring(0, text.length() - 1) + reader.readLine();
                }
                if (code == null || text == null) break;
                table.put(code, text);
            }
            languageTables.put(enc, table);
            theTable = table;
        }
        catch (Exception exception) {
            CloseUtils.close(fileInputStream);
            CloseUtils.close(inputStream);
            CloseUtils.close(reader);
            catch (Throwable throwable) {
                CloseUtils.close(fileInputStream);
                CloseUtils.close(inputStream);
                CloseUtils.close(reader);
                throw throwable;
            }
        }
        CloseUtils.close(fileInputStream);
        CloseUtils.close(inputStream);
        CloseUtils.close(reader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void loadFromServer(String fileName, String enc) {
        useDefaultLanguage = false;
        languageTables = new Hashtable();
        if (fileName.endsWith(".xml")) {
            try {
                theTable = new Hashtable();
                LanguageEncoder.load(fileName, enc, new Vector<Product>(), theTable);
                languageTables.put(enc, theTable);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return;
        }
        DataInputStream dis = null;
        InputStreamReader inputStream = null;
        BufferedReader reader = null;
        try {
            ReadDataFile rdf = new ReadDataFile();
            dis = rdf.getInputStream(fileName);
            inputStream = new InputStreamReader((InputStream)dis, enc);
            reader = new BufferedReader(inputStream);
            Hashtable<String, String> table = new Hashtable<String, String>();
            String code = null;
            String text = null;
            while (true) {
                code = reader.readLine();
                while (code != null && (code.trim().equals("") || code.startsWith(comment))) {
                    code = reader.readLine();
                }
                while (code != null && code.endsWith("\\")) {
                    code = code.substring(0, code.length() - 1) + reader.readLine();
                }
                text = reader.readLine();
                while (text != null && (text.trim().equals("") || text.startsWith(comment))) {
                    text = reader.readLine();
                }
                while (text != null && text.endsWith("\\")) {
                    text = text.substring(0, text.length() - 1) + reader.readLine();
                }
                if (code == null || text == null) break;
                table.put(code, text);
            }
            languageTables.put(enc, table);
            theTable = table;
        }
        catch (Exception exception) {
            CloseUtils.close(inputStream);
            CloseUtils.close(reader);
            catch (Throwable throwable) {
                CloseUtils.close(inputStream);
                CloseUtils.close(reader);
                throw throwable;
            }
        }
        CloseUtils.close(inputStream);
        CloseUtils.close(reader);
    }

    public static Hashtable<String, String> getTheTable() {
        return theTable;
    }

    public static void setEncoding(String enc) {
        theTable = languageTables.get(enc);
        useDefaultLanguage = false;
    }

    public static String getText(String code) {
        if (useDefaultLanguage) {
            return code;
        }
        String text = theTable.get(code);
        if (text == null) {
            text = theTable.get(code.toUpperCase());
        }
        if (text == null) {
            text = theTable.get(code.toLowerCase());
        }
        if (text == null) {
            text = theTable.get(code.trim());
        }
        if (text != null) {
            return text;
        }
        return code;
    }

    public static void load(String filename, String enc, Vector<Product> products, Hashtable<String, String> translationTable) throws Exception {
        String original = null;
        String translation = null;
        String line = null;
        Product product = null;
        JavaFile file = null;
        ReadDataFile rdf = new ReadDataFile();
        DataInputStream dis = rdf.getInputStream(filename);
        InputStreamReader inputStream = new InputStreamReader((InputStream)dis, enc);
        BufferedReader reader = new BufferedReader(inputStream);
        int mujIndex = 0;
        while ((line = reader.readLine()) != null) {
            int end;
            while ((line.trim() == null || line.trim().equals("") || line.startsWith(comment) || line.trim().startsWith("</")) && (line = reader.readLine()) != null) {
            }
            if (line == null) break;
            if ((line = line.trim()).indexOf("<Product") >= 0) {
                int start = line.indexOf("name=") + 6;
                end = line.indexOf("\"", start);
                String prodName = line.substring(start, end);
                start = line.indexOf("dir=") + 5;
                end = line.indexOf("\"", start);
                String dir = line.substring(start, end);
                product = new Product(prodName, dir);
                products.addElement(product);
                continue;
            }
            if (line.indexOf("<File") >= 0) {
                int start = line.indexOf("name=") + 6;
                String fileName = line.substring(start, end = line.indexOf("\"", start));
                file = fileName.toUpperCase().indexOf("MENUBAR") > 0 ? new JavaFile(fileName, "MENUBAR") : (fileName.toUpperCase().indexOf("TOOLBAR") > 0 ? new JavaFile(fileName, "TOOLBAR") : (fileName.toUpperCase().startsWith("POPUPMENU") ? new JavaFile(fileName, "POPUPMENU") : new JavaFile(fileName, "ALL")));
                product.addFile(file);
                continue;
            }
            try {
                ++mujIndex;
                int start = line.indexOf("<CODE>") + 6;
                end = line.indexOf("</CODE>");
                original = line.substring(start, end);
                line = reader.readLine();
                start = line.indexOf("<TEXT>") + 6;
                end = line.indexOf("</TEXT>");
                translation = line.substring(start, end);
                if (!original.equals(translation)) {
                    translationTable.put(original, translation);
                }
                file.addText(original);
            }
            catch (Exception e) {
                System.out.println(mujIndex + " - " + product + " - " + line);
            }
        }
    }

    static {
        useDefaultLanguage = true;
    }
}

