/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.util.internal;

import quadbase.reportorganizer.data.ChartDataTable;
import quadbase.reportorganizer.data.DashboardDataTable;
import quadbase.reportorganizer.data.MapDataTable;
import quadbase.reportorganizer.data.ReportDataTable;

public class OrgUtil {
    public static String fixDataFileName(String filePath) {
        int idx = (filePath = filePath.replace('/', '\\')).lastIndexOf(92);
        if (idx >= 0) {
            filePath = filePath.substring(idx + 1);
        }
        return filePath;
    }

    public static boolean isChartData(String id) {
        return (id = OrgUtil.fixDataFileName(id)).endsWith(".pac") && id.startsWith("*DB-") || id.endsWith(".qch") && id.startsWith("*DB-");
    }

    public static boolean isDashboardData(String id) {
        return (id = OrgUtil.fixDataFileName(id)).endsWith(".dsb") && id.startsWith("*DB-");
    }

    public static boolean isPackChartData(String id) {
        return ((id = OrgUtil.fixDataFileName(id)).endsWith(".pac") || id.endsWith(".tpl") || id.endsWith(".qch")) && id.startsWith("*DB-");
    }

    public static boolean isPackTPLData(String id) {
        return (id = OrgUtil.fixDataFileName(id)).endsWith(".tpl") && id.startsWith("*DB-");
    }

    public static boolean isDatabasePack(String id) {
        return (id = OrgUtil.fixDataFileName(id)).toLowerCase().endsWith(".pak") && id.toUpperCase().startsWith("*DB-");
    }

    public static boolean isDatabaseFile(String id) {
        id = OrgUtil.fixDataFileName(id);
        return id.toUpperCase().startsWith("*DB-");
    }

    public static boolean isDBPackReportData(String id) {
        return (id = OrgUtil.fixDataFileName(id)).endsWith(".rpt") && id.startsWith("*DB-") || id.endsWith(".pak") && id.indexOf("sub") > 0 && id.startsWith("*DB-") || id.endsWith(".pak") && id.indexOf("lvl") > 0 && id.startsWith("*DB-");
    }

    public static boolean isPackReportData(String id) {
        return (id = OrgUtil.fixDataFileName(id)).endsWith(".pak") && id.indexOf("sub") > 0 || id.endsWith(".pak") && id.indexOf("lvl") > 0 || id.startsWith("*DB-") && id.indexOf("sub") > 0 || id.startsWith("*DB-") && id.indexOf("lvl") > 0;
    }

    public static boolean isReportChartData(String input) {
        String id = OrgUtil.fixDataFileName(input).toLowerCase();
        return id.endsWith(".pak") || id.endsWith(".rpt") || id.endsWith(".qrp") || id.endsWith(".cht") || id.endsWith(".pac") || id.endsWith(".tpl") || id.endsWith(".qch");
    }

    public static boolean isReportData(String id) {
        return (id = OrgUtil.fixDataFileName(id)).endsWith(".pak") && id.startsWith("*DB-") || id.endsWith(".qrp") && id.startsWith("*DB-");
    }

    public static boolean isQRPData(String id) {
        return (id = OrgUtil.fixDataFileName(id)).endsWith(".pak") && id.startsWith("*DB-") || id.endsWith(".rpt") && id.startsWith("*DB-") || id.endsWith(".qrp") && id.startsWith("*DB-");
    }

    public static boolean isQCHData(String id) {
        return (id = OrgUtil.fixDataFileName(id)).endsWith(".pac") && id.startsWith("*DB-") || id.endsWith(".cht") && id.startsWith("*DB-") || id.endsWith(".qch") && id.startsWith("*DB-");
    }

    public static boolean isMapData(String id) {
        return ((id = OrgUtil.fixDataFileName(id)).endsWith(".sxml") || id.endsWith(".gxml") || id.endsWith(".cxml")) && id.startsWith("*DB-");
    }

    public static boolean isCoordinatesData(String id) {
        return (id = OrgUtil.fixDataFileName(id)).endsWith(".cxml") && id.startsWith("*DB-");
    }

    public static boolean isSVGMapData(String filePath) {
        return (filePath = OrgUtil.fixDataFileName(filePath)).endsWith(".sxml") && filePath.startsWith("*DB-");
    }

    public static boolean isGoogleMapData(String filePath) {
        return (filePath = OrgUtil.fixDataFileName(filePath)).endsWith(".gxml") && filePath.startsWith("*DB-");
    }

    public static String createChartDataID(int chartID) {
        return "*DB-" + chartID + ".pac";
    }

    public static String createQCHDataID(int chartID) {
        return "*DB-" + chartID + ".qch";
    }

    public static String createReportDataID(int reportID) {
        return "*DB-" + reportID + ".pak";
    }

    public static String createQRPDataID(int reportID) {
        return "*DB-" + reportID + ".qrp";
    }

    public static String createDashboardDataID(int dashboardID) {
        return "*DB-" + dashboardID + ".dsb";
    }

    public static String createSVGMapDataID(int mapID) {
        return "*DB-" + mapID + ".sxml";
    }

    public static String createGoogleMapDataID(int mapID) {
        return "*DB-" + mapID + ".gxml";
    }

    public static String createCoordinatesDataID(int mapID) {
        return "*DB-" + mapID + ".cxml";
    }

    public static String createTemplateName(String id) {
        id = OrgUtil.fixDataFileName(id);
        return id.substring(0, id.length() - 4);
    }

    public static int getChartDataID(String id) {
        id = OrgUtil.fixDataFileName(id);
        String chartID = id.substring(4, id.length() - 4);
        return Integer.parseInt(chartID);
    }

    public static int getReportDataID(String id) {
        id = OrgUtil.fixDataFileName(id);
        String reportID = id.substring(4, id.length() - 4);
        return Integer.parseInt(reportID);
    }

    public static int getDashboardDataID(String id) {
        id = OrgUtil.fixDataFileName(id);
        String dashID = id.substring(4, id.length() - 4);
        return Integer.parseInt(dashID);
    }

    public static int getMapDataID(String id) {
        id = OrgUtil.fixDataFileName(id);
        String dashID = id.substring(4, id.length() - 5);
        return Integer.parseInt(dashID);
    }

    public static byte[] getReportData(String id) throws Exception {
        return ReportDataTable.getReportData((int)OrgUtil.getReportDataID(id));
    }

    public static byte[] getChartData(String id) throws Exception {
        return ChartDataTable.getChartData((int)OrgUtil.getChartDataID(id));
    }

    public static byte[] getDashboardData(String id) throws Exception {
        return DashboardDataTable.getDashboardData((int)OrgUtil.getDashboardDataID(id));
    }

    public static byte[] getMapData(String id) throws Exception {
        return MapDataTable.getMapData((int)OrgUtil.getMapDataID(id));
    }

    public static void setReportData(String id, byte[] data) throws Exception {
        ReportDataTable.modify((byte[])data, (int)OrgUtil.getReportDataID(id));
    }

    public static void setChartData(String id, byte[] data) throws Exception {
        ChartDataTable.modify((byte[])data, (int)OrgUtil.getChartDataID(id));
    }

    public static void setDashboardData(String id, byte[] data) throws Exception {
        DashboardDataTable.modify((byte[])data, (int)OrgUtil.getDashboardDataID(id));
    }

    public static void setMapData(String id, byte[] data) throws Exception {
        MapDataTable.modify((byte[])data, (int)OrgUtil.getMapDataID(id));
    }
}

