/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.util.internal;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import quadbase.chart.Axis;
import quadbase.chart.CAnnotation;
import quadbase.chart.Chart;
import quadbase.chart.PieChart;
import quadbase.chart.chart2d.MultiDimData2D;
import quadbase.chart.chart2d.types2d.general2d.LineChart2D;
import quadbase.common.util.internal.CloseUtils;
import quadbase.common.util.internal.QbUtil;

public class PatchReader {
    private static boolean debug = false;
    private static boolean init = false;
    private static String patchV1 = "QbPatch_VER01.patch";
    private static String patchV2 = "QbPatch_VER02.patch";
    private static String patchV3 = "QbPatch_VER03.patch";
    private static String patchV4 = "QbPatch_VER04.patch";
    private static String patchV5 = "QbPatch_VER05.patch";
    private static String patchV6 = "QbPatch_VER06.patch";
    private static String patchV7 = "QbPatch_VER07.patch";
    private static String patchV8 = "QbPatch_VER08.patch";
    private static String patchV9 = "QbPatch_VER09.patch";

    public static void readPatch() {
        if (init) {
            return;
        }
        init = true;
        if (debug) {
            System.out.println("TRYING TO READ PATCH...");
        }
        if (PatchReader.readSuccess(patchV1)) {
            if (debug) {
                System.out.println("APPLY PATCH VERSION 1.0");
            }
            Axis.DEFAULTADDAXISPADDING = false;
            QbUtil.usePatch = true;
        }
        if (PatchReader.readSuccess(patchV2)) {
            if (debug) {
                System.out.println("APPLY PATCH VERSION 2.0");
            }
            CAnnotation.setAddLeftMargin();
        }
        if (PatchReader.readSuccess(patchV3)) {
            if (debug) {
                System.out.println("APPLY PATCH VERSION 3.0");
            }
            Axis.DEFAULTAUTOSCALEFORVALLESSTHAN1 = false;
        }
        if (PatchReader.readSuccess(patchV4)) {
            if (debug) {
                System.out.println("APPLY PATCH VERSION 4.0");
            }
            PieChart.DEFAULTNEWLABELPLACEMENT = false;
        }
        if (PatchReader.readSuccess(patchV5)) {
            if (debug) {
                System.out.println("APPLY PATCH VERSION 5.0");
            }
            Axis.DEFAULTUSEINTVALUEFORAUTOSCALE = true;
        }
        if (PatchReader.readSuccess(patchV6)) {
            if (debug) {
                System.out.println("APPLY PATCH VERSION 6.0");
            }
            Chart.ENABLEMINMAXERRORCHECK = false;
        }
        if (PatchReader.readSuccess(patchV7)) {
            if (debug) {
                System.out.println("APPLY PATCH VERSION 7.0");
            }
            Chart.DEFAULTSINGLECOLORFORCATEGORIES = false;
        }
        if (PatchReader.readSuccess(patchV8)) {
            if (debug) {
                System.out.println("APPLY PATCH VERSION 8.0");
            }
            LineChart2D.USE_YAXIS_FOR_SINGLE_POINT_LINECHART = true;
        }
        if (PatchReader.readSuccess(patchV9)) {
            if (debug) {
                System.out.println("APPLY PATCH VERSION 9.0");
            }
            MultiDimData2D.SHOW_STACK_LABEL_REGARDLESS_OF_SIZE = true;
        }
    }

    private static boolean readSuccess(String patchFileName) {
        try {
            InputStream is = PatchReader.class.getResourceAsStream("/" + patchFileName);
            return is != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static void writePatchJar(String jarFileDir) throws IOException {
        PatchReader.writePatch(jarFileDir + "Patch.jar", patchV1, "Patch Version 01:  turn off axis padding by default");
    }

    public static void writePatchJar2(String jarFileDir) throws IOException {
        PatchReader.writePatch(jarFileDir + "Patch2.jar", patchV2, "Patch Version 02:  add left margin for annotation text");
    }

    public static void writePatchJar3(String jarFileDir) throws IOException {
        PatchReader.writePatch(jarFileDir + "Patch3.jar", patchV3, "Patch Version 03:  use 0 to 1 autoscale for axis pt less than 1");
    }

    public static void writePatchJar4(String jarFileDir) throws IOException {
        PatchReader.writePatch(jarFileDir + "Patch4.jar", patchV4, "Patch Version 04:  new pie label placement algorithm");
    }

    public static void writePatchJar5(String jarFileDir) throws IOException {
        PatchReader.writePatch(jarFileDir + "Patch5.jar", patchV5, "Patch Version 05:  always use INT value for auto scale");
    }

    public static void writePatchJar6(String jarFileDir) throws IOException {
        PatchReader.writePatch(jarFileDir + "Patch6.jar", patchV6, "Patch Version 06:  disable MIN MAX error check for axis scale");
    }

    public static void writePatchJar7(String jarFileDir) throws IOException {
        PatchReader.writePatch(jarFileDir + "Patch7.jar", patchV7, "Patch Version 07:  disable Single Color for Categories for Bar and Columnar charts without series by default");
    }

    public static void writePatchJar8(String jarFileDir) throws IOException {
        PatchReader.writePatch(jarFileDir + "Patch8.jar", patchV8, "Patch Version 08:  Line chart end to end revert single point data to display on left axis");
    }

    public static void writePatchJar9(String jarFileDir) throws IOException {
        PatchReader.writePatch(jarFileDir + "Patch9.jar", patchV9, "Patch Version 09:  Display stack label despite not having enough space in the stack to render it");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writePatch(String jarFilePath, String patchName, String description) throws IOException {
        byte[] buffer = description.getBytes();
        FileOutputStream fileOutputStream = null;
        JarOutputStream zipOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(jarFilePath);
            zipOutputStream = new JarOutputStream(fileOutputStream);
            JarEntry zipEntry = new JarEntry(patchName);
            zipOutputStream.putNextEntry(zipEntry);
            zipOutputStream.write(buffer, 0, buffer.length);
        }
        catch (Throwable throwable) {
            CloseUtils.close(zipOutputStream);
            CloseUtils.close(fileOutputStream);
            throw throwable;
        }
        CloseUtils.close(zipOutputStream);
        CloseUtils.close(fileOutputStream);
    }
}

