/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.util.internal;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.hsqldb.DatabaseManager;
import quadbase.common.client.ServerMessage;
import quadbase.common.util.internal.ConnectionPool;
import quadbase.common.util.internal.QbCallableStatement;
import quadbase.common.util.internal.QbPreparedStatement;
import quadbase.common.util.internal.QbStatement;

public class QbConnection
implements Connection {
    private static final Logger LOGGER = Logger.getLogger(QbConnection.class.getName());
    private boolean closed = false;
    private Connection conn;
    private String driver;
    private String url;
    private Properties info;
    static boolean debug = false;
    static boolean debugConnection = false;
    static Vector connInfo = new Vector();
    static ConnectionPool pool = new ConnectionPool();
    static final int RETRY = 1;
    static final long TIME_BETWEEN_RETRY = 1L;
    static int queryTimeout = -1;

    public QbConnection(String databaseDriver, String databaseURL, Properties info) throws ClassNotFoundException, SQLException {
        this.init(databaseDriver, databaseURL, info, false);
    }

    public QbConnection(String databaseDriver, String databaseURL, String databaseUsername, String databasePassword) throws ClassNotFoundException, SQLException {
        Properties prop = new Properties();
        prop.setProperty("user", databaseUsername);
        prop.setProperty("password", databasePassword);
        this.init(databaseDriver, databaseURL, prop, false);
    }

    public void init() throws ClassNotFoundException, SQLException {
        this.init(this.driver, this.url, this.info, true);
    }

    private void init(String databaseDriver, String databaseURL, Properties info, boolean forceAllocate) throws ClassNotFoundException, SQLException {
        this.init(databaseDriver, databaseURL, info, forceAllocate, pool.size(databaseURL, info) + 1);
    }

    private void init(String databaseDriver, String databaseURL, Properties info, boolean forceAllocate, int retry) throws ClassNotFoundException, SQLException {
        block15: {
            String msg = "Connect to DB [" + databaseURL + "] ...";
            this.driver = databaseDriver;
            this.url = ServerMessage.getDatabaseURL(databaseURL);
            this.info = info;
            if (this.url.indexOf("hsql") > -1) {
                this.info.put("ifexists", "true");
            }
            try {
                Class.forName(databaseDriver);
            }
            catch (ClassNotFoundException e) {
                QbConnection.debugc(msg + "FAILED, message: [" + e.getMessage() + "]");
                throw e;
            }
            for (int i = 0; i < 1; ++i) {
                try {
                    this.conn = pool.getConnection(this.url, this.info, forceAllocate);
                    break;
                }
                catch (SQLException e) {
                    QbConnection.debugc(msg + "FAILED, message: [" + e.getMessage() + "]");
                    QbConnection.debugc("---------------------------------------------------------------------------------current open connections are:\n" + QbConnection.getConnInfoStr() + "\n---------------------------------------------------------------------------------");
                    if (i + 1 >= 1) {
                        throw e;
                    }
                    QbConnection.debugc("RETRYING after [1] milliseconds ...");
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    continue;
                }
            }
            QbConnection.debugc(msg + "CONNECTED [" + this.conn + "]");
            if (debugConnection) {
                connInfo.add(new ConnectionInfo(this.conn, "time [" + System.currentTimeMillis() + "]\n" + QbConnection.toStackTrace(new Exception()), databaseURL));
            }
            try {
                this.commit();
                this.setAutoCommit(false);
            }
            catch (SQLException e) {
                if (retry <= 0) break block15;
                this.init(this.driver, this.url, this.info, true, --retry);
            }
        }
        try {
            if (!this.url.contains("hive")) {
                this.conn.setTransactionIsolation(2);
            }
        }
        catch (SQLException e) {
            LOGGER.log(Level.FINE, "Failed to set transaction isolation.", e);
        }
    }

    public static int getQueryTimeout() {
        return queryTimeout;
    }

    public static void setQueryTimeout(int time) {
        queryTimeout = time;
    }

    void setQueryTimeout(Statement stat) {
        try {
            if (queryTimeout > 0 && !this.conn.getMetaData().getDatabaseProductName().toLowerCase().contains("hive")) {
                stat.setQueryTimeout(queryTimeout);
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINEST, "Failed to set query timeout", ex);
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.conn.clearWarnings();
    }

    @Override
    public void close() throws SQLException {
        if (!this.closed) {
            pool.close(this, this.conn);
            this.closed = true;
        }
    }

    public void closeConnection() throws SQLException {
        this.closeConnection(true);
    }

    public void closeConnection(boolean removeFromPool) throws SQLException {
        String msg = "Closing Connection [" + this.conn + "] ... ";
        try {
            if (this.conn.isClosed()) {
                QbConnection.debugc(msg + "ALREADY CLOSED, do nothing");
                return;
            }
            msg = msg + "COMMIT ... ";
            this.commit();
            msg = msg + "OK ... ";
        }
        catch (SQLException ex) {
            msg = msg + "FAILED ... ";
            ex.printStackTrace();
        }
        try {
            msg = msg + "CLOSE ... ";
            this.conn.close();
            if (this.conn.isClosed()) {
                msg = msg + "CLOSED";
                QbConnection.debugc(msg);
                if (removeFromPool) {
                    QbConnection.removeConnInfo(this.conn);
                }
            } else {
                msg = msg + "NOT CLOSED";
                QbConnection.debugc(msg);
            }
        }
        catch (SQLException e) {
            msg = msg + "FAILED TO CLOSE";
            QbConnection.debugc(msg);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() throws SQLException {
        Connection connection = this.conn;
        synchronized (connection) {
            if (!this.getAutoCommit()) {
                this.conn.commit();
            }
            this.setAutoCommit(true);
        }
    }

    @Override
    public Statement createStatement() throws SQLException {
        try {
            return new QbStatement(this.conn.createStatement(), this);
        }
        catch (SQLException e) {
            QbConnection.debugc("possible connection corruption, reconnecting");
            try {
                this.init(this.driver, this.url, this.info, true);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            return new QbStatement(this.conn.createStatement(), this);
        }
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            return new QbStatement(this.conn.createStatement(resultSetType, resultSetConcurrency), this);
        }
        catch (SQLException e) {
            QbConnection.debugc("possible connection corruption, reconnecting");
            try {
                this.init(this.driver, this.url, this.info, true);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            return new QbStatement(this.conn.createStatement(resultSetType, resultSetConcurrency), this);
        }
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        try {
            return new QbStatement(this.conn.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability), this);
        }
        catch (SQLException e) {
            QbConnection.debugc("possible connection corruption, reconnecting");
            try {
                this.init(this.driver, this.url, this.info, true);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            return new QbStatement(this.conn.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability), this);
        }
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return this.conn.getAutoCommit();
    }

    @Override
    public String getCatalog() throws SQLException {
        return this.conn.getCatalog();
    }

    @Override
    public int getHoldability() throws SQLException {
        return this.conn.getHoldability();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        try {
            return this.conn.getMetaData();
        }
        catch (SQLException e) {
            QbConnection.debugc("possible connection corruption, reconnecting");
            try {
                this.init(this.driver, this.url, this.info, true);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            return this.conn.getMetaData();
        }
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return this.conn.getTransactionIsolation();
    }

    public Map getTypeMap() throws SQLException {
        return this.conn.getTypeMap();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.conn.getWarnings();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.conn.isReadOnly();
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        return this.conn.nativeSQL(sql);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        return new QbCallableStatement(this.conn, sql);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return new QbCallableStatement(this.conn, sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return new QbCallableStatement(this.conn, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        if (debug) {
            System.out.println("PRE: " + sql);
        }
        QbPreparedStatement pStat = null;
        try {
            pStat = new QbPreparedStatement(this.conn.prepareStatement(sql), this, sql);
        }
        catch (SQLException e) {
            QbConnection.debugc("possible connection corruption, reconnecting");
            try {
                this.init(this.driver, this.url, this.info, true);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            pStat = new QbPreparedStatement(this.conn.prepareStatement(sql), this, sql);
        }
        this.setQueryTimeout(pStat);
        return pStat;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        QbPreparedStatement pStat = null;
        try {
            pStat = new QbPreparedStatement(this.conn.prepareStatement(sql, autoGeneratedKeys), this, sql);
        }
        catch (SQLException e) {
            QbConnection.debugc("possible connection corruption, reconnecting");
            try {
                this.init(this.driver, this.url, this.info, true);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            pStat = new QbPreparedStatement(this.conn.prepareStatement(sql, autoGeneratedKeys), this, sql);
        }
        this.setQueryTimeout(pStat);
        return pStat;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        QbPreparedStatement pStat = null;
        try {
            pStat = new QbPreparedStatement(this.conn.prepareStatement(sql, columnIndexes), this, sql);
        }
        catch (SQLException e) {
            QbConnection.debugc("possible connection corruption, reconnecting");
            try {
                this.init(this.driver, this.url, this.info, true);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            pStat = new QbPreparedStatement(this.conn.prepareStatement(sql, columnIndexes), this, sql);
        }
        this.setQueryTimeout(pStat);
        return pStat;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        QbPreparedStatement pStat = null;
        try {
            pStat = new QbPreparedStatement(this.conn.prepareStatement(sql, resultSetType, resultSetConcurrency), this, sql);
        }
        catch (SQLException e) {
            QbConnection.debugc("possible connection corruption, reconnecting");
            try {
                this.init(this.driver, this.url, this.info, true);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            pStat = new QbPreparedStatement(this.conn.prepareStatement(sql, resultSetType, resultSetConcurrency), this, sql);
        }
        this.setQueryTimeout(pStat);
        return pStat;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        QbPreparedStatement pStat = null;
        try {
            pStat = new QbPreparedStatement(this.conn.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability), this, sql);
        }
        catch (SQLException e) {
            QbConnection.debugc("possible connection corruption, reconnecting");
            try {
                this.init(this.driver, this.url, this.info, true);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            pStat = new QbPreparedStatement(this.conn.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability), this, sql);
        }
        this.setQueryTimeout(pStat);
        return pStat;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        QbPreparedStatement pStat = null;
        try {
            pStat = new QbPreparedStatement(this.conn.prepareStatement(sql, columnNames), this, sql);
        }
        catch (SQLException e) {
            QbConnection.debugc("possible connection corruption, reconnecting");
            try {
                this.init(this.driver, this.url, this.info, true);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            pStat = new QbPreparedStatement(this.conn.prepareStatement(sql, columnNames), this, sql);
        }
        this.setQueryTimeout(pStat);
        return pStat;
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.conn.releaseSavepoint(savepoint);
    }

    @Override
    public void rollback() throws SQLException {
        this.conn.rollback();
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.conn.rollback(savepoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        String driverName = this.conn.getMetaData().getDriverName();
        if (driverName.toLowerCase().indexOf("informix") >= 0 || driverName.toLowerCase().contains("hive") || driverName.toLowerCase().contains("cassandra")) {
            return;
        }
        Connection connection = this.conn;
        synchronized (connection) {
            this.conn.setAutoCommit(autoCommit);
        }
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.conn.setCatalog(catalog);
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.conn.setHoldability(holdability);
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.conn.setReadOnly(readOnly);
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        return this.conn.setSavepoint();
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        return this.conn.setSavepoint(name);
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.conn.setTransactionIsolation(level);
    }

    public void setTypeMap(Map map) throws SQLException {
        this.conn.setTypeMap(map);
    }

    private static void debugc(String msg) {
        QbConnection.initDEBUG();
        if (debugConnection) {
            System.out.println("DEBUG: " + msg);
        }
    }

    static void initDEBUG() {
        try {
            File debugFile = new File("debug.conf");
            if (debugFile.exists()) {
                debugConnection = true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static String toStackTrace(Exception e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    static void removeConnInfo(Connection c) {
        ConnectionInfo ci = null;
        for (ConnectionInfo info : connInfo) {
            if (info.connection != c) continue;
            ci = info;
            break;
        }
        if (ci != null) {
            connInfo.remove(ci);
        }
    }

    static String getConnInfoStr() {
        StringBuffer buf = new StringBuffer();
        for (ConnectionInfo info : connInfo) {
            try {
                if (info.connection.isClosed()) continue;
                buf.append("open connection[" + info.connection + "], stack trace: \n" + info.stackTrace + "\n##############################################\n");
            }
            catch (SQLException e) {
                System.out.println("exception while checking connection is closed");
                e.printStackTrace();
            }
        }
        return buf.toString();
    }

    static void closeConflictConnections(String url) throws SQLException {
        for (int i = 0; i < connInfo.size(); ++i) {
            ConnectionInfo info = (ConnectionInfo)connInfo.get(i);
            if (info.url == null || !info.url.equals(url)) continue;
            info.connection.close();
            connInfo.remove(info);
            --i;
        }
    }

    public void setBadConnection() {
        pool.setBadConnection(this.conn);
    }

    public void allocateNewConnection() throws ClassNotFoundException, SQLException {
        String msg = "Connect to DB [" + this.url + "] ...";
        try {
            Class.forName(this.driver);
        }
        catch (ClassNotFoundException e) {
            QbConnection.debugc(msg + "FAILED, message: [" + e.getMessage() + "]");
            throw e;
        }
        for (int i = 0; i < 1; ++i) {
            try {
                this.conn = pool.allocateConnection(this.url, this.info, true);
                break;
            }
            catch (SQLException e) {
                QbConnection.debugc(msg + "FAILED, message: [" + e.getMessage() + "]");
                QbConnection.debugc("---------------------------------------------------------------------------------current open connections are:\n" + QbConnection.getConnInfoStr() + "\n---------------------------------------------------------------------------------");
                if (i + 1 >= 1) {
                    throw e;
                }
                QbConnection.debugc("RETRYING after [1] milliseconds ...");
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                continue;
            }
        }
        QbConnection.debugc(msg + "CONNECTED [" + this.conn + "]");
        if (debugConnection) {
            connInfo.add(new ConnectionInfo(this.conn, "time [" + System.currentTimeMillis() + "]\n" + QbConnection.toStackTrace(new Exception()), this.url));
        }
        try {
            this.setAutoCommit(false);
            this.conn.setTransactionIsolation(2);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public boolean checkConnection() {
        try {
            String str = this.conn.getMetaData().getDatabaseProductName().toUpperCase();
            String query = str.contains("MYSQL") ? "SELECT 1" : (str.contains("ORACLE") ? "SELECT 1 FROM USER_CONSTRAINTS WHERE 1=2" : (str.contains("MSSQLSERVER") ? "SELECT 1 FROM sysobjects WHERE 1=2" : (str.contains("MSACCESS") ? "SELECT 1 FROM MSysRelationships WHERE 1=2" : (str.contains("DB2") ? "SELECT 1 FROM sysibm.systables WHERE 1=2" : (str.contains("HSQL") ? "SELECT 1 FROM INFORMATION_SCHEMA.SYSTEM_TABLES WHERE 1=2" : (str.contains("HIVE") || str.contains("SPARK") ? "SHOW TABLES" : "SELECT 1"))))));
            Statement stat = this.conn.createStatement();
            stat.executeQuery(query);
            return true;
        }
        catch (SQLException e) {
            return false;
        }
    }

    public boolean checkDB2Views() {
        try {
            String str = this.conn.getMetaData().getDatabaseProductName().toUpperCase();
            if (str.indexOf("DB2") == -1) {
                return true;
            }
            String query = "SELECT 1 FROM SYSCAT.KEYCOLUSE WHERE 1=2";
            Statement stat = this.conn.createStatement();
            stat.executeQuery(query);
            return true;
        }
        catch (SQLException e) {
            return false;
        }
    }

    public static void destroyConnectionPool() {
        DatabaseManager.getTimer().shutDown();
        Enumeration<Driver> drivers = DriverManager.getDrivers();
        while (drivers.hasMoreElements()) {
            Driver driver = drivers.nextElement();
            try {
                DriverManager.deregisterDriver(driver);
                LOGGER.fine("Deregistering JDBC driver: " + driver);
            }
            catch (SQLException e) {
                LOGGER.log(Level.WARNING, "Error deregistering driver " + driver, e);
            }
        }
        pool.destroy();
    }

    @Override
    public Array createArrayOf(String arg0, Object[] arg1) throws SQLException {
        return this.conn.createArrayOf(arg0, arg1);
    }

    @Override
    public Blob createBlob() throws SQLException {
        return this.conn.createBlob();
    }

    @Override
    public Clob createClob() throws SQLException {
        return this.conn.createClob();
    }

    @Override
    public NClob createNClob() throws SQLException {
        return this.conn.createNClob();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        return this.conn.createSQLXML();
    }

    @Override
    public Struct createStruct(String arg0, Object[] arg1) throws SQLException {
        return this.conn.createStruct(arg0, arg1);
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.conn.setSchema(schema);
    }

    @Override
    public String getSchema() throws SQLException {
        return this.conn.getSchema();
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        this.conn.abort(executor);
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        this.conn.setNetworkTimeout(executor, milliseconds);
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        return this.conn.getNetworkTimeout();
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return this.conn.getClientInfo();
    }

    @Override
    public String getClientInfo(String arg0) throws SQLException {
        return this.conn.getClientInfo(arg0);
    }

    @Override
    public boolean isValid(int arg0) throws SQLException {
        return this.conn.isValid(arg0);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.conn.isWrapperFor(iface);
    }

    @Override
    public void setClientInfo(Properties arg0) throws SQLClientInfoException {
        this.conn.setClientInfo(arg0);
    }

    @Override
    public void setClientInfo(String arg0, String arg1) throws SQLClientInfoException {
        this.conn.setClientInfo(arg0, arg1);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.conn.unwrap(iface);
    }

    class ConnectionInfo {
        Connection connection;
        String stackTrace;
        String url;

        ConnectionInfo(Connection c, String stackTrace, String url) {
            this.connection = c;
            this.stackTrace = stackTrace;
            this.url = url;
        }
    }
}

