/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.util.internal;

import quadbase.common.util.internal.IOUtil;

public class QbDebug {
    public static int currentMode = -1;
    public static final int RESET_DEBUG_MODE = -1;
    public static final int DB_LINKED_SUBREPORT = 0;
    public static final int PRELOAD_CHART = 1;
    public static final int ERES_SCHEDULER_POOL = 2;
    public static final int LICENSE = 3;
    public static final int DVW_SEC_PARAM = 4;
    public static final int REPLACE_SQL_COLUMN = 5;
    public static final int MEMORY_PAGING = 6;
    public static final String[] DBMODE = new String[]{"DB_LINKED_SUBREPORT", "PRELOAD_CHART", "ERES_SCHEDULER_POOL", "LICENSE", "DVW_SEC_PARAM", "REPLACE_SQL_COLUMN", "MEMORY_PAGING"};

    public static final int getDebugMode() {
        return currentMode;
    }

    public static final void setDebugMode(int mode) {
        currentMode = mode;
    }

    public static final void setDebugMode(String mode) {
        for (int i = 0; i < DBMODE.length; ++i) {
            if (!DBMODE[i].equalsIgnoreCase(mode)) continue;
            QbDebug.setDebugMode(i);
            return;
        }
        QbDebug.setDebugMode(-1);
    }

    public static final void print(int mode, String err) {
        if (mode == currentMode) {
            System.out.print(DBMODE[mode] + " : " + err + " " + System.currentTimeMillis());
        }
    }

    public static final void println(int mode, String err) {
        if (mode == currentMode) {
            System.out.println(DBMODE[mode] + " : " + err + " " + System.currentTimeMillis());
        }
    }

    public static final void println(int mode, Throwable err) {
        if (mode == currentMode) {
            System.out.println(DBMODE[mode] + " : " + System.currentTimeMillis() + "\n" + IOUtil.getStackTrace(err));
        }
    }
}

