/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.util.internal;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import quadbase.common.client.ServerMessage;
import quadbase.common.network.IConnection;
import quadbase.common.util.internal.IOUtil;

public class QbFileOutputStream
extends OutputStream {
    private int BUFFER_SIZE = 4096;
    private OutputStream outputStream = null;
    private String filename = null;

    public QbFileOutputStream(String fname) throws IOException {
        this(fname, false);
    }

    public QbFileOutputStream(String fname, boolean append) throws IOException {
        if (fname == null) {
            throw new IllegalArgumentException("Filename cannot be null.");
        }
        if (ServerMessage.useServer || !ServerMessage.isLoadBalancer) {
            this.filename = fname;
            if (this.filename.startsWith("http://") || this.filename.startsWith("https://")) {
                this.filename = IOUtil.extractHostPath(fname, ServerMessage.getApplet());
            }
            ByteArrayOutputStream bstream = new ByteArrayOutputStream(50);
            DataOutputStream dout = new DataOutputStream(bstream);
            dout.writeShort(10001);
            dout.writeBoolean(false);
            IOUtil.writeString(dout, this.filename);
            dout.writeBoolean(append);
            IConnection socket = null;
            try {
                try {
                    socket = ServerMessage.createConnection();
                    byte[] array = bstream.toByteArray();
                    socket.setContentLength(array.length);
                    socket.getOutputStream().write(array);
                    socket.getOutputStream().flush();
                }
                catch (Exception ex) {
                    if (socket != null) {
                        socket.close();
                    }
                    throw new IOException("Failed to connect to server !");
                }
                DataInputStream din = new DataInputStream(socket.getInputStream());
                int errorcode = din.readInt();
                if (errorcode != 0) {
                    throw new IOException(IOUtil.readString(din, true));
                }
                socket.close();
            }
            catch (IOException ex) {
                try {
                    socket.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw ex;
            }
            this.outputStream = new ByteArrayOutputStream(this.BUFFER_SIZE);
        } else {
            if (fname.startsWith("http://") || fname.startsWith("https://")) {
                throw new IOException("Cannot write to HTTP URL :" + fname);
            }
            this.outputStream = new FileOutputStream(ServerMessage.getPath(fname), append);
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.outputStream.write(b);
        if (this.outputStream instanceof ByteArrayOutputStream && ((ByteArrayOutputStream)this.outputStream).size() > this.BUFFER_SIZE) {
            this.flush_internal();
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.outputStream.write(b, off, len);
        if (this.outputStream instanceof ByteArrayOutputStream && ((ByteArrayOutputStream)this.outputStream).size() > this.BUFFER_SIZE) {
            this.flush_internal();
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.outputStream.write(b);
        if (this.outputStream instanceof ByteArrayOutputStream && ((ByteArrayOutputStream)this.outputStream).size() > this.BUFFER_SIZE) {
            this.flush_internal();
        }
    }

    @Override
    public void flush() throws IOException {
        this.outputStream.flush();
        if (this.outputStream instanceof ByteArrayOutputStream && ((ByteArrayOutputStream)this.outputStream).size() > this.BUFFER_SIZE) {
            this.flush_internal();
        }
    }

    private void flush_internal() throws IOException {
        this.outputStream.flush();
        if (this.outputStream instanceof ByteArrayOutputStream) {
            ByteArrayOutputStream bytestream = (ByteArrayOutputStream)this.outputStream;
            if (bytestream.size() > 0) {
                byte[] barray = bytestream.toByteArray();
                ByteArrayOutputStream bstream = new ByteArrayOutputStream(50);
                DataOutputStream dout = new DataOutputStream(bstream);
                dout.writeShort(10002);
                dout.writeBoolean(false);
                IOUtil.writeString(dout, this.filename);
                dout.writeInt(barray.length);
                IConnection socket = null;
                try {
                    try {
                        socket = ServerMessage.createConnection();
                        byte[] array = bstream.toByteArray();
                        socket.setContentLength(array.length + barray.length);
                        socket.getOutputStream().write(array);
                        socket.getOutputStream().write(barray);
                        socket.getOutputStream().flush();
                    }
                    catch (Exception ex) {
                        if (socket != null) {
                            socket.close();
                        }
                        throw new IOException("Failed to connect to server !");
                    }
                    DataInputStream din = new DataInputStream(socket.getInputStream());
                    int errorcode = din.readInt();
                    if (errorcode != 0) {
                        throw new IOException(IOUtil.readString(din, true));
                    }
                    socket.close();
                }
                catch (IOException ex) {
                    try {
                        socket.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw ex;
                }
            }
            bytestream.reset();
        }
    }

    @Override
    public void close() throws IOException {
        this.flush_internal();
        this.outputStream.close();
        if (this.outputStream instanceof ByteArrayOutputStream) {
            ByteArrayOutputStream bstream = new ByteArrayOutputStream(50);
            DataOutputStream dout = new DataOutputStream(bstream);
            dout.writeShort(10003);
            dout.writeBoolean(false);
            IOUtil.writeString(dout, this.filename);
            IConnection socket = null;
            try {
                try {
                    socket = ServerMessage.createConnection();
                    byte[] array = bstream.toByteArray();
                    socket.setContentLength(array.length);
                    socket.getOutputStream().write(array);
                    socket.getOutputStream().flush();
                }
                catch (Exception ex) {
                    if (socket != null) {
                        socket.close();
                    }
                    throw new IOException("Failed to connect to server !");
                }
                DataInputStream din = new DataInputStream(socket.getInputStream());
                int errorcode = din.readInt();
                if (errorcode != 0) {
                    throw new IOException(IOUtil.readString(din, true));
                }
                socket.close();
            }
            catch (IOException ex) {
                try {
                    socket.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw ex;
            }
        }
    }

    public void setBufferSize(int size) {
        this.BUFFER_SIZE = size < 1 ? 1 : size;
    }

    public int getBufferSize() {
        return this.BUFFER_SIZE;
    }
}

