/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.util.internal;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.geom.PathIterator;
import java.awt.image.ImageObserver;
import java.io.DataOutputStream;
import java.net.URL;
import java.text.AttributedCharacterIterator;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.IQbGraphics;

public class QbGraphics
extends Graphics
implements IQbGraphics {
    public static final int OBJECT_WITH_ROUND_CORNERS = 37;
    static final int OTHERS = 0;
    static final int CHART = 1;
    static final int LEGEND = 2;
    static final int TABLE = 3;
    private static final Logger LOGGER = Logger.getLogger(QbGraphics.class.getName());
    final String[] tab = new String[]{"OTHERS", "CHART", "LEGEND", "TABLE"};
    DataOutputStream out;
    int winWidth;
    int winHeight;
    Color foreground;
    Font font = new Font("Helvetica", 0, 12);
    boolean[] update = new boolean[4];
    Vector<String> currentTab;

    public QbGraphics() {
    }

    public QbGraphics(int width, int height, DataOutputStream out, boolean[] update) {
        this.out = out;
        this.update = update;
        this.winWidth = width;
        this.winHeight = height;
        this.currentTab = new Vector();
        this.currentTab.insertElementAt(this.tab[0], 0);
    }

    public QbGraphics(int width, int height, DataOutputStream out) {
        this.out = out;
        this.winWidth = width;
        this.winHeight = height;
        this.currentTab = null;
    }

    private boolean skip() {
        if (this.out == null) {
            return true;
        }
        if (this.currentTab == null) {
            return false;
        }
        if (this.currentTab.elementAt(0).equals(this.tab[1])) {
            return !this.update[1];
        }
        if (this.currentTab.elementAt(0).equals(this.tab[2])) {
            return !this.update[2];
        }
        if (this.currentTab.elementAt(0).equals(this.tab[3])) {
            return !this.update[3];
        }
        return !this.update[0];
    }

    private void writeShape(Shape shape) throws Exception {
        PathIterator it = shape.getPathIterator(null);
        float[] af = new float[6];
        while (!it.isDone()) {
            switch (it.currentSegment(af)) {
                case 4: {
                    this.out.writeInt(4);
                    break;
                }
                case 0: {
                    this.out.writeInt(0);
                    this.out.writeFloat(af[0]);
                    this.out.writeFloat(af[1]);
                    break;
                }
                case 1: {
                    this.out.writeInt(1);
                    this.out.writeFloat(af[0]);
                    this.out.writeFloat(af[1]);
                    break;
                }
                case 2: {
                    this.out.writeInt(2);
                    this.out.writeFloat(af[0]);
                    this.out.writeFloat(af[1]);
                    this.out.writeFloat(af[2]);
                    this.out.writeFloat(af[3]);
                    break;
                }
                case 3: {
                    this.out.writeInt(3);
                    this.out.writeFloat(af[0]);
                    this.out.writeFloat(af[1]);
                    this.out.writeFloat(af[2]);
                    this.out.writeFloat(af[3]);
                    this.out.writeFloat(af[4]);
                    this.out.writeFloat(af[5]);
                }
            }
            it.next();
        }
        this.out.writeInt(-1);
    }

    private void writeShort(int i) throws Exception {
        if (this.out == null) {
            return;
        }
        this.out.writeShort(i);
    }

    private void writeArray(int[] array) {
        try {
            if (array == null) {
                this.out.writeShort(0);
                return;
            }
            this.out.writeShort(array.length);
            for (int element : array) {
                this.out.writeShort(element);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void done() throws Exception {
        this.writeShort(0);
    }

    @Override
    public void setChartTab() {
        if (this.currentTab == null) {
            return;
        }
        this.currentTab.insertElementAt(this.tab[1], 0);
        try {
            this.writeShort(101);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void setTableTab() {
        if (this.currentTab == null) {
            return;
        }
        this.currentTab.insertElementAt(this.tab[3], 0);
        try {
            this.writeShort(102);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void setLegendTab() {
        if (this.currentTab == null) {
            return;
        }
        this.currentTab.insertElementAt(this.tab[2], 0);
        try {
            this.writeShort(103);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void setEndTab() {
        if (this.currentTab == null) {
            return;
        }
        this.currentTab.removeElementAt(0);
        try {
            this.writeShort(-1);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void clearRect(int x, int y, int width, int height) {
        if (this.skip()) {
            return;
        }
        try {
            this.writeShort(1);
            this.out.writeShort(x);
            this.out.writeShort(y);
            this.out.writeShort(width);
            this.out.writeShort(height);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void clipRect(int x, int y, int width, int height) {
        LOGGER.log(Level.FINEST, "clipRect not supported");
    }

    @Override
    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
        LOGGER.log(Level.FINEST, "copyArea not supported");
    }

    @Override
    public Graphics create() {
        LOGGER.log(Level.FINEST, "create not supported");
        return null;
    }

    @Override
    public Graphics create(int x, int y, int width, int height) {
        LOGGER.log(Level.FINEST, "create not supported");
        return null;
    }

    @Override
    public void dispose() {
    }

    @Override
    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        if (this.skip()) {
            return;
        }
        try {
            this.writeShort(2);
            this.out.writeShort(x);
            this.out.writeShort(y);
            this.out.writeShort(width);
            this.out.writeShort(height);
            this.out.writeShort(startAngle);
            this.out.writeShort(arcAngle);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void drawImage(URL url, int option, int x, int y, int width, int height) {
        if (this.skip()) {
            return;
        }
        try {
            this.writeShort(21);
            IOUtil.writeString(this.out, url.toString());
            this.out.writeShort(option);
            this.out.writeShort(x);
            this.out.writeShort(y);
            this.out.writeShort(width);
            this.out.writeShort(height);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void drawImage(byte[] data, int option, int x, int y, int width, int height) {
        if (this.skip()) {
            return;
        }
        try {
            this.writeShort(24);
            this.out.writeInt(data.length);
            this.out.write(data, 0, data.length);
            this.out.writeShort(option);
            this.out.writeShort(x);
            this.out.writeShort(y);
            this.out.writeShort(width);
            this.out.writeShort(height);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void drawLine2D(float x1, float y1, float x2, float y2) {
        if (this.skip()) {
            return;
        }
        try {
            this.writeShort(25);
            this.out.writeFloat(x1);
            this.out.writeFloat(y1);
            this.out.writeFloat(x2);
            this.out.writeFloat(y2);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void drawArc2D(float x, float y, float w, float h, float start, float extent, int type) {
        if (this.skip()) {
            return;
        }
        try {
            this.writeShort(26);
            this.out.writeFloat(x);
            this.out.writeFloat(y);
            this.out.writeFloat(w);
            this.out.writeFloat(h);
            this.out.writeFloat(start);
            this.out.writeFloat(extent);
            this.out.writeInt(type);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void setBasicStroke(float width, int cap, int join, float miterlimit, float[] dash, float dash_phase) {
        if (this.skip()) {
            return;
        }
        try {
            this.writeShort(27);
            this.out.writeFloat(width);
            this.out.writeInt(cap);
            this.out.writeInt(join);
            this.out.writeFloat(miterlimit);
            if (dash != null) {
                this.out.writeBoolean(true);
                this.out.writeInt(dash.length);
                for (float element : dash) {
                    this.out.writeFloat(element);
                }
            } else {
                this.out.writeBoolean(false);
            }
            this.out.writeFloat(dash_phase);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void drawRoundRectangle(float x1, float y1, float x2, float y2, float rx, float ry) {
        if (this.skip()) {
            return;
        }
        try {
            this.writeShort(28);
            this.out.writeFloat(x1);
            this.out.writeFloat(y1);
            this.out.writeFloat(x2);
            this.out.writeFloat(y2);
            this.out.writeFloat(rx);
            this.out.writeFloat(ry);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void fillRoundRectangle(float x, float y, float w, float h, float r, float thickness, boolean drawTop, boolean drawBottom) {
        if (this.skip()) {
            return;
        }
        try {
            this.writeShort(29);
            this.out.writeFloat(x);
            this.out.writeFloat(y);
            this.out.writeFloat(w);
            this.out.writeFloat(h);
            this.out.writeFloat(r);
            this.out.writeFloat(thickness);
            this.out.writeBoolean(drawTop);
            this.out.writeBoolean(drawBottom);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void fillIntersect(Polygon poly, double x, double y, double w) {
        if (this.skip()) {
            return;
        }
        try {
            this.writeShort(32);
            this.writeArray(poly.xpoints);
            this.writeArray(poly.ypoints);
            this.out.writeShort(poly.npoints);
            this.out.writeDouble(x);
            this.out.writeDouble(y);
            this.out.writeDouble(w);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void drawIntersect(Polygon poly, double x, double y, double w, int thickness) {
        if (this.skip()) {
            return;
        }
        try {
            this.writeShort(33);
            this.writeArray(poly.xpoints);
            this.writeArray(poly.ypoints);
            this.out.writeShort(poly.npoints);
            this.out.writeDouble(x);
            this.out.writeDouble(y);
            this.out.writeDouble(w);
            this.out.writeShort(thickness);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void setGradientPaint(int x1, int y1, Color color1, int x2, int y2, Color color2, boolean cyclic) {
        if (this.skip()) {
            return;
        }
        try {
            this.writeShort(34);
            this.out.writeShort(x1);
            this.out.writeShort(y1);
            this.out.writeInt(color1.getRGB());
            this.out.writeShort(x2);
            this.out.writeShort(y2);
            this.out.writeInt(color2.getRGB());
            this.out.writeBoolean(cyclic);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void setTexturePaint(int patternID, Color color) {
        if (this.skip()) {
            return;
        }
        try {
            this.writeShort(35);
            this.out.writeInt(patternID);
            this.out.writeInt(color.getRGB());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void fill(Shape shape) {
        if (this.skip()) {
            return;
        }
        try {
            this.writeShort(36);
            this.writeShape(shape);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void drawCellWithRoundCornersBySegments(float rX, float rY, int roundCornerRadius, boolean[] roundCornersArray, float rW, float rH, Color borderColor, Color bgColor, int gridStyle, boolean drawTop, boolean drawBottom, float[] borderThickness) throws Exception {
        if (this.skip()) {
            return;
        }
        try {
            this.writeShort(37);
            this.out.writeFloat(rX);
            this.out.writeFloat(rY);
            this.out.writeInt(roundCornerRadius);
            IOUtil.writeBooleans(this.out, roundCornersArray);
            this.out.writeFloat(rW);
            this.out.writeFloat(rH);
            this.out.writeInt(borderColor != null ? borderColor.getRGB() : 0);
            this.out.writeInt(bgColor != null ? bgColor.getRGB() : 0);
            this.out.writeInt(gridStyle);
            IOUtil.writeInts(this.out, new int[]{Math.round(borderThickness[0]), Math.round(borderThickness[1]), Math.round(borderThickness[2]), Math.round(borderThickness[3])}, borderThickness.length);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public boolean drawImage(Image img, int x, int y, Color bgcolor, ImageObserver observer) {
        return this.drawImage(img, x, y, img.getWidth(observer), img.getHeight(observer), bgcolor, observer);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, ImageObserver observer) {
        return this.drawImage(img, x, y, img.getWidth(observer), img.getHeight(observer), observer);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, int width, int height, Color bgcolor, ImageObserver observer) {
        return this.drawImage(img, x, y, x + width, y + height, 0, 0, img.getWidth(observer), img.getHeight(observer), bgcolor, observer);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, int width, int height, ImageObserver observer) {
        return this.drawImage(img, x, y, x + width, y + height, 0, 0, img.getWidth(observer), img.getHeight(observer), observer);
    }

    @Override
    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgcolor, ImageObserver observer) {
        return true;
    }

    @Override
    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
        return true;
    }

    @Override
    public void setCompositeSrcOver(float alpha) {
        if (this.skip()) {
            return;
        }
        try {
            this.writeShort(22);
            this.out.writeFloat(alpha);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void setOriginalComposite() {
        if (this.skip()) {
            return;
        }
        try {
            this.writeShort(23);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void drawLine(int x1, int y1, int x2, int y2) {
        if (this.skip()) {
            return;
        }
        try {
            this.writeShort(3);
            this.out.writeShort(x1);
            this.out.writeShort(y1);
            this.out.writeShort(x2);
            this.out.writeShort(y2);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void drawOval(int x, int y, int width, int height) {
        if (this.skip()) {
            return;
        }
        try {
            this.writeShort(4);
            this.out.writeShort(x);
            this.out.writeShort(y);
            this.out.writeShort(width);
            this.out.writeShort(height);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        if (this.skip()) {
            return;
        }
        try {
            this.writeShort(5);
            this.writeArray(xPoints);
            this.writeArray(yPoints);
            this.out.writeShort(nPoints);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void drawPolyline(int[] xPoints, int[] yPoints, int nPoints) {
        if (this.skip()) {
            return;
        }
        try {
            this.writeShort(6);
            this.writeArray(xPoints);
            this.writeArray(yPoints);
            this.out.writeShort(nPoints);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void drawRect(int x, int y, int width, int height) {
        if (this.skip()) {
            return;
        }
        try {
            this.writeShort(7);
            this.out.writeShort(x);
            this.out.writeShort(y);
            this.out.writeShort(width);
            this.out.writeShort(height);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void draw3DRect(int x, int y, int width, int height, boolean raised) {
        if (this.skip()) {
            return;
        }
        try {
            this.writeShort(18);
            this.out.writeShort(x);
            this.out.writeShort(y);
            this.out.writeShort(width);
            this.out.writeShort(height);
            this.out.writeBoolean(raised);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        if (this.skip()) {
            return;
        }
        try {
            this.writeShort(8);
            this.out.writeShort(x);
            this.out.writeShort(y);
            this.out.writeShort(width);
            this.out.writeShort(height);
            this.out.writeShort(arcWidth);
            this.out.writeShort(arcHeight);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void drawString(String str, int x, int y) {
        if (this.skip()) {
            return;
        }
        try {
            this.writeShort(9);
            IOUtil.writeString(this.out, str);
            this.out.writeShort(x);
            this.out.writeShort(y);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void drawString(String str, int x, int w, short align, int y, boolean drawUnderline) {
        if (this.skip()) {
            return;
        }
        try {
            this.writeShort(30);
            IOUtil.writeString(this.out, str);
            this.out.writeShort(x);
            this.out.writeShort(w);
            this.out.writeShort(align);
            this.out.writeShort(y);
            this.out.writeBoolean(drawUnderline);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void drawSegment(Object[] res, int x, int y) {
        if (this.skip()) {
            return;
        }
        try {
            this.writeShort(31);
            this.out.writeShort(res.length);
            for (Object re : res) {
                Object[] seg = (Object[])re;
                if (seg.length == 4) {
                    this.out.writeShort(0);
                    IOUtil.writeString(this.out, (String)seg[0]);
                    this.font = (Font)seg[1];
                    IOUtil.writeString(this.out, this.font.getName());
                    this.out.writeShort(this.font.getStyle());
                    this.out.writeShort(this.font.getSize());
                    this.foreground = (Color)seg[2];
                    this.out.writeInt(this.foreground.getRGB());
                    this.out.writeBoolean((Boolean)seg[3]);
                    continue;
                }
                this.out.writeShort(1);
                byte[] data = (byte[])seg[0];
                if (data != null) {
                    this.out.writeInt(data.length);
                    this.out.write(data, 0, data.length);
                } else {
                    this.out.writeInt(-1);
                }
                this.out.writeShort((Integer)seg[1]);
                this.out.writeShort((Integer)seg[2]);
            }
            this.out.writeShort(x);
            this.out.writeShort(y);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void drawRotateString(String str, Font font, boolean isJ2DRotateText, Color color, float angle, int x, int y) {
        if (this.skip()) {
            return;
        }
        try {
            this.writeShort(20);
            IOUtil.writeString(this.out, str);
            IOUtil.writeString(this.out, font.getName());
            this.out.writeShort(font.getStyle());
            this.out.writeShort(font.getSize());
            this.out.writeBoolean(isJ2DRotateText);
            this.out.writeInt(color.getRGB());
            this.out.writeFloat(angle);
            this.out.writeShort(x);
            this.out.writeShort(y);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void drawRotateString2(String text, Font font, Color color, int x, int y, int w, int h, short align, short valign, boolean isUnderline, double rotation, int length, int index) {
        try {
            this.writeShort(40);
            IOUtil.writeString(this.out, text);
            IOUtil.writeString(this.out, font.getName());
            this.out.writeShort(font.getStyle());
            this.out.writeShort(font.getSize());
            this.out.writeInt(color.getRGB());
            this.out.writeShort(x);
            this.out.writeShort(y);
            this.out.writeInt(w);
            this.out.writeInt(h);
            this.out.writeShort(align);
            this.out.writeShort(valign);
            this.out.writeBoolean(isUnderline);
            this.out.writeDouble(rotation);
            this.out.writeInt(length);
            this.out.writeInt(index);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void drawString(AttributedCharacterIterator text, int x, int y) {
        LOGGER.log(Level.FINEST, "drawString(java.text.AttributedCharacterIterator,..) not supported");
    }

    @Override
    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        if (this.skip()) {
            return;
        }
        try {
            this.writeShort(10);
            this.out.writeShort(x);
            this.out.writeShort(y);
            this.out.writeShort(width);
            this.out.writeShort(height);
            this.out.writeShort(startAngle);
            this.out.writeShort(arcAngle);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void fillOval(int x, int y, int width, int height) {
        if (this.skip()) {
            return;
        }
        try {
            this.writeShort(11);
            this.out.writeShort(x);
            this.out.writeShort(y);
            this.out.writeShort(width);
            this.out.writeShort(height);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        if (this.skip()) {
            return;
        }
        try {
            this.writeShort(12);
            this.writeArray(xPoints);
            this.writeArray(yPoints);
            this.out.writeShort(nPoints);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void fillRect(int x, int y, int width, int height) {
        if (this.skip()) {
            return;
        }
        try {
            this.writeShort(13);
            this.out.writeShort(x);
            this.out.writeShort(y);
            this.out.writeShort(width);
            this.out.writeShort(height);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void fill3DRect(int x, int y, int width, int height, boolean raised) {
        if (this.skip()) {
            return;
        }
        try {
            this.writeShort(19);
            this.out.writeShort(x);
            this.out.writeShort(y);
            this.out.writeShort(width);
            this.out.writeShort(height);
            this.out.writeBoolean(raised);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        if (this.skip()) {
            return;
        }
        try {
            this.writeShort(14);
            this.out.writeShort(x);
            this.out.writeShort(y);
            this.out.writeShort(width);
            this.out.writeShort(height);
            this.out.writeShort(arcWidth);
            this.out.writeShort(arcHeight);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public Shape getClip() {
        return null;
    }

    @Override
    public void setClip(Shape clip) {
        try {
            this.writeShort(39);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public Rectangle getClipRect() {
        LOGGER.log(Level.FINEST, "getClipRect not supported");
        return null;
    }

    @Override
    public Rectangle getClipBounds() {
        LOGGER.log(Level.FINEST, "getClipBounds not supported");
        return null;
    }

    @Override
    public Color getColor() {
        return this.foreground;
    }

    @Override
    public void setColor(Color newcolor) {
        this.foreground = newcolor;
        if (this.skip()) {
            return;
        }
        try {
            this.writeShort(15);
            this.out.writeInt(newcolor.getRGB());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public Font getFont() {
        return this.font;
    }

    @Override
    public void setFont(Font newfont) {
        this.font = newfont;
        if (this.skip()) {
            return;
        }
        try {
            this.writeShort(16);
            IOUtil.writeString(this.out, newfont.getName());
            this.out.writeShort(newfont.getStyle());
            this.out.writeShort(newfont.getSize());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public FontMetrics getFontMetrics(Font f) {
        return Toolkit.getDefaultToolkit().getFontMetrics(f);
    }

    @Override
    public void setClip(int x, int y, int width, int height) {
        try {
            this.writeShort(38);
            this.out.writeInt(x);
            this.out.writeInt(y);
            this.out.writeInt(width);
            this.out.writeInt(height);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setPaintMode() {
        LOGGER.log(Level.FINEST, "setPaintMode not supported");
    }

    @Override
    public void setXORMode(Color c1) {
        LOGGER.log(Level.FINEST, "setXORMode not supported");
    }

    @Override
    public void translate(int x, int y) {
        if (this.skip()) {
            return;
        }
        try {
            this.writeShort(17);
            this.out.writeShort(x);
            this.out.writeShort(y);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

