/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.util.internal;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import quadbase.common.util.internal.QbConnection;

public class QbStatement
implements Statement {
    private Statement stat;
    private QbConnection qbc;

    public QbStatement(Statement stat, QbConnection qbc) {
        this.stat = stat;
        this.qbc = qbc;
        qbc.setQueryTimeout(stat);
    }

    public Statement getStatement() {
        return this.stat;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.stat.addBatch(sql);
    }

    @Override
    public void cancel() throws SQLException {
        this.stat.cancel();
    }

    @Override
    public void clearBatch() throws SQLException {
        this.stat.clearBatch();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.stat.clearWarnings();
    }

    @Override
    public void close() throws SQLException {
        this.stat.close();
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        this.debug("QBS execute: " + sql);
        try {
            return this.stat.execute(sql);
        }
        catch (SQLException e) {
            this.debug("possible connection corruption, reconnecting");
            if (this.qbc.checkConnection()) {
                throw e;
            }
            try {
                try {
                    this.debug("Connection Error with execute... Allocating new connection");
                    this.qbc.setBadConnection();
                    this.qbc.allocateNewConnection();
                }
                catch (SQLException e_badConn) {
                    this.qbc.setBadConnection();
                    throw e_badConn;
                }
                catch (ClassNotFoundException ce) {
                    this.qbc.setBadConnection();
                }
                this.debug("recreating statement...");
                QbStatement qbt = (QbStatement)this.qbc.createStatement();
                if (qbt == null) {
                    throw e;
                }
                this.stat = qbt.getStatement();
                return this.stat.execute(sql);
            }
            catch (SQLException e1) {
                DatabaseMetaData dbMeta = this.qbc.getMetaData();
                String product = dbMeta.getDatabaseProductName();
                if (product.toLowerCase().indexOf("postgresql") > -1) {
                    this.qbc.rollback();
                }
                throw e1;
            }
        }
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        return this.stat.execute(sql, autoGeneratedKeys);
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        return this.stat.execute(sql, columnIndexes);
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        return this.stat.execute(sql, columnNames);
    }

    @Override
    public int[] executeBatch() throws SQLException {
        return this.stat.executeBatch();
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        this.debug("QBS executeQuery: " + sql);
        try {
            return this.stat.executeQuery(sql);
        }
        catch (SQLException e) {
            this.debug("possible connection corruption, reconnecting");
            if (this.qbc.checkConnection()) {
                throw e;
            }
            try {
                try {
                    this.debug("Connection Error in executeQuery... Allocating new connection");
                    this.qbc.setBadConnection();
                    this.qbc.allocateNewConnection();
                }
                catch (SQLException e_badConn) {
                    this.qbc.setBadConnection();
                    throw e_badConn;
                }
                catch (ClassNotFoundException ce) {
                    this.qbc.setBadConnection();
                }
                this.debug("recreating statement...");
                QbStatement qbt = (QbStatement)this.qbc.createStatement();
                if (qbt == null) {
                    throw e;
                }
                this.stat = qbt.getStatement();
                return this.stat.executeQuery(sql);
            }
            catch (SQLException e1) {
                DatabaseMetaData dbMeta = this.qbc.getMetaData();
                String product = dbMeta.getDatabaseProductName();
                if (product.toLowerCase().indexOf("postgresql") > -1) {
                    this.qbc.rollback();
                }
                throw e1;
            }
        }
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        return this.stat.executeUpdate(sql);
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return this.stat.executeUpdate(sql, autoGeneratedKeys);
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return this.stat.executeUpdate(sql, columnIndexes);
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        return this.stat.executeUpdate(sql, columnNames);
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.stat.getConnection();
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this.stat.getFetchDirection();
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.stat.getFetchSize();
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        return this.stat.getGeneratedKeys();
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return this.stat.getMaxFieldSize();
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this.stat.getMaxRows();
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return this.stat.getMoreResults();
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        return this.stat.getMoreResults(current);
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return this.stat.getQueryTimeout();
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return this.stat.getResultSet();
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return this.stat.getResultSetConcurrency();
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return this.stat.getResultSetHoldability();
    }

    @Override
    public int getResultSetType() throws SQLException {
        return this.stat.getResultSetType();
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return this.stat.getUpdateCount();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.stat.getWarnings();
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        this.stat.setCursorName(name);
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.stat.setEscapeProcessing(enable);
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.stat.setFetchDirection(direction);
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.stat.setFetchSize(rows);
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.stat.setMaxFieldSize(max);
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.stat.setMaxRows(max);
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.stat.setQueryTimeout(seconds);
    }

    void debug(String m) {
        if (QbConnection.debug) {
            System.out.println(m);
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.stat.isClosed();
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return this.stat.isPoolable();
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this.stat.closeOnCompletion();
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return this.stat.isCloseOnCompletion();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.stat.isWrapperFor(iface);
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        this.stat.setPoolable(poolable);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.stat.unwrap(iface);
    }
}

