/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.util.internal;

import java.applet.Applet;
import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.MalformedURLException;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jnlp.BasicService;
import javax.servlet.http.HttpServletRequest;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import quadbase.chart.ColData;
import quadbase.chart.WriteDataFile;
import quadbase.common.client.ReadDatabase;
import quadbase.common.client.ServerMessage;
import quadbase.common.pak.PakFile;
import quadbase.common.util.internal.CloseUtils;
import quadbase.common.util.internal.Coder;
import quadbase.common.util.internal.HttpsIO;
import quadbase.common.util.internal.IDataSet;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.LCKey;
import quadbase.common.util.internal.StartBrowser;
import quadbase.reportorganizer.data.OrganizerDataImpl;

public class QbUtil {
    private static final Logger LOGGER = Logger.getLogger(QbUtil.class.getName());
    public static int pixelPerInch = -1;
    public static int pixelPerInchExport = -1;
    private static int pixelPerCm = (int)((double)QbUtil.toPixel(1.0) / 2.54);
    private static int cmUnit = (int)((double)pixelPerCm * 0.25);
    private static float POINTS_PER_INCH = 72.0f;
    public static boolean usePatch = false;
    private static int nextNumber = -1;
    public static String[] invalidChar = new String[]{"*", "?", "\"", "<", ">", "|"};
    public static String invalidCharSet = "* ? < > |";
    public static final char[] NON_PARAMETER_DELIMITERS = new char[]{'#', '\"', '\''};
    public static final char[] PARAMETER_DELIMITERS = new char[]{')', ' ', '\n'};

    public static boolean containInvalidChar(String str) {
        for (String element : invalidChar) {
            if (str.indexOf(element) < 0) continue;
            return true;
        }
        return false;
    }

    public static int countOccurences(String where, String what) {
        if (where == null || what == null) {
            return -1;
        }
        if (where.length() == 0 || what.length() == 0) {
            return -1;
        }
        return (where.length() - where.replace(what, "").length()) / what.length();
    }

    public static String removeExtension(String str) {
        String[] ext;
        for (String element : ext = new String[]{".html", ".cht", ".rpt", ".tpl", ".xml", ".rtf", ".svg", ".png", ".jpg", ".jpeg", ".gif", ".pdf", ".csv", ".txt", ".xls", ".view", ".swf", ".wmf"}) {
            if (!str.toLowerCase().endsWith(element)) continue;
            return str.substring(0, str.length() - element.length());
        }
        return str;
    }

    public static File urlToFile(URL url) {
        String filename = url.getFile();
        StringBuffer sb = new StringBuffer(128);
        int i = 0;
        if (filename.length() > 3 && filename.charAt(0) == '/' && filename.charAt(2) == '|') {
            sb.append(filename.charAt(1));
            sb.append(':');
            i = 3;
        }
        String slashReplacement = System.getProperty("file.separator");
        while (i < filename.length()) {
            if (filename.charAt(i) == '/' && filename.charAt(i) == '\\') {
                sb.append(slashReplacement);
            } else {
                sb.append(filename.charAt(i));
            }
            ++i;
        }
        return new File(sb.toString());
    }

    public static final void add(Container x, Component c, GridBagLayout gbl, GridBagConstraints gbc, int gx, int gy, int w, int h) {
        gbc.gridx = gx;
        gbc.gridy = gy;
        gbc.gridwidth = w;
        gbc.gridheight = h;
        gbl.setConstraints(c, gbc);
        x.add(c);
    }

    public static Panel makeButtonPanel(String buttonNames, int alignment) {
        Panel buttonPanel = new Panel();
        buttonPanel.setLayout(new FlowLayout(alignment));
        StringTokenizer st = new StringTokenizer(buttonNames, ",");
        while (st.hasMoreTokens()) {
            buttonPanel.add(new Button(st.nextToken()));
        }
        return buttonPanel;
    }

    public static String escapeSqlString(String s) {
        if (s.indexOf(39) == -1) {
            return s;
        }
        StringBuffer sb = new StringBuffer(s.length() + 10);
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\'') {
                sb.append("''");
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static Panel labelComponent(String label, Component component) {
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout(0, 5, 2));
        panel.add(new Label(label));
        panel.add(component);
        return panel;
    }

    public static String convertToHTMLFileName(String str) {
        if (str == null) {
            return null;
        }
        if (!str.toLowerCase().startsWith("file:/") && str.indexOf("://") == -1) {
            str = QbUtil.encodeURIComponent(str);
            return str.replaceAll("%2C", ",");
        }
        return QbUtil.fixUrlString(str);
    }

    public static String escapeHTML(String str) {
        if (str == null) {
            return null;
        }
        str = str.replaceAll("<br>", "##BBB#RRR###");
        str = str.replaceAll("<br/>", "##BBB#RRR###");
        str = str.replaceAll("&", "&amp;");
        str = str.replaceAll("<", "&lt;");
        str = str.replaceAll(">", "&gt;");
        str = str.replaceAll("\"", "&quot;");
        str = str.replaceAll("##BBB#RRR###", "<br>");
        str = str.replaceAll("##BBB#RRR###", "<br/>");
        str = str.replaceAll("\n", "<br>");
        str = str.replaceAll("'", "&#39;");
        return str;
    }

    public static String RevertEscapeHTML(String str) {
        if (str == null) {
            return null;
        }
        str = str.replaceAll("&amp;", "&");
        str = str.replaceAll("&lt;", "<");
        str = str.replaceAll("&gt;", ">");
        str = str.replaceAll("&quot;", "\"");
        str = str.replaceAll("<br>", "\n");
        str = str.replaceAll("&#39;", "'");
        return str;
    }

    public static String escapeHTMLIfNecessary(String str) {
        if (!QbUtil.isEscapedHTML(str)) {
            return QbUtil.escapeHTML(str);
        }
        return str;
    }

    public static boolean isEscapedHTML(String str) {
        if (str == null) {
            return false;
        }
        return str.matches(".*(&amp;|&lt;|&gt;|&quot;).*");
    }

    public static String escapeFormulaText(String str) {
        if (str == null) {
            return null;
        }
        str = str.replaceAll("\\\\", "\\\\\\\\");
        str = str.replaceAll("\"", "\\\\\"");
        str = str.replaceAll("\n", "\\\\n");
        return str;
    }

    public static String replace(String sOriginal, String sReplace, String sNew) {
        int nIndex = 0;
        String sReturn = new String();
        if (sOriginal != null) {
            sReturn = sOriginal;
            nIndex = sOriginal.indexOf(sReplace);
            while (nIndex != -1) {
                sReturn = sReturn.substring(0, nIndex) + sNew + sReturn.substring(nIndex + sReplace.length(), sReturn.length());
                nIndex = sReturn.indexOf(sReplace, nIndex + sNew.length());
            }
        } else {
            sReturn = "";
        }
        return sReturn;
    }

    public static String replaceUnicode(String sOriginal) {
        int nIndex = 0;
        int endIndex = 0;
        StringBuffer sb = new StringBuffer();
        if (sOriginal != null) {
            nIndex = sOriginal.indexOf("\\u");
            while (nIndex != -1) {
                sb.append(sOriginal.substring(endIndex, nIndex));
                String unicode = sOriginal.substring(nIndex + 2, nIndex + 6);
                char c = (char)Integer.parseInt(unicode, 16);
                sb.append(Character.valueOf(c).toString());
                endIndex = nIndex + 6;
                nIndex = sOriginal.indexOf("\\u", nIndex + 6);
            }
            if (endIndex < sOriginal.length()) {
                sb.append(sOriginal.substring(endIndex));
            }
        }
        return sb.toString();
    }

    public static Font getDefaultFont(Font oldFont, Font newFont) {
        if (usePatch) {
            return oldFont;
        }
        return newFont;
    }

    public static void setPixelPerInchForExport(int ppi) {
        pixelPerInchExport = ppi;
        pixelPerInch = ppi;
        pixelPerCm = (int)((double)QbUtil.toPixel(1.0) / 2.54);
        cmUnit = (int)((double)pixelPerCm * 0.25);
    }

    public static int getPixelPerInch() {
        if (pixelPerInchExport > 0) {
            return pixelPerInchExport;
        }
        if (pixelPerInch <= 0) {
            try {
                pixelPerInch = Toolkit.getDefaultToolkit().getScreenResolution();
            }
            catch (Exception ex) {
                pixelPerInch = 75;
            }
        }
        return pixelPerInch;
    }

    public static int getPixelPerInch_export() {
        if (pixelPerInchExport > 0) {
            return pixelPerInchExport;
        }
        return QbUtil.getPixelPerInch();
    }

    public static int toPixel(double inch) {
        return (int)Math.rint((double)QbUtil.getPixelPerInch() * inch);
    }

    public static int toPixelCeil(double inch) {
        return (int)Math.ceil((double)QbUtil.getPixelPerInch() * inch);
    }

    public static int toPixel_export(double inch) {
        return (int)Math.rint((double)QbUtil.getPixelPerInch_export() * inch);
    }

    public static double toInch(double pixel) {
        return pixel / (double)QbUtil.getPixelPerInch();
    }

    public static double toInch_export(double pixel) {
        return pixel / (double)QbUtil.getPixelPerInch_export();
    }

    public static float toPoints(double inch) {
        return (float)inch * POINTS_PER_INCH;
    }

    public static double pointsToInch(float points) {
        return (double)points / (double)POINTS_PER_INCH;
    }

    public static float pixelToPoints(int pixel) {
        return QbUtil.toPoints(QbUtil.toInch_export(pixel));
    }

    public static int resizeViewerFont(int size, boolean isViewerAdjustFont) {
        if (usePatch) {
            return size;
        }
        if (isViewerAdjustFont) {
            return (int)Math.ceil((double)(size * QbUtil.getPixelPerInch_export()) / 72.0);
        }
        return size;
    }

    public static int resizeViewerFontRTF(int size, boolean isViewerAdjustFont) {
        if (usePatch) {
            return size;
        }
        if (isViewerAdjustFont) {
            return (int)Math.rint((double)(size * QbUtil.getPixelPerInch_export()) / 72.0);
        }
        return size;
    }

    public static int getAdjustedFont(int size, boolean isViewerAdjustFont) {
        if (usePatch) {
            return size;
        }
        if (isViewerAdjustFont) {
            return (int)Math.rint((double)size * 72.0 / (double)QbUtil.getPixelPerInch_export());
        }
        return size;
    }

    public static int resizeExportFont(int size, boolean isViewerAdjustFont) {
        if (usePatch) {
            return size;
        }
        if (isViewerAdjustFont) {
            return size;
        }
        return (int)Math.floor((double)size * 72.0 / (double)QbUtil.getPixelPerInch());
    }

    public static Font resizeViewerFont(Font font, boolean adjust) {
        if (usePatch) {
            return font;
        }
        if (!adjust) {
            return font;
        }
        return new Font(font.getName(), font.getStyle(), QbUtil.resizeViewerFont(font.getSize(), adjust));
    }

    public static FontMetrics getViewerFontMetrics(FontMetrics fm, boolean isAdjustFont) {
        if (usePatch) {
            return fm;
        }
        if (!isAdjustFont) {
            return fm;
        }
        return IOUtil.getOffScreenGraphics().getFontMetrics(QbUtil.resizeViewerFont(fm.getFont(), isAdjustFont));
    }

    public static Object[] toArray(Vector vec) {
        Object[] tmp = new Object[vec.size()];
        for (int i = 0; i < tmp.length; ++i) {
            tmp[i] = vec.elementAt(i);
        }
        return tmp;
    }

    public static Object[] toArray(IDataSet vec) {
        Object[] tmp = new Object[vec.size()];
        for (int i = 0; i < tmp.length; ++i) {
            tmp[i] = vec.elementAt(i);
        }
        return tmp;
    }

    public static void addArrayToVector(Vector vec, Object[] array) {
        if (vec == null) {
            vec = new Vector<Object>();
        }
        if (array == null) {
            return;
        }
        for (Object element : array) {
            vec.addElement(element);
        }
    }

    public static String arrayToString(Object[] array, String separator) {
        if (array == null || array.length == 0) {
            return "";
        }
        StringBuffer buf = new StringBuffer(String.valueOf(array[0]));
        for (int i = 1; i < array.length; ++i) {
            buf.append(separator);
            buf.append(array[i]);
        }
        return buf.toString();
    }

    public static String collectionToString(Collection col, String separator) {
        if (col == null || col.size() == 0) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        Iterator it = col.iterator();
        while (it.hasNext()) {
            buf.append(it.next());
            if (!it.hasNext()) continue;
            buf.append(separator);
        }
        return buf.toString();
    }

    public static String getExtension(String filepath) {
        if (filepath == null) {
            return "";
        }
        int idx = (filepath = filepath.replace('\\', '/')).lastIndexOf(47);
        if (idx >= 0) {
            filepath = filepath.substring(idx + 1);
        }
        if ((idx = filepath.lastIndexOf(46)) >= 0) {
            return filepath.substring(idx + 1);
        }
        return "";
    }

    public static String getFilePathWithoutExtension(String name) {
        int index = name.lastIndexOf(46);
        if (index > 0) {
            return name.substring(0, index);
        }
        return name;
    }

    public static String getDirectoryFromPathName(String path) {
        String tmp = path.replace('\\', '/');
        int idx = tmp.lastIndexOf(47);
        if (idx < 0) {
            return "";
        }
        if (idx + 1 < path.length()) {
            return path.substring(0, idx);
        }
        return path;
    }

    public static String getFileName(String path) {
        String tmp = path.replace('\\', '/');
        int idx = tmp.lastIndexOf(47);
        if (idx < 0) {
            return path;
        }
        if (idx + 1 < path.length()) {
            return path.substring(idx + 1);
        }
        return path;
    }

    public static String getFileDirectory(String path) {
        String tmp = path.replace('\\', '/');
        int idx = tmp.lastIndexOf(47);
        if (idx < 0) {
            return path;
        }
        if (idx < path.length()) {
            return path.substring(0, idx);
        }
        return path;
    }

    public static String getFileNameWithoutExtension(String path) {
        String name = QbUtil.getFileName(path);
        int index = name.lastIndexOf(46);
        if (index >= 0) {
            return name.substring(0, index);
        }
        return name;
    }

    public static String getFileNameForPak(String path) {
        if (path.toLowerCase().startsWith("zip:")) {
            try {
                return new PakFile(path).getFileName();
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        return QbUtil.getFileName(path);
    }

    public static int[] convertVectorToIntArray(Vector<Integer> v) {
        int[] intArray = new int[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            intArray[i] = v.elementAt(i);
        }
        return intArray;
    }

    public static String getValidFilename(String filename) {
        if (filename == null) {
            return null;
        }
        String ret = "";
        for (int i = 0; i < filename.length(); ++i) {
            char c = filename.charAt(i);
            ret = c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' ? ret + c : ret + '_';
        }
        return ret;
    }

    public static boolean isValidName(String s) {
        if (s == null) {
            return false;
        }
        if (s.equals("")) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (Character.isDigit(c) || Character.isLetter(c) || c == '_') continue;
            return false;
        }
        return true;
    }

    public static String getIntegerString(String text) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; text != null && i < text.length(); ++i) {
            char c = text.charAt(i);
            if (!Character.isDigit(c)) continue;
            buffer.append(c);
        }
        return buffer.toString();
    }

    public static String getDoubleString(String text) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; text != null && i < text.length(); ++i) {
            char c = text.charAt(i);
            if (!Character.isDigit(c) && c != '.') continue;
            buffer.append(c);
        }
        return buffer.toString();
    }

    public static String removeSkipChar(String originalString) {
        StringBuffer buffer = new StringBuffer(originalString);
        int i = 0;
        while (i + 1 < buffer.length()) {
            if (buffer.charAt(i) == '\\' && (buffer.charAt(i + 1) == '\"' || buffer.charAt(i + 1) == '\'')) {
                StringBuffer temp = new StringBuffer();
                for (int j = 0; j < buffer.length(); ++j) {
                    if (j == i) continue;
                    temp.append(buffer.charAt(j));
                }
                buffer = temp;
                continue;
            }
            ++i;
        }
        return buffer.toString();
    }

    public static String makeNewLine(String str) {
        String str2 = "";
        int len = str.length();
        boolean isSlash = false;
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (c == '\\' && !isSlash) {
                isSlash = true;
                continue;
            }
            if ((c == 'n' || c == 'r') && isSlash) {
                c = '\n';
            } else if (c != '\\' && isSlash) {
                str2 = str2 + '\\';
            }
            isSlash = false;
            str2 = str2 + c;
        }
        return str2;
    }

    public static String buildSelectQuery(ReadDatabase readDB, String columnName, String tableName) {
        return QbUtil.buildSelectQuery(readDB, columnName, tableName, false);
    }

    public static String buildSelectQuery(ReadDatabase readDB, String columnName, String tableName, boolean showDistinct) {
        StringBuffer query = new StringBuffer("select ");
        if (showDistinct) {
            query.append("distinct ");
        }
        try {
            columnName = readDB.addQuotes(columnName);
            query.append(columnName);
            query.append(" from ");
            if (!tableName.contains("`")) {
                tableName = readDB.addQuotes(tableName);
            }
            query.append(tableName);
        }
        catch (Exception e) {
            System.out.println(e);
        }
        return query.toString();
    }

    public static int getPosAfterSnapToGrid(int x) {
        int wholeCmPixel = (int)(Math.floor(x / pixelPerCm) * (double)pixelPerCm);
        int remainingPixel = x - wholeCmPixel;
        remainingPixel = (int)(Math.round((double)remainingPixel / (double)cmUnit) * (long)cmUnit);
        x = wholeCmPixel + remainingPixel;
        return x;
    }

    public static double getPosAfterSnapToGrid(double x) {
        int xInPixel = QbUtil.toPixel(x);
        int wholeCmPixel = (int)(Math.floor(xInPixel / pixelPerCm) * (double)pixelPerCm);
        int remainingPixel = xInPixel - wholeCmPixel;
        remainingPixel = (int)(Math.round((double)remainingPixel / (double)cmUnit) * (long)cmUnit);
        xInPixel = wholeCmPixel + remainingPixel;
        x = (double)xInPixel / (double)QbUtil.getPixelPerInch();
        return x;
    }

    public static void setCM_UNIT(double CmGridStepSize) {
        cmUnit = (int)((double)pixelPerCm * CmGridStepSize);
    }

    public static Vector readMultiValues(String valueString) {
        if (valueString == null) {
            return null;
        }
        try {
            Vector<String> vect = new Vector<String>();
            StreamTokenizer st = new StreamTokenizer(new StringReader(valueString));
            int ttype = st.nextToken();
            while (ttype != -1) {
                if (ttype == -2) {
                    vect.addElement(st.nval + "");
                } else if (st.sval != null) {
                    vect.addElement(st.sval);
                }
                ttype = st.nextToken();
            }
            return vect;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static String[] getQueryParamNames(String[] conditions) {
        Hashtable<Character, String> nonParamDelimiters = QbUtil.getHashTable(NON_PARAMETER_DELIMITERS);
        Hashtable<Character, String> paramDelimiters = QbUtil.getHashTable(PARAMETER_DELIMITERS);
        LinkedList<String> paramNames = new LinkedList<String>();
        StringBuffer buf = null;
        for (String condition : conditions) {
            char[] characters = condition.toCharArray();
            boolean parseParam = false;
            boolean isInsideNonParamDelimiter = false;
            Character delim = null;
            block4: for (char character : characters) {
                if (delim == null && nonParamDelimiters.get(Character.valueOf(character)) != null || delim != null && delim.charValue() == character || delim != null && delim.charValue() == '#' && character == '\n') {
                    isInsideNonParamDelimiter = !isInsideNonParamDelimiter;
                    delim = !isInsideNonParamDelimiter ? null : Character.valueOf(character);
                }
                boolean isParamDelimiter = paramDelimiters.get(Character.valueOf(character)) != null;
                switch (character) {
                    case ':': {
                        if (isInsideNonParamDelimiter) continue block4;
                        buf = new StringBuffer();
                        parseParam = true;
                        continue block4;
                    }
                    default: {
                        if (isParamDelimiter && parseParam && buf.charAt(0) != '=') {
                            paramNames.add(buf.toString());
                            parseParam = false;
                        }
                        if (!parseParam) continue block4;
                        buf.append(character);
                    }
                }
            }
            if (!parseParam || buf.charAt(0) == '=') continue;
            paramNames.add(buf.toString());
        }
        return QbUtil.toStringArray(paramNames);
    }

    public static Hashtable<Character, String> getHashTable(char[] names) {
        if (names == null) {
            return null;
        }
        Hashtable<Character, String> result = new Hashtable<Character, String>();
        for (char name : names) {
            result.put(Character.valueOf(name), "");
        }
        return result;
    }

    public static <T> String[] toStringArray(List<T> list) {
        Iterator<T> it = list.iterator();
        String[] result = new String[list.size()];
        int i = 0;
        while (it.hasNext()) {
            result[i] = it.next() + "";
            ++i;
        }
        return result;
    }

    public static String getDecodedString(String str) throws UnsupportedEncodingException {
        if (str == null) {
            return null;
        }
        return new String(str.getBytes("UTF-8"), "ISO-8859-1");
    }

    public static String encodePath(String s) {
        if (s == null) {
            return null;
        }
        if (s.endsWith("*")) {
            return "*" + Coder.encode(s);
        }
        int idx = s.replace('\\', '/').lastIndexOf(47);
        String str = s.substring(0, idx + 1) + "*" + Coder.encode(s.substring(idx + 1));
        return str;
    }

    public static String decodePath(String s) {
        if (s == null) {
            return null;
        }
        if (s.startsWith("*")) {
            return Coder.decode(s.substring(1));
        }
        int idx = s.indexOf(42);
        String str = s.substring(0, idx) + Coder.decode(s.substring(idx + 1));
        return str;
    }

    public static String removeUnsafeChars(String s) {
        if (s == null) {
            return s;
        }
        if (!s.contains("javascript:")) {
            s = s.replaceAll("'", "");
        }
        s = s.replaceAll("\"", "");
        s = s.replaceAll("%27", "");
        s = s.replaceAll("%22", "");
        s = s.replaceAll("</", "");
        s = s.replaceAll("<", "");
        s = s.replaceAll("%3C", "");
        s = s.replaceAll("%3c", "");
        s = s.replaceAll(">", "");
        s = s.replaceAll("%3E", "");
        s = s.replaceAll("%3e", "");
        s = s.replaceAll(";", "");
        s = s.replaceAll("%3B", "");
        s = s.replaceAll("%3b", "");
        return s;
    }

    public static String tokenizeAndEscapeGETParameters(String s) {
        if (s == null) {
            return null;
        }
        s = QbUtil.removeUnsafeChars(s);
        StringBuffer buf = new StringBuffer();
        int uriIndex = s.indexOf(63) + 1;
        if (uriIndex == -1) {
            String uriPart = s.substring(uriIndex);
            buf.append(s.substring(0, uriIndex));
            StringTokenizer st = new StringTokenizer(uriPart, "&");
            int counter = 0;
            while (st.hasMoreTokens()) {
                String pairStr = st.nextToken();
                if (counter > 0) {
                    buf.append("&");
                }
                buf.append(QbUtil.escapeGETPair(pairStr));
                ++counter;
            }
            return buf.toString();
        }
        return s;
    }

    public static String escapeGETPair(String s) {
        int splitInt = s.indexOf(61);
        if (splitInt <= 0) {
            return null;
        }
        String rtrn = s.substring(0, ++splitInt);
        String split = s.substring(splitInt);
        rtrn = rtrn + QbUtil.urlEncode(split);
        return rtrn;
    }

    public static String urlEncode(String s) {
        if (s == null) {
            return null;
        }
        try {
            s = URLEncoder.encode(s, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            System.err.println("Failed to encode URL");
            e.printStackTrace();
        }
        return s;
    }

    public static String encodeURIComponent(String s) {
        if (s == null) {
            return null;
        }
        try {
            s = URLEncoder.encode(s, "utf-8");
            s = s.replaceAll("\\+", "%20");
            s = s.replaceAll("%5B", "[");
            s = s.replaceAll("%5D", "]");
            s = s.replaceAll("%7E", "~");
            s = s.replaceAll("%28", "(");
            s = s.replaceAll("%29", ")");
            s = s.replaceAll("%21", "!");
        }
        catch (UnsupportedEncodingException e) {
            System.err.println("Failed to encode URL");
            e.printStackTrace();
        }
        return s;
    }

    public static String urlEncode2IfNecessary(String s) {
        if (s == null) {
            return null;
        }
        if (s.matches(".*%[0-9A-Z]{2,}.*")) {
            return s;
        }
        return QbUtil.encodeURIComponent(s);
    }

    public static String urlDecode(String s) {
        if (s == null) {
            return null;
        }
        try {
            s = URLDecoder.decode(s, "utf-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return s;
    }

    public static String fixUrlString(String url) {
        if (url == null) {
            return null;
        }
        String lc = url.toLowerCase();
        if (!lc.startsWith("file:/") && url.indexOf("://") == -1) {
            return url;
        }
        PakFile pakFile = null;
        if (lc.startsWith("zip:")) {
            try {
                pakFile = new PakFile(url);
            }
            catch (MalformedURLException e) {
                return url;
            }
            url = pakFile.getMainFilePath();
        }
        if (!url.matches(".*[#&?].*")) {
            url = url.replace("[", "%5B").replace("]", "%5D");
            try {
                url = new URI(url).toASCIIString();
            }
            catch (URISyntaxException e1) {
                try {
                    url = new URI(null, url, null).toASCIIString();
                    url = url.replace("%255B", "%5B").replace("%255D", "%5D");
                }
                catch (URISyntaxException e2) {
                    e2.printStackTrace();
                }
            }
        }
        url = url.replaceAll("&", QbUtil.urlEncode("&"));
        if (pakFile != null) {
            return "zip:" + url + "?" + pakFile.getZipPath();
        }
        return url;
    }

    public static String findName(String url) {
        String str;
        int index;
        int forwardslash;
        int index2;
        if (url == null || url.trim().equals("")) {
            return "";
        }
        int backslash = url.lastIndexOf(92);
        int n = index2 = backslash > (forwardslash = url.lastIndexOf(47)) ? backslash : forwardslash;
        if (index2 < 0) {
            index2 = -1;
        }
        if ((index = url.lastIndexOf(46)) == -1 || index < index2) {
            index = url.length();
        }
        if ((str = url.substring(index2 + 1, index)).startsWith("*")) {
            return str.substring(1);
        }
        return str;
    }

    public static synchronized int nextNumber() {
        return ++nextNumber;
    }

    public static String[] parseMultiValues(String in) {
        if (in == null || in.length() == 0 || in.indexOf(44) == -1) {
            return new String[]{in};
        }
        Pattern pat = Pattern.compile("\"([^\"]+)\"");
        Matcher matcher = pat.matcher(in);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, Matcher.quoteReplacement(matcher.group(1)).replaceAll(",", "#C!o#M!a"));
        }
        matcher.appendTail(sb);
        String[] result = sb.toString().split(",");
        for (int i = 0; i < result.length; ++i) {
            result[i] = result[i] != null ? result[i].replaceAll("#C!o#M!a", ",").trim() : "";
        }
        return result;
    }

    public static void setConnectTimeout(URLConnection conn, int timeout) {
        if (timeout == -1) {
            return;
        }
        conn.setConnectTimeout(timeout);
    }

    public static boolean isInDirectory(String file, String dir) {
        File file1 = new File(file);
        File file2 = new File(dir + "/" + file1.getName());
        return file1.equals(file2);
    }

    public static String createRelativeUrl(String absoluteUrl) {
        URI baseUri;
        URI uri;
        String baseUriString = ServerMessage.getConnectServlet() + "/" + ServerMessage.getServletContext().replaceFirst("\\/*", "").replaceFirst("\\/*servlet\\/*", "");
        try {
            uri = new URI(absoluteUrl);
            baseUri = new URI(baseUriString);
        }
        catch (URISyntaxException e) {
            LOGGER.log(Level.WARNING, "Invalid URL", e);
            return absoluteUrl;
        }
        return QbUtil.urlDecode(baseUri.relativize(uri).toString());
    }

    public static String createRelativePath(String absolutePath, String relativeTo) {
        if (absolutePath.matches("(?i)^(http:\\/\\/|https:\\/\\/).*")) {
            return QbUtil.createRelativeUrl(absolutePath);
        }
        File directory = new File(relativeTo);
        File file = new File(absolutePath);
        File dir = directory;
        StringBuffer dots = new StringBuffer(absolutePath.length());
        do {
            StringBuffer path = new StringBuffer(absolutePath.length());
            File f = file;
            path.append(file.getName());
            while ((f = f.getParentFile()) != null && !f.equals(dir)) {
                path.insert(0, f.getName() + "/");
            }
            if (f != null) {
                String res = dots.append(path).toString();
                if ((absolutePath.endsWith("\\") || absolutePath.endsWith("/")) && !res.endsWith("/")) {
                    res = res + "/";
                }
                return res;
            }
            dots.append("../");
        } while ((dir = dir.getParentFile()) != null);
        return null;
    }

    public static String createAbsolutePath(String relativePath, String relativeTo) {
        File directory = new File(relativeTo);
        relativePath = relativePath.replace('\\', '/');
        while (relativePath.startsWith("../")) {
            relativePath = relativePath.substring(3);
            if (directory.getParentFile() == null) continue;
            directory = directory.getParentFile();
        }
        String absolutePath = directory.getAbsolutePath().replace('\\', '/');
        while (absolutePath.endsWith("/")) {
            absolutePath = absolutePath.substring(0, absolutePath.length() - 1);
        }
        return absolutePath + "/" + relativePath;
    }

    public static void setWindowsLAF() {
        UIManager.LookAndFeelInfo[] lf = UIManager.getInstalledLookAndFeels();
        if (lf != null && lf.length > 0) {
            int i = 0;
            for (i = 0; i < lf.length && !lf[i].getName().equals("Windows"); ++i) {
            }
            if (i < lf.length) {
                try {
                    UIManager.setLookAndFeel(lf[i].getClassName());
                    UIManager.put("TextArea.font", new FontUIResource(new Font("monospaced", 0, 12)));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public static boolean isXMLChart(String url) {
        try {
            InputStreamReader instream;
            if (url.toLowerCase().startsWith("file:/") || url.toLowerCase().startsWith("http:/")) {
                url = QbUtil.fixUrlString(url);
                instream = new InputStreamReader(new URL(url).openStream());
            } else {
                instream = url.toLowerCase().startsWith("https:/") ? new InputStreamReader(HttpsIO.getHttpsInputStream(url)) : new FileReader(url);
            }
            return QbUtil.isXMLChart(instream);
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINE, "failed to find chart [" + url + "]", ex);
            return false;
        }
    }

    private static boolean isXMLChart(Reader instream) throws IOException {
        BufferedReader buffer = new BufferedReader(instream);
        String tmp = null;
        for (int i = 0; i < 5 && (tmp = buffer.readLine()) != null; ++i) {
            if (tmp.toUpperCase().indexOf("ESPRESSCHARTATTR") < 0) continue;
            buffer.close();
            instream.close();
            return true;
        }
        buffer.close();
        instream.close();
        return false;
    }

    public static boolean isXMLChart(byte[] bytes) {
        InputStreamReader instream = new InputStreamReader(new ByteArrayInputStream(bytes));
        try {
            return QbUtil.isXMLChart(instream);
        }
        catch (IOException ex) {
            LOGGER.log(Level.FINE, "failed to detect XML chart from byte array", ex);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isXMLReport(String url) {
        boolean bl;
        BufferedReader buffer;
        InputStreamReader instream;
        block8: {
            boolean bl2;
            instream = null;
            buffer = null;
            try {
                if (url.toLowerCase().startsWith("file:/") || url.toLowerCase().startsWith("http:/")) {
                    url = QbUtil.fixUrlString(url);
                    instream = new InputStreamReader(new URL(url).openStream());
                } else {
                    instream = url.toLowerCase().startsWith("https:/") ? new InputStreamReader(HttpsIO.getHttpsInputStream(url)) : new FileReader(url);
                }
                buffer = new BufferedReader(instream);
                String tmp = null;
                for (int i = 0; i < 5 && (tmp = buffer.readLine()) != null; ++i) {
                    if (tmp.toUpperCase().indexOf("<REPORT NAME") < 0) continue;
                    bl = true;
                    break block8;
                }
                bl2 = false;
            }
            catch (Exception ex) {
                try {
                    LOGGER.log(Level.WARNING, "failed to find report [" + url + "]", ex);
                    bl2 = false;
                }
                catch (Throwable throwable) {
                    CloseUtils.close(buffer);
                    CloseUtils.close(instream);
                    throw throwable;
                }
                CloseUtils.close(buffer);
                CloseUtils.close(instream);
                return bl2;
            }
            CloseUtils.close(buffer);
            CloseUtils.close(instream);
            return bl2;
        }
        CloseUtils.close(buffer);
        CloseUtils.close(instream);
        return bl;
    }

    public static void showDocumentation() {
        String url = LCKey.isERES() ? "http://data.quadbase.com/Docs70/eres/help/manual/index.html" : (LCKey.isDashboardOnly() ? "http://data.quadbase.com/Docs70/edab/help/manual/index.html" : (LCKey.isReport() ? "http://data.quadbase.com/Docs70/er/help/manual/index.html" : "http://data.quadbase.com/Docs70/ec/help/manual/index.html"));
        Applet applet = ServerMessage.getApplet();
        if (applet == null) {
            StartBrowser.startBrowser(url);
        } else {
            try {
                applet.getAppletContext().showDocument(new URL(applet.getDocumentBase(), url), "_blank");
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, "Failed to show documentation in browser", ex);
            }
        }
    }

    public static boolean isImageFile(String filename) {
        String[] ext;
        for (String element : ext = new String[]{".png", ".jpg", ".jpeg", ".gif"}) {
            if (!filename.toLowerCase().endsWith(element)) continue;
            return true;
        }
        return false;
    }

    public static boolean isEspressMobile(HttpServletRequest request) {
        String ua = request.getHeader("User-Agent");
        if (ua == null) {
            ua = "";
        }
        return (ua = ua.toLowerCase()).indexOf("espressmobile") != -1;
    }

    public static void checkExtensionsBlacklist(String filename) {
        if (filename == null) {
            return;
        }
        String lowerCase = filename.toLowerCase();
        if (lowerCase.endsWith(".jsp") || lowerCase.endsWith(".jspx")) {
            throw new IllegalArgumentException("Blacklisted file extension.");
        }
    }

    public static String generateFileNameWithTimestamp(String orgFileName, String username, String extension) {
        orgFileName = QbUtil.getFileNameOnly(orgFileName, extension);
        String fileName = orgFileName + "_" + username + "_" + System.currentTimeMillis();
        fileName = fileName + extension;
        return fileName;
    }

    public static String getFileNameOnly(String fileName, String extension) {
        if (fileName.toLowerCase().endsWith(extension)) {
            fileName = fileName.substring(0, fileName.length() - extension.length());
        }
        return fileName;
    }

    public static boolean isNullOrEmpty(String string) {
        return string == null || string.length() == 0;
    }

    public static String emptyStringIfNull(String string) {
        if (string == null) {
            return "";
        }
        return string;
    }

    public static boolean isThisMyIpAddress(String URL2) {
        Enumeration<NetworkInterface> ifaces;
        URL aURL;
        if (URL2 == null) {
            return false;
        }
        if (!URL2.toLowerCase().startsWith("http")) {
            return true;
        }
        try {
            aURL = new URL(QbUtil.urlDecode(URL2));
        }
        catch (MalformedURLException e4) {
            LOGGER.log(Level.FINEST, "Can't parse URL", e4);
            return false;
        }
        URL2 = aURL.getHost();
        if (URL2 == null) {
            return false;
        }
        try {
            if (URL2.contains(OrganizerDataImpl.getServerName())) {
                return true;
            }
        }
        catch (Exception e1) {
            LOGGER.log(Level.FINEST, "Failed to get the server name", e1);
            return false;
        }
        try {
            ifaces = NetworkInterface.getNetworkInterfaces();
            while (ifaces.hasMoreElements()) {
                NetworkInterface param = ifaces.nextElement();
                List<InterfaceAddress> addrs = param.getInterfaceAddresses();
                for (InterfaceAddress ia : addrs) {
                    String ipadr = ia.getAddress().toString().substring(1);
                    if (URL2.contains(ipadr)) {
                        return true;
                    }
                    try {
                        InetAddress addr = InetAddress.getByName(ipadr);
                        if (!URL2.contains(addr.getHostName())) continue;
                        return true;
                    }
                    catch (UnknownHostException unknownHostException) {
                    }
                }
            }
        }
        catch (SocketException e2) {
            LOGGER.log(Level.FINEST, "Failed to get local IP addresses", e2);
        }
        InetAddress[] addrss = null;
        try {
            addrss = InetAddress.getAllByName(URL2);
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        if (addrss != null && addrss.length > 0) {
            for (InetAddress ad : addrss) {
                try {
                    ifaces = NetworkInterface.getNetworkInterfaces();
                    while (ifaces.hasMoreElements()) {
                        NetworkInterface param = ifaces.nextElement();
                        List<InterfaceAddress> addrs = param.getInterfaceAddresses();
                        for (InterfaceAddress ia : addrs) {
                            if (!Arrays.equals(ia.getAddress().getAddress(), ad.getAddress())) continue;
                            return true;
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    public static boolean openLinkInBrowserFromJNLP(String link) {
        BasicService basicService = ServerMessage.getBasicService();
        if (basicService != null) {
            try {
                URL url = new URL(link.replaceAll(" ", "%20"));
                basicService.showDocument(url);
                return true;
            }
            catch (MalformedURLException e) {
                LOGGER.log(Level.WARNING, "Cannot create URL: " + link, e);
            }
        }
        return false;
    }

    public static double getScaleValue(int bin, ColData colData, boolean sorted, Object lBound, Object uBound) {
        return QbUtil.getScaleValue(bin, colData, sorted, lBound, uBound, false);
    }

    public static double getScaleValue(int bin, ColData colData, boolean sorted, Object lBound, Object uBound, boolean toRound) {
        double d;
        double dataRange = 0.0;
        if (sorted) {
            dataRange = QbUtil.getDataRange(colData.getValue(0), colData.getValue(colData.getSize() - 1), lBound, uBound);
        } else {
            Vector vData = colData.getDistinctValue();
            Collections.sort(vData);
            dataRange = QbUtil.getDataRange(Double.valueOf(vData.get(0).toString()), Double.valueOf(vData.get(vData.size() - 1).toString()), lBound, uBound);
        }
        double scaleVal = d = dataRange / Double.valueOf(bin);
        if (d > 0.5) {
            if (toRound && scaleVal > 10.0) {
                int cnt = QbUtil.countDigits((int)scaleVal) - 1;
                scaleVal = QbUtil.round(scaleVal, Math.pow(10.0, cnt));
            } else {
                scaleVal = (double)Math.round(d * 2.0) / 2.0;
            }
        } else {
            scaleVal = d == 0.0 ? 1.0 : new BigDecimal(d).setScale(4, RoundingMode.HALF_UP).doubleValue();
        }
        return scaleVal;
    }

    public static double round(double i, double v) {
        return (double)Math.round(i / v) * v;
    }

    public static double floor(double i, double v) {
        return Math.floor(i / v) * v;
    }

    public static int countDigits(int num) {
        int count = 0;
        while (num != 0) {
            num /= 10;
            ++count;
        }
        return count;
    }

    public static double getDataRange(double min, double max, Object lBound, Object uBound) {
        double lbound = 0.0;
        double ubound = 0.0;
        lbound = lBound != null && !lBound.toString().equals("") ? Double.valueOf(lBound.toString()) : min;
        ubound = uBound != null && !uBound.toString().equals("") ? Double.valueOf(uBound.toString()) : max;
        return (ubound - lbound) * 1.01;
    }

    public static ColData[] probabilityHistogram(ColData[] colData) {
        int i;
        int nRow = colData[0].getSize();
        int nCol = colData.length - 1;
        ColData[] colData2 = new ColData[nCol + 1];
        int total = 0;
        for (i = 0; i < nRow; ++i) {
            Object o = colData[1].getData(i);
            if (o == null) continue;
            total += ((Integer)colData[1].getData(i)).intValue();
        }
        for (i = 0; i < nCol; ++i) {
            String colName = colData[i].getName().replace("count", "probability");
            String tblName = colData[i].getTableName().replace("count", "probability");
            int dtype = colData[i].getOriginalDataType();
            if (i == 1) {
                dtype = 8;
            }
            colData2[i] = new ColData(colName, tblName, dtype, nRow, nCol);
        }
        colData2[nCol] = new ColData("qbCount", 4, nRow, colData.length);
        for (i = 0; i < nRow; ++i) {
            colData2[0].add(colData[0].getData(i));
            Object cData = colData[1].getData(i);
            Number x = null;
            x = cData != null ? (Number)new BigDecimal((double)((Integer)cData).intValue() * 1.0 / (double)total).setScale(2, RoundingMode.HALF_UP).doubleValue() : (Number)0;
            colData2[1].add(x);
        }
        return colData2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportDataFile(String filename, int separator, int format, quadbase.reportdesigner.report.ColData[] colData) throws Exception {
        ByteArrayOutputStream fstream = new ByteArrayOutputStream(1024);
        PrintStream pout = new PrintStream(fstream);
        try {
            pout = new PrintStream(fstream);
            quadbase.reportdesigner.report.ColData.print(pout, colData, separator, format);
            new WriteDataFile().output(fstream.toByteArray(), filename);
        }
        finally {
            fstream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportDataFile(String filename, int separator, int format, ColData[] colData) throws Exception {
        ByteArrayOutputStream fstream = new ByteArrayOutputStream(1024);
        PrintStream pout = new PrintStream(fstream);
        try {
            pout = new PrintStream(fstream);
            ColData.print(pout, colData, separator, format);
            new WriteDataFile().output(fstream.toByteArray(), filename);
        }
        finally {
            fstream.close();
        }
    }

    public static boolean isValidDashboardName(String dname) {
        return Pattern.compile("[\\\\\\/\\:\\*\\?\\\"\\<\\>\\|\\.]").matcher(dname).matches();
    }
}

