/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.util.internal;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import quadbase.common.client.ServerMessage;
import quadbase.common.network.IConnection;
import quadbase.common.util.internal.CloseUtils;
import quadbase.common.util.internal.IOUtil;

public class RenameFile {
    String filename = null;
    String newfilename = null;

    public RenameFile(String fileName, String newfileName) {
        this.filename = fileName.replace('\\', '/');
        this.newfilename = newfileName.replace('\\', '/');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean rename() {
        int code;
        if (this.filename.equals(this.newfilename)) {
            return true;
        }
        if (!ServerMessage.useServer && ServerMessage.isLoadBalancer) {
            this.filename = ServerMessage.getPath(this.filename);
            this.newfilename = ServerMessage.getPath(this.newfilename);
            File file = new File(this.filename);
            if (file.exists()) {
                return file.renameTo(new File(this.newfilename));
            }
            return false;
        }
        IConnection socket = null;
        DataInputStream din = null;
        try {
            socket = ServerMessage.createConnection();
            ByteArrayOutputStream bstream = new ByteArrayOutputStream(1024);
            DataOutputStream out = new DataOutputStream(bstream);
            out.writeShort(23868);
            out.writeBoolean(false);
            IOUtil.writeString(out, this.filename);
            IOUtil.writeString(out, this.newfilename);
            byte[] array = bstream.toByteArray();
            socket.setContentLength(array.length);
            socket.getOutputStream().write(array);
            socket.getOutputStream().flush();
            din = new DataInputStream(socket.getInputStream());
            code = din.readInt();
            CloseUtils.close(din);
        }
        catch (IOException ex) {
            boolean bl = false;
            return bl;
        }
        finally {
            CloseUtils.close(din);
            CloseUtils.close(socket);
        }
        CloseUtils.close(socket);
        switch (code) {
            case 0: {
                return true;
            }
        }
        return false;
    }
}

