/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.util.internal;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.ServiceException;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.axis.description.OperationDesc;
import org.apache.axis.description.ParameterDesc;
import org.apache.axis.message.RPCElement;
import org.apache.axis.message.RPCHeaderParam;
import org.apache.axis.message.RPCParam;
import org.apache.axis.message.SOAPBodyElement;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.message.SOAPHeaderElement;
import org.apache.axis.utils.Messages;
import org.apache.axis.wsdl.gen.Parser;

public class SOAPCall {
    Call call;

    public SOAPCall(Parser wsdlParser, QName serviceName, String portName, String operationName) throws ServiceException {
        Service service = new Service(wsdlParser, serviceName);
        this.call = (Call)service.createCall(new QName(portName), operationName);
    }

    public ArrayList getParameters() {
        return this.call.getOperation().getAllInParams();
    }

    public String invoke(Object[] params) throws RemoteException {
        QName operationName = this.call.getOperationName();
        try {
            if (this.call.getReturnType() != null && params != null && params.length != 0 && this.call.getOperation().getNumParams() == 0) {
                throw new AxisFault(Messages.getMessage((String)"mustSpecifyParms"));
            }
            RPCElement body = new RPCElement(operationName.getNamespaceURI(), operationName.getLocalPart(), this.getParamList(params));
            MessageContext msgCtx = this.call.getMessageContext();
            SOAPEnvelope reqEnv = new SOAPEnvelope(msgCtx.getSOAPConstants(), msgCtx.getSchemaVersion());
            SOAPEnvelope resEnv = null;
            Message reqMsg = new Message((Object)reqEnv);
            Message resMsg = null;
            body.setEncodingStyle(this.call.getEncodingStyle());
            this.call.setRequestMessage(reqMsg);
            reqEnv.addBodyElement((SOAPBodyElement)body);
            reqEnv.setMessageType("request");
            this.call.invoke();
            resMsg = msgCtx.getResponseMessage();
            if (resMsg == null) {
                if (msgCtx.isPropertyTrue("call.FaultOnNoResponse", false)) {
                    throw new AxisFault(Messages.getMessage((String)"nullResponse00"));
                }
                return null;
            }
            resEnv = resMsg.getSOAPEnvelope();
            SOAPBodyElement bodyEl = resEnv.getFirstBody();
            if (bodyEl == null) {
                return null;
            }
            return this.removeNamespaces(bodyEl.getAsString());
        }
        catch (AxisFault af) {
            if (af.detail != null && af.detail instanceof RemoteException) {
                throw (RemoteException)af.detail;
            }
            throw af;
        }
        catch (Exception exp) {
            throw AxisFault.makeFault((Exception)exp);
        }
    }

    private Object[] getParamList(Object[] params) {
        OperationDesc operation = this.call.getOperation();
        int numParams = 0;
        if (operation == null || operation.getNumParams() == 0) {
            return params;
        }
        numParams = operation.getNumInParams();
        if (params == null || numParams != params.length) {
            throw new JAXRPCException(Messages.getMessage((String)"parmMismatch00", (String)(params == null ? "no params" : "" + params.length), (String)("" + numParams)));
        }
        Vector<RPCParam> result = new Vector<RPCParam>();
        int j = 0;
        ArrayList parameters = operation.getParameters();
        for (int i = 0; i < parameters.size(); ++i) {
            Object p;
            ParameterDesc param = (ParameterDesc)parameters.get(i);
            if (param.getMode() == 2) continue;
            QName paramQName = param.getQName();
            RPCParam rpcParam = null;
            rpcParam = (p = params[j++]) instanceof RPCParam ? (RPCParam)p : new RPCParam(paramQName.getNamespaceURI(), paramQName.getLocalPart(), p);
            rpcParam.setParamDesc(param);
            if (param.isInHeader()) {
                this.call.addHeader((SOAPHeaderElement)new RPCHeaderParam(rpcParam));
                continue;
            }
            result.add(rpcParam);
        }
        return result.toArray();
    }

    private String removeNamespaces(String s) {
        if (s == null) {
            return null;
        }
        s = s.replaceAll("xmlns:?[^=]*=\"[^\"]*\"", "");
        s = s.replaceAll("<\\w*[^: >]+:", "<");
        s = s.replaceAll("<\\w*/[^: >]+:", "</");
        return s;
    }
}

