/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.util.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.ResultSet;
import java.sql.SQLException;

public class SerialBlob
implements Blob {
    private byte[] binaryData = null;

    public SerialBlob(byte[] data) {
        this.setBinaryData(data);
    }

    SerialBlob(byte[] data, ResultSet creatorResultSetToSet, int columnIndexToSet) {
        this.setBinaryData(data);
    }

    private byte[] getBinaryData() {
        return this.binaryData;
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        return new ByteArrayInputStream(this.getBinaryData());
    }

    @Override
    public byte[] getBytes(long pos, int length) throws SQLException {
        if (pos < 1L) {
            throw new SQLException("Postion is less than 1");
        }
        byte[] newData = new byte[length];
        System.arraycopy(this.getBinaryData(), (int)(pos - 1L), newData, 0, length);
        return newData;
    }

    @Override
    public long length() throws SQLException {
        return this.getBinaryData().length;
    }

    @Override
    public long position(byte[] pattern, long start) throws SQLException {
        throw new SQLException("Not implemented");
    }

    @Override
    public long position(Blob pattern, long start) throws SQLException {
        return this.position(pattern.getBytes(0L, (int)pattern.length()), start);
    }

    private void setBinaryData(byte[] newBinaryData) {
        this.binaryData = newBinaryData;
    }

    @Override
    public OutputStream setBinaryStream(long indexToWriteAt) throws SQLException {
        if (indexToWriteAt < 1L) {
            throw new SQLException("Index To Write At is less than 1");
        }
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        if (indexToWriteAt > 0L) {
            bytesOut.write(this.binaryData, 0, (int)(indexToWriteAt - 1L));
        }
        return bytesOut;
    }

    @Override
    public int setBytes(long writeAt, byte[] bytes) throws SQLException {
        return this.setBytes(writeAt, bytes, 0, bytes.length);
    }

    @Override
    public int setBytes(long writeAt, byte[] bytes, int offset, int length) throws SQLException {
        OutputStream bytesOut = this.setBinaryStream(writeAt);
        try {
            bytesOut.write(bytes, offset, length);
        }
        catch (IOException ioEx) {
            throw new SQLException();
        }
        finally {
            try {
                bytesOut.close();
            }
            catch (IOException iOException) {}
        }
        return length;
    }

    @Override
    public void truncate(long arg0) throws SQLException {
        throw new SQLException("truncate is not implemented");
    }

    @Override
    public void free() throws SQLException {
    }

    @Override
    public InputStream getBinaryStream(long pos, long length) throws SQLException {
        return null;
    }
}

