/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.util.internal;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import quadbase.common.client.ServerMessage;
import quadbase.common.network.IConnection;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.common.util.internal.QbUtil;

public class WriteDataFile {
    public void output(byte[] barray, String filename) throws Exception {
        this.output(barray, filename, false, false);
    }

    public void output(byte[] barray, String filename, boolean isPageViewer, boolean fromLoadBalancer) throws Exception {
        filename.replace('\\', '/');
        if (ServerMessage.useServer || !ServerMessage.isLoadBalancer && !fromLoadBalancer && !isPageViewer) {
            if (filename.startsWith("http://") || filename.startsWith("https:/")) {
                this.sendToServer(barray, filename, false);
            } else {
                this.sendToServer(barray, filename, (filename = filename.replace('\\', '/')).startsWith("/") || filename.indexOf(":/") >= 0);
            }
            return;
        }
        if (filename.startsWith("http://") || filename.startsWith("https:/")) {
            throw new IOException("Cannot write to HTTP URL :" + filename);
        }
        QbUtil.checkExtensionsBlacklist(filename);
        FileOutputStream fstream = IOUtil.createFileOutputStream(filename);
        DataOutputStream out = new DataOutputStream(fstream);
        out.write(barray, 0, barray.length);
        fstream.flush();
        fstream.close();
    }

    void sendToServer(byte[] barray, String filename, boolean absolutePath) throws Exception {
        if (!absolutePath) {
            filename = IOUtil.extractHostPath(filename, ServerMessage.getApplet());
        }
        ByteArrayOutputStream bstream = new ByteArrayOutputStream(50);
        DataOutputStream dout = new DataOutputStream(bstream);
        dout.writeShort(1076);
        dout.writeBoolean(false);
        dout.writeInt(barray.length);
        IOUtil.writeString(dout, filename);
        dout.writeBoolean(absolutePath);
        dout.writeBoolean(false);
        dout.writeBoolean(false);
        dout.writeBoolean(false);
        dout.writeBoolean(false);
        IOUtil.writeStr(dout, null);
        IConnection socket = null;
        try {
            try {
                socket = ServerMessage.createConnection();
                byte[] array = bstream.toByteArray();
                socket.setContentLength(array.length + barray.length);
                socket.getOutputStream().write(array);
                socket.getOutputStream().write(barray);
                socket.getOutputStream().flush();
            }
            catch (IOException ex) {
                if (socket != null) {
                    socket.close();
                }
                throw new IOException("Failed to connect to server !");
            }
            DataInputStream din = new DataInputStream(socket.getInputStream());
            String errMessage = this.getErrorString(din.readInt());
            String reason = IOUtil.readString(din, true);
            socket.close();
            if (errMessage != null) {
                throw new IOException(errMessage + "\n" + reason);
            }
        }
        catch (Exception ex) {
            try {
                socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw ex;
        }
    }

    String getErrorString(int code) {
        String scode;
        if (code == 0) {
            return null;
        }
        switch (code) {
            case 5: {
                scode = "Access Denied.";
                break;
            }
            case 2: {
                scode = "Server out of memory.\n Please try again later.";
                break;
            }
            case 1: 
            case 3: {
                scode = "";
                break;
            }
            case 4: {
                scode = "Too many users logged onto the server. \n Please try again later.";
                break;
            }
            default: {
                scode = LanguageEncoder.getText("Unknown error code") + " " + code + "!";
            }
        }
        return scode;
    }
}

