/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.util.internal;

import java.sql.Date;
import java.util.Vector;
import quadbase.common.paramquery.QueryInParam;
import quadbase.common.paramquery.QueryMultiValueInParam;
import quadbase.common.util.internal.XMLDefaultTreeNode;
import quadbase.common.util.internal.XMLFieldInfo;

public class XMLConditionNode
extends XMLDefaultTreeNode {
    private XMLFieldInfo fieldInfo;
    private int conditionType;
    private Vector value;
    private Vector inputData;
    private String condition;

    public XMLConditionNode(String name, String[] path, String attrName, int conditionType, Vector value) {
        super(name);
        this.fieldInfo = attrName != null && !attrName.equals("") ? new XMLFieldInfo(path, attrName) : new XMLFieldInfo(path);
        this.conditionType = conditionType;
        this.value = value;
    }

    @Override
    public String getName() {
        return (String)this.getUserObject();
    }

    @Override
    public void setName(String name) {
        this.setUserObject(name);
    }

    public XMLFieldInfo getXMLFieldInfo() {
        return this.fieldInfo;
    }

    public void setXMLFieldInfo(XMLFieldInfo field) {
        this.fieldInfo = field;
    }

    public String[] getFullPath() {
        return this.fieldInfo.getPath();
    }

    public void setFullPath(String[] path) {
        this.fieldInfo.setPath(path);
    }

    public int getConditionType() {
        return this.conditionType;
    }

    public void setConditionType(int type) {
        this.conditionType = type;
    }

    public Vector getValue() {
        return this.value;
    }

    public void setValue(Vector value) {
        this.value = value;
    }

    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String string) {
        this.condition = string;
    }

    public String getElementDataType() {
        return this.fieldInfo.getElementDataType();
    }

    public void setElementDataType(String type) {
        this.fieldInfo.setElementDataType(type);
    }

    public String getAttributeDataType() {
        return this.fieldInfo.getAttributeDataType();
    }

    public void setAttributeDataType(String type) {
        this.fieldInfo.setAttributeDataType(type);
    }

    public String getAttributeName() {
        return this.fieldInfo.getAttributeName();
    }

    public void setAttributeName(String attr) {
        this.fieldInfo.setAttributeName(attr);
    }

    public String getDateFormat() {
        return this.fieldInfo.getDateFormat();
    }

    public void setDateFormat(String format) {
        this.fieldInfo.setDateFormat(format);
    }

    public int getXMLType() {
        return this.fieldInfo.getXMLType();
    }

    public void setXMLType(int type) {
        this.fieldInfo.setXMLType(type);
    }

    public Vector getInputData() {
        return this.inputData;
    }

    public void setInputData(Vector inputData) {
        this.inputData = inputData;
    }

    @Override
    public XMLFieldInfo getField(String paramName) {
        for (int i = 0; i < this.value.size(); ++i) {
            if (!(this.value.elementAt(i) instanceof QueryInParam) || !((QueryInParam)this.value.elementAt(i)).getParamName().equals(paramName)) continue;
            return this.fieldInfo;
        }
        return null;
    }

    @Override
    public boolean execute() {
        if (this.inputData == null || this.inputData.size() == 0) {
            return false;
        }
        try {
            this.isExecutable();
            if (this.conditionType == 0) {
                return this.executeEqual();
            }
            if (this.conditionType == 1) {
                return this.executeNotEqual();
            }
            if (this.conditionType == 2) {
                return this.executeGreaterThan();
            }
            if (this.conditionType == 3) {
                return this.executeGreaterThanOrEqual();
            }
            if (this.conditionType == 4) {
                return this.executeLessThan();
            }
            if (this.conditionType == 5) {
                return this.executeLessThanOrEqual();
            }
            if (this.conditionType == 6) {
                return this.executeIn();
            }
            return this.executeBetween();
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean isExecutable() throws Exception {
        if (this.value == null || this.value.size() == 0) {
            throw new Exception("There is no preset value for this node");
        }
        if (this.conditionType > 7 || this.conditionType < 0) {
            throw new Exception("Invalid Condition Type");
        }
        if (this.conditionType == 7) {
            if (this.value.size() != 2) {
                throw new Exception("BETWEEN operator has to have 2 values");
            }
        } else if (this.conditionType == 6) {
            if (this.value.size() < 1) {
                throw new Exception("IN OPERATOR need at least one value");
            }
        } else if (this.value.size() != 1) {
            throw new Exception("OPERATOR has to have one value");
        }
        return true;
    }

    private boolean compareString() {
        int xmlType = this.getXMLType();
        String eltDataType = this.getElementDataType();
        String attrDataType = this.getAttributeDataType();
        return xmlType == 1 && eltDataType.equals("string") || xmlType == 2 && attrDataType.equals("string");
    }

    private boolean compareInteger() {
        int xmlType = this.getXMLType();
        String eltDataType = this.getElementDataType();
        String attrDataType = this.getAttributeDataType();
        return xmlType == 1 && eltDataType.equals("int") || xmlType == 2 && attrDataType.equals("int");
    }

    private boolean compareDouble() {
        int xmlType = this.getXMLType();
        String eltDataType = this.getElementDataType();
        String attrDataType = this.getAttributeDataType();
        return xmlType == 1 && eltDataType.equals("double") || xmlType == 2 && attrDataType.equals("double");
    }

    private boolean compareDate() {
        int xmlType = this.getXMLType();
        String eltDataType = this.getElementDataType();
        String attrDataType = this.getAttributeDataType();
        return xmlType == 1 && eltDataType.equals("date") || xmlType == 2 && attrDataType.equals("date");
    }

    private boolean compareBoolean() {
        int xmlType = this.getXMLType();
        String eltDataType = this.getElementDataType();
        String attrDataType = this.getAttributeDataType();
        return xmlType == 1 && eltDataType.equals("boolean") || xmlType == 2 && attrDataType.equals("boolean");
    }

    private boolean executeEqual() {
        block7: {
            Object[] inputValObj;
            Object valObj;
            block10: {
                block9: {
                    block8: {
                        block6: {
                            valObj = this.value.elementAt(0);
                            if (valObj instanceof QueryInParam) {
                                valObj = ((QueryInParam)valObj).getValue() != null ? ((QueryInParam)valObj).getValue() : ((QueryInParam)valObj).getDefaultValue();
                            }
                            inputValObj = this.inputData.toArray();
                            if (!this.compareString()) break block6;
                            String val = (String)valObj;
                            for (Object element : inputValObj) {
                                if (((String)element).compareTo(val) != 0) continue;
                                return true;
                            }
                            break block7;
                        }
                        if (!this.compareInteger()) break block8;
                        int val = (Integer)valObj;
                        for (Object element : inputValObj) {
                            if ((Integer)element != val) continue;
                            return true;
                        }
                        break block7;
                    }
                    if (!this.compareDouble()) break block9;
                    double val = (Double)valObj;
                    for (Object element : inputValObj) {
                        if ((Double)element != val) continue;
                        return true;
                    }
                    break block7;
                }
                if (!this.compareDate()) break block10;
                Date val = (Date)valObj;
                for (Object element : inputValObj) {
                    if (((Date)element).compareTo(val) != 0) continue;
                    return true;
                }
                break block7;
            }
            if (!this.compareBoolean()) break block7;
            boolean val = (Boolean)valObj;
            for (Object element : inputValObj) {
                if ((Boolean)element != val) continue;
                return true;
            }
        }
        return false;
    }

    private boolean executeGreaterThan() {
        Object valObj = this.value.elementAt(0);
        if (valObj instanceof QueryInParam) {
            valObj = ((QueryInParam)valObj).getValue() != null ? ((QueryInParam)valObj).getValue() : ((QueryInParam)valObj).getDefaultValue();
        }
        Object[] inputValObj = this.inputData.toArray();
        if (this.compareString()) {
            String val = (String)valObj;
            for (Object element : inputValObj) {
                if (((String)element).compareTo(val) <= 0) continue;
                return true;
            }
        } else if (this.compareInteger()) {
            int val = (Integer)valObj;
            for (Object element : inputValObj) {
                if ((Integer)element <= val) continue;
                return true;
            }
        } else if (this.compareDouble()) {
            double val = (Double)valObj;
            for (Object element : inputValObj) {
                if (!((Double)element > val)) continue;
                return true;
            }
        } else if (this.compareDate()) {
            Date val = (Date)valObj;
            for (Object element : inputValObj) {
                if (((Date)element).compareTo(val) <= 0) continue;
                return true;
            }
        } else if (this.compareBoolean()) {
            return false;
        }
        return false;
    }

    private boolean executeNotEqual() {
        return !this.executeEqual();
    }

    private boolean executeGreaterThanOrEqual() {
        if (this.executeEqual()) {
            return true;
        }
        return this.executeGreaterThan();
    }

    private boolean executeLessThan() {
        return !this.executeGreaterThanOrEqual();
    }

    private boolean executeLessThanOrEqual() {
        return !this.executeGreaterThan();
    }

    private boolean executeIn() {
        block11: {
            Object[] inputValObj;
            Object[] valObj;
            block14: {
                block13: {
                    block12: {
                        block10: {
                            valObj = this.value.elementAt(0) instanceof QueryMultiValueInParam ? ((QueryMultiValueInParam)this.value.elementAt(0)).getValues().toArray() : this.value.toArray();
                            inputValObj = this.inputData.toArray();
                            if (!this.compareString()) break block10;
                            for (Object element : valObj) {
                                String val = (String)element;
                                for (Object element2 : inputValObj) {
                                    if (((String)element2).compareTo(val) != 0) continue;
                                    return true;
                                }
                            }
                            break block11;
                        }
                        if (!this.compareInteger()) break block12;
                        for (Object element : valObj) {
                            int val = (Integer)element;
                            for (Object element2 : inputValObj) {
                                if ((Integer)element2 != val) continue;
                                return true;
                            }
                        }
                        break block11;
                    }
                    if (!this.compareDouble()) break block13;
                    for (Object element : valObj) {
                        double val = (Double)element;
                        for (Object element2 : inputValObj) {
                            if ((Double)element2 != val) continue;
                            return true;
                        }
                    }
                    break block11;
                }
                if (!this.compareDate()) break block14;
                for (Object element : valObj) {
                    Date val = (Date)element;
                    for (Object element2 : inputValObj) {
                        if (((Date)element2).compareTo(val) != 0) continue;
                        return true;
                    }
                }
                break block11;
            }
            if (!this.compareBoolean()) break block11;
            for (Object element : valObj) {
                boolean val = (Boolean)element;
                for (Object element2 : inputValObj) {
                    if ((Boolean)element2 != val) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean executeBetween() {
        Object maxValObj;
        Object minValObj = this.value.elementAt(0);
        if (minValObj instanceof QueryInParam) {
            minValObj = ((QueryInParam)minValObj).getValue() != null ? ((QueryInParam)minValObj).getValue() : ((QueryInParam)minValObj).getDefaultValue();
        }
        if ((maxValObj = this.value.elementAt(1)) instanceof QueryInParam) {
            maxValObj = ((QueryInParam)maxValObj).getValue() != null ? ((QueryInParam)maxValObj).getValue() : ((QueryInParam)maxValObj).getDefaultValue();
        }
        Object[] inputValObj = this.inputData.toArray();
        if (this.compareString()) {
            String minVal = (String)minValObj;
            String maxVal = (String)maxValObj;
            for (Object element : inputValObj) {
                if (((String)element).compareTo(minVal) < 0 || ((String)element).compareTo(maxVal) > 0) continue;
                return true;
            }
        } else if (this.compareInteger()) {
            int minVal = (Integer)minValObj;
            int maxVal = (Integer)maxValObj;
            for (Object element : inputValObj) {
                if ((Integer)element < minVal || (Integer)element > maxVal) continue;
                return true;
            }
        } else if (this.compareDouble()) {
            double minVal = (Double)minValObj;
            double maxVal = (Double)maxValObj;
            for (Object element : inputValObj) {
                if (!((Double)element >= minVal) || !((Double)element <= maxVal)) continue;
                return true;
            }
        } else if (this.compareDate()) {
            Date minVal = (Date)minValObj;
            Date maxVal = (Date)maxValObj;
            for (Object element : inputValObj) {
                if (((Date)element).compareTo(minVal) < 0 || ((Date)element).compareTo(maxVal) > 0) continue;
                return true;
            }
        } else if (this.compareBoolean()) {
            return false;
        }
        return false;
    }
}

