/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.util.internal;

import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;

public class XMLDataTypeUtil {
    private static final Logger LOGGER = Logger.getLogger(XMLDataTypeUtil.class.getName());
    private static final int Y1900 = 1900;
    private static final int MONTHSINYEAR = 12;
    private static final int MAXDAYSINMONTH = 31;
    public static final String MM_DD_YYYY = "MM-DD-YYYY";
    public static final String MMDDYYYY = "MM/DD/YYYY";
    public static final String YYYY_MM_DD = "YYYY-MM-DD";
    public static final String YYYYMMDD = "YYYY/MM/DD";
    public static final String DD_MM_YYYY = "DD-MM-YYYY";
    public static final String DDMMYYYY = "DD/MM/YYYY";
    public static final String MM_DD_YY = "MM-DD-YY";
    public static final String MMDDYY = "MM/DD/YY";
    public static final String YY_MM_DD = "YY-MM-DD";
    public static final String YYMMDD = "YY/MM/DD";
    public static final String DD_MM_YY = "DD-MM-YY";
    public static final String DDMMYY = "DD/MM/YY";
    public static final String[] DATETYPE = new String[]{"MM-DD-YYYY", "MM/DD/YYYY", "YYYY-MM-DD", "YYYY/MM/DD", "DD-MM-YYYY", "DD/MM/YYYY", "MM-DD-YY", "MM/DD/YY", "YY-MM-DD", "YY/MM/DD", "DD-MM-YY", "DD/MM/YY"};

    public static Date getDate(String str, String format, int dataType) {
        if (format == null || str == null) {
            LOGGER.log(Level.WARNING, "XMLDataTypeUtil Not VALID");
            return null;
        }
        boolean predefined = false;
        for (int i = 0; i < DATETYPE.length && !predefined; ++i) {
            if (!DATETYPE[i].equals(format)) continue;
            predefined = true;
        }
        if (predefined) {
            int index2;
            int index1 = str.indexOf(45) > 0 ? str.indexOf(45) : str.indexOf(47);
            int n = index2 = str.lastIndexOf(45) > 0 ? str.lastIndexOf(45) : str.lastIndexOf(47);
            if (format.equals(MM_DD_YYYY) || format.equals(MMDDYYYY) || format.equals(MM_DD_YY) || format.equals(MMDDYY)) {
                int year = Integer.parseInt(str.substring(index2 + 1));
                int month = Integer.parseInt(str.substring(0, index1));
                int day = Integer.parseInt(str.substring(index1 + 1, index2));
                return XMLDataTypeUtil.getDate(year, month, day);
            }
            if (format.equals(YYYY_MM_DD) || format.equals(YYYYMMDD) || format.equals(YY_MM_DD) || format.equals(YYMMDD)) {
                int year = Integer.parseInt(str.substring(0, index1));
                int month = Integer.parseInt(str.substring(index1 + 1, index2));
                int day = Integer.parseInt(str.substring(index2 + 1));
                return XMLDataTypeUtil.getDate(year, month, day);
            }
            if (format.equals(DD_MM_YYYY) || format.equals(DDMMYYYY) || format.equals(DD_MM_YY) || format.equals(DDMMYY)) {
                int year = Integer.parseInt(str.substring(index2 + 1));
                int month = Integer.parseInt(str.substring(index1 + 1, index2));
                int day = Integer.parseInt(str.substring(0, index1));
                return XMLDataTypeUtil.getDate(year, month, day);
            }
            LOGGER.log(Level.WARNING, "Not a supported date format");
            return null;
        }
        try {
            SimpleDateFormat simpleformat = new SimpleDateFormat(format);
            Date d = simpleformat.parse(str);
            if (dataType == 91) {
                return new java.sql.Date(d.getTime());
            }
            if (dataType == 92) {
                return new Time(d.getTime());
            }
            return new Timestamp(d.getTime());
        }
        catch (ParseException ex) {
            LOGGER.log(Level.WARNING, "Problem with parsing Date.", ex);
            ex.printStackTrace();
            return null;
        }
    }

    private static java.sql.Date getDate(int year, int month, int day) {
        year = year >= 1900 ? (year -= 1900) : (year += 100);
        if (month >= 1 && month <= 12) {
            --month;
        } else {
            LOGGER.log(Level.WARNING, "MONTH is not from Jan to Dec");
        }
        if (day < 1 || day > 31) {
            LOGGER.log(Level.WARNING, "DAY is not within 1 to 31");
        }
        return new java.sql.Date(year, month, day);
    }
}

