/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.util.internal;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;
import quadbase.common.util.internal.XMLConditionType;
import quadbase.common.util.internal.XMLFieldInfo;

public class XMLDefaultTreeNode
implements XMLConditionType,
Cloneable {
    protected XMLDefaultTreeNode parent = null;
    protected Vector children;
    protected boolean allowsChildren = true;
    protected Object userObject;
    public static final Enumeration EMPTY_ENUMERATION = new Enumeration(){

        @Override
        public boolean hasMoreElements() {
            return false;
        }

        public Object nextElement() {
            throw new NoSuchElementException("No more elements");
        }
    };

    public XMLDefaultTreeNode() {
        this(null);
    }

    public XMLDefaultTreeNode(Object userObject) {
        this.userObject = userObject;
    }

    public XMLDefaultTreeNode(Object userObject, boolean allowsChildren) {
        this.userObject = userObject;
        this.allowsChildren = allowsChildren;
    }

    public boolean execute() {
        return true;
    }

    public boolean isExecutable() throws Exception {
        return true;
    }

    public void insert(XMLDefaultTreeNode newChild, int childIndex) {
        if (newChild == null) {
            throw new IllegalArgumentException("new child is null");
        }
        XMLDefaultTreeNode oldParent = newChild.getParent();
        if (oldParent != null) {
            oldParent.remove(newChild);
        }
        newChild.setParent(this);
        if (this.children == null) {
            this.children = new Vector();
        }
        this.children.insertElementAt(newChild, childIndex);
    }

    public void remove(int childIndex) {
        XMLDefaultTreeNode child = this.getChildAt(childIndex);
        this.children.removeElementAt(childIndex);
        child.setParent(null);
    }

    public void setParent(XMLDefaultTreeNode newParent) {
        this.parent = newParent;
    }

    public XMLDefaultTreeNode getParent() {
        return this.parent;
    }

    public XMLDefaultTreeNode getChildAt(int index) {
        if (this.children == null || index > this.children.size()) {
            throw new ArrayIndexOutOfBoundsException("node has no children");
        }
        return (XMLDefaultTreeNode)this.children.elementAt(index);
    }

    public int getChildCount() {
        if (this.children == null) {
            return 0;
        }
        return this.children.size();
    }

    public int getIndex(XMLDefaultTreeNode aChild) {
        if (aChild == null) {
            throw new IllegalArgumentException("argument is null");
        }
        if (!this.isNodeChild(aChild)) {
            return -1;
        }
        return this.children.indexOf(aChild);
    }

    public boolean isNodeChild(XMLDefaultTreeNode aNode) {
        boolean retval = aNode == null ? false : (this.getChildCount() == 0 ? false : aNode.getParent() == this);
        return retval;
    }

    public Enumeration children() {
        if (this.children == null) {
            return EMPTY_ENUMERATION;
        }
        return this.children.elements();
    }

    public boolean getAllowsChildren() {
        return this.allowsChildren;
    }

    public void setName(String userObject) {
        this.userObject = userObject;
    }

    public String getName() {
        return this.userObject.toString();
    }

    public void removeFromParent() {
        XMLDefaultTreeNode parent = this.getParent();
        if (parent != null) {
            parent.remove(this);
        }
    }

    public void remove(XMLDefaultTreeNode aChild) {
        if (aChild == null) {
            throw new IllegalArgumentException("argument is null");
        }
        if (!this.isNodeChild(aChild)) {
            throw new IllegalArgumentException("argument is not a child");
        }
        this.remove(this.getIndex(aChild));
    }

    public void removeAllChildren() {
        for (int i = this.getChildCount() - 1; i >= 0; --i) {
            this.remove(i);
        }
    }

    public void add(XMLDefaultTreeNode newChild) {
        if (newChild != null && newChild.getParent() == this) {
            this.insert(newChild, this.getChildCount() - 1);
        } else {
            this.insert(newChild, this.getChildCount());
        }
    }

    public boolean isRoot() {
        return this.getParent() == null;
    }

    public XMLDefaultTreeNode getFirstChild() {
        if (this.getChildCount() == 0) {
            throw new NoSuchElementException("node has no children");
        }
        return this.getChildAt(0);
    }

    public XMLDefaultTreeNode getLastChild() {
        if (this.getChildCount() == 0) {
            throw new NoSuchElementException("node has no children");
        }
        return this.getChildAt(this.getChildCount() - 1);
    }

    public boolean isLeaf() {
        return this.getChildCount() == 0;
    }

    public String toString() {
        return this.userObject.toString();
    }

    public Object clone() {
        XMLDefaultTreeNode newNode = null;
        try {
            newNode = (XMLDefaultTreeNode)super.clone();
            newNode.children = this.children;
            newNode.parent = this.parent;
        }
        catch (CloneNotSupportedException e) {
            throw new Error(e.toString());
        }
        return newNode;
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public void setUserObject(Object userObj) {
        this.userObject = userObj;
    }

    public XMLFieldInfo getField(String paramName) {
        return null;
    }
}

