/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.util.internal;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import quadbase.common.paramquery.QueryInParamSet;
import quadbase.common.util.IQueryInParam;
import quadbase.common.util.internal.Coder;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.XMLFieldInfo;
import quadbase.common.util.internal.XMLUtil;

public class XMLFileQueryInfo {
    private String fileName;
    private String condition;
    private XMLFieldInfo[] fieldInfo;
    private XMLFieldInfo[] conditionInfo;
    private String dtdName = null;
    private boolean verify = false;
    private byte[] data;
    private byte[] dtd;
    private QueryInParamSet inSet;
    private String dtdTreeFileName;
    public static final String XMLTAG = "XMLFILEQUERYINFO";
    public static final int VERSION = 8;

    public XMLFileQueryInfo(String fileName, XMLFieldInfo[] fieldInfo, String condition, XMLFieldInfo[] conditionInfo) {
        this(fileName, fieldInfo, condition, conditionInfo, null, false, null);
    }

    public XMLFileQueryInfo(String fileName, XMLFieldInfo[] fieldInfo, String condition, XMLFieldInfo[] conditionInfo, QueryInParamSet inSet) {
        this(fileName, fieldInfo, condition, conditionInfo, null, false, inSet);
    }

    public XMLFileQueryInfo(String fileName, XMLFieldInfo[] fieldInfo, String condition, XMLFieldInfo[] conditionInfo, String dtdName, boolean verify) {
        this(fileName, fieldInfo, condition, conditionInfo, dtdName, verify, null);
    }

    public XMLFileQueryInfo(String fileName, XMLFieldInfo[] fieldInfo, String condition, XMLFieldInfo[] conditionInfo, String dtdName, boolean verify, QueryInParamSet inSet) {
        this(fileName, fieldInfo, condition, conditionInfo, dtdName, verify, inSet, null);
    }

    public XMLFileQueryInfo(String fileName, XMLFieldInfo[] fieldInfo, String condition, XMLFieldInfo[] conditionInfo, String dtdName, boolean verify, QueryInParamSet inSet, String dtdTreeFileName) {
        this.fileName = fileName;
        this.fieldInfo = fieldInfo != null ? fieldInfo : new XMLFieldInfo[0];
        this.condition = condition;
        this.conditionInfo = conditionInfo != null ? conditionInfo : new XMLFieldInfo[0];
        this.dtdName = dtdName;
        this.verify = verify;
        this.data = null;
        this.inSet = inSet;
        this.dtdTreeFileName = dtdTreeFileName;
    }

    public XMLFileQueryInfo(ByteArrayInputStream bstream, XMLFieldInfo[] fieldInfo, String condition, XMLFieldInfo[] conditionInfo) {
        this(bstream, fieldInfo, condition, conditionInfo, (String)null, false, null);
    }

    public XMLFileQueryInfo(ByteArrayInputStream bstream, XMLFieldInfo[] fieldInfo, String condition, XMLFieldInfo[] conditionInfo, QueryInParamSet inSet) {
        this(bstream, fieldInfo, condition, conditionInfo, (String)null, false, inSet);
    }

    public XMLFileQueryInfo(ByteArrayInputStream bstream, XMLFieldInfo[] fieldInfo, String condition, XMLFieldInfo[] conditionInfo, String dtdName, boolean verify) {
        this(bstream, fieldInfo, condition, conditionInfo, dtdName, verify, null);
    }

    public XMLFileQueryInfo(ByteArrayInputStream bstream, XMLFieldInfo[] fieldInfo, String condition, XMLFieldInfo[] conditionInfo, String dtdName, boolean verify, QueryInParamSet inSet) {
        this(bstream, fieldInfo, condition, conditionInfo, dtdName, verify, inSet, null);
    }

    public XMLFileQueryInfo(ByteArrayInputStream bstream, XMLFieldInfo[] fieldInfo, String condition, XMLFieldInfo[] conditionInfo, String dtdName, boolean verify, QueryInParamSet inSet, String dtdTreeFileName) {
        this.fileName = null;
        this.fieldInfo = fieldInfo != null ? fieldInfo : new XMLFieldInfo[0];
        this.condition = condition;
        this.conditionInfo = conditionInfo != null ? conditionInfo : new XMLFieldInfo[0];
        this.dtdName = dtdName;
        this.verify = verify;
        this.inSet = inSet;
        this.dtdTreeFileName = dtdTreeFileName;
        this.data = new byte[bstream.available()];
        bstream.read(this.data, 0, bstream.available());
    }

    public XMLFileQueryInfo(InputStream datastream, XMLFieldInfo[] fieldInfo, String condition, XMLFieldInfo[] conditionInfo, InputStream dtdstream, boolean verify, QueryInParamSet inSet) {
        this(datastream, fieldInfo, condition, conditionInfo, dtdstream, verify, inSet, null);
    }

    public XMLFileQueryInfo(InputStream datastream, XMLFieldInfo[] fieldInfo, String condition, XMLFieldInfo[] conditionInfo, InputStream dtdstream, boolean verify, QueryInParamSet inSet, String dtdTreeFileName) {
        this.fileName = null;
        this.fieldInfo = fieldInfo != null ? fieldInfo : new XMLFieldInfo[0];
        this.condition = condition;
        this.conditionInfo = conditionInfo != null ? conditionInfo : new XMLFieldInfo[0];
        this.verify = verify;
        this.inSet = inSet;
        this.dtdTreeFileName = dtdTreeFileName;
        try {
            this.data = new byte[datastream.available()];
            datastream.read(this.data, 0, datastream.available());
            this.dtd = new byte[dtdstream.available()];
            dtdstream.read(this.dtd, 0, dtdstream.available());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public XMLFileQueryInfo(byte[] data, XMLFieldInfo[] fieldInfo, String condition, XMLFieldInfo[] conditionInfo, byte[] dtd, boolean verify, QueryInParamSet inSet) {
        this(data, fieldInfo, condition, conditionInfo, dtd, verify, inSet, null);
    }

    public XMLFileQueryInfo(byte[] data, XMLFieldInfo[] fieldInfo, String condition, XMLFieldInfo[] conditionInfo, byte[] dtd, boolean verify, QueryInParamSet inSet, String dtdTreeFileName) {
        this.fileName = null;
        this.fieldInfo = fieldInfo != null ? fieldInfo : new XMLFieldInfo[0];
        this.condition = condition;
        this.conditionInfo = conditionInfo != null ? conditionInfo : new XMLFieldInfo[0];
        this.verify = verify;
        this.inSet = inSet;
        this.dtdTreeFileName = dtdTreeFileName;
        this.data = data;
        this.dtd = dtd;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String f) {
        this.fileName = f;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] barray) {
        this.data = barray;
    }

    public XMLFieldInfo[] getFieldInfo() {
        return this.fieldInfo;
    }

    public void setFieldInfo(XMLFieldInfo[] fields) {
        this.fieldInfo = fields;
    }

    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String cond) {
        this.condition = cond;
    }

    public XMLFieldInfo[] getConditionInfo() {
        return this.conditionInfo;
    }

    public String getDTDName() {
        return this.dtdName;
    }

    public void setDTDName(String f) {
        this.dtdName = f;
    }

    public byte[] getDTD() {
        return this.dtd;
    }

    public void setDTD(byte[] b) {
        this.dtd = b;
    }

    public boolean isVerify() {
        return this.verify;
    }

    public void setVerify(boolean state) {
        this.verify = state;
    }

    public QueryInParamSet getInSet() {
        return this.inSet;
    }

    public IQueryInParam[] getInParam() {
        if (this.inSet == null) {
            return null;
        }
        return this.inSet.getParameter();
    }

    public IQueryInParam[][] getParameterInPromptSequence() {
        if (this.inSet == null) {
            return null;
        }
        return this.inSet.getParameterInPromptSequence();
    }

    public void setInSet(QueryInParamSet inSet) {
        this.inSet = inSet;
    }

    public XMLFieldInfo getFieldInfo(String pathStr) {
        String s;
        for (XMLFieldInfo element : this.fieldInfo) {
            s = element.getColumnName();
            if (!s.equals(pathStr)) continue;
            return element;
        }
        for (XMLFieldInfo element : this.conditionInfo) {
            s = element.getColumnName();
            if (!s.equals(pathStr)) continue;
            return element;
        }
        return null;
    }

    public String getDTDTreeFileName() {
        return this.dtdTreeFileName;
    }

    public void setDTDTreeFileName(String f) {
        this.dtdTreeFileName = f;
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(8);
        out.writeInt(6612);
        out.writeInt(2);
        if (this.fileName != null) {
            out.writeBoolean(true);
            IOUtil.writeString(out, Coder.encode(this.fileName));
        } else {
            out.writeBoolean(false);
            out.writeInt(this.data.length);
            for (byte element : this.data) {
                out.writeByte(element);
            }
        }
        IOUtil.writeStr(out, this.condition);
        out.writeInt(this.fieldInfo.length);
        for (XMLFieldInfo element : this.fieldInfo) {
            element.write(out, true);
        }
        out.writeInt(this.conditionInfo.length);
        for (XMLFieldInfo element : this.conditionInfo) {
            element.write(out, true);
        }
        boolean bl = this.inSet != null;
        out.writeBoolean(bl);
        if (bl) {
            this.inSet.write(out);
        }
        if (this.dtdName != null) {
            out.writeBoolean(true);
            IOUtil.writeString(out, Coder.encode(this.dtdName));
        } else {
            out.writeBoolean(false);
            int len = this.dtd == null ? 0 : this.dtd.length;
            out.writeInt(len);
            for (int i = 0; i < len; ++i) {
                out.writeByte(this.dtd[i]);
            }
        }
        out.writeBoolean(this.verify);
        IOUtil.writeStr(out, this.dtdTreeFileName);
    }

    public static XMLFileQueryInfo read(DataInput in) throws IOException {
        boolean hasInSet;
        int in_version = in.readInt();
        int chart_version = 0;
        if (in_version >= 6) {
            chart_version = in.readInt();
        }
        int in_xmlVersion = in.readInt();
        boolean fromFile = true;
        if (in_version >= 4) {
            fromFile = in.readBoolean();
        }
        String in_fileName = null;
        byte[] in_data = null;
        if (fromFile) {
            in_fileName = Coder.decode(IOUtil.readString(in, true));
        } else {
            int in_size = in.readInt();
            in_data = new byte[in_size];
            for (int i = 0; i < in_size; ++i) {
                in_data[i] = in.readByte();
            }
        }
        String in_condition = IOUtil.readStr(in);
        XMLFieldInfo[] in_fieldInfo = new XMLFieldInfo[in.readInt()];
        for (int i = 0; i < in_fieldInfo.length; ++i) {
            in_fieldInfo[i] = XMLFieldInfo.createXMLFieldInfo(in, in_xmlVersion, true);
        }
        XMLFieldInfo[] in_condInfo = new XMLFieldInfo[in.readInt()];
        for (int i = 0; i < in_condInfo.length; ++i) {
            in_condInfo[i] = XMLFieldInfo.createXMLFieldInfo(in, in_xmlVersion, true);
        }
        QueryInParamSet in_inSet = null;
        if (in_version >= 5 && (hasInSet = in.readBoolean())) {
            in_inSet = QueryInParamSet.read(in, chart_version);
        }
        String in_dtdName = null;
        byte[] in_dtdData = null;
        boolean in_verify = false;
        if (in_version > 6) {
            fromFile = in.readBoolean();
            if (fromFile) {
                in_dtdName = Coder.decode(IOUtil.readString(in, true));
            } else {
                int in_size = in.readInt();
                in_dtdData = new byte[in_size];
                for (int i = 0; i < in_size; ++i) {
                    in_dtdData[i] = in.readByte();
                }
            }
            in_verify = in.readBoolean();
        } else if (in_version > 2) {
            in_dtdName = IOUtil.readStr(in);
            in_verify = in.readBoolean();
        }
        String in_dtdTreeFileName = null;
        if (in_version > 7) {
            in_dtdTreeFileName = IOUtil.readStr(in);
        }
        if (in_fileName != null) {
            return new XMLFileQueryInfo(in_fileName, in_fieldInfo, in_condition, in_condInfo, in_dtdName, in_verify, in_inSet, in_dtdTreeFileName);
        }
        if (in_dtdName != null) {
            return new XMLFileQueryInfo(new ByteArrayInputStream(in_data), in_fieldInfo, in_condition, in_condInfo, in_dtdName, in_verify, in_inSet, in_dtdTreeFileName);
        }
        return new XMLFileQueryInfo((InputStream)new ByteArrayInputStream(in_data), in_fieldInfo, in_condition, in_condInfo, new ByteArrayInputStream(in_dtdData), in_verify, in_inSet);
    }

    static void write(Writer dout, String str) throws IOException {
        dout.write(str);
    }

    public void writeXML(Writer dout) throws IOException {
        XMLFileQueryInfo.write(dout, "<XMLFILEQUERYINFO>\n");
        if (this.fileName != null) {
            XMLFileQueryInfo.write(dout, "<FILENAME>" + XMLUtil.encodeXML(this.fileName) + "</FILENAME>\n");
        }
        if (this.data != null) {
            XMLFieldInfo[] xmlContent = IOUtil.convertString(this.data);
            XMLFileQueryInfo.write(dout, "<XMLCONTENTDATA>" + XMLUtil.encodeXML((String)xmlContent) + "</XMLCONTENTDATA>\n");
        }
        XMLFileQueryInfo.write(dout, "<CONDITION>" + XMLUtil.encodeXML(this.condition) + "</CONDITION>\n");
        XMLFileQueryInfo.write(dout, "<FIELDCOUNT>" + this.fieldInfo.length + "</FIELDCOUNT>\n");
        for (XMLFieldInfo element : this.fieldInfo) {
            element.writeXML(dout);
        }
        XMLFileQueryInfo.write(dout, "<CONDFIELDCOUNT>" + this.conditionInfo.length + "</CONDFIELDCOUNT>\n");
        for (XMLFieldInfo element : this.conditionInfo) {
            element.writeXML(dout);
        }
        if (this.inSet != null) {
            this.inSet.writeXML(dout);
        }
        if (this.dtdName != null) {
            XMLFileQueryInfo.write(dout, "<DTDNAME>" + XMLUtil.encodeXML(this.dtdName) + "</DTDNAME>\n");
        } else if (this.dtd != null) {
            String dtdContent = IOUtil.convertString(this.dtd);
            XMLFileQueryInfo.write(dout, "<DTDCONTENTDATA>" + XMLUtil.encodeXML(dtdContent) + "</DTDCONTENTDATA>\n");
        }
        XMLFileQueryInfo.write(dout, "<VERIFY>" + this.verify + "</VERIFY>\n");
        XMLFileQueryInfo.write(dout, "<DTDTREEFILENAME>" + XMLUtil.encodeXML(this.dtdTreeFileName) + "</DTDTREEFILENAME>\n");
        XMLFileQueryInfo.write(dout, "</XMLFILEQUERYINFO>\n");
    }

    public static XMLFileQueryInfo readXML(Node dnode, int version) throws Exception {
        if (dnode.getNodeName().equalsIgnoreCase(XMLTAG)) {
            int count = 0;
            int index = 0;
            int condCount = 0;
            int condIndex = 0;
            String filename = null;
            byte[] data = null;
            byte[] dtd = null;
            String condition = null;
            XMLFieldInfo[] fields = null;
            XMLFieldInfo[] condFields = null;
            String dtdName = null;
            boolean verify = false;
            QueryInParamSet inSet = null;
            String dtdTreeFileName = null;
            NodeList nodeList = dnode.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (node.getNodeName().equalsIgnoreCase("FILENAME")) {
                    filename = XMLUtil.readText(node);
                    continue;
                }
                if (node.getNodeName().equalsIgnoreCase("XMLCONTENTDATA")) {
                    data = IOUtil.convertByte(XMLUtil.readText(node));
                    continue;
                }
                if (node.getNodeName().equalsIgnoreCase("CONDITION")) {
                    condition = XMLUtil.readText(node);
                    continue;
                }
                if (node.getNodeName().equalsIgnoreCase("DTDTREEFILENAME")) {
                    dtdTreeFileName = XMLUtil.readText(node);
                    continue;
                }
                if (node.getNodeName().equalsIgnoreCase("FIELDCOUNT")) {
                    count = Integer.parseInt(XMLUtil.readText(node));
                    continue;
                }
                if (node.getNodeName().equalsIgnoreCase("CONDFIELDCOUNT")) {
                    condCount = Integer.parseInt(XMLUtil.readText(node));
                    continue;
                }
                if (node.getNodeName().equalsIgnoreCase("XMLFIELDINFO")) {
                    if (fields == null) {
                        fields = new XMLFieldInfo[count];
                    }
                    if (index < fields.length) {
                        fields[index] = XMLFieldInfo.readXML(node, version);
                        ++index;
                        continue;
                    }
                    if (condFields == null) {
                        condFields = new XMLFieldInfo[condCount];
                    }
                    condFields[condIndex] = XMLFieldInfo.readXML(node, version);
                    ++condIndex;
                    continue;
                }
                if (node.getNodeName().equalsIgnoreCase("DTDNAME")) {
                    dtdName = XMLUtil.readText(node);
                    continue;
                }
                if (node.getNodeName().equalsIgnoreCase("DTDCONTENTDATA")) {
                    dtd = IOUtil.convertByte(XMLUtil.readText(node));
                    continue;
                }
                if (node.getNodeName().equalsIgnoreCase("VERIFY")) {
                    verify = XMLUtil.parseBoolean(XMLUtil.readText(node));
                    continue;
                }
                if (!node.getNodeName().equalsIgnoreCase("QUERY_PARAMETER_SET")) continue;
                inSet = QueryInParamSet.readXML(node, 0);
            }
            if (filename != null) {
                return new XMLFileQueryInfo(filename, fields, condition, condFields, dtdName, verify, inSet);
            }
            if (data != null && dtdName != null) {
                return new XMLFileQueryInfo(new ByteArrayInputStream(data), fields, condition, condFields, dtdName, verify, inSet, dtdTreeFileName);
            }
            if (data != null && dtd != null) {
                return new XMLFileQueryInfo((InputStream)new ByteArrayInputStream(data), fields, condition, condFields, new ByteArrayInputStream(dtd), verify, inSet, dtdTreeFileName);
            }
            return null;
        }
        return null;
    }
}

