/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.util.internal;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import quadbase.common.client.ServerMessage;
import quadbase.common.network.IConnection;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.XMLVerifierHandler;

public class XMLVerifier {
    public static final int DTD = 0;
    public static final int SCHEMA = 1;
    private String xmlFile;
    private String externalFile;
    private int type;
    ServerMessage sm;

    public XMLVerifier(String xFile, int type, String exFile) {
        this.xmlFile = xFile;
        this.type = type;
        this.externalFile = exFile;
        this.xmlFile = this.xmlFile.replace('\\', '/');
        this.externalFile = this.externalFile.replace('\\', '/');
    }

    public String verify() {
        String msg = null;
        if (!ServerMessage.useServer && ServerMessage.isLoadBalancer) {
            XMLVerifierHandler handle = new XMLVerifierHandler(this.xmlFile, this.type, this.externalFile);
            msg = handle.verify();
            return msg;
        }
        IConnection socket = null;
        try {
            socket = ServerMessage.createConnection();
            ByteArrayOutputStream bstream = new ByteArrayOutputStream(1024);
            DataOutputStream out = new DataOutputStream(bstream);
            out.writeShort(32419);
            IOUtil.writeString(out, this.xmlFile);
            out.writeInt(this.type);
            IOUtil.writeString(out, this.externalFile);
            byte[] array = bstream.toByteArray();
            socket.setContentLength(array.length);
            socket.getOutputStream().write(array);
            socket.getOutputStream().flush();
            DataInputStream din = new DataInputStream(socket.getInputStream());
            int code = din.readInt();
            if (code != 0) {
                msg = IOUtil.readString(din, true);
            }
            socket.close();
        }
        catch (Exception ex) {
            try {
                if (socket != null) {
                    socket.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            msg = ex.getMessage();
        }
        return msg;
    }
}

