/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.util.output;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import quadbase.common.util.output.Chunk;
import quadbase.common.util.output.DocumentException;
import quadbase.common.util.output.Element;
import quadbase.common.util.output.ElementListener;
import quadbase.common.util.output.FontFactory;
import quadbase.common.util.output.ListItem;
import quadbase.common.util.output.MarkupAttributes;
import quadbase.common.util.output.TextElementArray;

public class List
implements TextElementArray,
MarkupAttributes {
    protected ArrayList list = new ArrayList();
    protected boolean numbered;
    protected boolean lettered;
    protected int first = 1;
    protected char firstCh = (char)65;
    protected char lastCh = (char)90;
    protected Chunk symbol = new Chunk("-");
    protected float indentationLeft = 0.0f;
    protected float indentationRight = 0.0f;
    protected int symbolIndent;
    protected Properties markupAttributes;

    public List(boolean numbered, int symbolIndent) {
        this.numbered = numbered;
        this.lettered = false;
        this.symbolIndent = symbolIndent;
    }

    public List(boolean numbered, boolean lettered, int symbolIndent) {
        this.numbered = numbered;
        this.lettered = lettered;
        this.symbolIndent = symbolIndent;
    }

    public List(Properties attributes) {
        String value = (String)attributes.remove("listsymbol");
        if (value == null) {
            value = "-";
        }
        this.symbol = new Chunk(value, FontFactory.getFont(attributes));
        this.numbered = false;
        value = (String)attributes.remove("numbered");
        if (value != null) {
            this.numbered = Boolean.valueOf(value);
            if (this.lettered && this.numbered) {
                this.lettered = false;
            }
        }
        if ((value = (String)attributes.remove("lettered")) != null) {
            this.lettered = Boolean.valueOf(value);
            if (this.numbered && this.lettered) {
                this.numbered = false;
            }
        }
        this.symbolIndent = 0;
        value = (String)attributes.remove("symbolindent");
        if (value != null) {
            this.symbolIndent = Integer.parseInt(value);
        }
        if ((value = (String)attributes.remove("first")) != null) {
            char khar = value.charAt(0);
            if (Character.isLetter(khar)) {
                this.setFirst(khar);
            } else {
                this.setFirst(Integer.parseInt(value));
            }
        }
        if ((value = (String)attributes.remove("indentationleft")) != null) {
            this.setIndentationLeft(Float.valueOf(value + "f").floatValue());
        }
        if ((value = (String)attributes.remove("indentationright")) != null) {
            this.setIndentationRight(Float.valueOf(value + "f").floatValue());
        }
        if (attributes.size() > 0) {
            this.setMarkupAttributes(attributes);
        }
    }

    @Override
    public boolean process(ElementListener listener) {
        try {
            Iterator i = this.list.iterator();
            while (i.hasNext()) {
                listener.add((Element)i.next());
            }
            return true;
        }
        catch (DocumentException de) {
            return false;
        }
    }

    @Override
    public int type() {
        return 14;
    }

    @Override
    public ArrayList getChunks() {
        ArrayList tmp = new ArrayList();
        Iterator i = this.list.iterator();
        while (i.hasNext()) {
            tmp.addAll(((Element)i.next()).getChunks());
        }
        return tmp;
    }

    @Override
    public boolean add(Object o) {
        if (o instanceof ListItem) {
            ListItem item = (ListItem)o;
            if (this.numbered || this.lettered) {
                Chunk chunk = this.numbered ? new Chunk(String.valueOf(this.first + this.list.size()), this.symbol.font()) : new Chunk(this.nextLetter(), this.symbol.font());
                chunk.append(".");
                item.setListSymbol(chunk);
            } else {
                item.setListSymbol(this.symbol);
            }
            item.setIndentationLeft(this.symbolIndent);
            item.setIndentationRight(0.0f);
            this.list.add(item);
        } else {
            if (o instanceof List) {
                List nested = (List)o;
                nested.setIndentationLeft(nested.indentationLeft() + (float)this.symbolIndent);
                --this.first;
                return this.list.add(nested);
            }
            if (o instanceof String) {
                return this.add(new ListItem((String)o));
            }
        }
        return false;
    }

    public void setIndentationLeft(float indentation) {
        this.indentationLeft = indentation;
    }

    public void setIndentationRight(float indentation) {
        this.indentationRight = indentation;
    }

    public void setFirst(int first) {
        this.first = first;
    }

    public void setFirst(char first) {
        this.firstCh = first;
        this.lastCh = Character.isLowerCase(this.firstCh) ? (char)122 : (char)90;
    }

    public void setListSymbol(Chunk symbol) {
        this.symbol = symbol;
    }

    public void setListSymbol(String symbol) {
        this.symbol = new Chunk(symbol);
    }

    public ArrayList getItems() {
        return this.list;
    }

    public int size() {
        return this.list.size();
    }

    public float leading() {
        if (this.list.size() < 1) {
            return -1.0f;
        }
        ListItem item = (ListItem)this.list.get(0);
        return item.leading();
    }

    public boolean isNumbered() {
        return this.numbered;
    }

    public int symbolIndent() {
        return this.symbolIndent;
    }

    public Chunk symbol() {
        return this.symbol;
    }

    public int first() {
        return this.first;
    }

    public float indentationLeft() {
        return this.indentationLeft;
    }

    public float indentationRight() {
        return this.indentationRight;
    }

    public static boolean isSymbol(String tag) {
        return "listsymbol".equals(tag);
    }

    public static boolean isTag(String tag) {
        return "list".equals(tag);
    }

    private String nextLetter() {
        int ival;
        int num_in_list = this.list.size();
        int max_ival = this.lastCh + '\u0000';
        for (ival = this.firstCh + num_in_list; ival > max_ival; ival -= 26) {
        }
        char[] new_char = new char[]{(char)ival};
        String ret = new String(new_char);
        return ret;
    }

    @Override
    public void setMarkupAttribute(String name, String value) {
        this.markupAttributes = this.markupAttributes == null ? new Properties() : this.markupAttributes;
        this.markupAttributes.put(name, value);
    }

    @Override
    public void setMarkupAttributes(Properties markupAttributes) {
        this.markupAttributes = markupAttributes;
    }

    @Override
    public String getMarkupAttribute(String name) {
        return this.markupAttributes == null ? null : String.valueOf(this.markupAttributes.get(name));
    }

    @Override
    public Set getMarkupAttributeNames() {
        return Chunk.getKeySet(this.markupAttributes);
    }

    @Override
    public Properties getMarkupAttributes() {
        return this.markupAttributes;
    }
}

