/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.util.output;

import java.util.Properties;
import quadbase.common.util.output.Chunk;
import quadbase.common.util.output.Font;
import quadbase.common.util.output.FontFactory;
import quadbase.common.util.output.MarkupAttributes;
import quadbase.common.util.output.Paragraph;
import quadbase.common.util.output.Phrase;
import quadbase.common.util.output.TextElementArray;
import quadbase.common.util.output.markup.MarkupParser;

public class ListItem
extends Paragraph
implements TextElementArray,
MarkupAttributes {
    private Chunk symbol;

    public ListItem() {
    }

    public ListItem(float leading) {
        super(leading);
    }

    public ListItem(Chunk chunk) {
        super(chunk);
    }

    public ListItem(String string) {
        super(string);
    }

    public ListItem(String string, Font font) {
        super(string, font);
    }

    public ListItem(float leading, Chunk chunk) {
        super(leading, chunk);
    }

    public ListItem(float leading, String string) {
        super(leading, string);
    }

    public ListItem(float leading, String string, Font font) {
        super(leading, string, font);
    }

    public ListItem(Phrase phrase) {
        super(phrase);
    }

    public ListItem(Properties attributes) {
        super("", FontFactory.getFont(attributes));
        String value = (String)attributes.remove("itext");
        if (value != null) {
            this.add(new Chunk(value));
        }
        if ((value = (String)attributes.remove("leading")) != null) {
            this.setLeading(Float.valueOf(value + "f").floatValue());
        } else {
            value = (String)attributes.remove("line-height");
            if (value != null) {
                this.setLeading(MarkupParser.parseLength((String)value));
            }
        }
        value = (String)attributes.remove("indentationleft");
        if (value != null) {
            this.setIndentationLeft(Float.valueOf(value + "f").floatValue());
        }
        if ((value = (String)attributes.remove("indentationright")) != null) {
            this.setIndentationRight(Float.valueOf(value + "f").floatValue());
        }
        if ((value = (String)attributes.remove("align")) != null) {
            this.setAlignment(value);
        }
        if (attributes.size() > 0) {
            this.setMarkupAttributes(attributes);
        }
    }

    @Override
    public int type() {
        return 15;
    }

    public void setListSymbol(Chunk symbol) {
        this.symbol = symbol;
        if (this.symbol.font().isStandardFont()) {
            this.symbol.setFont(this.font);
        }
    }

    public Chunk listSymbol() {
        return this.symbol;
    }

    public static boolean isTag(String tag) {
        return "listitem".equals(tag);
    }
}

