/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.util.output;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import quadbase.common.util.output.BadElementException;
import quadbase.common.util.output.Element;
import quadbase.common.util.output.Image;

public class Png
extends Image
implements Element {
    public static final int[] PNGID = new int[]{137, 80, 78, 71, 13, 10, 26, 10};
    public static final String IHDR = "IHDR";
    public static final String PLTE = "PLTE";
    public static final String IDAT = "IDAT";
    public static final String IEND = "IEND";
    public static final String tRNS = "tRNS";
    public static final String pHYs = "pHYs";

    Png(Image image) {
        super(image);
    }

    public Png(URL url) throws BadElementException, IOException {
        super(url);
        this.processParameters();
    }

    @Deprecated
    public Png(URL url, float width, float height) throws BadElementException, IOException {
        this(url);
        this.scaledWidth = width;
        this.scaledHeight = height;
    }

    @Deprecated
    public Png(String filename) throws MalformedURLException, BadElementException, IOException {
        this(Image.toURL(filename));
    }

    @Deprecated
    public Png(String filename, float width, float height) throws MalformedURLException, BadElementException, IOException {
        this(Image.toURL(filename), width, height);
    }

    public Png(byte[] img) throws BadElementException, IOException {
        super((URL)null);
        this.rawData = img;
        this.processParameters();
    }

    public Png(byte[] img, float width, float height) throws BadElementException, IOException {
        this(img);
        this.scaledWidth = width;
        this.scaledHeight = height;
    }

    public static final int getInt(InputStream is) throws IOException {
        return (is.read() << 24) + (is.read() << 16) + (is.read() << 8) + is.read();
    }

    public static final int getWord(InputStream is) throws IOException {
        return (is.read() << 8) + is.read();
    }

    public static final String getString(InputStream is) throws IOException {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < 4; ++i) {
            buf.append((char)is.read());
        }
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processParameters() throws BadElementException, IOException {
        this.type = 33;
        InputStream is = null;
        try {
            String errorID;
            if (this.rawData == null) {
                is = this.url.openStream();
                errorID = this.url.toString();
            } else {
                is = new ByteArrayInputStream(this.rawData);
                errorID = "Byte array";
            }
            for (int element : PNGID) {
                if (element == is.read()) continue;
                throw new BadElementException(errorID + " is not a valid PNG-file.");
            }
            while (true) {
                int len = Png.getInt(is);
                String id = Png.getString(is);
                if (IHDR.equals(id)) {
                    this.scaledWidth = Png.getInt(is);
                    this.setRight(this.scaledWidth);
                    this.scaledHeight = Png.getInt(is);
                    this.setTop(this.scaledHeight);
                    Png.skip(is, len + 4 - 8);
                    continue;
                }
                if (pHYs.equals(id)) {
                    int dx = Png.getInt(is);
                    int dy = Png.getInt(is);
                    int unit = is.read();
                    if (unit == 1) {
                        this.dpiX = (int)((float)dx * 0.0254f + 0.5f);
                        this.dpiY = (int)((float)dy * 0.0254f + 0.5f);
                    }
                    Png.skip(is, len + 4 - 9);
                    continue;
                }
                if (IDAT.equals(id)) break;
                if (IEND.equals(id)) {
                    break;
                }
                Png.skip(is, len + 4);
            }
        }
        finally {
            if (is != null) {
                is.close();
            }
            this.plainWidth = this.width();
            this.plainHeight = this.height();
        }
    }
}

