/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.util.output.pdf;

import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import quadbase.common.util.output.DocumentException;
import quadbase.common.util.output.Rectangle;
import quadbase.common.util.output.pdf.CMYKColor;
import quadbase.common.util.output.pdf.DocumentFont;
import quadbase.common.util.output.pdf.FdfReader;
import quadbase.common.util.output.pdf.GrayColor;
import quadbase.common.util.output.pdf.PRIndirectReference;
import quadbase.common.util.output.pdf.PRTokeniser;
import quadbase.common.util.output.pdf.PdfAppearance;
import quadbase.common.util.output.pdf.PdfArray;
import quadbase.common.util.output.pdf.PdfBoolean;
import quadbase.common.util.output.pdf.PdfDictionary;
import quadbase.common.util.output.pdf.PdfEncodings;
import quadbase.common.util.output.pdf.PdfName;
import quadbase.common.util.output.pdf.PdfNumber;
import quadbase.common.util.output.pdf.PdfObject;
import quadbase.common.util.output.pdf.PdfReader;
import quadbase.common.util.output.pdf.PdfString;
import quadbase.common.util.output.pdf.PdfWriter;
import quadbase.common.util.output.pdf.TextField;

public class AcroFields {
    PdfReader reader;
    PdfWriter writer;
    HashMap fields;
    private int topFirst;
    private boolean generateAppearances = true;

    AcroFields(PdfReader reader, PdfWriter writer) {
        this.reader = reader;
        this.writer = writer;
        this.fill();
    }

    void fill() {
        this.fields = new HashMap();
        PdfDictionary top = (PdfDictionary)PdfReader.getPdfObject(this.reader.getCatalog().get(PdfName.ACROFORM));
        for (int k = 1; k <= this.reader.getNumberOfPages(); ++k) {
            PdfDictionary page = this.reader.getPageN(k);
            PdfArray annots = (PdfArray)PdfReader.getPdfObject(page.get(PdfName.ANNOTS));
            if (annots == null) continue;
            ArrayList arr = annots.getArrayList();
            for (int j = 0; j < arr.size(); ++j) {
                Item item;
                PdfDictionary annot = (PdfDictionary)PdfReader.getPdfObject((PdfObject)arr.get(j));
                if (!PdfName.WIDGET.equals(annot.get(PdfName.SUBTYPE))) continue;
                PdfDictionary widget = annot;
                PdfDictionary dic = new PdfDictionary();
                dic.putAll(annot);
                String name = "";
                PdfDictionary value = null;
                PdfObject lastV = null;
                while (annot != null) {
                    dic.mergeDifferent(annot);
                    PdfString t = (PdfString)annot.get(PdfName.T);
                    if (t != null) {
                        name = t.toUnicodeString() + "." + name;
                    }
                    if (lastV == null && annot.get(PdfName.V) != null) {
                        lastV = annot.get(PdfName.V);
                    }
                    if (value == null && t != null) {
                        value = annot;
                        if (annot.get(PdfName.V) == null && lastV != null) {
                            value.put(PdfName.V, lastV);
                        }
                    }
                    annot = (PdfDictionary)PdfReader.getPdfObject(annot.get(PdfName.PARENT));
                }
                if (name.length() > 0) {
                    name = name.substring(0, name.length() - 1);
                }
                if ((item = (Item)this.fields.get(name)) == null) {
                    item = new Item();
                    this.fields.put(name, item);
                }
                if (value == null) {
                    item.values.add(widget);
                } else {
                    item.values.add(value);
                }
                item.widgets.add(widget);
                if (top != null) {
                    dic.mergeDifferent(top);
                }
                item.merged.add(dic);
                item.page.add(k);
            }
        }
    }

    PdfAppearance getAppearance(PdfDictionary merged, String text) throws IOException, DocumentException {
        PdfDictionary bs;
        PdfDictionary mk;
        this.topFirst = 0;
        TextField tx = new TextField(this.writer, null, null);
        PdfString da = (PdfString)PdfReader.getPdfObject(merged.get(PdfName.DA));
        if (da != null) {
            PRIndirectReference iref;
            PdfDictionary font;
            PRTokeniser tk = new PRTokeniser(PdfEncodings.convertToBytes(da.toUnicodeString(), null));
            ArrayList<String> stack = new ArrayList<String>();
            String fontName = null;
            while (tk.nextToken()) {
                if (tk.getTokenType() == 4) continue;
                if (tk.getTokenType() == 10) {
                    String operator = tk.getStringValue();
                    if (operator.equals("Tf")) {
                        if (stack.size() >= 2) {
                            fontName = (String)stack.get(stack.size() - 2);
                            tx.setFontSize(Float.parseFloat((String)stack.get(stack.size() - 1)));
                        }
                    } else if (operator.equals("g")) {
                        float gray;
                        if (stack.size() >= 1 && (gray = Float.parseFloat((String)stack.get(stack.size() - 1))) != 0.0f) {
                            tx.setTextColor(new GrayColor(gray));
                        }
                    } else if (operator.equals("rg")) {
                        if (stack.size() >= 3) {
                            float red = Float.parseFloat((String)stack.get(stack.size() - 3));
                            float green = Float.parseFloat((String)stack.get(stack.size() - 2));
                            float blue = Float.parseFloat((String)stack.get(stack.size() - 1));
                            tx.setTextColor(new Color(red, green, blue));
                        }
                    } else if (operator.equals("k") && stack.size() >= 4) {
                        float cyan = Float.parseFloat((String)stack.get(stack.size() - 4));
                        float magenta = Float.parseFloat((String)stack.get(stack.size() - 3));
                        float yellow = Float.parseFloat((String)stack.get(stack.size() - 2));
                        float black = Float.parseFloat((String)stack.get(stack.size() - 1));
                        tx.setTextColor(new CMYKColor(cyan, magenta, yellow, black));
                    }
                    stack.clear();
                    continue;
                }
                stack.add(tk.getStringValue());
            }
            if (fontName != null && (font = (PdfDictionary)PdfReader.getPdfObject(merged.get(PdfName.DR))) != null && (font = (PdfDictionary)PdfReader.getPdfObject(font.get(PdfName.FONT))) != null && (iref = (PRIndirectReference)font.get(new PdfName(fontName))) != null) {
                tx.setFont(new DocumentFont(iref));
            }
        }
        if ((mk = (PdfDictionary)PdfReader.getPdfObject(merged.get(PdfName.MK))) != null) {
            PdfArray ar = (PdfArray)PdfReader.getPdfObject(mk.get(PdfName.BC));
            tx.setBorderColor(this.getMKColor(ar));
            ar = (PdfArray)PdfReader.getPdfObject(mk.get(PdfName.BG));
            tx.setBackgroundColor(this.getMKColor(ar));
            PdfNumber rotation = (PdfNumber)PdfReader.getPdfObject(mk.get(PdfName.R));
            if (rotation != null) {
                tx.setRotation(rotation.intValue());
            }
        }
        int flags = 0;
        PdfNumber nfl = (PdfNumber)PdfReader.getPdfObject(merged.get(PdfName.FF));
        if (nfl != null) {
            flags = nfl.intValue();
        }
        tx.setOptions((flags & 0x1000) == 0 ? 0 : 4);
        nfl = (PdfNumber)PdfReader.getPdfObject(merged.get(PdfName.Q));
        if (nfl != null) {
            if (nfl.intValue() == 1) {
                tx.setAlignment(1);
            } else if (nfl.intValue() == 2) {
                tx.setAlignment(2);
            }
        }
        if ((bs = (PdfDictionary)PdfReader.getPdfObject(merged.get(PdfName.BS))) != null) {
            PdfName s;
            PdfNumber w = (PdfNumber)PdfReader.getPdfObject(bs.get(PdfName.W));
            if (w != null) {
                tx.setBorderWidth(w.floatValue());
            }
            if (PdfName.D.equals(s = (PdfName)PdfReader.getPdfObject(bs.get(PdfName.S)))) {
                tx.setBorderStyle(1);
            } else if (PdfName.B.equals(s)) {
                tx.setBorderStyle(2);
            } else if (PdfName.I.equals(s)) {
                tx.setBorderStyle(3);
            } else if (PdfName.U.equals(s)) {
                tx.setBorderStyle(4);
            }
        } else {
            PdfArray bd = (PdfArray)PdfReader.getPdfObject(merged.get(PdfName.BORDER));
            if (bd != null) {
                ArrayList ar = bd.getArrayList();
                if (ar.size() >= 3) {
                    tx.setBorderWidth(((PdfNumber)ar.get(2)).floatValue());
                }
                if (ar.size() >= 4) {
                    tx.setBorderStyle(1);
                }
            }
        }
        PdfArray rect = (PdfArray)PdfReader.getPdfObject(merged.get(PdfName.RECT));
        Rectangle box = PdfReader.getNormalizedRectangle(rect);
        if (tx.getRotation() == 90 || tx.getRotation() == 270) {
            box = box.rotate();
        }
        tx.setBox(box);
        PdfName fieldType = (PdfName)PdfReader.getPdfObject(merged.get(PdfName.FT));
        if (PdfName.TX.equals(fieldType)) {
            PdfNumber maxLen = (PdfNumber)PdfReader.getPdfObject(merged.get(PdfName.MAXLEN));
            int len = 0;
            if (maxLen != null) {
                len = maxLen.intValue();
            }
            if (len > 0) {
                text = text.substring(0, Math.min(len, text.length()));
            }
            tx.setText(text);
            return tx.getAppearance();
        }
        if (!PdfName.CH.equals(fieldType)) {
            throw new DocumentException("An appearance was requested without a variable text field.");
        }
        if ((flags & 0x20000) != 0) {
            tx.setText(text);
            return tx.getAppearance();
        }
        PdfArray opt = (PdfArray)PdfReader.getPdfObject(merged.get(PdfName.OPT));
        boolean arrsize = false;
        if (opt != null) {
            ArrayList op = opt.getArrayList();
            String[] choices = new String[op.size()];
            String[] choicesExp = new String[op.size()];
            for (int k = 0; k < op.size(); ++k) {
                PdfObject obj = (PdfObject)op.get(k);
                if (obj.type() == 3) {
                    choices[k] = choicesExp[k] = ((PdfString)obj).toUnicodeString();
                    continue;
                }
                ArrayList opar = ((PdfArray)obj).getArrayList();
                choicesExp[k] = ((PdfString)opar.get(0)).toUnicodeString();
                choices[k] = ((PdfString)opar.get(1)).toUnicodeString();
            }
            int idx = 0;
            for (int k = 0; k < choices.length; ++k) {
                if (!text.equals(choices[k])) continue;
                idx = k;
                break;
            }
            tx.setChoices(choices);
            tx.setChoiceExports(choicesExp);
            tx.setChoiceSelection(idx);
        }
        PdfAppearance app = tx.getListAppearance();
        this.topFirst = tx.getTopFirst();
        return app;
    }

    Color getMKColor(PdfArray ar) {
        if (ar == null) {
            return null;
        }
        ArrayList cc = ar.getArrayList();
        switch (cc.size()) {
            case 1: {
                return new GrayColor(((PdfNumber)cc.get(0)).floatValue());
            }
            case 3: {
                return new Color(((PdfNumber)cc.get(0)).floatValue(), ((PdfNumber)cc.get(1)).floatValue(), ((PdfNumber)cc.get(2)).floatValue());
            }
            case 4: {
                return new CMYKColor(((PdfNumber)cc.get(0)).floatValue(), ((PdfNumber)cc.get(1)).floatValue(), ((PdfNumber)cc.get(2)).floatValue(), ((PdfNumber)cc.get(3)).floatValue());
            }
        }
        return null;
    }

    public String getField(String name) {
        Item item = (Item)this.fields.get(name);
        if (item == null) {
            return null;
        }
        PdfObject v = PdfReader.getPdfObject(((PdfDictionary)item.merged.get(0)).get(PdfName.V));
        if (v == null) {
            return "";
        }
        if (v.type() == 3) {
            return ((PdfString)v).toUnicodeString();
        }
        return PdfName.decodeName(v.toString());
    }

    public void setFields(FdfReader fdf) throws IOException, DocumentException {
        HashMap fd = fdf.getFields();
        for (String f : this.fields.keySet()) {
            String v = fdf.getFieldValue(f);
            if (v == null) continue;
            this.setField(f, v);
        }
    }

    public boolean setField(String name, String value) throws IOException, DocumentException {
        return this.setField(name, value, value);
    }

    public boolean setField(String name, String value, String display) throws IOException, DocumentException {
        Item item = (Item)this.fields.get(name);
        if (item == null) {
            return false;
        }
        PdfName type = (PdfName)PdfReader.getPdfObject(((PdfDictionary)item.merged.get(0)).get(PdfName.FT));
        if (PdfName.TX.equals(type) || PdfName.CH.equals(type)) {
            PdfString v = new PdfString(value, "UnicodeBig");
            for (int idx = 0; idx < item.values.size(); ++idx) {
                ((PdfDictionary)item.values.get(idx)).put(PdfName.V, v);
                PdfDictionary merged = (PdfDictionary)item.merged.get(idx);
                merged.put(PdfName.V, v);
                PdfDictionary widget = (PdfDictionary)item.widgets.get(idx);
                if (this.generateAppearances) {
                    PdfDictionary appDic;
                    PdfAppearance app = this.getAppearance(merged, display);
                    if (PdfName.CH.equals(type)) {
                        PdfNumber n = new PdfNumber(this.topFirst);
                        widget.put(PdfName.TI, n);
                        merged.put(PdfName.TI, n);
                    }
                    if ((appDic = (PdfDictionary)PdfReader.getPdfObject(widget.get(PdfName.AP))) == null) {
                        appDic = new PdfDictionary();
                        widget.put(PdfName.AP, appDic);
                        merged.put(PdfName.AP, appDic);
                    }
                    appDic.put(PdfName.N, app.getIndirectReference());
                    continue;
                }
                widget.remove(PdfName.AP);
                merged.remove(PdfName.AP);
            }
            return true;
        }
        if (PdfName.BTN.equals(type)) {
            PdfNumber ff = (PdfNumber)PdfReader.getPdfObject(((PdfDictionary)item.merged.get(0)).get(PdfName.FF));
            int flags = 0;
            if (ff != null) {
                flags = ff.intValue();
            }
            if ((flags & 0x10000) != 0) {
                return true;
            }
            PdfName v = new PdfName(value);
            if ((flags & 0x8000) == 0) {
                for (int idx = 0; idx < item.values.size(); ++idx) {
                    ((PdfDictionary)item.values.get(idx)).put(PdfName.V, v);
                    PdfDictionary merged = (PdfDictionary)item.merged.get(idx);
                    merged.put(PdfName.V, v);
                    merged.put(PdfName.AS, v);
                    PdfDictionary widget = (PdfDictionary)item.widgets.get(idx);
                    widget.put(PdfName.AS, v);
                }
            } else {
                for (int idx = 0; idx < item.values.size(); ++idx) {
                    ((PdfDictionary)item.values.get(idx)).put(PdfName.V, v);
                    PdfDictionary merged = (PdfDictionary)item.merged.get(idx);
                    PdfDictionary widget = (PdfDictionary)item.widgets.get(idx);
                    merged.put(PdfName.V, v);
                    if (this.isInAP(widget, v)) {
                        merged.put(PdfName.AS, v);
                        widget.put(PdfName.AS, v);
                        continue;
                    }
                    merged.put(PdfName.AS, PdfName.OFF);
                    widget.put(PdfName.AS, PdfName.OFF);
                }
            }
            return true;
        }
        return false;
    }

    boolean isInAP(PdfDictionary dic, PdfName check) {
        PdfDictionary appDic = (PdfDictionary)PdfReader.getPdfObject(dic.get(PdfName.AP));
        if (appDic == null) {
            return false;
        }
        PdfDictionary NDic = (PdfDictionary)PdfReader.getPdfObject(appDic.get(PdfName.N));
        return NDic != null && NDic.get(check) != null;
    }

    public HashMap getFields() {
        return this.fields;
    }

    public boolean isGenerateAppearances() {
        return this.generateAppearances;
    }

    public void setGenerateAppearances(boolean generateAppearances) {
        this.generateAppearances = generateAppearances;
        PdfDictionary top = (PdfDictionary)PdfReader.getPdfObject(this.reader.getCatalog().get(PdfName.ACROFORM));
        if (generateAppearances) {
            top.remove(PdfName.NEEDAPPEARANCES);
        } else {
            top.put(PdfName.NEEDAPPEARANCES, PdfBoolean.PDFTRUE);
        }
    }

    public class Item {
        public ArrayList values = new ArrayList();
        public ArrayList widgets = new ArrayList();
        public ArrayList merged = new ArrayList();
        public ArrayList page = new ArrayList();
    }
}

