/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.util.output.pdf;

import java.awt.Color;
import quadbase.common.util.output.ExceptionConverter;
import quadbase.common.util.output.Rectangle;
import quadbase.common.util.output.pdf.Barcode;
import quadbase.common.util.output.pdf.BaseFont;
import quadbase.common.util.output.pdf.PdfContentByte;

public class Barcode128
extends Barcode {
    static byte[][] BARS = new byte[][]{{2, 1, 2, 2, 2, 2}, {2, 2, 2, 1, 2, 2}, {2, 2, 2, 2, 2, 1}, {1, 2, 1, 2, 2, 3}, {1, 2, 1, 3, 2, 2}, {1, 3, 1, 2, 2, 2}, {1, 2, 2, 2, 1, 3}, {1, 2, 2, 3, 1, 2}, {1, 3, 2, 2, 1, 2}, {2, 2, 1, 2, 1, 3}, {2, 2, 1, 3, 1, 2}, {2, 3, 1, 2, 1, 2}, {1, 1, 2, 2, 3, 2}, {1, 2, 2, 1, 3, 2}, {1, 2, 2, 2, 3, 1}, {1, 1, 3, 2, 2, 2}, {1, 2, 3, 1, 2, 2}, {1, 2, 3, 2, 2, 1}, {2, 2, 3, 2, 1, 1}, {2, 2, 1, 1, 3, 2}, {2, 2, 1, 2, 3, 1}, {2, 1, 3, 2, 1, 2}, {2, 2, 3, 1, 1, 2}, {3, 1, 2, 1, 3, 1}, {3, 1, 1, 2, 2, 2}, {3, 2, 1, 1, 2, 2}, {3, 2, 1, 2, 2, 1}, {3, 1, 2, 2, 1, 2}, {3, 2, 2, 1, 1, 2}, {3, 2, 2, 2, 1, 1}, {2, 1, 2, 1, 2, 3}, {2, 1, 2, 3, 2, 1}, {2, 3, 2, 1, 2, 1}, {1, 1, 1, 3, 2, 3}, {1, 3, 1, 1, 2, 3}, {1, 3, 1, 3, 2, 1}, {1, 1, 2, 3, 1, 3}, {1, 3, 2, 1, 1, 3}, {1, 3, 2, 3, 1, 1}, {2, 1, 1, 3, 1, 3}, {2, 3, 1, 1, 1, 3}, {2, 3, 1, 3, 1, 1}, {1, 1, 2, 1, 3, 3}, {1, 1, 2, 3, 3, 1}, {1, 3, 2, 1, 3, 1}, {1, 1, 3, 1, 2, 3}, {1, 1, 3, 3, 2, 1}, {1, 3, 3, 1, 2, 1}, {3, 1, 3, 1, 2, 1}, {2, 1, 1, 3, 3, 1}, {2, 3, 1, 1, 3, 1}, {2, 1, 3, 1, 1, 3}, {2, 1, 3, 3, 1, 1}, {2, 1, 3, 1, 3, 1}, {3, 1, 1, 1, 2, 3}, {3, 1, 1, 3, 2, 1}, {3, 3, 1, 1, 2, 1}, {3, 1, 2, 1, 1, 3}, {3, 1, 2, 3, 1, 1}, {3, 3, 2, 1, 1, 1}, {3, 1, 4, 1, 1, 1}, {2, 2, 1, 4, 1, 1}, {4, 3, 1, 1, 1, 1}, {1, 1, 1, 2, 2, 4}, {1, 1, 1, 4, 2, 2}, {1, 2, 1, 1, 2, 4}, {1, 2, 1, 4, 2, 1}, {1, 4, 1, 1, 2, 2}, {1, 4, 1, 2, 2, 1}, {1, 1, 2, 2, 1, 4}, {1, 1, 2, 4, 1, 2}, {1, 2, 2, 1, 1, 4}, {1, 2, 2, 4, 1, 1}, {1, 4, 2, 1, 1, 2}, {1, 4, 2, 2, 1, 1}, {2, 4, 1, 2, 1, 1}, {2, 2, 1, 1, 1, 4}, {4, 1, 3, 1, 1, 1}, {2, 4, 1, 1, 1, 2}, {1, 3, 4, 1, 1, 1}, {1, 1, 1, 2, 4, 2}, {1, 2, 1, 1, 4, 2}, {1, 2, 1, 2, 4, 1}, {1, 1, 4, 2, 1, 2}, {1, 2, 4, 1, 1, 2}, {1, 2, 4, 2, 1, 1}, {4, 1, 1, 2, 1, 2}, {4, 2, 1, 1, 1, 2}, {4, 2, 1, 2, 1, 1}, {2, 1, 2, 1, 4, 1}, {2, 1, 4, 1, 2, 1}, {4, 1, 2, 1, 2, 1}, {1, 1, 1, 1, 4, 3}, {1, 1, 1, 3, 4, 1}, {1, 3, 1, 1, 4, 1}, {1, 1, 4, 1, 1, 3}, {1, 1, 4, 3, 1, 1}, {4, 1, 1, 1, 1, 3}, {4, 1, 1, 3, 1, 1}, {1, 1, 3, 1, 4, 1}, {1, 1, 4, 1, 3, 1}, {3, 1, 1, 1, 4, 1}, {4, 1, 1, 1, 3, 1}, {2, 1, 1, 4, 1, 2}, {2, 1, 1, 2, 1, 4}, {2, 1, 1, 2, 3, 2}};
    static byte[] BARS_STOP = new byte[]{2, 3, 3, 1, 1, 1, 2};
    public static final char CODE_AB_TO_C = 'c';
    public static final char CODE_AC_TO_B = 'd';
    public static final char CODE_BC_TO_A = 'e';
    public static final char FNC1 = 'f';
    public static final char START_A = 'g';
    public static final char START_B = 'h';
    public static final char START_C = 'i';

    public Barcode128() {
        try {
            this.x = 0.8f;
            this.font = BaseFont.createFont("Helvetica", "winansi", false);
            this.baseline = this.size = 8.0f;
            this.barHeight = this.size * 3.0f;
            this.textAlignment = 1;
            this.codeType = 9;
        }
        catch (Exception e) {
            throw new ExceptionConverter(e);
        }
    }

    static boolean isNextDigits(String text, int textIndex, int numDigits) {
        if (textIndex + numDigits > text.length()) {
            return false;
        }
        while (numDigits-- > 0) {
            char c;
            if ((c = text.charAt(textIndex++)) >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }

    static String getPackedRawDigits(String text, int textIndex, int numDigits) {
        String out = "";
        while (numDigits > 0) {
            numDigits -= 2;
            int c1 = text.charAt(textIndex++) - 48;
            int c2 = text.charAt(textIndex++) - 48;
            out = out + (char)(c1 * 10 + c2);
        }
        return out;
    }

    public static String getRawText(String text, boolean ucc) {
        String out = "";
        int tLen = text.length();
        if (tLen == 0) {
            out = out + 'h';
            if (ucc) {
                out = out + 'f';
            }
            return out;
        }
        char c = '\u0000';
        for (int k = 0; k < tLen; ++k) {
            c = text.charAt(k);
            if (c <= '\u007f') continue;
            throw new RuntimeException("There are illegal characters for barcode 128 in '" + text + "'.");
        }
        c = text.charAt(0);
        int currentCode = 104;
        int index = 0;
        if (Barcode128.isNextDigits(text, index, 2)) {
            currentCode = 105;
            out = out + (char)currentCode;
            if (ucc) {
                out = out + 'f';
            }
            out = out + Barcode128.getPackedRawDigits(text, index, 2);
            index += 2;
        } else if (c < ' ') {
            currentCode = 103;
            out = out + (char)currentCode;
            if (ucc) {
                out = out + 'f';
            }
            out = out + (char)(c + 64);
            ++index;
        } else {
            out = out + (char)currentCode;
            if (ucc) {
                out = out + 'f';
            }
            out = out + (char)(c - 32);
            ++index;
        }
        while (index < tLen) {
            switch (currentCode) {
                case 103: {
                    if (Barcode128.isNextDigits(text, index, 4)) {
                        currentCode = 105;
                        out = out + 'c';
                        out = out + Barcode128.getPackedRawDigits(text, index, 4);
                        index += 4;
                        break;
                    }
                    if ((c = text.charAt(index++)) > '_') {
                        currentCode = 104;
                        out = out + 'd';
                        out = out + (char)(c - 32);
                        break;
                    }
                    if (c < ' ') {
                        out = out + (char)(c + 64);
                        break;
                    }
                    out = out + (char)(c - 32);
                    break;
                }
                case 104: {
                    if (Barcode128.isNextDigits(text, index, 4)) {
                        currentCode = 105;
                        out = out + 'c';
                        out = out + Barcode128.getPackedRawDigits(text, index, 4);
                        index += 4;
                        break;
                    }
                    if ((c = text.charAt(index++)) < ' ') {
                        currentCode = 103;
                        out = out + 'e';
                        out = out + (char)(c + 64);
                        break;
                    }
                    out = out + (char)(c - 32);
                    break;
                }
                case 105: {
                    if (Barcode128.isNextDigits(text, index, 2)) {
                        out = out + Barcode128.getPackedRawDigits(text, index, 2);
                        index += 2;
                        break;
                    }
                    if ((c = text.charAt(index++)) < ' ') {
                        currentCode = 103;
                        out = out + 'e';
                        out = out + (char)(c + 64);
                        break;
                    }
                    currentCode = 104;
                    out = out + 'd';
                    out = out + (char)(c - 32);
                }
            }
        }
        return out;
    }

    public static byte[] getBarsCode128Raw(String text) {
        int k;
        int idx = text.indexOf(65535);
        if (idx >= 0) {
            text = text.substring(0, idx);
        }
        int chk = text.charAt(0);
        for (int k2 = 1; k2 < text.length(); ++k2) {
            chk += k2 * text.charAt(k2);
        }
        text = text + (char)(chk %= 103);
        byte[] bars = new byte[(text.length() + 1) * 6 + 7];
        for (k = 0; k < text.length(); ++k) {
            System.arraycopy(BARS[text.charAt(k)], 0, bars, k * 6, 6);
        }
        System.arraycopy(BARS_STOP, 0, bars, k * 6, 7);
        return bars;
    }

    @Override
    public Rectangle getBarcodeSize() {
        int idx;
        String fullCode;
        float fontX = 0.0f;
        float fontY = 0.0f;
        if (this.font != null) {
            fontY = this.baseline > 0.0f ? this.baseline - this.font.getFontDescriptor(3, this.size) : -this.baseline + this.size;
            fullCode = this.code;
            if (this.codeType == 11) {
                idx = this.code.indexOf(65535);
                fullCode = idx < 0 ? "" : this.code.substring(idx + 1);
            }
            fontX = this.font.getWidthPoint(fullCode, this.size);
        }
        fullCode = this.codeType == 11 ? ((idx = this.code.indexOf(65535)) >= 0 ? this.code.substring(0, idx) : this.code) : Barcode128.getRawText(this.code, this.codeType == 10);
        int len = fullCode.length();
        float fullWidth = (float)((len + 2) * 11) * this.x + 2.0f * this.x;
        fullWidth = Math.max(fullWidth, fontX);
        float fullHeight = this.barHeight + fontY;
        return new Rectangle(fullWidth, fullHeight);
    }

    @Override
    public Rectangle placeBarcode(PdfContentByte cb, Color barColor, Color textColor) {
        int idx;
        String fullCode = this.code;
        if (this.codeType == 11) {
            int idx2 = this.code.indexOf(65535);
            fullCode = idx2 < 0 ? "" : this.code.substring(idx2 + 1);
        }
        float fontX = 0.0f;
        if (this.font != null) {
            fontX = this.font.getWidthPoint(fullCode, this.size);
        }
        String bCode = this.codeType == 11 ? ((idx = this.code.indexOf(65535)) >= 0 ? this.code.substring(0, idx) : this.code) : Barcode128.getRawText(this.code, this.codeType == 10);
        int len = bCode.length();
        float fullWidth = (float)((len + 2) * 11) * this.x + 2.0f * this.x;
        float barStartX = 0.0f;
        float textStartX = 0.0f;
        switch (this.textAlignment) {
            case 0: {
                break;
            }
            case 2: {
                if (fontX > fullWidth) {
                    barStartX = fontX - fullWidth;
                    break;
                }
                textStartX = fullWidth - fontX;
                break;
            }
            default: {
                if (fontX > fullWidth) {
                    barStartX = (fontX - fullWidth) / 2.0f;
                    break;
                }
                textStartX = (fullWidth - fontX) / 2.0f;
            }
        }
        float barStartY = 0.0f;
        float textStartY = 0.0f;
        if (this.font != null) {
            if (this.baseline <= 0.0f) {
                textStartY = this.barHeight - this.baseline;
            } else {
                textStartY = -this.font.getFontDescriptor(3, this.size);
                barStartY = textStartY + this.baseline;
            }
        }
        byte[] bars = Barcode128.getBarsCode128Raw(bCode);
        boolean print = true;
        if (barColor != null) {
            cb.setColorFill(barColor);
        }
        for (int k = 0; k < bars.length; ++k) {
            float w = (float)bars[k] * this.x;
            if (print) {
                cb.rectangle(barStartX, barStartY, w, this.barHeight);
            }
            print = !print;
            barStartX += w;
        }
        cb.fill();
        if (this.font != null) {
            if (textColor != null) {
                cb.setColorFill(textColor);
            }
            cb.beginText();
            cb.setFontAndSize(this.font, this.size);
            cb.setTextMatrix(textStartX, textStartY);
            cb.showText(fullCode);
            cb.endText();
        }
        return this.getBarcodeSize();
    }
}

