/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.util.output.pdf;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import quadbase.common.util.output.Document;
import quadbase.common.util.output.DocumentException;
import quadbase.common.util.output.pdf.BadPdfFormatException;
import quadbase.common.util.output.pdf.PRIndirectReference;
import quadbase.common.util.output.pdf.PRStream;
import quadbase.common.util.output.pdf.PdfAnnotation;
import quadbase.common.util.output.pdf.PdfArray;
import quadbase.common.util.output.pdf.PdfBoolean;
import quadbase.common.util.output.pdf.PdfContents;
import quadbase.common.util.output.pdf.PdfDictionary;
import quadbase.common.util.output.pdf.PdfDocument;
import quadbase.common.util.output.pdf.PdfException;
import quadbase.common.util.output.pdf.PdfImage;
import quadbase.common.util.output.pdf.PdfImportedPage;
import quadbase.common.util.output.pdf.PdfIndirectObject;
import quadbase.common.util.output.pdf.PdfIndirectReference;
import quadbase.common.util.output.pdf.PdfLiteral;
import quadbase.common.util.output.pdf.PdfName;
import quadbase.common.util.output.pdf.PdfObject;
import quadbase.common.util.output.pdf.PdfOutline;
import quadbase.common.util.output.pdf.PdfPage;
import quadbase.common.util.output.pdf.PdfReader;
import quadbase.common.util.output.pdf.PdfReaderInstance;
import quadbase.common.util.output.pdf.PdfStream;
import quadbase.common.util.output.pdf.PdfWriter;

public class PdfCopy
extends PdfWriter {
    protected HashMap indirects;
    protected HashMap indirectMap;
    protected int currentObjectNum = 1;
    protected PdfReader reader;
    protected PdfIndirectReference acroForm;
    protected PdfIndirectReference topPageParent;

    public PdfCopy(Document document, OutputStream os) throws DocumentException {
        super(new PdfDocument(), os);
        document.addDocListener(this.pdf);
        this.pdf.addWriter(this);
        this.indirectMap = new HashMap();
    }

    @Override
    public void open() {
        super.open();
        this.topPageParent = this.getPdfIndirectReference();
        this.root.setLinearMode(this.topPageParent);
    }

    @Override
    public PdfImportedPage getImportedPage(PdfReader reader, int pageNumber) {
        if (this.currentPdfReaderInstance != null) {
            if (this.currentPdfReaderInstance.getReader() != reader) {
                try {
                    this.currentPdfReaderInstance.getReaderFile().close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.currentPdfReaderInstance = reader.getPdfReaderInstance(this);
            }
        } else {
            this.currentPdfReaderInstance = reader.getPdfReaderInstance(this);
        }
        return this.currentPdfReaderInstance.getImportedPage(pageNumber);
    }

    protected PdfIndirectReference copyIndirect(PRIndirectReference in) throws IOException, BadPdfFormatException {
        PdfIndirectReference theRef;
        RefKey key = new RefKey(in);
        IndirectReferences iRef = (IndirectReferences)this.indirects.get(key);
        if (iRef != null) {
            theRef = iRef.getRef();
            if (iRef.getCopied()) {
                return theRef;
            }
        } else {
            theRef = this.body.getPdfIndirectReference();
            iRef = new IndirectReferences(theRef);
            this.indirects.put(key, iRef);
        }
        iRef.setCopied();
        PdfObject obj = this.copyObject(PdfReader.getPdfObject(in));
        PdfIndirectObject theObj = this.body.add(obj, theRef);
        return theRef;
    }

    protected PdfDictionary copyDictionary(PdfDictionary in) throws IOException, BadPdfFormatException {
        PdfDictionary out = new PdfDictionary();
        PdfName type = (PdfName)in.get(PdfName.TYPE);
        for (PdfName key : in.getKeys()) {
            PdfObject value = in.get(key);
            if (key.equals(PdfName.PARENT) && type != null && type.equals(PdfName.PAGE)) {
                out.put(PdfName.PARENT, this.topPageParent);
                continue;
            }
            out.put(key, this.copyObject(value));
        }
        return out;
    }

    protected PdfStream copyStream(PRStream in) throws IOException, BadPdfFormatException {
        PRStream out = new PRStream(in.getReader(), in.getOffset());
        out.setLength(in.getLength());
        for (PdfName key : in.getKeys()) {
            PdfObject value = in.get(key);
            out.put(key, this.copyObject(value));
        }
        return out;
    }

    protected PdfArray copyArray(PdfArray in) throws IOException, BadPdfFormatException {
        PdfArray out = new PdfArray();
        for (PdfObject value : in.getArrayList()) {
            out.add(this.copyObject(value));
        }
        return out;
    }

    protected PdfObject copyObject(PdfObject in) throws IOException, BadPdfFormatException {
        switch (in.type) {
            case 6: {
                return this.copyDictionary((PdfDictionary)in);
            }
            case 10: {
                return this.copyIndirect((PRIndirectReference)in);
            }
            case 5: {
                return this.copyArray((PdfArray)in);
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: {
                return in;
            }
            case 7: {
                return this.copyStream((PRStream)in);
            }
        }
        if (in.type < 0) {
            String lit = ((PdfLiteral)in).toString();
            if (lit.equals("true") || lit.equals("false")) {
                return new PdfBoolean(lit);
            }
            return new PdfLiteral(lit);
        }
        System.out.println("CANNOT COPY type " + in.type);
        return null;
    }

    protected int setFromIPage(PdfImportedPage iPage) {
        int pageNum = iPage.getPageNumber();
        PdfReaderInstance inst = this.currentPdfReaderInstance = iPage.getPdfReaderInstance();
        this.reader = inst.getReader();
        this.setFromReader(this.reader);
        return pageNum;
    }

    protected void setFromReader(PdfReader reader) {
        this.reader = reader;
        this.indirects = (HashMap)this.indirectMap.get(reader);
        if (this.indirects == null) {
            this.indirects = new HashMap();
            this.indirectMap.put(reader, this.indirects);
            PdfDictionary catalog = reader.getCatalog();
            PRIndirectReference ref = (PRIndirectReference)catalog.get(PdfName.PAGES);
            this.indirects.put(new RefKey(ref), new IndirectReferences(this.topPageParent));
            ref = (PRIndirectReference)catalog.get(PdfName.ACROFORM);
            if (ref != null) {
                if (this.acroForm == null) {
                    this.acroForm = this.body.getPdfIndirectReference();
                }
                this.indirects.put(new RefKey(ref), new IndirectReferences(this.acroForm));
            }
        }
    }

    public void addPage(PdfImportedPage iPage) throws IOException, BadPdfFormatException {
        PdfIndirectReference pageRef;
        int pageNum = this.setFromIPage(iPage);
        PdfDictionary thePage = this.reader.getPageN(pageNum);
        PRIndirectReference origRef = this.reader.getPageOrigRef(pageNum);
        RefKey key = new RefKey(origRef);
        IndirectReferences iRef = (IndirectReferences)this.indirects.get(key);
        if (iRef != null) {
            pageRef = iRef.getRef();
        } else {
            pageRef = this.body.getPdfIndirectReference();
            iRef = new IndirectReferences(pageRef);
            this.indirects.put(key, iRef);
        }
        this.pageReferences.add(pageRef);
        ++this.currentPageNumber;
        if (!iRef.getCopied()) {
            iRef.setCopied();
            PdfDictionary newPage = this.copyDictionary(thePage);
            newPage.put(PdfName.PARENT, this.topPageParent);
            PdfIndirectObject pdfIndirectObject = this.body.add((PdfObject)newPage, pageRef);
        }
        this.root.addPage(pageRef);
    }

    public void copyAcroForm(PdfReader reader) throws IOException, BadPdfFormatException {
        PdfIndirectReference myRef;
        this.setFromReader(reader);
        PdfDictionary catalog = reader.getCatalog();
        PRIndirectReference hisRef = (PRIndirectReference)catalog.get(PdfName.ACROFORM);
        RefKey key = new RefKey(hisRef);
        IndirectReferences iRef = (IndirectReferences)this.indirects.get(key);
        if (iRef != null) {
            this.acroForm = myRef = iRef.getRef();
        } else {
            this.acroForm = myRef = this.body.getPdfIndirectReference();
            iRef = new IndirectReferences(myRef);
            this.indirects.put(key, iRef);
        }
        if (!iRef.getCopied()) {
            iRef.setCopied();
            PdfDictionary theForm = this.copyDictionary((PdfDictionary)PdfReader.getPdfObject(hisRef));
            PdfIndirectObject pdfIndirectObject = this.body.add((PdfObject)theForm, myRef);
        }
    }

    @Override
    protected PdfDictionary getCatalog(PdfIndirectReference rootObj) {
        PdfDocument.PdfCatalog theCat = ((PdfDocument)this.document).getCatalog(rootObj);
        if (this.acroForm != null) {
            theCat.put(PdfName.ACROFORM, this.acroForm);
        }
        return theCat;
    }

    @Override
    public synchronized void close() {
        if (this.open) {
            PdfReaderInstance ri = this.currentPdfReaderInstance;
            this.pdf.close();
            super.close();
            if (ri != null) {
                try {
                    ri.getReaderFile().close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    PdfIndirectReference add(PdfImage pdfImage) throws PdfException {
        return null;
    }

    public PdfIndirectReference add(PdfOutline outline) {
        return null;
    }

    @Override
    public void addAnnotation(PdfAnnotation annot) {
    }

    @Override
    PdfIndirectReference add(PdfPage page, PdfContents contents) throws PdfException {
        return null;
    }

    protected class RefKey {
        int num;
        int gen;

        RefKey(int num, int gen) {
            this.num = num;
            this.gen = gen;
        }

        RefKey(PdfIndirectReference ref) {
            this.num = ref.getNumber();
            this.gen = ref.getGeneration();
        }

        RefKey(PRIndirectReference ref) {
            this.num = ref.getNumber();
            this.gen = ref.getGeneration();
        }

        public int hashCode() {
            return (this.gen << 16) + this.num;
        }

        public boolean equals(Object o) {
            RefKey other = (RefKey)o;
            return this.gen == other.gen && this.num == other.num;
        }

        public String toString() {
            return "" + this.num + " " + this.gen;
        }
    }

    class IndirectReferences {
        PdfIndirectReference theRef;
        boolean hasCopied;

        IndirectReferences(PdfIndirectReference ref) {
            this.theRef = ref;
            this.hasCopied = false;
        }

        void setCopied() {
            this.hasCopied = true;
        }

        boolean getCopied() {
            return this.hasCopied;
        }

        PdfIndirectReference getRef() {
            return this.theRef;
        }
    }
}

