/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.util.output.pdf;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Set;
import quadbase.common.util.output.pdf.PdfName;
import quadbase.common.util.output.pdf.PdfObject;
import quadbase.common.util.output.pdf.PdfWriter;

public class PdfDictionary
extends PdfObject {
    public static final PdfName FONT = PdfName.FONT;
    public static final PdfName OUTLINES = PdfName.OUTLINES;
    public static final PdfName PAGE = PdfName.PAGE;
    public static final PdfName PAGES = PdfName.PAGES;
    public static final PdfName CATALOG = PdfName.CATALOG;
    private PdfName dictionaryType = null;
    protected HashMap hashMap = new HashMap();

    public PdfDictionary() {
        super(6);
    }

    public PdfDictionary(PdfName type) {
        this();
        this.dictionaryType = type;
        this.put(PdfName.TYPE, this.dictionaryType);
    }

    @Override
    public void toPdf(PdfWriter writer, OutputStream os) throws IOException {
        os.write(60);
        os.write(60);
        for (PdfName key : this.hashMap.keySet()) {
            PdfObject value = (PdfObject)this.hashMap.get(key);
            key.toPdf(writer, os);
            os.write(32);
            value.toPdf(writer, os);
            os.write(10);
        }
        os.write(62);
        os.write(62);
    }

    public PdfObject put(PdfName key, PdfObject value) {
        return this.hashMap.put(key, value);
    }

    public PdfObject putEx(PdfName key, PdfObject value) {
        if (value == null) {
            return null;
        }
        return this.hashMap.put(key, value);
    }

    public PdfObject putDel(PdfName key, PdfObject value) {
        if (value == null) {
            return (PdfObject)this.hashMap.remove(key);
        }
        return this.hashMap.put(key, value);
    }

    public PdfObject remove(PdfName key) {
        return (PdfObject)this.hashMap.remove(key);
    }

    public PdfObject get(PdfName key) {
        return (PdfObject)this.hashMap.get(key);
    }

    @Deprecated
    public boolean isDictionaryType(PdfName type) {
        return this.dictionaryType.compareTo(type) == 0;
    }

    public boolean isFont() {
        return this.dictionaryType.compareTo(FONT) == 0;
    }

    public boolean isPage() {
        return this.dictionaryType.compareTo(PAGE) == 0;
    }

    public boolean isPages() {
        return this.dictionaryType.compareTo(PAGES) == 0;
    }

    public boolean isCatalog() {
        return this.dictionaryType.compareTo(CATALOG) == 0;
    }

    public boolean isOutlineTree() {
        return this.dictionaryType.compareTo(OUTLINES) == 0;
    }

    public void merge(PdfDictionary other) {
        this.hashMap.putAll(other.hashMap);
    }

    public void mergeDifferent(PdfDictionary other) {
        for (Object key : other.hashMap.keySet()) {
            if (this.hashMap.containsKey(key)) continue;
            this.hashMap.put(key, other.hashMap.get(key));
        }
    }

    public Set getKeys() {
        return this.hashMap.keySet();
    }

    public void putAll(PdfDictionary dic) {
        this.hashMap.putAll(dic.hashMap);
    }

    public int size() {
        return this.hashMap.size();
    }

    public boolean contains(PdfName key) {
        return this.hashMap.containsKey(key);
    }
}

